/********************************************************************************
*                                                                               *
*                         J P E G   I c o n   O b j e c t                       *
*                                                                               *
*********************************************************************************
* Author: David Tyree   Email: celer@ipro.lug.usf.edu                           *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXJPEGIcon.h,v 1.5 1999/11/30 14:58:59 jeroen Exp $                      *
********************************************************************************/
#ifndef FXJPEGICON_H
#define FXJPEGICON_H


/// JPEG Icon class
class FXJPEGIcon : public FXIcon {
  FXDECLARE(FXJPEGIcon)
protected:
  FXint quality;
protected:
  FXJPEGIcon(){}      
private:
  FXJPEGIcon(const FXJPEGIcon&);
  FXJPEGIcon &operator=(const FXJPEGIcon&);
public:
  
  /// Construct an icon from memory stream formatted in JPEG format
  FXJPEGIcon(FXApp *a,const void *pix=NULL,FXColor clr=FXRGB(192,192,192),FXuint opts=0,FXint w=1,FXint h=1);

  /// Save pixels into stream in JPEG format
  virtual void savePixels(FXStream& store) const;
  
  /// Load pixels from stream in JPEG format
  virtual void loadPixels(FXStream& store);
  
  /// Set image quality to save with
  void setQuality(FXint q){ quality=q; }

  /// Get image quality setting
  FXint getQuality() const { return quality; }
  
  /// Destroy
  virtual ~FXJPEGIcon();
  };
  

/// Load a jpeg from a stream
extern FXAPI FXbool fxloadJPEG(FXStream& store,FXuchar*& data,FXColor& transp,FXint& width,FXint& height,FXint& quality);


/// Save a jpeg to a stream
extern FXAPI FXbool fxsaveJPEG(FXStream& store,const FXuchar* data,FXColor transp,FXint width,FXint height,FXint quality);


#endif
