/********************************************************************************
*                                                                               *
*                         I c o n   L i s t   W i d g e t                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 1999 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXIconList.h,v 1.17 2000/03/02 07:23:24 jeroen Exp $                     *
********************************************************************************/
#ifndef FXICONLIST_H
#define FXICONLIST_H



/// Icon list styles
enum {
  ICONLIST_EXTENDEDSELECT = 0,                /// Extended selection mode
  ICONLIST_SINGLESELECT   = 0x00100000,       /// At most one selected item
  ICONLIST_BROWSESELECT   = 0x00200000,       /// Always exactly one selected item
  ICONLIST_MULTIPLESELECT = 0x00300000,       /// Multiple selection mode
  ICONLIST_AUTOSIZE       = 0x00400000,       /// Automatically size item spacing
  ICONLIST_DETAILED       = 0,                /// List mode
  ICONLIST_MINI_ICONS     = 0x00800000,       /// Mini Icon mode
  ICONLIST_BIG_ICONS      = 0x01000000,       /// Big Icon mode
  ICONLIST_ROWS           = 0,                /// Row-wise mode
  ICONLIST_COLUMNS        = 0x02000000        /// Column-wise mode
  };


/// Icon item
class FXAPI FXIconItem : public FXObject {
  FXDECLARE(FXIconItem)
  friend class FXIconList;
protected:
  FXString  label;
  FXIcon   *bigIcon;
  FXIcon   *miniIcon;
  void     *data;
  FXuint    state;
protected:
  FXIconItem():bigIcon(NULL),miniIcon(NULL),data(NULL),state(0){}
  virtual void draw(const FXIconList* list,FXDC& dc,FXint x,FXint y,FXint w,FXint h) const;
  virtual FXint hitItem(const FXIconList* list,FXint rx,FXint ry,FXint rw=1,FXint rh=1) const;
protected:
  void drawBigIcon(const FXIconList* list,FXDC& dc,FXint x,FXint y,FXint w,FXint h) const;
  void drawMiniIcon(const FXIconList* list,FXDC& dc,FXint x,FXint y,FXint w,FXint h) const;
  void drawDetails(const FXIconList* list,FXDC& dc,FXint x,FXint y,FXint w,FXint h) const;
  void drawFocus(const FXIconList* list,FXDC& dc,FXint x,FXint y,FXint w,FXint h) const;
protected:
  enum {
    SELECTED  = 1,
    MARKED    = 2,
    FOCUS     = 4,
    DISABLED  = 8,
    DRAGGABLE = 16
    };
public:
  FXIconItem(const FXString& text,FXIcon* bi=NULL,FXIcon* mi=NULL,void* ptr=NULL):label(text),bigIcon(bi),miniIcon(mi),data(ptr),state(0){}
  virtual void setText(const FXString& txt){ label=txt; }
  FXString getText() const { return label; }
  virtual void setBigIcon(FXIcon* icn){ bigIcon=icn; }
  FXIcon* getBigIcon() const { return bigIcon; }
  virtual void setMiniIcon(FXIcon* icn){ miniIcon=icn; }
  FXIcon* getMiniIcon() const { return miniIcon; }
  void setData(void* ptr){ data=ptr; }
  void* getData() const { return data; }
  virtual void setFocus(FXbool focus);
  FXbool hasFocus() const { return (state&FOCUS)!=0; }
  virtual void setSelected(FXbool selected);
  FXbool isSelected() const { return (state&SELECTED)!=0; }
  virtual void setEnabled(FXbool enabled);
  FXbool isEnabled() const { return (state&DISABLED)==0; }
  virtual void setDraggable(FXbool draggable);
  FXbool isDraggable() const { return (state&DRAGGABLE)!=0; }
  virtual void setMarked(FXbool marked);
  FXbool isMarked() const { return (state&MARKED)!=0; }
  virtual FXint getWidth(const FXIconList* list) const;
  virtual FXint getHeight(const FXIconList* list) const;
  virtual void create();
  virtual void detach();
  virtual void destroy();
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXIconItem(){}
  };


/// Icon item collate function
typedef FXint (*FXIconListSortFunc)(const FXIconItem*,const FXIconItem*);


/// Icon List Widget
class FXAPI FXIconList : public FXScrollArea {
  FXDECLARE(FXIconList)
protected:
  FXHeader          *header;            // Header control
  FXIconItem       **items;             // Item list
  FXint              nitems;            // Number of items
  FXint              nrows;             // Number of rows
  FXint              ncols;             // Number of columns
  FXint              anchor;            // Anchor item
  FXint              current;           // Current item
  FXint              extent;            // Extent item
  FXint              cursor;            // Cursor item
  FXFont            *font;              // Font
  FXIconListSortFunc sortfunc;          // Item sort function
  FXColor            textColor;         // Text color
  FXColor            selbackColor;      // Selected back color
  FXColor            seltextColor;      // Selected text color
  FXint              itemWidth;         // Item width
  FXint              itemHeight;        // Item height
  FXint              itemSpace;         // Space for item label
  FXint              anchorx;           // Rectangular selection
  FXint              anchory;
  FXint              currentx;
  FXint              currenty;
  FXint              grabx;             // Grab point x
  FXint              graby;             // Grab point y
  FXTimer           *timer;             // Tip hover timer
  FXString           help;              // Help text
protected:
  FXIconList();
  FXbool mark(FXint fm,FXint to,FXuint sel);
  FXbool restore(FXint fm,FXint to);
  void markAllItems();
  void markItem(FXint index);
  FXbool restoreItem(FXint index);
  void drawLasso(FXint x0,FXint y0,FXint x1,FXint y1);
  virtual void layout();
  void recompute();
  void getrowscols(FXint& nr,FXint& nc,FXint w,FXint h) const;
  virtual FXIconItem *createItem(const FXString& text,FXIcon *big,FXIcon* mini,void* ptr);
private:
  FXIconList(const FXIconList&);
  FXIconList &operator=(const FXIconList&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onEnter(FXObject*,FXSelector,void*);
  long onLeave(FXObject*,FXSelector,void*);
  long onUngrabbed(FXObject*,FXSelector,void*);
  long onKeyPress(FXObject*,FXSelector,void*);
  long onKeyRelease(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onRightBtnPress(FXObject*,FXSelector,void*);
  long onRightBtnRelease(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
  long onActivate(FXObject*,FXSelector,void*);
  long onDeactivate(FXObject*,FXSelector,void*);
  long onQueryTip(FXObject*,FXSelector,void*);
  long onQueryHelp(FXObject*,FXSelector,void*);
  long onTipTimer(FXObject*,FXSelector,void*);
  long onCmdSelectAll(FXObject*,FXSelector,void*);
  long onCmdDeselectAll(FXObject*,FXSelector,void*);
  long onCmdSelectInverse(FXObject*,FXSelector,void*);
  long onCmdArrangeByRows(FXObject*,FXSelector,void*);
  long onUpdArrangeByRows(FXObject*,FXSelector,void*);
  long onCmdArrangeByColumns(FXObject*,FXSelector,void*);
  long onUpdArrangeByColumns(FXObject*,FXSelector,void*);
  long onCmdShowDetails(FXObject*,FXSelector,void*);
  long onUpdShowDetails(FXObject*,FXSelector,void*);
  long onCmdShowBigIcons(FXObject*,FXSelector,void*);
  long onUpdShowBigIcons(FXObject*,FXSelector,void*);
  long onCmdShowMiniIcons(FXObject*,FXSelector,void*);
  long onUpdShowMiniIcons(FXObject*,FXSelector,void*);
  long onHeaderChanged(FXObject*,FXSelector,void*);
  long onFocusIn(FXObject*,FXSelector,void*);
  long onFocusOut(FXObject*,FXSelector,void*);
  long onSelectionLost(FXObject*,FXSelector,void*);
  long onSelectionGained(FXObject*,FXSelector,void*);
  long onChanged(FXObject*,FXSelector,void*);
  long onClicked(FXObject*,FXSelector,void*);
  long onDoubleClicked(FXObject*,FXSelector,void*);
  long onTripleClicked(FXObject*,FXSelector,void*);
  long onCommand(FXObject*,FXSelector,void*);
  long onAutoScroll(FXObject*,FXSelector,void*);
public:
  enum {
    ID_SHOW_DETAILS=FXScrollArea::ID_LAST,
    ID_SHOW_MINI_ICONS,
    ID_SHOW_BIG_ICONS,
    ID_ARRANGE_BY_ROWS,
    ID_ARRANGE_BY_COLUMNS,
    ID_HEADER_CHANGE,
    ID_TIPTIMER,
    ID_SELECT_ALL,
    ID_DESELECT_ALL,
    ID_SELECT_INVERSE,
    ID_LAST
    };
public:
  /// Constructor
  FXIconList(FXComposite *p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
  virtual void create();
  virtual void detach();
  virtual void recalc();
  virtual FXint getContentWidth();
  virtual FXint getContentHeight();
  virtual FXbool canFocus() const;
  virtual FXint getViewportHeight();
  virtual void moveContents(FXint x,FXint y);
  virtual void resize(FXint w,FXint h);
  virtual void position(FXint x,FXint y,FXint w,FXint h);
  FXint getNumItems() const { return nitems; }
  FXint getNumRows() const { return nrows; }
  FXint getNumCols() const { return ncols; }
  FXHeader* getHeader() const { return header; }
  void appendHeader(const FXString& text,FXIcon *icon=NULL,FXint size=1);
  void removeHeader(FXint index);
  void setHeaderText(FXint index,const FXString& text);
  FXString getHeaderText(FXint index) const;
  void setHeaderIcon(FXint index,FXIcon *icon);
  FXIcon* getHeaderIcon(FXint index) const;
  void setHeaderSize(FXint index,FXint size);
  FXint getHeaderSize(FXint index) const;
  FXint getNumHeaders() const;
  FXIconItem *retrieveItem(FXint index) const;
  FXint insertItem(FXint index,FXIconItem* item);
  FXint replaceItem(FXint index,FXIconItem* item);
  FXint appendItem(FXIconItem* item);
  FXint insertItem(FXint index,const FXString& text,FXIcon *big=NULL,FXIcon* mini=NULL,void* ptr=NULL);
  FXint replaceItem(FXint index,const FXString& text,FXIcon *big=NULL,FXIcon* mini=NULL,void* ptr=NULL);
  FXint appendItem(const FXString& text,FXIcon *big=NULL,FXIcon* mini=NULL,void* ptr=NULL);
  void removeItem(FXint index);
  void clearItems();
  FXint getItemWidth() const { return itemWidth; }
  FXint getItemHeight() const { return itemHeight; }
  FXint getItemAt(FXint x,FXint y) const;
  FXint findItem(const FXString& text,FXuint len=2147483647) const;
  void makeItemVisible(FXint index);
  void setItemText(FXint index,const FXString& text);
  FXString getItemText(FXint index) const;
  void setItemBigIcon(FXint index,FXIcon* icon);
  FXIcon* getItemBigIcon(FXint index) const;
  void setItemMiniIcon(FXint index,FXIcon* icon);
  FXIcon* getItemMiniIcon(FXint index) const;
  void setItemData(FXint index,void* ptr);
  void* getItemData(FXint index) const;
  FXbool isItemSelected(FXint index) const;
  FXbool isItemCurrent(FXint index) const;
  FXbool isItemVisible(FXint index) const;
  FXbool isItemEnabled(FXint index) const;
  FXint hitItem(FXint index,FXint x,FXint y,FXint ww=1,FXint hh=1) const;
  void updateItem(FXint index);
  FXbool selectInRectangle(FXint x,FXint y,FXint w,FXint h);
  FXbool enableItem(FXint index);
  FXbool disableItem(FXint index);
  FXbool selectItem(FXint index);
  FXbool deselectItem(FXint index);
  FXbool toggleItem(FXint index);
  void setCurrentItem(FXint index);
  FXint getCurrentItem() const { return current; }
  void setAnchorItem(FXint index);
  FXint getAnchorItem() const { return anchor; }
  FXint getCursorItem() const { return cursor; }
  FXbool extendSelection(FXint index);
  FXbool killSelection();
  void sortItems();
  void setFont(FXFont* fnt);
  FXFont* getFont() const { return font; }
  FXColor getTextColor() const { return textColor; }
  void setTextColor(FXColor clr);
  FXColor getSelBackColor() const { return selbackColor; }
  void setSelBackColor(FXColor clr);
  FXColor getSelTextColor() const { return seltextColor; }
  void setSelTextColor(FXColor clr);
  void setItemSpace(FXint s);
  FXint getItemSpace() const { return itemSpace; }
  FXIconListSortFunc getSortFunc() const { return sortfunc; }
  void setSortFunc(FXIconListSortFunc func){ sortfunc=func; }

  /// Get the current icon list style
  FXuint getListStyle() const;

  /// Set the current icon list style.
  void setListStyle(FXuint style);
  void setHelpText(const FXString& text);
  FXString getHelpText() const { return help; }
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);

  /// Destructor
  virtual ~FXIconList();
  };



#endif
