/********************************************************************************
*                                                                               *
*                          H e a d e r   W i d g e t                            *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXHeader.h,v 1.10 2000/02/24 14:21:29 jeroen Exp $                        *
********************************************************************************/
#ifndef FXHEADER_H
#define FXHEADER_H


 
/// Header style options
enum {
  HEADER_NORMAL     = 0,              /// Default is non-clickable
  HEADER_BUTTON     = 0x00008000,     /// Button style can be clicked
  HEADER_TRACKING   = 0x00010000      /// Tracks continuously while moving
  };
  

/// Header item
class FXAPI FXHeaderItem : public FXObject {
  FXDECLARE(FXHeaderItem)
  friend class FXHeader;
protected:
  FXString  label;
  FXIcon   *icon;
  FXint     size;
  void     *data;
protected:
  FXHeaderItem(){}
  virtual void draw(const FXHeader* header,FXDC& dc,FXint x,FXint y,FXint w,FXint h);
public:
  
  /// Construct new item with given text, icon, size, and user-data
  FXHeaderItem(const FXString& text,FXIcon* ic=NULL,FXint s=0,void* ptr=NULL):label(text),icon(ic),size(s),data(ptr){}

  /// Change item's text label
  virtual void setText(const FXString& txt){ label=txt; }

  /// Return item's text label
  FXString getText() const { return label; }

  /// Change item's icon
  virtual void setIcon(FXIcon* icn){ icon=icn; }

  /// Return item's icon
  FXIcon* getIcon() const { return icon; }

  /// Change item's user data
  void setData(void* ptr){ data=ptr; }

  /// Get item's user data
  void* getData() const { return data; }

  /// Return the item's width in the header
  virtual FXint getWidth(const FXHeader* header) const;
  
  /// Return the item's height in the header
  virtual FXint getHeight(const FXHeader* header) const;
  
  /// Create server-side resources
  virtual void create();
  
  /// Detach from server-side resources
  virtual void detach();
  
  /// Destroy server-side resources
  virtual void destroy();

  /// Destructor
  virtual ~FXHeaderItem(){}
  };

  
/**
* Header control may be placed over a table of other
* widgets to provide a caption and icon.  
* It also provides the means for the columns to be interactively
* resized.
*/
class FXAPI FXHeader : public FXFrame {
  FXDECLARE(FXHeader)
protected:
  FXHeaderItem **items;
  FXint          nitems;
  FXColor        textColor;
  FXbool         state;
  FXFont*        font;
  FXint          active;
  FXint          activex;
  FXint          activew;
  FXint          off;
protected:
  FXHeader();
  void drawSplit(FXint pos);
  virtual FXHeaderItem *createItem(const FXString& text,FXIcon* icon,FXint size,void* ptr);
  virtual void layout();
private:
  FXHeader(const FXHeader&);
  FXHeader &operator=(const FXHeader&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onUngrabbed(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
public:

  /// Construct new header control
  FXHeader(FXComposite* p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=FRAME_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);

  /// Create server-side resources
  virtual void create();
  
  
  /// Detach server-side resources
  virtual void detach();
  
  /// Return number of items
  FXint getNumItems() const { return nitems; }

  /// Return default width
  virtual FXint getDefaultWidth();
  
  /// Return default height
  virtual FXint getDefaultHeight();
  
  /// Return item at given index
  FXHeaderItem *retrieveItem(FXint index) const;
  
  /// Append new item
  FXint appendItem(FXHeaderItem* item);
  
  /// Append new item with given text, icon, size and data
  FXint appendItem(const FXString& text,FXIcon *icon=NULL,FXint size=0,void* ptr=NULL);
  
  /// Remove item at index
  void removeItem(FXint index);
  
  /// Remove all items
  void clearItems();
  
  /// Return item-index given pixel-offset from left
  FXint getItemAt(FXint offset) const;
  
  /// Change text label for item at index
  void setItemText(FXint index,const FXString& text);
  
  /// Get text of item at index
  FXString getItemText(FXint index) const;
  
  /// Change icon of item at index
  void setItemIcon(FXint index,FXIcon* icon);
  
  /// Return icon of item at index
  FXIcon* getItemIcon(FXint index) const;
  
  /// Change size of item at index
  void setItemSize(FXint index,FXint size);
  
  /// Return size of item at index
  FXint getItemSize(FXint index) const;
  
  /// Compute offset from the left side of item at index
  FXint getItemOffset(FXint index) const;
  
  /// Change data of item at index
  void setItemData(FXint index,void* ptr);
  
  /// Return data of item at index 
  void* getItemData(FXint index) const;
  
  /// Change text font
  void setFont(FXFont* fnt);
  
  /// return text font
  FXFont* getFont() const { return font; }

  /// Return text color
  FXColor getTextColor() const { return textColor; }

  /// Change text color
  void setTextColor(FXColor clr);

  /// Set header style options
  void setHeaderStyle(FXuint style);

  /// Get header style options
  FXuint getHeaderStyle() const;

  /// Save header to a stream
  virtual void save(FXStream& store) const;

  /// Load header from a stream
  virtual void load(FXStream& store);

  /// Destructor
  virtual ~FXHeader();
  };


#endif
