/********************************************************************************
*                                                                               *
*                   O p e n G L   S p h e r e   O b j e c t                     *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXGLSphere.h,v 1.5 1999/12/08 08:40:47 jeroen Exp $                      *
********************************************************************************/
#ifndef FXGLSPHERE_H
#define FXGLSPHERE_H
    

/// OpenGL Sphere Object
class FXAPI FXGLSphere : public FXGLShape {
  FXDECLARE(FXGLSphere)
public:
  FXfloat radius;
protected:
  FXGLSphere();
  virtual void drawshape(FXGLViewer* viewer);
public:
  enum {
    ID_LAST=FXGLShape::ID_LAST
    };
public:

  /// Construct with specified origin and radius
  FXGLSphere(FXfloat x,FXfloat y,FXfloat z,FXfloat r=1.0);

  /// Construct with specified origin, radius and material
  FXGLSphere(FXfloat x,FXfloat y,FXfloat z,FXfloat r,const FXMaterial& mtl);

  /// Save to a stream
  virtual void save(FXStream& store) const;

  /// Load from a stream
  virtual void load(FXStream& store);
  };


#endif
