/********************************************************************************
*                                                                               *
*                     O p e n G L   C y l i n d e r    O b j e c t              *
*                                                                               *
*********************************************************************************
* Copyright (C) 1999 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXGLCylinder.h,v 1.4 1999/12/08 08:40:47 jeroen Exp $                    *
********************************************************************************/
#ifndef FXGLCYLINDER_H
#define FXGLCYLINDER_H


/// OpenGL Cylinder Object
class FXAPI FXGLCylinder : public FXGLShape {
  FXDECLARE(FXGLCylinder)
public:
  FXfloat height;
  FXfloat radius;
protected:
  FXGLCylinder();
  virtual void drawshape(FXGLViewer* viewer);
public:

  /// Construct with specified origin, height and radius
  FXGLCylinder(FXfloat x,FXfloat y,FXfloat z,FXfloat h=1.0, FXfloat r=1.0);

  /// Construct with specified origin, height, radius and material
  FXGLCylinder(FXfloat x,FXfloat y,FXfloat z,FXfloat h,FXfloat r,const FXMaterial& mtl);

  /// Save to a stream
  virtual void save(FXStream& store) const;

  /// Load from a stream
  virtual void load(FXStream& store);
  };

#endif
