/********************************************************************************
*                                                                               *
*                      F i l e   S e l e c t i o n   O b j e c t                *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXFileSelector.h,v 1.8 2000/01/11 15:10:27 jeroen Exp $                  *
********************************************************************************/
#ifndef FXFILESELECTOR_H
#define FXFILESELECTOR_H


/// File selection widget
class FXAPI FXFileSelector : public FXPacker {
  FXDECLARE(FXFileSelector)
protected:
  FXFileList    *filebox;         // File list widget
  FXTextField   *filename;        // File name entry field
  FXComboBox    *filefilter;      // Combobox for pattern list
  FXDirBox      *dirbox;          // Directory hierarchy list
  FXButton      *accept;          // Accept button
  FXButton      *cancel;          // Cancel button
  FXGIFIcon     *updiricon;       // Up directory icon
  FXGIFIcon     *newdiricon;      // New directory icon
  FXGIFIcon     *listicon;        // List mode icon
  FXGIFIcon     *detailicon;      // Detail mode icon
  FXGIFIcon     *iconsicon;       // Icon mode icon
  FXGIFIcon     *homeicon;        // Go home icon
  FXGIFIcon     *shownicon;       // Files shown icon
  FXGIFIcon     *hiddenicon;      // Files hidden icon
protected:
  FXFileSelector(){}
private:
  FXFileSelector(const FXFileSelector&);
  FXFileSelector &operator=(const FXFileSelector&);
public:
  long onCmdName(FXObject*,FXSelector,void*);
  long onCmdFilter(FXObject*,FXSelector,void*);
  long onCmdItemOpened(FXObject*,FXSelector,void*);
  long onCmdItemSelected(FXObject*,FXSelector,void*);
  long onCmdDirectoryUp(FXObject*,FXSelector,void*);
  long onUpdDirectoryUp(FXObject*,FXSelector,void*);
  long onCmdDirTree(FXObject*,FXSelector,void*);
  long onCmdHome(FXObject*,FXSelector,void*);
public:
  enum {
    ID_FILEFILTER=FXPacker::ID_LAST,
    ID_FILENAME,
    ID_FILELIST,
    ID_DIRECTORY_UP,
    ID_DIRTREE,
    ID_HOME,
    ID_LAST
    };
public:

  /// Constructor
  FXFileSelector(FXComposite *p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);

  /// Return a pointer to the "Accept" button
  FXButton *acceptButton() const { return accept; }

  /// Return a pointer to the "Cancel" button
  FXButton *cancelButton() const { return cancel; }

  /// Change file name
  void setFilename(const FXString& path);
  
  /// Return file name
  FXString getFilename() const;
  
  /// Change file pattern
  void setPattern(const FXString& ptrn);
  
  /// Return file pattern
  FXString getPattern() const;
  
  /// Change directory
  void setDirectory(const FXString& path);
  
  /// Return directory
  FXString getDirectory() const;
  
  /// Set current pattern number
  void setCurrentPattern(FXint n);
  
  /// Return current pattern number
  FXint getCurrentPattern() const;
  
  /// Get pattern text for given pattern number
  FXString getPatternText(FXint patno) const;
  
  /// Change pattern text for pattern number
  void setPatternText(FXint patno,const FXString& text);
  
  /// Set list of patterns
  void setPatternList(const FXchar **ptrns);

  /// Set the inter-item spacing (in pixels)
  void setItemSpace(FXint s);

  /// Return the inter-item spacing (in pixels)
  FXint getItemSpace() const;

  /// Change File List style
  void setFileBoxStyle(FXuint style);
  
  /// Return File List style
  FXuint getFileBoxStyle() const;
  
  /// Save object to a stream
  virtual void save(FXStream& store) const;

  /// Load object from a stream
  virtual void load(FXStream& store);

  /// Destructor
  virtual ~FXFileSelector();
  };


#endif
