/********************************************************************************
*                                                                               *
*                   F i l e   S e l e c t i o n   D i a l o g                   *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXFileDialog.h,v 1.6 2000/01/11 15:10:27 jeroen Exp $                    *
********************************************************************************/
#ifndef FXFILEDIALOG_H
#define FXFILEDIALOG_H


/// File selection dialog
class FXAPI FXFileDialog : public FXDialogBox {
  FXDECLARE(FXFileDialog)
protected:
  FXFileSelector *filebox;
protected:
  FXFileDialog(){}
private:
  FXFileDialog(const FXFileDialog&);
  FXFileDialog &operator=(const FXFileDialog&);
public:
  
  /// Construct File Dialog Box
  FXFileDialog(FXWindow* owner,const FXString& name,FXuint opts=0,FXint x=0,FXint y=0,FXint w=500,FXint h=300);

  /// Change file name
  void setFilename(const FXString& path);
  
  /// Return file name
  FXString getFilename() const;
  
  /// Change file pattern
  void setPattern(const FXString& ptrn);
  
  /// Return file pattern
  FXString getPattern() const;
  
  /// Change directory
  void setDirectory(const FXString& path);
  
  /// Return directory
  FXString getDirectory() const;
  
  /// Change pattern text for pattern number
  void setPatternList(const FXchar **ptrns);
  
  /// Set current pattern number
  void setCurrentPattern(FXint n);
  
  /// Return current pattern number
  FXint getCurrentPattern() const;
  
  /// Get pattern text for given pattern number
  FXString getPatternText(FXint patno) const;
  
  /// Change pattern text for pattern number
  void setPatternText(FXint patno,const FXString& text);

  /// Set the inter-item spacing (in pixels)
  void setItemSpace(FXint s);

  /// Return the inter-item spacing (in pixels)
  FXint getItemSpace() const;

  /// Change File List style
  void setFileBoxStyle(FXuint style);

  /// Return File List style
  FXuint getFileBoxStyle() const;

  /// Save to stream
  virtual void save(FXStream& store) const;
  
  /// Load from stream
  virtual void load(FXStream& store);

  /// Destructor
  virtual ~FXFileDialog();
  };


#endif
