/********************************************************************************
*                                                                               *
*      F i l e   I n f o r m a t i o n   a n d   M a n i p u l a t i o n        *
*                                                                               *
*********************************************************************************
* Copyright (C) 2000 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXFile.h,v 1.10 2000/04/10 16:00:42 gui Exp $                          *
********************************************************************************/
#ifndef FXFILE_H
#define FXFILE_H


/// Declared as "C" so as to not clash tag-names
extern "C" { struct stat; }


/// This will be a namespace before long
class FXAPI FXFile {
public:
  /// Return the user's home direcory.
  static FXString getHomeDirectory();

  /// Set the current working directory
  static FXbool setCurrentDirectory(const FXString& path);

  /// Get the current working directory
  static FXString getCurrentDirectory();

  /// Set the current drive (for Win32 systems)
  static FXbool setCurrentDrive(const FXString& prefix);

  /// Return the current drive (for Win32 systems)
  static FXString getCurrentDrive();

  /// Get executable path
  static FXString getExecPath();

  /// Return the directory part of the path name
  static FXString directory(const FXString& file);

  /// Return name and extension part of the path name
  static FXString name(const FXString& file);

  /// Return file title, i.e. document name only
  static FXString title(const FXString& file);

  /// Return extension part of the file name
  static FXString extension(const FXString& file);

  /// Return the drive letter prefixing this file name (if any).
  static FXString drive(const FXString& file);

  /// Expand ~ in file names using the HOME environment variable.
  static FXString expand(const FXString& file);

  /// Simplify a file path; the path will remain relative if it was relative.
  static FXString simplify(const FXString& file);

  /// Build absolute path name
  static FXString absolute(const FXString& file);

  /// Build absolute path name from parts
  static FXString absolute(const FXString& base,const FXString& file);

  /// Search path list for this file, return full path name for first occurrence
  static FXString search(const FXString& pathlist,const FXString& file);

  /// Return path to directory above input directory name
  static FXString upLevel(const FXString& file);

  /// Return true if file name is absolute
  static FXbool isAbsolute(const FXString& file);

  /// Return true if input directory is a top-level directory
  static FXbool isTopDirectory(const FXString& file);

  /// Return true if input path is a file name
  static FXbool isFile(const FXString& file);

  /// Return true if input path is a link
  static FXbool isLink(const FXString& file);

  /// Return true if input path is a directory
  static FXbool isDirectory(const FXString& file);

  /// Return true if owner has read-write-execute permissions
  static FXbool isOwnerReadWriteExecute(const FXString& file);

  /// Return true if owner has read permissions
  static FXbool isOwnerReadable(const FXString& file);

  /// Return true if owner has write permissions
  static FXbool isOwnerWritable(const FXString& file);

  /// Return true if owner has execute permissions
  static FXbool isOwnerExecutable(const FXString& file);

  /// Return true if group has read-write-execute permissions
  static FXbool isGroupReadWriteExecute(const FXString& file);

  /// Return true if group has read permissions
  static FXbool isGroupReadable(const FXString& file);

  /// Return true if group has write permissions
  static FXbool isGroupWritable(const FXString& file);

  /// Return true if group has execute permissions
  static FXbool isGroupExecutable(const FXString& file);

  /// Return true if others have read-write-execute permissions
  static FXbool isOtherReadWriteExecute(const FXString& file);

  /// Return true if others have read permissions
  static FXbool isOtherReadable(const FXString& file);

  /// Return true if others have write permissions
  static FXbool isOtherWritable(const FXString& file);

  /// Return true if others have execute permissions
  static FXbool isOtherExecutable(const FXString& file);

  /// Return file size in bytes
  static unsigned long size(const FXString& file);

  /// Return last modified time for this file
  static long modified(const FXString& file);

  /// Return last accessed time for this file
  static long accessed(const FXString& file);

  /// Return created time for this file
  static long created(const FXString& file);

  /// Return touched time for this file
  static long touched(const FXString& file);

  /// Return file info as reported by system stat() function
  static FXbool info(const FXString& file,struct stat& info);

  /// Return true if file exists
  static FXbool exists(const FXString& file);

  /// Return the mode flags for this file
  static FXuint mode(const FXString& file);
  };
  
  
#endif
