/********************************************************************************
*                                                                               *
*                       D r a g   C o r n e r   W i d g e t                     *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXDragCorner.h,v 1.3 1999/12/02 05:18:14 jeroen Exp $                    *
********************************************************************************/
#ifndef FXDRAGCORNER_H
#define FXDRAGCORNER_H



/**
* A drag corner widget may be placed in the bottom right corner
* so as to allow the window to be resized more easily.
*/
class FXAPI FXDragCorner : public FXWindow {
  FXDECLARE(FXDragCorner)
protected:
  FXColor hiliteColor;
  FXColor shadowColor;
  FXint   oldw;
  FXint   oldh;
  FXint   xoff;
  FXint   yoff;
protected:
  FXDragCorner();
private:
  FXDragCorner(const FXDragCorner&);
  FXDragCorner &operator=(const FXDragCorner&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
public:
  
  /// Construct a drag corner
  FXDragCorner(FXComposite* p);

  /// Get default width
  virtual FXint getDefaultWidth();
  
  /// Get default height
  virtual FXint getDefaultHeight();
  
  /// Change highlight color
  void setHiliteColor(FXColor clr);
  
  /// Return current highlight color
  FXColor getHiliteColor() const { return hiliteColor; }

  /// Change shadow color
  void setShadowColor(FXColor clr);
  
  /// Return current shadow color
  FXColor getShadowColor() const { return shadowColor; }

  /// Save drag corner to a stream
  virtual void save(FXStream& store) const;
  
  /// Load drag corner from a stream
  virtual void load(FXStream& store);
  };



#endif
