/********************************************************************************
*                                                                               *
*                              D a t a   T a r g e t                            *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXDataTarget.h,v 1.8 1999/12/15 04:55:56 jeroen Exp $                    *
********************************************************************************/
#ifndef FXDATATARGET_H
#define FXDATATARGET_H


/// Data target
class FXAPI FXDataTarget : public FXObject {
  FXDECLARE(FXDataTarget)
protected:
  FXuint  type;
  void   *data;
public:
  long onCmdValue(FXObject*,FXSelector,void*);
  long onUpdValue(FXObject*,FXSelector,void*);
  long onCmdOption(FXObject*,FXSelector,void*);
  long onUpdOption(FXObject*,FXSelector,void*);
public:
  enum {
    DT_VOID=0,
    DT_CHAR,
    DT_UCHAR,
    DT_SHORT,
    DT_USHORT,
    DT_INT,
    DT_UINT,
    DT_FLOAT,
    DT_DOUBLE,
    DT_STRING,
    DT_LAST
    };
public:
  enum {
    ID_VALUE=1,                   /// Will cause the FXDataTarget to ask sender for value
    ID_OPTION=ID_VALUE+10001,     /// ID_OPTION+i will set the value to i where -10000<=i<=10000
    ID_LAST=ID_OPTION+10000
    };
public:
  
  /// Associate with nothing
  FXDataTarget():type(DT_VOID),data(NULL){}

  /// Associate with character variable
  FXDataTarget(FXchar& value):type(DT_CHAR),data(&value){}

  /// Associate with unsigned character variable
  FXDataTarget(FXuchar& value):type(DT_UCHAR),data(&value){}

  /// Associate with signed short variable
  FXDataTarget(FXshort& value):type(DT_SHORT),data(&value){}

  /// Associate with unsigned short variable
  FXDataTarget(FXushort& value):type(DT_USHORT),data(&value){}

  /// Associate with int variable
  FXDataTarget(FXint& value):type(DT_INT),data(&value){}

  /// Associate with unsigned int variable
  FXDataTarget(FXuint& value):type(DT_UINT),data(&value){}

  /// Associate with float variable
  FXDataTarget(FXfloat& value):type(DT_FLOAT),data(&value){}

  /// Associate with double variable
  FXDataTarget(FXdouble& value):type(DT_DOUBLE),data(&value){}

  /// Associate with string variable
  FXDataTarget(FXString& value):type(DT_STRING),data(&value){}


  /// Associate with nothing
  void connect(){ type=DT_VOID; data=NULL; }

  /// Associate with character variable
  void connect(FXchar& value){ type=DT_CHAR; data=&value; }

  /// Associate with unsigned character variable
  void connect(FXuchar& value){ type=DT_UCHAR; data=&value; }

  /// Associate with signed short variable
  void connect(FXshort& value){ type=DT_SHORT; data=&value; }

  /// Associate with unsigned short variable
  void connect(FXushort& value){ type=DT_USHORT; data=&value; }

  /// Associate with int variable
  void connect(FXint& value){ type=DT_INT; data=&value; }

  /// Associate with unsigned int variable
  void connect(FXuint& value){ type=DT_UINT; data=&value; }

  /// Associate with float variable
  void connect(FXfloat& value){ type=DT_FLOAT; data=&value; }

  /// Associate with double variable
  void connect(FXdouble& value){ type=DT_DOUBLE; data=&value; }

  /// Associate with string variable
  void connect(FXString& value){ type=DT_STRING; data=&value; }

  /// Return type of data its connected to
  FXuint getType() const { return type; }

  /// Return pointer to data its connected to
  void* getData() const { return data; }
  };
  


#endif
