/********************************************************************************
*                                                                               *
*           D e v i c e   C o n t e x t   F o r   X - W i n d o w s             *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXDCPrint.h,v 1.6 1999/12/29 07:09:43 jeroen Exp $                       *
********************************************************************************/
#ifndef FXDCPRINT_H
#define FXDCPRINT_H


class FXApp;
class FXDrawable;
class FXImage;
class FXBitmap;
class FXIcon;
class FXFont;


/// Bounding box
struct FXPSBounds {
  FXfloat  xmin;
  FXfloat  xmax;
  FXfloat  ymin;
  FXfloat  ymax;
  };

  
/// Postscript Printer Device Context
class FXAPI FXDCPrint : public FXDC {
  friend class FXGLViewer; // This is TEMPORARY!!!
protected:
  void      *psout;                   // File Stream for PS output
  FXFont    *font;
  FXuint     flags;
  FXint      Xr,Yr;
  FXfloat    mediawidth;              // Media width
  FXfloat    mediaheight;             // Media height
  FXPSBounds mediabb;                 // Media bounding box
  FXPSBounds docbb;                   // Document bounding box
  FXPSBounds pagebb;                  // Page bounding box
  FXint      pagecount;               // Number of pages printed
  FXint      nchars;                  // Number of characters on a line
protected:
  void outhex(FXuint hex);
  void outf(const char* format,...);
  void bbox(FXfloat x,FXfloat y);
  void tfm(FXfloat& xo,FXfloat& yo,FXfloat xi,FXfloat yi);
private:
  FXDCPrint();
  FXDCPrint(const FXDCPrint&);
  FXDCPrint &operator=(const FXDCPrint&);
public:
  
  /// Construct
  FXDCPrint(FXApp* a);

  /// Generate print job prolog
  FXbool beginPrint(FXPrinter& job);
  
  /// Generate print job epilog
  FXbool endPrint();
  
  /// Generate begin of page
  FXbool beginPage(FXuint page=1);
  
  /// Generate end of page
  FXbool endPage();
  
  /// Draw points
  virtual void drawPoint(FXint x,FXint y);
  virtual void drawPoints(const FXPoint* points,FXuint npoints);
  virtual void drawPointsRel(const FXPoint* points,FXuint npoints);

  /// Draw lines
  virtual void drawLine(FXint x1,FXint y1,FXint x2,FXint y2);
  virtual void drawLines(const FXPoint* points,FXuint npoints);
  virtual void drawLinesRel(const FXPoint* points,FXuint npoints);
  virtual void drawLineSegments(const FXSegment* segments,FXuint nsegments);
  
  /// Draw rectangles
  virtual void drawRectangle(FXint x,FXint y,FXint w,FXint h);
  virtual void drawRectangles(const FXRectangle* rectangles,FXuint nrectangles);

  /// Draw arcs
  virtual void drawArc(FXint x,FXint y,FXint w,FXint h,FXint ang1,FXint ang2);
  virtual void drawArcs(const FXArc* arcs,FXuint narcs);

  /// Filled rectangles
  virtual void fillRectangle(FXint x,FXint y,FXint w,FXint h);
  virtual void fillRectangles(const FXRectangle* rectangles,FXuint nrectangles);

  /// Draw arcs
  virtual void fillArc(FXint x,FXint y,FXint w,FXint h,FXint ang1,FXint ang2);
  virtual void fillArcs(const FXArc* arcs,FXuint narcs);

  /// Filled polygon
  virtual void fillPolygon(const FXPoint* points,FXuint npoints);
  virtual void fillConcavePolygon(const FXPoint* points,FXuint npoints);
  virtual void fillComplexPolygon(const FXPoint* points,FXuint npoints);

  /// Filled polygon with relative points
  virtual void fillPolygonRel(const FXPoint* points,FXuint npoints);
  virtual void fillConcavePolygonRel(const FXPoint* points,FXuint npoints);
  virtual void fillComplexPolygonRel(const FXPoint* points,FXuint npoints);

  /// Draw hashed box
  virtual void drawHashBox(FXint x,FXint y,FXint w,FXint h,FXint b=1);
  
  /// Draw area from source
  virtual void drawArea(const FXDrawable* source,FXint sx,FXint sy,FXint sw,FXint sh,FXint dx,FXint dy);

  /// Draw image 
  virtual void drawImage(const FXImage* image,FXint dx,FXint dy);

  /// Draw bitmap
  virtual void drawBitmap(const FXBitmap* bitmap,FXint dx,FXint dy);

  /// Draw icon 
  virtual void drawIcon(const FXIcon* icon,FXint dx,FXint dy);
  virtual void drawIconShaded(const FXIcon* icon,FXint dx,FXint dy);
  virtual void drawIconSunken(const FXIcon* icon,FXint dx,FXint dy);

  /// Draw string
  virtual void drawText(FXint x,FXint y,const FXchar* string,FXuint length);
  virtual void drawImageText(FXint x,FXint y,const FXchar* string,FXuint length);

  /// Set foreground/background drawing color
  virtual void setForeground(FXColor clr);
  virtual void setBackground(FXColor clr);

  /// Set dash pattern
  virtual void setDashes(FXuint dashoffset,const FXchar *dashlist,FXuint n);
  
  /// Set line width  
  virtual void setLineWidth(FXuint linewidth=0);
  
  /// Set line cap style
  virtual void setLineCap(FXCapStyle capstyle=CAP_BUTT);
  
  /// Set line join style
  virtual void setLineJoin(FXJoinStyle joinstyle=JOIN_MITER);
  
  /// Set line style
  virtual void setLineStyle(FXLineStyle linestyle=LINE_SOLID);
  
  /// Set fill style
  virtual void setFillStyle(FXFillStyle fillstyle=FILL_SOLID);
  
  /// Set fill rule
  virtual void setFillRule(FXFillRule fillrule=RULE_EVEN_ODD);
  
  /// Set blit function
  virtual void setFunction(FXFunction func=BLT_SRC);
  
  /// Set the tile 
  virtual void setTile(FXImage* tile,FXint dx=0,FXint dy=0);
  
  /// Set the stipple pattern 
  virtual void setStipple(FXBitmap *stipple,FXint dx=0,FXint dy=0);
  
  /// Set the stipple pattern
  virtual void setStipple(FXStipplePattern stipple,FXint dx=0,FXint dy=0);
  
  /// Set clip rectangle
  virtual void setClipRectangle(FXint x,FXint y,FXint w,FXint h);
  
  /// Clear clipping
  virtual void clearClipRectangle();
  
  /// Set clip mask
  virtual void setClipMask(FXBitmap* mask,FXint dx=0,FXint dy=0);
  
  /// Clear clip mask
  virtual void clearClipMask();
  
  /// Set font to draw text with
  virtual void setTextFont(FXFont *fnt);
  
  /// Clip drawing by child windows
  virtual void clipChildren(FXbool yes);
  
  /// Cleanup
  virtual ~FXDCPrint();
  };
 
  
#endif
