/********************************************************************************
*                                                                               *
*                    C h e c k   B u t t o n   W i d g e t                      *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXCheckButton.h,v 1.11 1999/12/29 07:09:43 jeroen Exp $                  *
********************************************************************************/
#ifndef FXCHECKBUTTON_H
#define FXCHECKBUTTON_H



/// CheckButton styles
enum {
  CHECKBUTTON_AUTOGRAY = 0x00800000,    /// Automatically gray out when not updated
  CHECKBUTTON_AUTOHIDE = 0x01000000     /// Automatically hide when not updated
  };


/// Check button
class FXAPI FXCheckButton : public FXLabel {
  FXDECLARE(FXCheckButton)
protected:
  FXuchar  check;
  FXuchar  oldcheck;
  FXColor  boxColor;
protected:
  FXCheckButton();
private:
  FXCheckButton(const FXCheckButton&);
  FXCheckButton &operator=(const FXCheckButton&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onHotKeyPress(FXObject*,FXSelector,void*);
  long onHotKeyRelease(FXObject*,FXSelector,void*);
  long onUngrabbed(FXObject*,FXSelector,void*);
  long onUpdate(FXObject*,FXSelector,void*);
  long onFocusIn(FXObject*,FXSelector,void*);
  long onFocusOut(FXObject*,FXSelector,void*);
  long onActivate(FXObject*,FXSelector,void*);
  long onDeactivate(FXObject*,FXSelector,void*);
  long onEnter(FXObject*,FXSelector,void*);
  long onLeave(FXObject*,FXSelector,void*);
  long onCheck(FXObject*,FXSelector,void*);
  long onUncheck(FXObject*,FXSelector,void*);
  long onUnknown(FXObject*,FXSelector,void*);
  long onCmdSetValue(FXObject*,FXSelector,void*);
  long onCmdSetIntValue(FXObject*,FXSelector,void*);
  long onCmdGetIntValue(FXObject*,FXSelector,void*);
public:
  
  /// Construct new check button
  FXCheckButton(FXComposite* p,const FXString& text,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=JUSTIFY_NORMAL|ICON_BEFORE_TEXT,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);

  /// Enable the check button 
  virtual void enable();

  /// Disable the check button
  virtual void disable();

  /// Returns true because a check button can receive focus
  virtual FXbool canFocus() const;

  /// Get default width
  virtual FXint getDefaultWidth();

  /// Get default height
  virtual FXint getDefaultHeight();

  /// Set check button state (TRUE, FALSE or MAYBE)
  void setCheck(FXuint s=TRUE);

  /// Get check button state (TRUE, FALSE or MAYBE)
  FXuint getCheck() const { return check; }

  /// Change check button style
  void setCheckButtonStyle(FXuint style);
  
  /// Return current check button style
  FXuint getCheckButtonStyle() const;

  /// Get the box background color
  FXColor getBoxColor() const { return boxColor; }

  /// Set the box background color
  void setBoxColor(FXColor clr);

  /// Save check button to a stream
  virtual void save(FXStream& store) const;

  /// Load check button from a stream
  virtual void load(FXStream& store);
  };


#endif
