/********************************************************************************
*                                                                               *
*                        B M P   I c o n   O b j e c t                          *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXBMPIcon.h,v 1.3 1999/11/30 14:58:59 jeroen Exp $                       *
********************************************************************************/
#ifndef FXBMPICON_H
#define FXBMPICON_H


/// Microsoft Bitmap icon
class FXAPI FXBMPIcon : public FXIcon {
  FXDECLARE(FXBMPIcon)
protected:
  FXBMPIcon(){}
private:
  FXBMPIcon(const FXBMPIcon&);
  FXBMPIcon &operator=(const FXBMPIcon&);
public:
  
  /// Construct icon from memory stream formatted in Microsoft bitmap format
  FXBMPIcon(FXApp* a,const void *pix=NULL,FXColor clr=FXRGB(192,192,192),FXuint opts=0,FXint w=1,FXint h=1);

  /// Save pixels into stream in Microsoft bitmap format
  virtual void savePixels(FXStream& store) const;
  
  /// Load pixels from stream in Microsoft bitmap format
  virtual void loadPixels(FXStream& store);
  
  /// Destroy icon
  virtual ~FXBMPIcon();
  };
  
  
/// Load a bmp file from a stream
extern FXAPI FXbool fxloadBMP(FXStream& store,FXuchar*& data,FXColor& transp,FXint& width,FXint& height);


/// Save a bmp file to a stream
extern FXAPI FXbool fxsaveBMP(FXStream& store,const FXuchar *data,FXColor transp,FXint width,FXint height);

    
#endif
