/********************************************************************************
*                                                                               *
*                     A p p l i c a t i o n   O b j e c t                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXApp.h,v 1.45 2000/03/23 07:57:01 jeroen Exp $                          *
********************************************************************************/
#ifndef FXAPP_H
#define FXAPP_H


// Forward declarations
class FXWindow;
class FXIcon;
class FXBitmap;
class FXCursor;
class FXRootWindow;
class FXMainWindow;
class FXFont;
class FXDC;
class FXDCWindow;
class FXVisual;
class FXGLVisual;
#ifdef WIN32
struct FXDragContext;
#endif

// Opaque FOX objects
struct FXTimer;
struct FXSignal;
struct FXChore;
struct FXRepaint;
struct FXInput;


/// Application Object
class FXAPI FXApp : public FXObject {
  FXDECLARE(FXApp)
    
  // We've got many friends
  friend class FXId;
  friend class FXBitmap;
  friend class FXImage;
  friend class FXIcon;
  friend class FXCursor;
  friend class FXDrawable;
  friend class FXWindow;
  friend class FXShell;
  friend class FXRootWindow;
  friend class FXTopWindow;
  friend class FXMainWindow;
  friend class FXGLCanvas;
  friend class FXFont;
  friend class FXVisual;
  friend class FXGLVisual;
  friend class FXDC;
  friend class FXDCWindow;
  
private:

  // Platform independent private data
  const FXchar    *appname;             // Name of the application
  FXRegistry       registry;            // Application setting registry
  FXWindow        *mainWindow;          // Main window
  FXWindow        *focusWindow;         // Window which has the focus
  FXWindow        *cursorWindow;        // Window under the cursor
  FXWindow        *grabWindow;          // Window which has the grab
  FXWindow        *keyWindow;           // Window in which key was pressed
  FXWindow        *dragWindow;          // Drag and drop source window
  FXWindow        *selectionWindow;     // Selection window
  FXWindow        *clipboardWindow;     // Clipboard window
  FXWindow        *refresher;           // GUI refresher pointer
  FXRootWindow    *root;                // Root window
  FXVisual        *monoVisual;          // Monochrome visual
  FXVisual        *defaultVisual;       // Default [color] visual
  FXTimer         *timers;              // List of timers, sorted by time
  FXChore         *chores;              // List of chores
  FXRepaint       *repaints;            // Unhandled repaint rectangles
  FXTimer         *timerrecs;           // List of recycled timer records
  FXChore         *chorerecs;           // List of recycled chore records
  FXRepaint       *repaintrecs;         // List of recycled repaint records
  FXInvocation    *invocation;          // Modal loop invocation
  FXSignal        *signals;             // Array of signal records
  FXint            nsignals;            // Number of signals
  FXFont          *normalFont;          // Normal font
  FXCursor        *waitCursor;          // Current wait cursor
  FXuint           waitcount;           // Number of times wait cursor was called
  FXuint           maxcolors;           // Maximum number of colors to allocate
  FXuint           done;                // True if application is done
  FXint            exitcode;            // Exit code
  FXEvent          event;               // Event
  FXbool           again;               // Refresher goes again
  
private:
  static FXApp    *app;                 // Application pointer

protected:

  // Platform dependent private data
#ifndef WIN32
  void            *display;             // Display we're talking to
  int              wcontext;            // Window hash context
#endif

private:

#ifndef WIN32
  FXID             wmDeleteWindow;      // Catch delete window
  FXID             wmQuitApp;           // Catch quit application
  FXID             wmProtocols;         // Window manager protocols
  FXID             wmMotifHints;        // Motif hints
  FXID             wmTakeFocus;         // Focus explicitly set by app
  FXID             wmState;             // Window state
  FXID             reqTargets;          // The TARGETS atom
  FXID             xcbSelection;        // Clipboard selection
  FXDragType      *xcbTypeList;         // Clipboard type list
  FXuint           xcbNumTypes;         // Clipboard number of types on list
  FXDragType      *xselTypeList;        // Selection type list
  FXuint           xselNumTypes;        // Selection number of types on list
  FXDragType      *xdndTypeList;        // XDND type list
  FXuint           xdndNumTypes;        // XDND number of types
  FXID             ddeAtom;             // DDE Exchange Atom
  FXID             ddeDelete;           // DDE Delete Target Atom
  FXuchar         *ddeData;             // DDE array
  FXuint           ddeSize;             // DDE array size
  FXID             xdndAware;           // XDND awareness atom
  FXID             xdndEnter;           // XDND enter window message
  FXID             xdndLeave;           // XDND leave window message
  FXID             xdndPosition;        // XDND position update message
  FXID             xdndStatus;          // XDND status feedback message
  FXID             xdndDrop;            // XDND drop message
  FXID             xdndFinished;        // XDND finished message
  FXID             xdndSelection;       // XDND selection atom
  FXID             xdndActionMove;      // XDND Move action
  FXID             xdndActionCopy;      // XDND Copy action
  FXID             xdndActionLink;      // XDND Link action
  FXID             xdndTypes;           // XDND types list atom
  FXID             xdndSource;          // XDND drag source window
  FXID             xdndTarget;          // XDND drop target window
  FXID             xdndAction;          // XDND Drag and Drop action
  FXbool           xdndAccepts;         // XDND true if target accepts
  FXbool           xdndSendPosition;    // XDND send position update when status comes in
  FXbool           xdndStatusPending;   // XDND waiting for status feedback
  FXbool           xdndFinishPending;   // XDND waiting for drop-confirmation
  FXbool           xdndStatusReceived;  // XDND received at least one status
  FXbool           xdndWantUpdates;     // XDND target wants new positions while in rect
  FXuint           xdndVersion;         // XDND version for ongoing transaction
  FXRectangle      xdndRect;            // XDND rectangle bounding target
  FXint            xdndXPos;            // XDND Cached X position
  FXint            xdndYPos;            // XDND Cached Y position
  FXID             stipples[23];        // Standard stipple patterns
  FXInput         *inputs;              // Input file descriptors being watched
  FXint            ninputs;             // Number of inputs
  FXint            maxinput;            // Maximum input number
  void            *r_fds;               // Set of file descriptors for read
  void            *w_fds;               // Set of file descriptors for write
  void            *e_fds;               // Set of file descriptors for exceptions
  FXbool           shmi;                // Use XSHM Image possible
  FXbool           shmp;                // Use XSHM Pixmap possible
  FXbool           synchronize;         // Synchronized
#else
  FXushort         reqTargets;          // TARGETS atom
  void*            filemapping;         // Handle to mapping object for dragContext
  FXDragContext   *dragContext;         // Shared drag context information
  void*            xdndTypes;           // Handle to file mapping object for types list
  FXDragType      *xdndTypeList;        // XDND type list
  FXuint           xdndNumTypes;        // XDND number of types
  FXushort         ddeAtom;             // DDE Exchange Atom
  FXDragType       ddeDelete;           // DDE Delete Target Atom
  FXuchar         *ddeData;             // DDE array
  FXuint           ddeSize;             // DDE array size
  FXushort         xdndAware;           // XDND awareness atom
  FXuint           xdndRequest;         // SEL_DND_REQUEST for remote windows
  FXuint           xdndEnter;           // XDND enter window message
  FXuint           xdndLeave;           // XDND leave window message
  FXuint           xdndPosition;        // XDND position update message
  FXuint           xdndStatus;          // XDND status feedback message
  FXuint           xdndDrop;            // XDND drop message
  FXuint           xdndFinished;        // XDND finished message
  FXushort         xdndSelection;       // XDND selection atom
  FXushort         xdndActionMove;      // XDND Move action
  FXushort         xdndActionCopy;      // XDND Copy action
  FXushort         xdndActionLink;      // XDND Link action
  FXID             xdndSource;          // XDND drag source window
  FXID             xdndTarget;          // XDND drop target window
  FXushort         xdndAction;          // XDND Drag and Drop action
  FXbool           xdndAccepts;         // XDND true if target accepts
  FXbool           xdndSendPosition;    // XDND send position update when status comes in
  FXbool           xdndStatusPending;   // XDND waiting for status feedback
  FXbool           xdndFinishPending;   // XDND waiting for drop-confirmation
  FXbool           xdndStatusReceived;  // XDND received at least one status
  FXbool           xdndWantUpdates;     // XDND target wants new positions while in rect
  FXRectangle      xdndRect;            // XDND rectangle bounding target
  FXint            xdndXPos;            // XDND Cached X position
  FXint            xdndYPos;            // XDND Cached Y position
  FXID             stipples[17];        // Standard stipple bitmaps
  static FXID      hInstance;           // Global instance handle
#endif

public:

  // Public platform independent data
  FXCursor        *arrowCursor;         // Arrow cursor
  FXCursor        *rarrowCursor;        // Reverse arrow cursor
  FXCursor        *textCursor;          // Text cursor
  FXCursor        *hsplitCursor;        // Horizontal split cursor
  FXCursor        *vsplitCursor;        // Vertical split cursor
  FXCursor        *xsplitCursor;        // Cross split cursor
  FXCursor        *resizeCursor;        // Resize grip cursor
  FXCursor        *swatchCursor;        // Color swatch drag cursor
  FXCursor        *dontdropCursor;      // Cursor indicating no drop
  FXCursor        *moveCursor;          // Move cursor
  FXCursor        *dragHCursor;         // Resize horizontal edge
  FXCursor        *dragVCursor;         // Resize vertical edge
  FXCursor        *dragTLCursor;        // Resize upper-left or bottom-right corner
  FXCursor        *dragTRCursor;        // Resize upper-left or bottom-right corner
  FXCursor        *dndCopyCursor;       // Drag and drop copy
  FXCursor        *dndMoveCursor;       // Drag and drop move
  FXCursor        *dndLinkCursor;       // Drag and drop link
  FXCursor        *crosshairCursor;     // Cross hair cursor
  FXCursor        *cornerNECursor;      // North-east cursor
  FXCursor        *cornerNWCursor;      // North-west cursor
  FXCursor        *cornerSECursor;      // South-east cursor
  FXCursor        *cornerSWCursor;      // South-west cursor
  FXCursor        *rotateCursor;        // Rotate cursor
  FXuint           clickSpeed;          // Double click speed
  FXuint           scrollSpeed;         // Scroll speed
  FXuint           scrollDelay;         // Scroll delay
  FXuint           blinkSpeed;          // Cursor blink speed
  FXuint           animSpeed;           // Animation speed
  FXuint           menuPause;           // Menu popup delay
  FXuint           tooltipPause;        // Tooltip popup delay
  FXuint           tooltipTime;         // Tooltip display time
  FXint            scrollbarWidth;      // Scrollbar width
  FXint            dragDelta;           // Minimum distance considered a move
  FXColor          borderColor;         // Border color
  FXColor          baseColor;           // Background color of GUI controls
  FXColor          hiliteColor;         // Highlight color of GUI controls
  FXColor          shadowColor;         // Shadow color of GUI controls
  FXColor          backColor;           // Background color
  FXColor          foreColor;           // Foreground color
  FXColor          selforeColor;        // Select foreground color
  FXColor          selbackColor;        // Select background color
  
public:
  static const FXuchar version[3];      // Version number
  static const FXuchar copyright[80];   // Copyright notice

private:

  // Private member functions
  FXApp(const FXApp&);
  FXApp &operator=(const FXApp&);
  static void signalhandler(int sig);
  static void immediatesignalhandler(int sig);
#ifndef WIN32
  void addRepaint(FXID win,FXint x,FXint y,FXint w,FXint h,FXbool synth=0);
  void scrollRepaints(FXID win,FXint dx,FXint dy);
#else
  void leaveWindow(FXWindow *win,FXWindow *anc);
  void enterWindow(FXWindow *win,FXWindow *anc);
  static long CALLBACK wndproc(FXID hwnd,unsigned int iMsg,unsigned int wParam,long lParam);
protected:
  virtual long dispatchEvent(FXID hwnd,unsigned int iMsg,unsigned int wParam,long lParam);
#endif

protected:

  // Raw platform event handling
  FXbool getNextEvent(FXRawEvent& ev,FXbool blocking=TRUE);
  virtual void dispatchEvent(FXRawEvent& ev);
  
  // Connection to display
  int openDisplay(const FXchar* dpyname);
  void closeDisplay();
  
public:

  // Message handlers
  long onCmdQuit(FXObject*,FXSelector,void*);
  long onCmdDump(FXObject*,FXSelector,void*);

public:
  
  // Messages applications understand
  enum {
    ID_QUIT=0,
    ID_DUMP,
    ID_LAST
    };

public:

  /**
  * Construct application object; the name and vendor strings are used
  * as keys into the registry database for this application's settings
  */
  FXApp(const FXchar *name="Application",const FXchar *vendor="Default");

  /// Get application name
  const FXchar *getAppName() const { return appname; };

  /// Get default visual
  FXVisual* getDefaultVisual() const { return defaultVisual; }

  /// Change default visual
  void setDefaultVisual(FXVisual* vis);

  /// Get monochrome visual
  FXVisual* getMonoVisual() const { return monoVisual; }

  /// Get root Window
  FXRootWindow* getRoot() const { return root; }

  /// Get the window under the cursor, if any  
  FXWindow *getCursorWindow() const { return cursorWindow; }

  /// Get the window which has the focus, if any  
  FXWindow *getFocusWindow() const { return focusWindow; }

  /// Get main window, if any
  FXWindow *getMainWindow() const { return mainWindow; }

  /// Add timeout message to be sent to target object in ms milliseconds
  FXTimer* addTimeout(FXint ms,FXObject* tgt,FXSelector sel);

  /// Remove timeout, returns NULL
  FXTimer* removeTimeout(FXTimer *t);
  
  /**
  * Add a idle processing message to be sent to target object when
  * the system becomes idle, i.e. there are no events to be processed.
  */
  FXChore* addChore(FXObject* tgt,FXSelector sel);
  
  /// Remove idle processing message
  FXChore* removeChore(FXChore *c);

  /**
  * Add signal processing message to be sent to target object when 
  * the signal sig is raised; flags are to be set as per POSIX definitions.
  * When immediate is TRUE, the message will be sent to the target right away;
  * this should be used with extreme care as the application is interrupted
  * at an unknown point it its execution.
  */
  void addSignal(FXint sig,FXObject* tgt,FXSelector sel,FXbool immediate=FALSE,FXuint flags=0);
  
  /// Remove signal message for signal sig
  void removeSignal(FXint sig);

#ifndef WIN32

  /**
  * Add a file descriptor fd to be watched for activity as determined
  * by mode (an OR of INPUT_READ, INPUT_WRITE, and INPUT_EXCEPT).
  * The message will be sent to the target when the specified activity
  * is detected on the file descriptor.
  */
  void addInput(FXint fd,FXuint mode,FXObject *tgt,FXSelector sel);
  
  /**
  * Remove input message and target object for the specified file
  * descriptor and mode.
  */
  void removeInput(FXint fd,FXuint mode);
  
#endif

  /// Create application's windows
  virtual void create();

  /// Destroy application's windows
  virtual void destroy();

  /// Detach application's windows
  virtual void detach();

  /// Peek to determine if there's an event
  FXbool peekEvent();
  
  /// Main application event loop; returns when the application terminates
  FXint run();

  /// Perform one event dispatch
  void runOneEvent();

  /// Break out of main event loop
  void stop(FXint code=0);

  /// Run an event loop till some flag becomes non-zero
  void runUntil(FXuint& condition);

  /// Run event loop while events are available
  void runWhileEvents();

  /**
  * Run a modal event loop for the given window; user-input to
  * all other windows but the modal one are blocked.
  */
  FXint runModalFor(FXWindow* window);

  /// Break out of event loop
  void stopModal(FXWindow* window,FXint code);

  /// Run modal while window is shown, or until stopModal is called
  FXint runModalWhileShown(FXWindow* window);

  /// True if the window is modal
  FXbool isModal(FXWindow* window) const;

  /// Force GUI refresh
  void forceRefresh();

  /// Schedule a refresh
  void refresh();

  /// Flush pending repaints
  void flush();

  /// Initialize application
  void init(int& argc,char** argv);

  /// Exit application
  void exit(FXint code);

  /// Get registry
  FXRegistry& reg(){ return registry; }

  /// Register new DND type
  FXDragType registerDragType(const FXString& name) const;

  /// Get drag type name
  FXString getDragTypeName(FXDragType type) const;

  /// Beep
  void beep();

  /// Return application instance
  static inline FXApp* instance(){ return app; }

  /// Change default font
  void setNormalFont(FXFont* font);

  /// Return default font
  FXFont* getNormalFont() const { return normalFont; }

  /// Begin of wait-cursor block; wait-cursor blocks may be nested.
  void beginWaitCursor();
  
  /// End of wait-cursor block
  void endWaitCursor();
  
  /// Change to a new wait cursor
  void setWaitCursor(FXCursor *cur);

  /// Return current wait cursor  
  FXCursor* getWaitCursor() const { return waitCursor; }

  /// Save
  virtual void save(FXStream& store) const;

  /// Load
  virtual void load(FXStream& store);

  /// Dump widget information
  void dumpWidgets() const;

  /// Destroy the application and all reachable resources
  virtual ~FXApp();
  };

#endif
