/********************************************************************************
*                                                                               *
*                          H e a d e r   W i d g e t                            *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXOldHeader.h,v 1.2 1999/09/21 13:30:03 jeroen Exp $                     *
********************************************************************************/
#ifndef FXOLDHEADER_H
#define FXOLDHEADER_H



//////////////////////  THIS WIDGET HAS BEEN DEPRECATED  ////////////////////////



struct FXOldHeaderItem {
  FXOldHeaderItem* next;
  FXOldHeaderItem* prev;
  FXString      label;
  FXIcon*       icon;
  FXObject*     target;
  FXSelector    message;
  FXint         size;
  FXint         pos;
  };



// Splitter window 
class FXAPI FXOldHeader : public FXFrame {
  FXDECLARE(FXOldHeader)
private:
  FXOldHeaderItem  *firstitem;
  FXOldHeaderItem  *lastitem;
  FXOldHeaderItem  *before;
  FXFont*           font;
  FXColor           textColor;
  FXint             split;
  FXint             off;
protected:
  FXOldHeader();
  void moveSplit(FXint amount);
  void adjustLayout();
  void drawSplit(FXint pos);
  virtual FXOldHeaderItem* createItem();
  virtual void deleteItem(FXOldHeaderItem*);
  virtual void layout();
private:
  FXOldHeader(const FXOldHeader&);
  FXOldHeader &operator=(const FXOldHeader&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onUngrabbed(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
public:
  FXOldHeader(FXComposite* p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=FRAME_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
  virtual void create();
  virtual void detach();
  FXint getNumItems() const;
  FXOldHeaderItem* getFirstItem() const { return firstitem; }
  FXOldHeaderItem* getLastItem() const { return lastitem; }
  FXOldHeaderItem* getNextItem(const FXOldHeaderItem* item) const;
  FXOldHeaderItem* getPrevItem(const FXOldHeaderItem* item) const;
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  FXOldHeaderItem* addItemFirst(const FXString& text,FXIcon* icon=NULL,FXint size=20,FXObject* tgt=NULL,FXSelector sel=0);
  FXOldHeaderItem* addItemLast(const FXString& text,FXIcon* icon=NULL,FXint size=20,FXObject* tgt=NULL,FXSelector sel=0);
  void removeItem(FXOldHeaderItem* item);
  void removeItems(FXOldHeaderItem* fm,FXOldHeaderItem* to);
  void removeAllItems();
  FXint getItemX(const FXOldHeaderItem* item) const;
  FXint getItemY(const FXOldHeaderItem* item) const;
  FXint getItemWidth(const FXOldHeaderItem* item) const;
  FXint getItemHeight(const FXOldHeaderItem* item) const;
  void setItemText(FXOldHeaderItem* item,const FXString& text);
  FXString getItemText(const FXOldHeaderItem* item) const;
  void setItemTarget(FXOldHeaderItem* item,FXObject* tgt);
  FXObject* getItemTarget(const FXOldHeaderItem* item) const;
  void setItemSelector(FXOldHeaderItem* item,FXSelector sel);
  FXSelector getItemSelector(const FXOldHeaderItem* item) const;
  void setItemIcon(FXOldHeaderItem* item,FXIcon* icon);
  FXIcon* getItemIcon(const FXOldHeaderItem* item) const;
  void setFont(FXFont* fnt);
  FXFont* getFont() const { return font; }
  FXColor getTextColor() const { return textColor; }
  void setTextColor(FXColor clr);
  virtual ~FXOldHeader();
  };

  
  
#endif
