/********************************************************************************
*                                                                               *
*                       C o m b o   B o x   W i d g e t                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXOldComboBox.h,v 1.2 1999/09/21 13:30:03 jeroen Exp $                   *
********************************************************************************/
#ifndef FXOLDCOMBOBOX_H
#define FXOLDCOMBOBOX_H


//////////////////////  THIS WIDGET HAS BEEN DEPRECATED  ////////////////////////


// ComboBox styles
enum FXOldComboBoxStyle {
  OLDCOMBOBOX_NORMAL         = 0,                  // Can type text but list is not changed
  OLDCOMBOBOX_NO_REPLACE     = 0,                  // Leave the list the same
  OLDCOMBOBOX_REPLACE        = 0x00020000,         // Replace current item with typed text
  OLDCOMBOBOX_INSERT_BEFORE  = 0x00040000,         // Typed text inserted before current
  OLDCOMBOBOX_INSERT_AFTER   = 0x00060000,         // Typed text inserted after current
  OLDCOMBOBOX_INSERT_FIRST   = 0x00080000,         // Typed text inserted at begin of list
  OLDCOMBOBOX_INSERT_LAST    = 0x00090000,         // Typed text inserted at end of list
  OLDCOMBOBOX_STATIC         = 0x00100000          // Unchangable text box
  };


// Combobox
class FXAPI FXOldComboBox : public FXPacker {
  FXDECLARE(FXOldComboBox)
protected:
  FXTextField   *text;
  FXMenuButton  *button;
  FXOldList     *list;
  FXPopup       *pane;
protected:
  FXOldComboBox(){}
  virtual void layout();
private:
  FXOldComboBox(const FXOldComboBox&);
  FXOldComboBox &operator=(const FXOldComboBox&);
public:
  long onFocusUp(FXObject*,FXSelector,void*);
  long onFocusDown(FXObject*,FXSelector,void*);
  long onChanged(FXObject*,FXSelector,void*);
  long onCommand(FXObject*,FXSelector,void*);
  long onTextButton(FXObject*,FXSelector,void*);
  long onTextChanged(FXObject*,FXSelector,void*);
  long onTextCommand(FXObject*,FXSelector,void*);
  long onListClicked(FXObject*,FXSelector,void*);
  long onFwdToText(FXObject*,FXSelector,void*);
  long onUpdFmText(FXObject*,FXSelector,void*);
public:
  enum{
    ID_LIST=FXPacker::ID_LAST,
    ID_TEXT,
    ID_LAST
    };
public:
  FXOldComboBox(FXComposite *p,FXint cols,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);
  virtual void create();
  virtual void detach();
  virtual void destroy();
  virtual void enable();
  virtual void disable();
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  FXbool isEditable() const;
  void setEditable(FXbool edit=TRUE);
  void setCursorPos(FXint pos);
  FXint getCursorPos() const;
  void setAnchorPos(FXint pos);
  FXint getAnchorPos() const;
  void setText(const FXString& txt);
  FXString getText() const;
  void setFont(FXFont* fnt);
  FXFont* getFont() const;
  void setNumColumns(FXuint cols);
  FXuint getNumColumns() const;
  FXint getNumItems() const;
  FXOldListItem* getFirstItem() const;
  FXOldListItem* getLastItem() const;
  FXOldListItem* getNextItem(const FXOldListItem* item) const;
  FXOldListItem* getPrevItem(const FXOldListItem* item) const;
  FXOldListItem* addItemFirst(const FXString& txt,void* ptr=NULL);
  FXOldListItem* addItemLast(const FXString& txt,void* ptr=NULL);
  FXOldListItem* addItemAfter(FXOldListItem* other,const FXString& txt,void* ptr=NULL);
  FXOldListItem* addItemBefore(FXOldListItem* other,const FXString& txt,void* ptr=NULL); 
  void removeItem(FXOldListItem* item);
  void removeItems(FXOldListItem* fm,FXOldListItem* to);
  void removeAllItems();
  FXbool isItemCurrent(const FXOldListItem* item) const;
  FXint indexOfItem(const FXOldListItem* item) const;
  FXOldListItem* itemAtIndex(FXint index) const;
  void sortItems();
  void setCurrentItem(FXOldListItem* item);
  FXOldListItem* getCurrentItem() const;
  void setItemText(FXOldListItem* item,const FXString& text);
  FXString getItemText(const FXOldListItem* item) const;
  void setItemData(FXOldListItem* item,void* ptr) const;
  void* getItemData(const FXOldListItem* item) const;
  void setComboStyle(FXuint mode);
  FXuint getComboStyle() const;
  FXOldListItemSortFunc getSortFunc() const;
  void setSortFunc(FXOldListItemSortFunc func);
  void setHelpText(const FXString& txt);
  FXString getHelpText() const;
  void setTipText(const FXString& txt);
  FXString getTipText() const;
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXOldComboBox();
  };

  

#endif
