REM Calculates NTFS/FAT32 filesize in QB64. Uses unsigned 64-bit.

REM Using wdta.bi filesize maximum at 16.0 EB.

_DEFINE A-Z AS _UNSIGNED _INTEGER64

DIM FileSizeHigh AS STRING * 4
DIM FileSizeLow AS STRING * 4

FileSizeHigh = CHR$(255) + CHR$(255) + CHR$(255) + CHR$(255) ' ffffffff
FileSizeLow = CHR$(255) + CHR$(255) + CHR$(255) + CHR$(255) ' ffffffff

Temp = ASC(MID$(FileSizeHigh, 4, 1))
Temp = Temp * &H100 + ASC(MID$(FileSizeHigh, 3, 1))
Temp = Temp * &H100 + ASC(MID$(FileSizeHigh, 2, 1))
Temp = Temp * &H100 + ASC(MID$(FileSizeHigh, 1, 1))
Temp = Temp * &H100 + ASC(MID$(FileSizeLow, 4, 1))
Temp = Temp * &H100 + ASC(MID$(FileSizeLow, 3, 1))
Temp = Temp * &H100 + ASC(MID$(FileSizeLow, 2, 1))
Temp = Temp * &H100 + ASC(MID$(FileSizeLow, 1, 1))

PRINT FormatString$(Temp)
CALL Suffix(Temp, Var3$)
PRINT Var3$
END

' formats a numeric string
FUNCTION FormatString$ (s)
x$ = ""
s$ = STR$(s)
IF LEFT$(s$, 1) = "-" THEN ' store sign
   e$ = "-"
   s$ = MID$(s$, 2)
END IF
s$ = LTRIM$(s$) ' format string
IF INSTR(s$, ".") THEN
   q$ = MID$(s$, INSTR(s$, "."))
   s$ = LEFT$(s$, INSTR(s$, ".") - 1)
END IF
FOR l = LEN(s$) TO 3 STEP -3
   x$ = MID$(s$, l - 2, 3) + "," + x$
NEXT
IF l > 0 THEN
   x$ = MID$(s$, 1, l) + "," + x$
END IF
IF LEN(s$) < 3 THEN
   x$ = s$
END IF
IF RIGHT$(x$, 1) = "," THEN
   x$ = LEFT$(x$, LEN(x$) - 1)
END IF
x$ = e$ + x$ + q$ ' construct string
FormatString$ = x$
END FUNCTION

' calculate byte suffix
SUB Suffix (Var, Var3$)

REM B  (Byte) = 00x - 0FFx (hexidecimal zero-based)
REM KB (Kilobyte) = 1024 B
REM MB (Megabyte) = 1024 KB (1 MB B)
REM GB (Gigabyte) = 1024 MB
REM TB (Terabyte) = 1024 GB (1 MB MB)
REM PB (Petabyte) = 1024 TB
REM EB (Exabyte) = 1024 PB (1 MB TB)
REM ZB (Zettabyte) = 1024 EB
REM YB (Yottabyte) = 1024 ZB (1 MB EB)

' check exponent
VarX = Var
s$ = STR$(VarX)
IF INSTR(s$, "D") THEN
   Var3$ = s$
   EXIT SUB
END IF

' get sign
IF VarX < 0# THEN
   Sign = -1
   VarX = ABS(VarX)
END IF

' calculate bytes
TempA = False
DO
   IF VarX >= 1024 THEN
      VarX = VarX / 1024
      TempA = TempA + 1
      IF TempA = 8 THEN
         EXIT DO
      END IF
   ELSE
      EXIT DO
   END IF
LOOP

' calculate byte string
Var3$ = FormatString$(VarX)

' calculate byte suffix
Var$ = ""
IF TempA > 0 THEN
   Var$ = MID$("KMGTPEZY", TempA, 1)
END IF
Var3$ = Var3$ + " " + Var$ + "B"

' calculate byte sign
IF Sign THEN
   Var3$ = "-" + Var3$
END IF
END SUB

