REM SICHelp.bas v64.0a r5.1a - Symbolic Instruction Code Kit; help module.

' get standard include declarations
REM $INCLUDE: 'SIC.INC'

' declare global error routine
ON ERROR GOTO ErrorRoutine

' run program from command line
CALL ListHelp
ErrorResume:
COLOR Plain, Black
WHILE INKEY$ <> Nul
WEND
PRINT "Exiting to system.."
END

' standard error trap for all Sic functions.
ErrorRoutine:
IF POS(0) > 1 THEN
    PRINT
END IF
COLOR White, Black
PRINT "Help utility error"; ERR
RESUME ErrorResume

' display help menu
SUB ListHelp
DO
    COLOR White, Black
    PRINT "Help utility SIC v" + Version + " r" + Release + " list:"
    COLOR Yellow, Black
    PRINT "[1]command list"
    PRINT "[2]general documentation"
    PRINT "[3]formatting information"
    PRINT "[4]screen mode tables"
    PRINT "[5]error code values"
    PRINT "[6]syntax documentation"
    PRINT "[7]boolean syntax/charts"
    PRINT "[8]troolean syntax/charts"
    PRINT "[9]disclaimer notice"
    PRINT "[A]shareware information"
    CALL MorePrompt1("Enter(1-A, Q to quit)?", "123456789aq", OutputChar$)
    SELECT CASE OutputChar$
        CASE "1"
            COLOR White, Black
            PRINT "SIC created: " + PublishDate
            COLOR Yellow, Black
            PRINT "ANALYZE  --  checks program structure."
            PRINT "CONTINUE --  continue halted program."
            PRINT "DEBUG    --  immediate debug mode."
            PRINT "DIRS     --  list directories."
            PRINT "DRIVES   --  list drive labels/space."
            PRINT "FILES    --  list filenames."
            PRINT "HELP     --  lists help topics."
            PRINT "INDENT   --  formats current program."
            PRINT "KILL     --  delete program."
            PRINT "LIST     --  display current program."
            PRINT "LOAD     --  read program from disk."
            PRINT "NEW      --  erase current program."
            PRINT "PRINT    --  print current program."
            PRINT "QUIT     --  exit SIC64 interpreter."
            PRINT "RENUMBER --  renumber program."
            PRINT "RUN      --  start current program."
            PRINT "SAVE     --  store current program."
            PRINT "SEARCH   --  search program for keyword."
            PRINT "SET      --  set string display for prompts."
            PRINT "SHELL    --  exit to dos shell."
            PRINT "VERSION  --  displays program version."
            PRINT "WHATIS   --  enter immediate mode."
            CALL KeyPrompt
        CASE "2"
            Filename = "sic64.doc"
            CALL ListHelpFile
        CASE "3"
            Filename = "sicform.doc"
            CALL ListHelpFile
        CASE "4"
            Filename = "sicscrn.doc"
            CALL ListHelpFile
        CASE "5"
            Filename = "error.doc"
            CALL ListHelpFile
        CASE "6"
            Filename = "syntax.doc"
            CALL ListHelpFile
        CASE "7"
            Filename = "boolean.doc"
            CALL ListHelpFile
        CASE "8"
            Filename = "troolean.doc"
            CALL ListHelpFile
        CASE "9"
            Filename = "disclaim.doc"
            CALL ListHelpFile
        CASE "a"
            Filename = "disclam2.doc"
            CALL ListHelpFile
        CASE "q"
            EXIT DO
    END SELECT
LOOP
END SUB

' displays a help file
SUB ListHelpFile
IF _FILEEXISTS(Filename$) = 0 THEN
    PRINT "Help file not found."
    EXIT SUB
END IF
CLOSE
OPEN Filename$ FOR INPUT AS #1
Continuous = False
LineCount = False
DO WHILE NOT EOF(1)
    COLOR Yellow, Black
    LINE INPUT #1, InputLine$
    PRINT InputLine$
    IF Continuous = False THEN
        LineCount = LineCount + 1
        IF LineCount = 23 THEN
            LineCount = False
            CALL MorePrompt1("More(y/n/c)?", "ync", OutputChar$)
            SELECT CASE OutputChar$
                CASE "n"
                    EXIT DO
                CASE "c"
                    Continuous = True
            END SELECT
        END IF
    END IF
LOOP
CALL KeyPrompt
END SUB

' prompts for multiple input characters
SUB MorePrompt1 (InputString$, InputMask$, OutputString$)
COLOR White, Black
PRINT InputString$; " ";
InputChar$ = Nul
DO
    LOCATE , , 1
    InputChar$ = INKEY$
    IF LEN(InputChar$) THEN
        InputChar$ = LCASE$(InputChar$)
        IF INSTR(InputMask$, InputChar$) THEN
            PRINT InputChar$
            OutputString$ = InputChar$
            EXIT DO
        END IF
    END IF
LOOP
END SUB

' prompts for a keystroke
SUB KeyPrompt
COLOR White, Black
LOCATE , , 1
PRINT "Press any key to continue:";
InputChar$ = Nul
DO
    InputChar$ = INKEY$
    IF LEN(InputChar$) THEN
        EXIT DO
    END IF
LOOP
PRINT
END SUB
