 REM file: Sic.inc v64.0a r5.1a - Symbolic Instruction Code Kit; include module.
 REM The public domain DOS programming interpreter.

 REM $DYNAMIC
 DEFINT A-Z

 ' boolean constants
 CONST Dfalse=0#
 CONST Dtrue=-1#
 CONST False=0
 CONST True=-1

 ' color constants
 CONST Black=0
 CONST Plain=7
 CONST Blue=9
 CONST Green=10
 CONST Cyan=11
 CONST Red=12
 CONST Magenta=13
 CONST Yellow=14
 CONST White=15

 ' can be changed
 CONST Max.Arrays=128
 CONST Max.FN.Length=1024
 CONST Max.Functions=26
 CONST Max.History=10
 CONST Max.Lines=4096
 CONST Max.Nest.Gosubs=128
 CONST Max.Recurse=16

 ' cannot be changed
 CONST MaxInt=32766
 CONST MaxFiles=255
 CONST MaxCommands=25
 CONST MaxStatements=151

 ' should not be changed
 CONST None$="<none>"
 CONST Nul=""
 CONST PrimeKey=29
 CONST PublishDate="04/20/2016"
 CONST Release="5.1a"
 CONST Version="64.0a"
 CONST Untitled$="<untitled>"

 ' could be changed
 CONST MorePrompt="More(y/n/c)?"
 CONST MorePrompt2="More(y/n)?"
 CONST MorePrompt3="(y/n/q)?"
 CONST MorePrompt4="-more-"

 ' subroutine declarations
 DECLARE SUB Analyze.Program(V1%, V2%, V$)
 DECLARE SUB Arith(V$, V1#, V2#)
 DECLARE SUB Assign.End()
 DECLARE SUB Assignment1(V$, V%)
 DECLARE SUB Assignment2(V$, V1%, V2%)
 DECLARE SUB Assignment3(V$, V1$)
 DECLARE SUB Assignment4(V$, V1$)
 DECLARE SUB Concatenate(V$)
 DECLARE SUB Check.Drive(V%,V#)
 DECLARE SUB Count.Lines(V%)
 DECLARE SUB Decrease.PSP()
 DECLARE SUB Display.Error()
 DECLARE SUB Debug.Command()
 DECLARE SUB End.Program()
 DECLARE SUB Enter.Equate()
 DECLARE SUB Enter.Program.Line()
 DECLARE SUB Equate(V#)
 DECLARE SUB Execute.Command(V$)
 DECLARE SUB Find.File(V$, V%)
 DECLARE SUB Get.Token()
 DECLARE SUB Get.Token2(V%)
 DECLARE SUB Get.Token3()
 DECLARE SUB Get.Token4()
 DECLARE SUB Indent.Program(V%)
 DECLARE SUB Key.Prompt()
 DECLARE SUB Kill.Program(V$)
 DECLARE SUB List.Drives(V$,V%)
 DECLARE SUB List.Files(V$,V%)
 DECLARE SUB List.Help()
 DECLARE SUB List.Help.File()
 DECLARE SUB List.Program(V1%, V2%, V3%)
 DECLARE SUB Load.Program(V$)
 DECLARE SUB More.Prompt(V1$, V2$, V$)
 DECLARE SUB New.Program()
 DECLARE SUB OS()
 DECLARE SUB Parse.Alphabetic1(V#)
 DECLARE SUB Parse.Alphabetic2(V#)
 DECLARE SUB Parse.Alphabetic3(V#)
 DECLARE SUB Parse.Numeric (V#)
 DECLARE SUB Parse.Quoted()
 DECLARE SUB Parse1(V#)
 DECLARE SUB Parse2(V#)
 DECLARE SUB Parse3(V#)
 DECLARE SUB Parse4(V#)
 DECLARE SUB Parse5(V#)
 DECLARE SUB Parse6(V#)
 DECLARE SUB Parse7(V#)
 DECLARE SUB Parse8(V#)
 DECLARE SUB Parse9(V#)
 DECLARE SUB Prepare.Program()
 DECLARE SUB Quit.Program()
 DECLARE SUB Read.Config(V%)
 DECLARE SUB Read.Data.Element(V%)
 DECLARE SUB Read.Program()
 DECLARE SUB Read.Stdin()
 DECLARE SUB Release.Time(V%)
 DECLARE SUB Renumber.Program(V1%, V2%)
 DECLARE SUB Run.Program(V%)
 DECLARE SUB Save.Current()
 DECLARE SUB Save.Program(V$)
 DECLARE SUB Search.Program()
 DECLARE SUB Stop.Program()
 DECLARE SUB Store.Program()
 DECLARE SUB Whatis.Command(V$)

 ' function declarations
 DECLARE FUNCTION Ambiguate$(V$)
 DECLARE FUNCTION BreakIS()
 DECLARE FUNCTION ClearBreak()
 DECLARE FUNCTION ClearBuffer()
 DECLARE FUNCTION FormatString$(s#)
 DECLARE FUNCTION FreeFileNumber()
 DECLARE FUNCTION KeyboardChar$()
 DECLARE FUNCTION KeyboardLine$()
 DECLARE FUNCTION KeyboardLine2$()
 DECLARE FUNCTION KeyIS()
 DECLARE FUNCTION TempName$()

 DECLARE FUNCTION STRIM$(V$)
 DECLARE FUNCTION TTRIM$(V$, V%)
 DECLARE FUNCTION XTRIM$(V$, V%)

 ' global variables
 DIM SHARED Allow.Alpha AS INTEGER
 DIM SHARED Allow.Extra AS INTEGER
 DIM SHARED Array.Size AS INTEGER
 DIM SHARED Assign AS INTEGER
 DIM SHARED ASCIIZ AS STRING * 260
 DIM SHARED Boot.Error AS INTEGER
 DIM SHARED CaseStrng AS STRING
 DIM SHARED CaseValue AS DOUBLE
 DIM SHARED CaseValue1 AS DOUBLE
 DIM SHARED CaseValue2 AS DOUBLE
 DIM SHARED CaseValueS1 AS STRING
 DIM SHARED CaseValueS2 AS STRING
 DIM SHARED CommandLine AS STRING
 DIM SHARED ControlBreak AS INTEGER
 DIM SHARED CurrentDirectory AS STRING
 DIM SHARED CurrentDirectory2 AS STRING
 DIM SHARED DataLine AS INTEGER
 DIM SHARED DataNumber AS INTEGER
 DIM SHARED DataValue AS DOUBLE
 DIM SHARED Debug.Active AS INTEGER
 DIM SHARED DEFSEGvalue AS DOUBLE
 DIM SHARED DOSbox AS INTEGER
 DIM SHARED ErrorLine AS INTEGER
 DIM SHARED ErrorLine2 AS INTEGER
 DIM SHARED ErrorType AS INTEGER
 DIM SHARED ErrorValue AS INTEGER
 DIM SHARED ExceptStep AS DOUBLE
 DIM SHARED ExceptStepIs AS INTEGER
 DIM SHARED FieldVariable AS INTEGER
 DIM SHARED Filename AS STRING
 DIM SHARED FileNumber AS INTEGER
 DIM SHARED FinishFor AS DOUBLE
 DIM SHARED Recurse AS INTEGER
 DIM SHARED InDEFSEG AS INTEGER
 DIM SHARED InDEFSEG2 AS INTEGER
 DIM SHARED LastCursor1 AS INTEGER
 DIM SHARED LastCursor2 AS INTEGER
 DIM SHARED LastCursor3 AS INTEGER
 DIM SHARED LastColor1 AS INTEGER
 DIM SHARED LastColor2 AS INTEGER
 DIM SHARED LastScreen1 AS INTEGER
 DIM SHARED LastScreen2 AS INTEGER
 DIM SHARED LastScreen3 AS INTEGER
 DIM SHARED LastScreen4 AS INTEGER
 DIM SHARED LastWidth1 AS INTEGER
 DIM SHARED LastWidth2 AS INTEGER
 DIM SHARED Last.Line AS INTEGER
 DIM SHARED Last.Search.Case AS INTEGER
 DIM SHARED Last.Search.Line AS INTEGER
 DIM SHARED Last.Search.Keyword AS STRING
 DIM SHARED Last.Token AS INTEGER
 DIM SHARED LineFeed AS INTEGER
 DIM SHARED ListLines AS INTEGER
 DIM SHARED Max.Errors AS INTEGER
 DIM SHARED Max.Gosubs AS INTEGER
 DIM SHARED Nested.Gosub AS INTEGER
 DIM SHARED OperatingSystem AS STRING
 DIM SHARED Out2 AS STRING
 DIM SHARED Out3 AS STRING
 DIM SHARED Out4 AS STRING
 DIM SHARED PageLength AS INTEGER
 DIM SHARED Pipe.Buffer AS STRING * 1
 DIM SHARED Printing AS INTEGER
 DIM SHARED PrinterLF AS INTEGER
 DIM SHARED Prepare.Filename AS STRING
 DIM SHARED Program.Line AS INTEGER
 DIM SHARED Program.Name AS STRING
 DIM SHARED Program.Resume AS INTEGER
 DIM SHARED Quote AS STRING * 1
 DIM SHARED Quotes AS INTEGER
 DIM SHARED Run.Line AS INTEGER
 DIM SHARED Run.Type AS INTEGER
 DIM SHARED StepTo AS DOUBLE
 DIM SHARED SaveOnExit AS INTEGER
 DIM SHARED ScreenHeight AS INTEGER
 DIM SHARED ScreenMode AS INTEGER
 DIM SHARED ScreenWidth AS INTEGER
 DIM SHARED StdinInput1 AS INTEGER
 DIM SHARED StdinInput2 AS STRING
 DIM SHARED StdinPrompt AS INTEGER
 DIM SHARED Supported.Call AS INTEGER
 DIM SHARED Strng AS STRING
 DIM SHARED Token AS INTEGER
 DIM SHARED Token.Index AS INTEGER
 DIM SHARED Token.List AS STRING
 DIM SHARED Unless.Branch AS INTEGER
 DIM SHARED Unless.Value AS DOUBLE
 DIM SHARED ValueIs AS DOUBLE
 DIM SHARED Visible AS INTEGER
 DIM SHARED Var.Seg1 AS STRING
 DIM SHARED Var.Seg2 AS DOUBLE
 DIM SHARED White.Space AS STRING
 DIM SHARED Windows.Detected AS INTEGER

 ' program areas
 DIM SHARED Commands(1) AS STRING ' stores all .sic menu commands
 DIM SHARED Statements(1) AS STRING ' stores all .sic program commands
 DIM SHARED LineBreak(1) AS INTEGER ' stores line break flags
 DIM SHARED VariableBreak(1) AS INTEGER ' stores variable break flags
 DIM SHARED VariableValue(1) AS DOUBLE ' stores variable values for break
 DIM SHARED VariableBreak2(1) AS INTEGER ' stores variable break flags
 DIM SHARED VariableValue2(1) AS STRING ' stores variable values for break
 DIM SHARED VariableBreak3(1) AS INTEGER ' stores variable break flags
 DIM SHARED VariableValue3(1) AS DOUBLE ' stores variable values for break

 ' code areas
 DIM SHARED GosubReturn(1) AS INTEGER ' stack space for gosubs
 DIM SHARED Program(1 TO Max.Lines) AS STRING ' storage space for .sic program

 ' data areas
 DIM SHARED Arrays(1) AS DOUBLE ' variable arrays A() to Z()
 DIM SHARED Strngs(1) AS STRING ' string variables A$ to Z$
 DIM SHARED Variables(1) AS DOUBLE ' variables A to Z
 DIM SHARED Definitions(1) AS STRING ' DEF FN functions
 DIM SHARED Errors(1) AS STRING * 64 ' error messages

 ' multi-dimensional command history arrays
 DIM SHARED History.Count2(1) As Integer
 DIM SHARED History2(1) As String*256

 ' multi-dimensional command history variable
 DIM SHARED Temp0 As Integer

 ' subroutine area
 DIM SHARED Renumber.List(1) AS INTEGER ' space for renumber subroutine

 ' file areas
 DIM SHARED Field.Array(1) AS STRING
 DIM SHARED File.Fields(1) AS STRING

 ' graphics areas
 DIM SHARED Graphics.Screen(1) AS INTEGER
 DIM SHARED Var.Seg3(1) AS INTEGER

 ' temp directory
 DIM SHARED DRX AS STRING

 ' declare prompt strings
 DIM SHARED Prompt1 AS STRING
 DIM SHARED Prompt2 AS STRING
 DIM SHARED Prompt3 AS STRING

 ' -end include file-
