REM Program: Hex Editor v6.0a, Module 5 of 5, PD 2004.
REM Author: Erik Jon Oredson AS. Csci
REM Release: 04/10/2004.
REM Status: Public Domain.
REM Email: eoredson@yahoo.com
REM Urls: www.simtel.net www.filegate.net
REM  www.winsite.com

' get include file.
REM $INCLUDE: 'hexedit.inc'

REM File menu box routine:

' These variables are set before a call to menu:
'   Mouse.Present = TestMouse ' check mouse present.
'   Windows.Detected = TestWindows ' verify windows loaded.

SUB Menu (C$, D$, X$, E$)

' Returns:
'   C$  -  Drive letter.
'       Normally C without : or \
'   D$  -  Directory.
'       Without leading or trailing \ (can be null)
'   X$  -  Filespec.
'       Normally *.*
'   E$  -  Filename.
'       Can be long filename. No leading or trailing spaces.
'
' Concatenate upon return:
'   IF D$ = "" THEN
'      Filename = C$ + ":\" + E$
'   ELSE
'      Filename = C$ + ":\" + D$ + "\" + E$
'   END IF
'
' During editing,
'   I$  -  Current keystroke.
'   F$  -  Fully qualified pathname with filename and drive letter.
'   Q$  -  Current subdirectory.
'   D1$ -  Temporary directory storage.
'   X1$ -  Temporary file entry area path/file.
'   X2$ -  Temporary filename storage.
'
' Mouse variables,
'   IsMenu =
'     1  -  Click in file box.
'     2  -  Click in dir box.
'     3  -  Click in drive box.
'     4  -  Click in entry area.
'     5  -  Click on 'x' to exit.

' define simple error routine.
ON LOCAL ERROR GOTO Error.Routine3

' restore data.
RESTORE

' read Alt-<key> data.
DIM Keys(26) AS INTEGER
FOR Var = 1 TO 26
   READ Keys(Var)
NEXT

' reset flags.
Ambiguate = AmbiguateSwitch

' open structure files.
GOSUB OpenDataFiles1

' display menu screen.
CALL FileMainMenu

' get current drive/directory.
Current.Drive = False
GOSUB GetDrives
GOSUB InitDrive
GOSUB InitDir

' get current filespec.
GOSUB InitFileSpec

' get current directory spec.
GOSUB InitDirSpec

' read all filenames.
GOSUB ClearFileBox
GOSUB LoadFileSpec
GOSUB DisplayFileSpec
GOSUB DisplayCurrentPath

' read all subdirectories.
GOSUB ClearDirBox
GOSUB LoadDirSpec
GOSUB DisplayDirSpec
GOSUB DisplayCurrentDir
GOSUB DisplayCurrentPath

' display first directory.
Current.Dir = 1
Dir.Box.Line = 1
GOSUB DisplayInitDir

' display all drives.
GOSUB InitDrives

' display first file.
GOSUB ClearLongName2
IF Num.Files > 0 THEN
   Current.File = 1
   Box.Line = 1
   GOSUB InitFiles
END IF

' check mouse.
IF Mouse.Present THEN
   ' position mouse.
   CALL MouseFunction2(1,1)
END IF
CALL SMouse

' reset filename attribute overrides.
RequireReadOnly = False
RequireHidden = False
RequireSystem = False
RequireArchive = False
RequireDirReadOnly = False
RequireDirHidden = False
RequireDirSystem = False
RequireDirArchive = False

' File entry area variables:
'   ProcessEditLine - processes X$ edit line when set to True.
'   Xstart     - hilights file entry area for overstrike when set to True.
'   Xposition1 - left position in file entry area editing string.
'   Xposition2 - position of character in file entry area editing string.
'
' main input loop.
Xstart = True
Xposition1 = 1
DO
   ' reset filespec.
   IF X$ = "" THEN
      X$ = "*.*"
      Xposition1 = 1
      Xposition2 = 3
   END IF

   ' display file entry area.
   GOSUB DisplayFileLine

   ' start input loop.
   DO
      ' reset input.
      I$ = ""

      ' reset edit line.
      ProcessEditLine = False

      ' process input.
      DO
         ' get keypress.
         I$ = INKEY$

         ' process keypress.
         IF LEN(I$) THEN
            IsMenu = False
            EXIT DO
         END IF

         ' call mouse subroutine.
         CALL MouseDriver

         ' check exit symbol.
         IF IsMenu = 5 THEN
            I$ = CHR$(27)
            EXIT DO
         END IF

         ' check left mouse button.
         IF Mouse.ButtonX THEN
            GOSUB MouseButton1Z
            SELECT CASE IsMenu
            CASE 1 ' file box.
               IF I$ = CHR$(13) THEN
                  E$ = RTRIM$(Filenames(Current.File))
                  GOTO EndLoop2
               ELSE
                  GOSUB FileBoxKey
               END IF
            CASE 2 ' dir box.
               IF I$ = CHR$(13) THEN
                  GOSUB GetNewPath
                  EXIT DO
               ELSE
                  GOSUB Dirboxkey
               END IF
            CASE 3 ' drive box.
               IF I$ = CHR$(13) THEN
                  X$ = CHR$(Current.Drive + 64) + ":\*.*"
                  ProcessEditLine = True
                  EXIT DO
               ELSE
                  GOSUB Driveboxkey
               END IF
            END SELECT
         ELSE
            ' check mouse position.
            IF Mouse.Row OR Mouse.Column THEN
               GOSUB MouseOverX1
               GOSUB DisplayFileLine
            END IF
         END IF

         ' release time slice,
         ' (speeds up mouse in windows).
         Var = ReleaseTime
      LOOP

      ' ignore network slash
      IF I$ = "/" THEN
         I$ = ""
      END IF
StartLoop0:
      ' check alt-<key>
      IF LEN(I$) = 2 THEN
         GOSUB GetAltKey
         IF VarZ THEN
            ' specify drive letter.
            X$ = CHR$(Var2 + 64) + ":\*.*"
            I$ = ""
            ProcessEditLine = True
            EXIT DO
         END IF
      END IF
StartLoop1:
      ' check extended key
      IF LEN(I$) = 2 THEN
         SELECT CASE ASC(RIGHT$(I$, 1))
         CASE 71 ' Home
            IF Xposition2 > 0 THEN
               Xposition1 = 1
               Xposition2 = 0
               GOSUB DisplayFileLine
            END IF
         CASE 79 ' End
            IF Xposition2 < LEN(X$) THEN
               Xposition2 = LEN(X$)
               Xposition1 = Xposition2 - 25
               IF Xposition1 < 1 THEN
                  Xposition1 = 1
               END IF
               GOSUB DisplayFileLine
            END IF
         CASE 83 ' Delete
            IF LEN(X$) > 0 THEN
               Xstart = False
               X$ = LEFT$(X$, Xposition2) + MID$(X$, Xposition2 + 2)
               GOSUB DisplayFileLine
            END IF
         CASE 75 ' Left
            IF LEN(X$) THEN
               IF Xposition2 > 0 THEN
                  Xposition2 = Xposition2 - 1
                  IF Xposition2 - 25 <= Xposition1 THEN
                     Xposition1 = Xposition1 - 1
                     IF Xposition1 < 1 THEN
                        Xposition1 = 1
                     END IF
                     GOSUB DisplayFileLine
                  END IF
               END IF
            END IF
         CASE 77 ' Right
            IF LEN(X$) THEN
               IF Xposition2 < LEN(X$) THEN
                  Xposition2 = Xposition2 + 1
                  IF Xposition2 > Xposition1 + 25 THEN
                     Xposition1 = Xposition1 + 1
                  END IF
                  GOSUB DisplayFileLine
               END IF
            END IF
         CASE 80 ' Down
            I$ = CHR$(9)
            GOTO TabFile
         CASE 59 ' F1 changes drive letter.
            I$ = ""
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            PRINTf SPACE$(38)
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            COLORf2 Yellow, 0
            PRINTf "Drive letter: "
            DO
               Z$ = INKEY$
               IF LEN(Z$) = 1 THEN
                  Z$ = UCASE$(Z$)
                  IF Z$ >= "A" AND Z$ <= "Z" THEN
                     EXIT DO
                  END IF
               END IF
            LOOP
            PRINTf Z$
            X$ = UCASE$(Z$) + ":\*.*"
            I$ = ""
            ProcessEditLine = True
            EXIT DO
         CASE 60 ' F2 toggles heap sorting.
            I$ = ""
            HeapSortOff = NOT HeapSortOff
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            PRINTf SPACE$(38)
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            COLORf2 White, 0
            IF HeapSortOff THEN
               PRINTf "Sorting Off. Press <esc>:"
            ELSE
               PRINTf "Sorting On. Press <esc>:"
            END IF
            WHILE INKEY$<>CHR$(27)
            WEND
            GOSUB UpdateDisplay
            EXIT DO
         CASE 61 ' F3 moves file menu box.
            CALL HMouse
            I$ = ""
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            PRINTf SPACE$(38)
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            COLORf2 White, 0
            PRINTf "Use cursor keys. Press <esc> to quit."
            ' move menu.
            GOSUB StoreArea
            COLORf2 White, 1
            CLS
            GOSUB RestoreArea
            I$ = ""
            DO
               I$ = INKEY$
               IF LEN(I$) THEN
                  IF I$ = CHR$(27) THEN
                     I$ = ""
                     EXIT DO
                  END IF
                  IF LEN(I$) = 2 THEN
                     SELECT CASE ASC(RIGHT$(I$, 1))
                     CASE 72 ' up
                        IF Xcoor - 1 >= 2 THEN
                           Xcoor = Xcoor - 1
                           COLORf2 White, 1
                           CLS
                           GOSUB RestoreArea
                        END IF
                     CASE 80 ' down
                        IF Xcoor + 1 <= 8 THEN
                           Xcoor = Xcoor + 1
                           COLORf2 White, 1
                           CLS
                           GOSUB RestoreArea
                        END IF
                     CASE 75 ' left
                        IF Ycoor - 1 >= 1 THEN
                           Ycoor = Ycoor - 1
                           COLORf2 White, 1
                           CLS
                           GOSUB RestoreArea
                        END IF
                     CASE 77 ' right
                        IF Ycoor + 1 <= 39 THEN
                           Ycoor = Ycoor + 1
                           COLORf2 White, 1
                           CLS
                           GOSUB RestoreArea
                        END IF
                     END SELECT
                  END IF
               END IF
            LOOP
            CALL BottomRow
            GOSUB DisplayCurrentPath
            IF Num.Files > 0 THEN
               GOSUB DisplayLongName2
            END IF
            GOSUB DisplayFilenamex
            GOSUB DisplayFileLine
            CALL SMouse
         CASE 62 ' F4 backward 1 drive letter.
            I$ = ""
            V = ASC(C$)
            IF V > 65 THEN
               V = V - 1
               X$ = CHR$(V) + ":\*.*"
               ProcessEditLine = True
               EXIT DO
            END IF
         CASE 63 ' F5 forward 1 drive letter.
            I$ = ""
            V = ASC(C$) - 64
            IF V + 1 <= Last.Drive THEN
               V = V + 1
               X$ = CHR$(V + 64) + ":\*.*"
               ProcessEditLine = True
               EXIT DO
            END IF
         CASE 64 ' F6 toggle ambiguate.
            I$ = ""
            Ambiguate = NOT Ambiguate
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            PRINTf SPACE$(38)
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            COLORf2 White, 0
            IF Ambiguate = False THEN
               PRINTf "Ambiguation Off. Press <esc>:"
            ELSE
               PRINTf "Ambiguation On. Press <esc>:"
            END IF
            WHILE INKEY$<>CHR$(27)
            WEND
            GOSUB UpdateDisplay
            EXIT DO
         CASE 65 ' F7 redraw screen
            GOSUB RedrawScreen
            EXIT DO
         CASE 66 ' F8 attribute override
            I$ = ""
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            PRINTf SPACE$(38)
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            COLORf2 White, 0
            PRINTf "Require readonly bit. Press <y/n>:"
            DO
               M$ = ""
               WHILE M$ = ""
                  M$ = INKEY$
               WEND
               M$ = UCASE$(M$)
               IF M$ = "Y" THEN
                  RequireReadOnly = True
                  EXIT DO
               END IF
               IF M$ = "N" THEN
                  RequireReadOnly = False
                  EXIT DO
               END IF
            LOOP
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            PRINTf SPACE$(38)
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            COLORf2 White, 0
            PRINTf "Require hidden bit. Press <y/n>:"
            DO
               M$ = ""
               WHILE M$ = ""
                  M$ = INKEY$
               WEND
               M$ = UCASE$(M$)
               IF M$ = "Y" THEN
                  RequireHidden = True
                  EXIT DO
               END IF
               IF M$ = "N" THEN
                  RequireHidden = False
                  EXIT DO
               END IF
            LOOP
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            PRINTf SPACE$(38)
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            COLORf2 White, 0
            PRINTf "Require system bit. Press <y/n>:"
            DO
               M$ = ""
               WHILE M$ = ""
                  M$ = INKEY$
               WEND
               M$ = UCASE$(M$)
               IF M$ = "Y" THEN
                  RequireSystem = True
                  EXIT DO
               END IF
               IF M$ = "N" THEN
                  RequireSystem = False
                  EXIT DO
               END IF
            LOOP
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            PRINTf SPACE$(38)
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            COLORf2 White, 0
            PRINTf "Require archive bit. Press <y/n>:"
            DO
               M$ = ""
               WHILE M$ = ""
                  M$ = INKEY$
               WEND
               M$ = UCASE$(M$)
               IF M$ = "Y" THEN
                  RequireArchive = True
                  EXIT DO
               END IF
               IF M$ = "N" THEN
                  RequireArchive = False
                  EXIT DO
               END IF
            LOOP
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            PRINTf SPACE$(38)
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            COLORf2 White, 0
            PRINTf "Require dir readonly bit. Press <y/n>:"
            DO
               M$ = ""
               WHILE M$ = ""
                  M$ = INKEY$
               WEND
               M$ = UCASE$(M$)
               IF M$ = "Y" THEN
                  RequireDirReadOnly = True
                  EXIT DO
               END IF
               IF M$ = "N" THEN
                  RequireDirReadOnly = False
                  EXIT DO
               END IF
            LOOP
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            PRINTf SPACE$(38)
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            COLORf2 White, 0
            PRINTf "Require dir hidden bit. Press <y/n>:"
            DO
               M$ = ""
               WHILE M$ = ""
                  M$ = INKEY$
               WEND
               M$ = UCASE$(M$)
               IF M$ = "Y" THEN
                  RequireDirHidden = True
                  EXIT DO
               END IF
               IF M$ = "N" THEN
                  RequireDirHidden = False
                  EXIT DO
               END IF
            LOOP
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            PRINTf SPACE$(38)
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            COLORf2 White, 0
            PRINTf "Require dir system bit. Press <y/n>:"
            DO
               M$ = ""
               WHILE M$ = ""
                  M$ = INKEY$
               WEND
               M$ = UCASE$(M$)
               IF M$ = "Y" THEN
                  RequireDirSystem = True
                  EXIT DO
               END IF
               IF M$ = "N" THEN
                  RequireDirSystem = False
                  EXIT DO
               END IF
            LOOP
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            PRINTf SPACE$(38)
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            COLORf2 White, 0
            PRINTf "Require dir archive bit. Press <y/n>:"
            DO
               M$ = ""
               WHILE M$ = ""
                  M$ = INKEY$
               WEND
               M$ = UCASE$(M$)
               IF M$ = "Y" THEN
                  RequireDirArchive = True
                  EXIT DO
               END IF
               IF M$ = "N" THEN
                  RequireDirArchive = False
                  EXIT DO
               END IF
            LOOP
            GOSUB UpdateDisplay
            EXIT DO
         CASE 67 ' F9 help screen
            I$ = ""
            CALL HMouse
            CALL DisplayHelp
            GOSUB RedrawScreen
            CALL SMouse
         CASE 68 ' F10 exit program
            I$ = CHR$(27)
            EXIT DO
         CASE 133 ' F11 Drop to DOS
            COLORf Plain
            CLS
            PRINTf "Type 'Exit' to return to editor.."
            SHELL
            GOSUB RedrawScreen
            EXIT DO
         CASE 134 ' F12 enter filespec
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            PRINTf SPACE$(38)
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            COLORf2 White, 0
            PRINTf "Enter file spec: "
            LINE INPUT X$
            I$ = ""
            IF LEN(X$) THEN
               I$ = CHR$(13)
               IF MID$(X$, 2, 1) = ":" THEN
                  C$ = LEFT$(X$, 1)
                  X$ = MID$(X$, 3)
               END IF
               D$ = ""
               E$ = "*.*"
               FOR VarQ = LEN(X$) TO 1 STEP -1
                  IF MID$(X$, VarQ, 1) = "\" THEN
                     D$ = LEFT$(X$, VarQ)
                     E$ = MID$(X$, VarQ + 1)
                     EXIT FOR
                  END IF
               NEXT
               IF RIGHT$(D$, 1) = "\" THEN
                  D$ = LEFT$(D$, LEN(D$) - 1)
               END IF
               IF LEFT$(D$, 1) = "\" THEN
                  D$ = MID$(D$, 2)
               END IF
               X$ = "*.*"
               EXIT DO
            END IF
            GOSUB DisplayFilenamex
            GOSUB DisplayFileLine
            EXIT DO
         CASE 104 ' Alt-F1 toggles quiet mode.
            I$ = ""
            QuietSwitch = NOT QuietSwitch
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            PRINTf SPACE$(38)
            LOCATEf Xcoor + 1, Ycoor + 2, 1
            COLORf2 White, 0
            IF QuietSwitch THEN
               PRINTf "Quiet mode on. Press <esc>:"
            ELSE
               PRINTf "Quiet mode off. Press <esc>:"
            END IF
            WHILE INKEY$<>CHR$(27)
            WEND
            GOSUB UpdateDisplay
            EXIT DO
         CASE 105 ' Alt-F2 file exclusion entry
            I$ = ""
            GOSUB Exclude.List
            FileY$ = Y$
            GOSUB RedrawScreen
            EXIT DO
         CASE 106 ' Alt-F3 file exclusion entry
            I$ = ""
            GOSUB Exclude.List2
            DirY$ = Y$
            GOSUB RedrawScreen
            EXIT DO
         CASE ELSE
            I$ = "" ' nul activity
         END SELECT
         I$ = "" ' nul keystroke
      END IF
' tab key label.
TabFile:
      ' Tab moves to file loop, or
      '   directory loop if there are no files.
      IF I$ = CHR$(9) THEN
         IF Num.Files > 0 THEN
            GOSUB FileInputLoop
            ' check function key.
            IF LEN(I$) = 2 THEN
               VarQ = ASC(RIGHT$(I$, 1))
               IF VarQ >= 59 AND VarQ <= 68 THEN
                  GOTO StartLoop1
               END IF
               IF VarQ = 104 OR VarQ = 105 OR VarQ = 106 THEN
                  GOTO StartLoop1
               END IF
               IF VarQ = 133 OR VarQ = 134 THEN
                  GOTO StartLoop1
               END IF
               GOSUB GetAltKey
               IF VarZ THEN
                  GOTO StartLoop0
               END IF
            END IF
            ' tab from drive input loop.
            IF I$ = CHR$(9) THEN
               I$ = ""
               EXIT DO
            END IF
            ' shift-tab from dir input loop.
            IF I$ = CHR$(0) + CHR$(15) THEN
               I$ = ""
               EXIT DO
            END IF
            ' click on file entry area.
            IF IsMenu = 4 THEN
               GOSUB DisplayCurrentPath
               IF Num.Files > 0 THEN
                  GOSUB DisplayLongName2
               END IF
               EXIT DO
            END IF
            IF I$ = CHR$(13) THEN
               SELECT CASE IsMenu
               CASE 1 ' file box.
                  E$ = RTRIM$(Filenames(Current.File))
                  GOTO EndLoop2
               CASE 2 ' dir box.
                  GOSUB GetNewPath
               CASE 3 ' drive box.
                  X$ = CHR$(Current.Drive + 64) + ":\*.*"
                  I$ = ""
                  ProcessEditLine = True
                  EXIT DO
               CASE 4 ' entry area.
                  GOSUB DisplayCurrentPath
                  IF Num.Files > 0 THEN
                     GOSUB DisplayLongName2
                  END IF
                  EXIT DO
               CASE 5
                  I$ = CHR$(27)
                  EXIT DO
               CASE ELSE
                  E$ = RTRIM$(Filenames(Current.File))
                  GOTO EndLoop2
               END SELECT
            END IF
         ELSE
            GOSUB DirInputLoop
            ' check function key.
            IF LEN(I$) = 2 THEN
               VarQ = ASC(RIGHT$(I$, 1))
               IF VarQ >= 59 AND VarQ <= 68 THEN
                  GOTO StartLoop1
               END IF
               IF VarQ = 104 OR VarQ = 105 OR VarQ = 106 THEN
                  GOTO StartLoop1
               END IF
               IF VarQ = 133 OR VarQ = 134 THEN
                  GOTO StartLoop1
               END IF
               GOSUB GetAltKey
               IF VarZ THEN
                  GOTO StartLoop0
               END IF
            END IF
            ' tab from drive input loop.
            IF I$ = CHR$(9) THEN
               I$ = ""
               EXIT DO
            END IF
            ' shift-tab from drive input loop.
            IF I$ = CHR$(0) + CHR$(15) THEN
               I$ = ""
               EXIT DO
            END IF
            IF IsMenu = 4 THEN
               GOSUB DisplayCurrentPath
               IF Num.Files > 0 THEN
                  GOSUB DisplayLongName2
               END IF
               EXIT DO
            END IF
            IF I$ = CHR$(13) THEN
               SELECT CASE IsMenu
               CASE 1 ' file box.
                  E$ = RTRIM$(Filenames(Current.File))
                  GOTO EndLoop2
               CASE 2 ' dir box.
                  GOSUB GetNewPath
               CASE 3 ' drive box.
                  X$ = CHR$(Current.Drive + 64) + ":\*.*"
                  I$ = ""
                  ProcessEditLine = True
                  EXIT DO
               CASE 4 ' entry area.
                  GOSUB DisplayCurrentPath
                  IF Num.Files > 0 THEN
                     GOSUB DisplayLongName2
                  END IF
                  EXIT DO
               CASE 5
                  I$ = CHR$(27)
                  EXIT DO
               CASE ELSE
                  GOSUB GetNewPath
               END SELECT
            END IF
         END IF
      END IF

      ' enter key.
      IF I$ = CHR$(13) THEN
         I$ = ""
         ProcessEditLine = True
         EXIT DO
      END IF

      ' escape key.
      IF I$ = CHR$(27) THEN
         EXIT DO ' exit box.
      END IF

      ' backspace.
      IF I$ = CHR$(8) THEN
         IF LEN(X$) THEN
            IF Xstart = True AND Xposition2 = 0 THEN
               X$ = ""
               Xstart = False
               Xposition1 = 1
               Xposition2 = 0
               GOSUB DisplayFileLine
            ELSE
               IF XPosition2 > 0 THEN
                  Xstart = False
                  X$ = LEFT$(X$, Xposition2 - 1) + MID$(X$, Xposition2 + 1)
                  Xposition2 = Xposition2 - 1
                  IF Xposition2 - 25 <= Xposition1 THEN
                     Xposition1 = Xposition1 - 1
                     IF Xposition1 < 1 THEN
                        Xposition1 = 1
                     END IF
                  END IF
                  GOSUB DisplayFileLine
               END IF
            END IF
         END IF
      ELSE
         ' append/insert character into filename area.
         IF LEN(I$) THEN
            ' error check input length.
            IF LEN(X$) >= 32767 THEN
               X$ = ""
               Xstart = False
               Xposition1 = 1
               Xposition2 = 0
               LOCATEf Xcoor + 1, Ycoor + 2, 1
               PRINTf SPACE$(38)
               LOCATEf Xcoor + 1, Ycoor + 2, 1
               COLORf2 White, 0
               PRINTf "Edit line error. Press <esc>:"
               WHILE INKEY$<>CHR$(27)
               WEND
            ELSE
               IF Xstart THEN
                  X$ = ""
                  Xstart = False
                  Xposition1 = 1
                  Xposition2 = 0
                  GOSUB DisplayFileLine
               END IF
               X$ = LEFT$(X$, Xposition2) + I$ + MID$(X$, Xposition2 + 1)
               Xposition2 = Xposition2 + 1
               IF Xposition2 > 26 THEN
                  Xposition1 = Xposition1 + 1
               END IF
               GOSUB DisplayFileLine
            END IF
         END IF
      END IF
   LOOP

   ' exit menu box with no filename.
   IF I$ = CHR$(27) THEN
      E$ = ""
      EXIT DO
   END IF

   ' exit menu box with filename.
   IF I$ = CHR$(13) THEN
      EXIT DO
   END IF

   ' process edit line in X$.

   ' parses drive/path/filename with partial pathname override, filename
   ' ambiguation detection, and multi-dot imbedded path retracting.

   IF ProcessEditLine THEN

      ' store values.
      D1$ = D$
      X2$ = F$

      ' change drive.
      IF MID$(X$, 2, 1) = ":" THEN

         ' display message.
         CALL HMouse
         COLORf White
         LOCATEf Xcoor + 1, Ycoor + 12, 1
         PRINTf SPACE$(26)
         LOCATEf Xcoor + 1, Ycoor + 12, 1
         PRINTf "Loading drive.."
         COLORf Plain
         CALL SMouse

         ' check drive disk space.
         Z$ = UCASE$(LEFT$(X$, 1))
         X$ = MID$(X$, 3)
         Check.Disk = True
         Disk.Ready = False
         InregsX.AX = &H3600
         InregsX.DX = ASC(Z$) - 64
         CALL InterruptX(&H21, InregsX, OutregsX)

         ' check disk not available.
         Check.Disk = False
         IF Disk.Ready = True THEN
            GOSUB PromptDisk
            GOSUB InitFileSpec
            Xstart = True
            GOTO EndLoop1
         END IF
         IF OutregsX.AX = &HFFFF THEN
            GOSUB PromptDisk
            GOSUB InitFileSpec
            Xstart = True
            GOTO EndLoop1
         END IF

         ' store new drive.
         C$ = Z$ ' new drive.
         D$ = "" ' root.
         IF X$ = "" THEN
            X$ = "\"
         END IF
         IF RIGHT$(X$, 1) = "\" THEN
            X$ = X$ + "*.*"
         END IF
         Current.Drive = ASC(Z$) - 64 ' drive number.
      END IF

      ' parse out path.
      CALL Parse.Path(D$, X$)

      ' parse off directory.
      IF INSTR(X$, "\") THEN
         FOR Var = LEN(X$) TO 1 STEP -1
            IF MID$(X$, Var, 1) = "\" THEN
               EXIT FOR
            END IF
         NEXT

         ' parse filename.
         SELECT CASE Var
         CASE 1 ' check root.
            D$ = ""
            X$ = MID$(X$, Var + 1)
         CASE LEN(X$) ' check nul filename.
            D$ = LEFT$(X$, Var - 1)
            X$ = ""
         ' parse directory/filename.
         CASE ELSE
            IF LEFT$(X$, 1) = "\" THEN
               D$ = LEFT$(X$, Var - 1)
            ELSE
               D$ = D$ + "\" + LEFT$(X$, Var - 1)
            END IF
            X$ = MID$(X$, Var + 1)
         END SELECT
      END IF

      ' process directory.
      IF LEFT$(D$, 1) = "\" THEN
         D$ = MID$(D$, 2)
      END IF
      IF RIGHT$(D$, 1) = "\" THEN
         D$ = LEFT$(D$, LEN(D$) - 1)
      END IF
      IF LEFT$(D$, 1) = "\" THEN
         D$ = ""
      END IF
      IF RIGHT$(D$, 1) = "\" THEN
         D$ = ""
      END IF
      IF D$ = "\" THEN
         D$ = ""
      END IF

      ' check directory.
      GOSUB CheckPath
      IF ValidPath = False THEN
         D$ = D1$
         X$ = X1$
         Xposition1 = 1
         Xposition2 = 0
         GOTO EndLoop1
      END IF
      GOSUB CheckPath2
      IF ValidPath = False THEN
         D$ = D1$
         X$ = X1$
         Xposition1 = 1
         Xposition2 = 0
         GOTO EndLoop1
      END IF

      ' store directory.
      D3$ = D$
      X3$ = X$

      ' prevent directory from loading twice.
      LoadedDir = False

      ' check filename.
      IF X$ = STRING$(LEN(X$), ".") THEN
         ' strip multiple dots from path.
         CALL Parse.Path2(D$, X$)
      END IF

      ' construct partial path.
      IF D$ = "" THEN
         D$ = X$
      ELSE
         IF X$ <> "" THEN
            D$ = D$ + "\" + X$
         END IF
      END IF

      ' check path.
      GOSUB CheckPath

      ' check path is file.
      IF OutregsX.AX = 32 THEN ' sharing violation.
         ValidPath = False
      END IF

      ' check valid path.
      IF ValidPath = False THEN
         D$ = D3$
         X$ = X3$
      END IF

      ' check valid path.
      IF ValidPath THEN
         ' check directory already loaded.
         IF D$ <> D1$ THEN
            ' load current directory.
            GOSUB LoadDirSpec
         END IF
         X$ = "" ' reset filename.
         LoadedDir = True ' set loaded flag.
      END IF

      ' check filename.
      IF X$ = "" THEN
         GOSUB InitFileSpec
      END IF

      ' check loaded dir.
      IF LoadedDir = False THEN
         ' check filename characters.
         IF INSTR(X$, "?") = 0 THEN
            IF INSTR(X$, "*") = 0 THEN
               ' search for directory spec override.
               FOR Var = 1 TO Num.Dirs
                  S$ = UCASE$(RTRIM$(Directories(Var)))
                  ' check X$ is directory in current one.
                  IF D$ = "" THEN
                     ASCIIZ = "\" + S$ + CHR$(0)
                  ELSE
                     ASCIIZ = "\" + D$ + "\" + S$ + CHR$(0)
                  END IF
                  ' get conanicalized directory name.
                  V4 = False
                  GOSUB ShortFilenameX
                  ' check both directory names.
                  IF UCASE$(X$) = S$ OR UCASE$(X$) = Short.Filename$ THEN
                     ' store case of directory.
                     S$ = RTRIM$(Directories(Var))
                     ' store directory.
                     IF D$ = "" THEN
                        D$ = S$
                     ELSE
                        D$ = D$ + "\" + S$
                     END IF
                     ' restore filename override.
                     GOSUB InitFileSpec
                     EXIT FOR
                  END IF
               NEXT
            END IF
         END IF
      END IF

      ' store current filespec.
      IF X$ = "." THEN
         X$ = ""
      END IF

      ' store and load directory.
      IF LoadedDir = False THEN
         ' load directories.
         GOSUB LoadNewDir
      ELSE
         ' init directory load.
         GOSUB LoadNewDir2
      END IF

      ' store filename.
      GOSUB InitDirSpec

      ' store filename.
      X1$ = X$
      Xposition1 = 1
      Xposition2 = 0

      ' compare filespecs.
      IF UCASE$(F$) <> UCASE$(X2$) THEN
         X2$ = F$ ' store filespec.
         GOSUB LoadNewFiles ' load file box.
      END IF

      ' check filename characters.
      IF INSTR(X$, "?") = 0 THEN
         IF INSTR(X$, "*") = 0 THEN
            ' search for filename spec override.
            FOR Var = 1 TO Num.Files
               S$ = UCASE$(RTRIM$(Filenames(Var)))
               ' check X$ is filename in current directory.
               IF D$ = "" THEN
                  ASCIIZ = "\" + S$ + CHR$(0)
               ELSE
                  ASCIIZ = "\" + D$ + "\" + S$ + CHR$(0)
               END IF
               ' get conanicalized filename.
               V4 = False
               GOSUB ShortFilenameX
               ' check both filenames.
               IF UCASE$(X$) = S$ OR UCASE$(X$) = Short.Filename$ THEN
                  E$ = RTRIM$(Filenames(Var)) ' select file for editing.
                  EXIT DO
               END IF
            NEXT
         END IF
      END IF

      ' construct dir/filename.
      IF D$ = "" THEN
         V$ = "\" + X$
      ELSE
         V$ = "\" + D$ + "\" + X$
      END IF

      ' check filename characters.
      IF INSTR(V$, "?") = 0 THEN
         IF INSTR(V$, "*") = 0 THEN
            ' check filename could or does exist.
            IF TestFile(V$) THEN
               ' select file for editing.
               E$ = X$
               EXIT DO
            END IF
         END IF
      END IF

      ' display all drives.
      GOSUB InitDrives
      Xstart = True
   END IF
EndLoop1:
LOOP

' exit editing loop.
EndLoop2:

' exit file menu box.
CALL HMouse
COLORf2 7, 0
CLS

' return to editor.
EXIT SUB

' reset file menu box.
UpdateDisplay:
 GOSUB DisplayFilenamex
 COLORf2 Plain, 0
 ' init dir box.
 GOSUB ClearDirBox
 GOSUB LoadDirSpec
 GOSUB DisplayDirSpec
 Current.Dir = 1
 Dir.Box.Line = 1
 GOSUB DisplayCurrentDir
 ' init file box.
 GOSUB ClearFileBox
 GOSUB LoadFileSpec
 GOSUB DisplayFileSpec
 GOSUB DisplayCurrentPath
 ' display first file.
 GOSUB ClearLongName2
 IF Num.Files > 0 THEN
    Current.File = 1
    Box.Line = 1
    GOSUB InitFiles
 END IF
 ' init drive box.
 GOSUB InitDrives
 RETURN

' init filespec.
InitFileSpec:
 ' compare stored filename.
 IF X1$ = "" THEN
    X$ = "*.*"
    Xposition1 = 1
    Xposition2 = 3
 ELSE
    ' restore filename spec.
    X$ = X1$
    Xposition1 = 1
    Xposition2 = 0
 END IF
 ' check filename.
 IF X$ = "." THEN
    X$ = ""
 END IF
 RETURN

' init current directory.
InitDirSpec:
 IF D$ = "" THEN
    F$ = C$ + ":\" + X$
 ELSE
    F$ = C$ + ":\" + D$ + "\" + X$
 END IF
 RETURN

' checks for alt-<n> key.
GetAltKey:
 VarZ = False
 ' get alt keycode.
 Var = ASC(RIGHT$(I$, 1))

 ' compare all Alt-n keys
 FOR Var2 = 1 TO 26
    ' check key.
    IF Keys(Var2) = Var THEN
       VarZ = True
       RETURN
    END IF
 NEXT
 RETURN

' inits dir box with new dirspec.
LoadNewDir:
 Current.Dir = 1
 Dir.Box.Line = 1
 GOSUB ClearDirBox
 GOSUB CheckPath
 IF ValidPath = False THEN
    D$ = D1$
    X$ = X1$
    Xposition1 = 1
    Xposition2 = 0
 END IF
 GOSUB LoadDirSpec
 GOSUB DisplayDirSpec
 GOSUB DisplayCurrentDir
 GOSUB DisplayCurrentPath
 RETURN

' inits dir box without new dirspec.
LoadNewDir2:
 Current.Dir = 1
 Dir.Box.Line = 1
 GOSUB ClearDirBox
 GOSUB CheckPath
 IF ValidPath = False THEN
    D$ = D1$
    X$ = X1$
    Xposition1 = 1
    Xposition2 = 0
 END IF
 GOSUB DisplayDirSpec
 GOSUB DisplayCurrentDir
 GOSUB DisplayCurrentPath2
 RETURN

' inits file box.
LoadNewFiles:
 GOSUB ClearFileBox
 GOSUB LoadFileSpec
 GOSUB DisplayFileSpec
 IF Num.Files > 0 THEN
    Current.File = 1
    Box.Line = 1
    GOSUB InitFiles
 ELSE
    GOSUB ClearLongName2
 END IF
 RETURN

' display current filename entry area.
DisplayFileLine:
 CALL HMouse
 LOCATEf Xcoor + 1, Ycoor + 12, 1
 PRINTf SPACE$(26)
 ' check hilighting.
 IF Xstart THEN
    COLORf2 Black, Plain
 END IF
 ' display edit line and position cursor.
 LOCATEf Xcoor + 1, Ycoor + 12, 1
 PRINTf MID$(X$, Xposition1, 26)
 LOCATEf Xcoor + 1, Ycoor + Xposition2 - Xposition1 + 13, 1
 COLORf2 Plain, 0
 CALL SMouse
 RETURN

' display invalid disk message.
PromptDisk:
 CALL HMouse
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 PRINTf SPACE$(38)
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 COLORf2 White, 0
 PRINTf "Disk not ready. Press <esc>:"
 WHILE INKEY$<>CHR$(27)
 WEND
 GOSUB DisplayFilenamex
 COLORf2 Plain, 0
 PRINTf X$
 CALL SMouse
 RETURN

' display filename line.
DisplayFilenamex:
 CALL HMouse
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 PRINTf SPACE$(38)
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 COLORf2 White, 0
 PRINTf "Filename: "
 COLORf2 Plain, 0
 CALL SMouse
 RETURN

' init filename input loop.
InitFiles:
 E$ = RTRIM$(Filenames(1))
 CALL HMouse
 COLORf2 Black, Plain
 LOCATEf Xcoor + 5, Ycoor + 3, 1
 PRINTf LEFT$(E$, 12)
 COLORf2 Plain, 0
 GOSUB DisplayLongName2
 CALL SMouse
 RETURN

' filename input loop.
FileInputLoop:
 I$ = ""
 DO
    IF Current.File > 0 THEN
       GOSUB DisplayLongName2
       GOSUB ClearFilename
       GOSUB DisplayFilename
    END IF
    DO
       ' get keystroke.
       I$ = INKEY$
       IF LEN(I$) THEN
          IsMenu = False
          EXIT DO
       END IF

       ' call mouse subroutine.
       CALL MouseDriver

       ' check file entry area.
       IF IsMenu >= 4 THEN
          RETURN
       END IF

       ' check left mouse button.
       IF Mouse.ButtonX THEN
          GOSUB MouseButton1Z
          SELECT CASE IsMenu
          CASE 1 ' file box.
             IF I$ = CHR$(13) THEN
                EXIT DO
             ELSE
                GOSUB FileBoxKey
             END IF
          CASE 2 ' dir box.
             IF I$ = CHR$(13) THEN
                RETURN
             ELSE
                GOSUB Dirboxkey
             END IF
          CASE 3 ' drive box.
             IF I$ = CHR$(13) THEN
                RETURN
             ELSE
                GOSUB Driveboxkey
             END IF
          END SELECT
       ELSE
          ' check mouse position.
          IF Mouse.Row OR Mouse.Column THEN
             GOSUB MouseOverX1
          END IF
       END IF

       ' release time slice.
       Var = ReleaseTime
    LOOP

    ' check function key.
    IF LEN(I$) = 2 THEN
       VarQ = ASC(RIGHT$(I$, 1))
       IF VarQ >= 59 AND VarQ <= 68 THEN
          RETURN
       END IF
       IF VarQ = 104 OR VarQ = 105 OR VarQ = 106 THEN
          RETURN
       END IF
       IF VarQ = 133 OR VarQ = 134 THEN
          RETURN
       END IF
       GOSUB GetAltKey
       IF VarZ THEN
          RETURN
       END IF
    END IF

    ' up returns shift-tab.
    IF LEN(I$) = 2 THEN
       IF ASC(RIGHT$(I$, 1)) = 72 THEN
          IF Current.File = 1 THEN
             IF Box.Line = 1 THEN
                I$ = CHR$(0) + CHR$(15)
             END IF
          END IF
       END IF
    END IF

    ' shift-tab returns to top.
    IF LEN(I$) = 2 THEN
       IF ASC(RIGHT$(I$, 1)) = 15 THEN
          RETURN
       END IF
    END IF

    ' right returns tab.
    IF LEN(I$) = 2 THEN
       IF ASC(RIGHT$(I$, 1)) = 77 THEN
          I$ = CHR$(9)
       END IF
    END IF

    ' Tab moves to directory loop.
    IF I$ = CHR$(9) THEN
       GOSUB DirInputLoop
       ' check function key.
       IF LEN(I$) = 2 THEN
          VarQ = ASC(RIGHT$(I$, 1))
          IF VarQ >= 59 AND VarQ <= 68 THEN
             RETURN
          END IF
          IF VarQ = 104 OR VarQ = 105 OR VarQ = 106 THEN
             RETURN
          END IF
          IF VarQ = 133 OR VarQ = 134 THEN
             RETURN
          END IF
          GOSUB GetAltKey
          IF VarZ THEN
             RETURN
          END IF
       END IF
       IF IsMenu >= 4 THEN
          RETURN
       END IF
       IF I$ = CHR$(9) THEN
          GOSUB DisplayCurrentPath
          RETURN
       END IF
    END IF
    IF I$ = CHR$(13) THEN
       RETURN
    END IF
    IF I$ = CHR$(27) THEN
       RETURN
    END IF
    IF LEN(I$) = 1 THEN
       SELECT CASE I$
       CASE "A" TO "Z", "a" TO "z", "0" TO "9"
       DO
          IF Current.File + 1 <= Num.Files THEN
             IF Box.Line < 10 THEN
                GOSUB ClearFilename
                Box.Line = Box.Line + 1
                Current.File = Current.File + 1
                GOSUB DisplayFilename
                GOSUB DisplayLongName2
             ELSE
                Current.File = Current.File + 1
                GOSUB DisplayFilename2
                GOSUB DisplayFileBox1
                GOSUB DisplayFilename3
                GOSUB DisplayLongName2
             END IF
             IF LEFT$(E$, 1) = I$ THEN
                EXIT DO
             END IF
          ELSE
             EXIT DO
          END IF
       LOOP
       END SELECT
       I$ = ""
    END IF
    IF LEN(I$) = 2 THEN
       GOSUB FileBoxKey
    END IF
 LOOP
 RETURN

' process key in file box.
FileBoxKey:
 V = ASC(RIGHT$(I$, 1))
 SELECT CASE V
 CASE 72 ' up
    IF Current.File - 1 > 0 THEN
       IF Box.Line > 1 THEN
          GOSUB ClearFilename
          Box.Line = Box.Line - 1
          Current.File = Current.File - 1
          GOSUB DisplayFilename
          GOSUB DisplayLongName2
       ELSE
          Current.File = Current.File - 1
          GOSUB DisplayFilename2
          GOSUB DisplayFileBox2
          GOSUB DisplayFilename4
          GOSUB DisplayLongName2
       END IF
    END IF
 CASE 80 ' down
    IF Current.File + 1 <= Num.Files THEN
       IF Box.Line < 10 THEN
          GOSUB ClearFilename
          Box.Line = Box.Line + 1
          Current.File = Current.File + 1
          GOSUB DisplayFilename
          GOSUB DisplayLongName2
       ELSE
          Current.File = Current.File + 1
          GOSUB DisplayFilename2
          GOSUB DisplayFileBox1
          GOSUB DisplayFilename3
          GOSUB DisplayLongName2
       END IF
    END IF
 CASE 73 ' pgup
    IF Current.File - 10 > 0 THEN
       Box.Line = 1
       Current.File = Current.File - 10
    ELSE
       Box.Line = 1
       Current.File = 1
    END IF
    GOSUB DisplayFilename2
    GOSUB DisplayFileBox2
    GOSUB DisplayFilename4
    GOSUB DisplayLongName2
 CASE 81 ' pgdn
    IF Current.File + 10 <= Num.Files THEN
       Box.Line = 10
       Current.File = Current.File + 10
       GOSUB DisplayFilename2
       GOSUB DisplayFileBox1
       GOSUB DisplayFilename3
       GOSUB DisplayLongName2
    ELSE
       IF Current.File + 1 <= Num.Files THEN
          DO UNTIL Current.File = Num.Files
             IF Box.Line < 10 THEN
                GOSUB ClearFilename
                Box.Line = Box.Line + 1
                Current.File = Current.File + 1
                GOSUB DisplayFilename
                GOSUB DisplayLongName2
             ELSE
                Current.File = Current.File + 1
                GOSUB DisplayFilename2
                GOSUB DisplayFileBox1
                GOSUB DisplayFilename3
                GOSUB DisplayLongName2
             END IF
          LOOP
       END IF
    END IF
 CASE 71 ' home
    IF Current.File > 1 THEN
       Box.Line = 1
       Current.File = 1
    END IF
    GOSUB DisplayFilename2
    GOSUB DisplayFileBox2
    GOSUB DisplayFilename4
    GOSUB DisplayLongName2
 CASE 79 ' end
    IF Current.File + 1 <= Num.Files THEN
       DO UNTIL Current.File = Num.Files
          IF Box.Line < 10 THEN
             GOSUB ClearFilename
             Box.Line = Box.Line + 1
             Current.File = Current.File + 1
             GOSUB DisplayFilename
             GOSUB DisplayLongName2
          ELSE
             Current.File = Current.File + 1
             GOSUB DisplayFilename2
             GOSUB DisplayFileBox1
             GOSUB DisplayFilename3
             GOSUB DisplayLongName2
          END IF
       LOOP
    END IF
 END SELECT
 RETURN

' clear filename.
ClearFilename:
 CALL HMouse
 COLORf2 Plain, 0
 LOCATEf Box.Line + Xcoor + 4, Ycoor + 3, 1
 PRINTf LEFT$(RTRIM$(Filenames(Current.File)), 12)
 CALL SMouse
 RETURN

' display filename.
DisplayFilename:
 E$ = RTRIM$(Filenames(Current.File))
 CALL HMouse
 COLORf2 Plain, 0
 LOCATEf Xcoor + 1, Ycoor + 12, 1
 PRINTf SPACE$(26)
 LOCATEf Xcoor + 1, Ycoor + 12, 1
 GOSUB TruncateFilename
 PRINTf A$
 COLORf2 Black, Plain
 LOCATEf Box.Line + Xcoor + 4, Ycoor + 3, 1
 PRINTf LEFT$(E$, 12)
 V9 = LEN(RTRIM$(LEFT$(E$, 12)))
 LOCATEf Box.Line + Xcoor + 4, Ycoor + V9 + 3, 1
 COLORf2 Plain, 0
 CALL SMouse
 RETURN

' display filename.
DisplayFilename2:
 E$ = RTRIM$(Filenames(Current.File))
 CALL HMouse
 COLORf2 Plain, 0
 LOCATEf Xcoor + 1, Ycoor + 12, 1
 PRINTf SPACE$(26)
 LOCATEf Xcoor + 1, Ycoor + 12, 1
 GOSUB TruncateFilename
 PRINTf A$
 GOSUB ClearFileBox
 COLORf2 Plain, 0
 CALL SMouse
 RETURN

' display filename.
DisplayFilename3:
 E$ = RTRIM$(Filenames(Current.File))
 CALL HMouse
 COLORf2 Black, Plain
 LOCATEf Xcoor + 14, Ycoor + 3, 1
 PRINTf LEFT$(E$, 12)
 V9 = LEN(RTRIM$(LEFT$(E$, 12)))
 LOCATEf Xcoor + 14, Ycoor + V9 + 3, 1
 CALL SMouse
 RETURN

' display filename.
DisplayFilename4:
 E$ = RTRIM$(Filenames(Current.File))
 CALL HMouse
 COLORf2 Black, Plain
 LOCATEf Xcoor + 5, Ycoor + 3, 1
 PRINTf LEFT$(E$, 12)
 V9 = LEN(RTRIM$(LEFT$(E$, 12)))
 LOCATEf Xcoor + 5, Ycoor + V9 + 3, 1
 CALL SMouse
 RETURN

' display filename.
DisplayFilename5:
 E$ = RTRIM$(Filenames(Current.File))
 CALL HMouse
 COLORf2 Black, Plain
 LOCATEf Box.Line + Xcoor + 4, Ycoor + 3, 1
 PRINTf LEFT$(E$, 12)
 COLORf2 Plain, 0
 CALL SMouse
 RETURN

' update filename box.
DisplayFileBox1:
 CALL HMouse
 FOR V = 1 TO 9
    LOCATEf Xcoor - V + 14, Ycoor + 3, 1
    PRINTf LEFT$(RTRIM$(Filenames(Current.File - V)), 12)
 NEXT
 CALL SMouse
 RETURN

' updates filename box.
DisplayFileBox2:
 CALL HMouse
 FOR V = 1 TO 9
    IF Current.File + V <= Num.Files THEN
       LOCATEf Xcoor + V + 5, Ycoor + 3, 1
       PRINTf LEFT$(RTRIM$(Filenames(Current.File + V)), 12)
    END IF
 NEXT
 CALL SMouse
 RETURN

' display init directory.
DisplayInitDir:
 CALL HMouse
 Q$ = RTRIM$(Directories(Current.Dir))
 LOCATEf Dir.Box.Line + Xcoor + 4, Ycoor + 19, 1
 COLORf2 Black, Plain
 PRINTf LEFT$(Q$, 12)
 COLORf2 Plain, 0
 CALL SMouse
 RETURN

' directory input loop.
DirInputLoop:
 GOSUB DisplayInitDir
 GOSUB DisplayLongName1
 I$ = ""
 DO
    DO
       ' get keystroke.
       I$ = INKEY$
       IF LEN(I$) THEN
          IsMenu = False
          EXIT DO
       END IF

       ' call mouse subroutine.
       CALL MouseDriver

       ' check file entry area.
       IF IsMenu >= 4 THEN
          RETURN
       END IF

       ' check left mouse button.
       IF Mouse.ButtonX THEN
          GOSUB MouseButton1Z
          SELECT CASE IsMenu
          CASE 1 ' file box.
             IF I$ = CHR$(13) THEN
                RETURN
             ELSE
                GOSUB FileBoxKey
             END IF
          CASE 2 ' dir box.
             IF I$ = CHR$(13) THEN
                RETURN
             ELSE
                GOSUB Dirboxkey
             END IF
          CASE 3 ' drive box.
             IF I$ = CHR$(13) THEN
                RETURN
             ELSE
                GOSUB Driveboxkey
             END IF
          END SELECT
       ELSE
          ' check mouse position.
          IF Mouse.Row OR Mouse.Column THEN
             GOSUB MouseOverX1
          END IF
       END IF

       ' release time slice.
       Var = ReleaseTime
    LOOP

    ' check function key.
    IF LEN(I$) = 2 THEN
       VarQ = ASC(RIGHT$(I$, 1))
       IF VarQ >= 59 AND VarQ <= 68 THEN
          RETURN
       END IF
       IF VarQ = 104 OR VarQ = 105 OR VarQ = 106 THEN
          RETURN
       END IF
       IF VarQ = 133 OR VarQ = 134 THEN
          RETURN
       END IF
       GOSUB GetAltKey
       IF VarZ THEN
          RETURN
       END IF
    END IF

    ' up returns shift-tab.
    IF LEN(I$) = 2 THEN
       IF ASC(RIGHT$(I$, 1)) = 72 THEN
          IF Current.Dir = 1 THEN
             IF Dir.Box.Line = 1 THEN
                I$ = CHR$(0) + CHR$(15)
             END IF
          END IF
       END IF
    END IF

    ' left returns shift-tab.
    IF LEN(I$) = 2 THEN
       IF ASC(RIGHT$(I$, 1)) = 75 THEN
          I$ = CHR$(0) + CHR$(15)
       END IF
    END IF

    ' shift-tab returns to file loop.
    IF LEN(I$) = 2 THEN
       IF ASC(RIGHT$(I$, 1)) = 15 THEN
          ' display current filename.
          GOSUB ClearLongName2
          IF Num.Files > 0 THEN
             GOSUB DisplayLongName2
             GOSUB ClearFilename
             GOSUB DisplayFilename
          END IF
          ' display current directory.
          GOSUB ClearDirectory
          GOSUB DisplayCurrentPath
          RETURN
       END IF
    END IF

    ' right returns tab.
    IF LEN(I$) = 2 THEN
       IF ASC(RIGHT$(I$, 1)) = 77 THEN
          I$ = CHR$(9)
       END IF
    END IF

    ' Tab moves to drive input loop.
    IF I$ = CHR$(9) THEN
       GOSUB DriveInputLoop
       ' check function key.
       IF LEN(I$) = 2 THEN
          VarQ = ASC(RIGHT$(I$, 1))
          IF VarQ >= 59 AND VarQ <= 68 THEN
             RETURN
          END IF
          IF VarQ = 104 OR VarQ = 105 OR VarQ = 106 THEN
             RETURN
          END IF
          IF VarQ = 133 OR VarQ = 134 THEN
             RETURN
          END IF
          GOSUB GetAltKey
          IF VarZ THEN
             RETURN
          END IF
       END IF
       IF IsMenu >= 3 THEN
          GOSUB DisplayCurrentPath
          IF Num.Files > 0 THEN
             GOSUB DisplayLongName2
          END IF
          RETURN
       END IF
       IF I$ = CHR$(9) THEN
          GOSUB DisplayCurrentPath
          IF Num.Files > 0 THEN
             GOSUB DisplayLongName2
          END IF
          RETURN
       END IF
       Q$ = RTRIM$(Directories(Current.Dir))
       GOSUB DisplayLongName1
    END IF
    IF I$ = CHR$(13) THEN
       IsMenu = 2
       RETURN
    END IF
    IF I$ = CHR$(27) THEN
       RETURN
    END IF
    IF LEN(I$) = 1 THEN
       SELECT CASE I$
       CASE "A" TO "Z", "a" TO "z", "0" TO "9"
       DO
          IF Current.Dir + 1 <= Num.Dirs THEN
             IF Dir.Box.Line < 10 THEN
                GOSUB ClearDirectory
                Dir.Box.Line = Dir.Box.Line + 1
                Current.Dir = Current.Dir + 1
                GOSUB DisplayDirectory
             ELSE
                GOSUB ClearDirBox
                Current.Dir = Current.Dir + 1
                GOSUB DisplayDirBox1
                GOSUB DisplayDirectory2
             END IF
             Q$ = RTRIM$(Directories(Current.Dir))
             GOSUB DisplayLongName1
             IF LEFT$(Q$, 1) = I$ THEN
                EXIT DO
             END IF
          ELSE
             EXIT DO
          END IF
       LOOP
       END SELECT
       I$ = ""
    END IF
    IF LEN(I$) = 2 THEN
       GOSUB DirBoxKey
    END IF
 LOOP
 RETURN

' clear directory.
ClearDirectory:
 CALL HMouse
 LOCATEf Dir.Box.Line + Xcoor + 4, Ycoor + 19, 1
 COLORf2 Plain, 0
 PRINTf LEFT$(RTRIM$(Directories(Current.Dir)), 12)
 CALL SMouse
 RETURN

' display directory.
DisplayDirectory:
 CALL HMouse
 LOCATEf Dir.Box.Line + Xcoor + 4, Ycoor + 19, 1
 COLORf2 Black, Plain
 PRINTf LEFT$(RTRIM$(Directories(Current.Dir)), 12)
 COLORf2 Plain, 0
 CALL SMouse
 RETURN

' display directory.
DisplayDirectory2:
 CALL HMouse
 COLORf2 Black, Plain
 LOCATEf Xcoor + 14, Ycoor + 19, 1
 PRINTf LEFT$(RTRIM$(Directories(Current.Dir)), 12)
 COLORf2 Plain, 0
 CALL SMouse
 RETURN

' display directory.
DisplayDirectory3:
 CALL HMouse
 COLORf2 Black, Plain
 LOCATEf Xcoor + 5, Ycoor + 19, 1
 PRINTf LEFT$(RTRIM$(Directories(Current.Dir)), 12)
 COLORf2 Plain, 0
 CALL SMouse
 RETURN

' update dir box.
DisplayDirBox1:
 CALL HMouse
 COLORf2 Plain, 0
 FOR V = 1 TO 9
    LOCATEf Xcoor - V + 14, Ycoor + 19, 1
    PRINTf LEFT$(RTRIM$(Directories(Current.Dir - V)), 12)
 NEXT
 CALL SMouse
 RETURN

' update dir box.
DisplayDirBox2:
 CALL HMouse
 COLORf2 Plain, 0
 FOR V = 1 TO 9
    IF Current.Dir + V <= Num.Dirs THEN
       LOCATEf Xcoor + V + 5, Ycoor + 19, 1
       PRINTf LEFT$(RTRIM$(Directories(Current.Dir + V)), 12)
    END IF
 NEXT
 CALL SMouse
 RETURN

' process dir box key.
DirBoxKey:
 V = ASC(RIGHT$(I$, 1))
 SELECT CASE V
 CASE 72 ' up
    IF Current.Dir - 1 > 0 THEN
       IF Dir.Box.Line > 1 THEN
          GOSUB ClearDirectory
          Dir.Box.Line = Dir.Box.Line - 1
          Current.Dir = Current.Dir - 1
          GOSUB DisplayDirectory
       ELSE
          GOSUB ClearDirBox
          Current.Dir = Current.Dir - 1
          GOSUB DisplayDirBox2
          GOSUB DisplayDirectory3
       END IF
       Q$ = RTRIM$(Directories(Current.Dir))
       GOSUB DisplayLongName1
    END IF
 CASE 80 ' down
    IF Current.Dir + 1 <= Num.Dirs THEN
       IF Dir.Box.Line < 10 THEN
          GOSUB ClearDirectory
          Dir.Box.Line = Dir.Box.Line + 1
          Current.Dir = Current.Dir + 1
          GOSUB DisplayDirectory
       ELSE
          GOSUB ClearDirBox
          Current.Dir = Current.Dir + 1
          GOSUB DisplayDirBox1
          GOSUB DisplayDirectory2
       END IF
       Q$ = RTRIM$(Directories(Current.Dir))
       GOSUB DisplayLongName1
    END IF
 CASE 73 ' pgup
    IF Current.Dir - 10 > 0 THEN
       Dir.Box.Line = 1
       Current.Dir = Current.Dir - 10
    ELSE
       Dir.Box.Line = 1
       Current.Dir = 1
    END IF
    GOSUB ClearDirBox
    GOSUB DisplayDirBox2
    GOSUB DisplayDirectory3
    Q$ = RTRIM$(Directories(Current.Dir))
    GOSUB DisplayLongName1
 CASE 81 ' pgdn
    IF Current.Dir + 10 <= Num.Dirs THEN
       GOSUB ClearDirBox
       Dir.Box.Line = 10
       Current.Dir = Current.Dir + 10
       GOSUB DisplayDirBox1
       GOSUB DisplayDirectory2
       Q$ = RTRIM$(Directories(Current.Dir))
       GOSUB DisplayLongName1
    ELSE
       IF Current.Dir + 1 <= Num.Dirs THEN
          DO UNTIL Current.Dir = Num.Dirs
             IF Dir.Box.Line < 10 THEN
                GOSUB ClearDirectory
                Dir.Box.Line = Dir.Box.Line + 1
                Current.Dir = Current.Dir + 1
                GOSUB DisplayDirectory
             ELSE
                GOSUB ClearDirBox
                Current.Dir = Current.Dir + 1
                GOSUB DisplayDirBox1
                GOSUB DisplayDirectory2
             END IF
          LOOP
          Q$ = RTRIM$(Directories(Current.Dir))
          GOSUB DisplayLongName1
       END IF
    END IF
 CASE 71 ' home
    IF Current.Dir > 1 THEN
       Dir.Box.Line = 1
       Current.Dir = 1
    END IF
    GOSUB ClearDirBox
    GOSUB DisplayDirBox2
    GOSUB DisplayDirectory3
    Q$ = RTRIM$(Directories(Current.Dir))
    GOSUB DisplayLongName1
 CASE 79 ' end
    IF Current.Dir + 1 <= Num.Dirs THEN
       DO UNTIL Current.Dir = Num.Dirs
          IF Dir.Box.Line < 10 THEN
             GOSUB ClearDirectory
             Dir.Box.Line = Dir.Box.Line + 1
             Current.Dir = Current.Dir + 1
             GOSUB DisplayDirectory
          ELSE
             GOSUB ClearDirBox
             Current.Dir = Current.Dir + 1
             GOSUB DisplayDirBox1
             GOSUB DisplayDirectory2
          END IF
       LOOP
       Q$ = RTRIM$(Directories(Current.Dir))
       GOSUB DisplayLongName1
    END IF
 END SELECT
 RETURN

' drive input loop.
DriveInputLoop:
 I$ = ""
 DO
    GOSUB DisplayDrive
    DO
       ' get keystroke.
       I$ = INKEY$
       IF LEN(I$) THEN
          IsMenu = False
          EXIT DO
       END IF

       ' call mouse subroutine.
       CALL MouseDriver

       ' check file entry area.
       IF IsMenu >= 4 THEN
          RETURN
       END IF

       ' check left mouse button.
       IF Mouse.ButtonX THEN
          GOSUB MouseButton1Z
          SELECT CASE IsMenu
          CASE 1 ' file box.
             IF I$ = CHR$(13) THEN
                RETURN
             ELSE
                GOSUB FileBoxKey
             END IF
          CASE 2 ' dir box.
             IF I$ = CHR$(13) THEN
                RETURN
             ELSE
                GOSUB Dirboxkey
             END IF
          CASE 3 ' drive box.
             IF I$ = CHR$(13) THEN
                RETURN
             ELSE
                GOSUB Driveboxkey
             END IF
          END SELECT
       ELSE
          ' check mouse position.
          IF Mouse.Row OR Mouse.Column THEN
             GOSUB MouseOverX1
             GOSUB DisplayDrive
          END IF
       END IF

       ' release time slice.
       Var = ReleaseTime
    LOOP

    ' check function key.
    IF LEN(I$) = 2 THEN
       VarQ = ASC(RIGHT$(I$, 1))
       IF VarQ >= 59 AND VarQ <= 68 THEN
          RETURN
       END IF
       IF VarQ = 104 OR VarQ = 105 OR VarQ = 106 THEN
          RETURN
       END IF
       IF VarQ = 133 OR VarQ = 134 THEN
          RETURN
       END IF
       GOSUB GetAltKey
       IF VarZ THEN
          RETURN
       END IF
    END IF

    ' left returns shift-tab.
    IF LEN(I$) = 2 THEN
       IF ASC(RIGHT$(I$, 1)) = 75 THEN
          I$ = CHR$(0) + CHR$(15)
       END IF
    END IF

    ' shift-tab returns to directory loop.
    IF LEN(I$) = 2 THEN
       IF ASC(RIGHT$(I$, 1)) = 15 THEN
          I$ = ""
          GOSUB DisplayDirectory
          RETURN
       END IF
    END IF

    ' up returns tab.
    IF LEN(I$) = 2 THEN
       IF ASC(RIGHT$(I$, 1)) = 72 THEN
          IF Current.Drive = 1 THEN
             IF Drive.Box.Line = 1 THEN
                I$ = CHR$(9)
             END IF
          END IF
       END IF
    END IF

    ' right returns tab.
    IF LEN(I$) = 2 THEN
       IF ASC(RIGHT$(I$, 1)) = 77 THEN
          I$ = CHR$(9)
       END IF
    END IF

    ' Tab returns to top loop.
    IF I$ = CHR$(9) THEN
       RETURN
    END IF

    ' select a drive.
    IF I$ = CHR$(13) THEN
       IsMenu = 3
       RETURN
    END IF

    ' exit from drive box.
    IF I$ = CHR$(27) THEN
       RETURN
    END IF

    ' process drive box keystroke.
    IF LEN(I$) = 2 THEN
       GOSUB DriveBoxKey
    END IF
 LOOP
 RETURN

' process drive box key.
DriveBoxKey:
 V = ASC(RIGHT$(I$, 1))
 SELECT CASE V
 CASE 72 ' up
    GOSUB MoveDriveUp
 CASE 80 ' down
    GOSUB MoveDriveDown
 END SELECT
 RETURN

' moves up one drive letter.
MoveDriveUp:
 IF Current.Drive - 1 > 0 THEN
    IF Drive.Box.Line > 1 THEN
       GOSUB ClearDrive
       Drive.Box.Line = Drive.Box.Line - 1
       Current.Drive = Current.Drive - 1
       GOSUB DisplayDrive
    ELSE
       Current.Drive = Current.Drive - 1
       GOSUB ClearDriveBox
       COLORf2 Plain, 0
       FOR V = 1 TO 9
          LOCATEf Xcoor + V + 5, Ycoor + 35, 0
          PRINTf "[" + CHR$(Current.Drive + V + 64) + "]"
       NEXT
       Drive.Box.Line = 1
       GOSUB DisplayDrive
    END IF
 END IF
 RETURN

' moves down one drive letter.
MoveDriveDown:
 IF Current.Drive + 1 <= Last.Drive THEN
    IF Drive.Box.Line < 10 THEN
       GOSUB ClearDrive
       Drive.Box.Line = Drive.Box.Line + 1
       Current.Drive = Current.Drive + 1
       GOSUB DisplayDrive
    ELSE
       Current.Drive = Current.Drive + 1
       GOSUB ClearDriveBox
       COLORf2 Plain, 0
       FOR V = 1 TO 9
          LOCATEf Xcoor + 14 - V, Ycoor + 35, 1
          PRINTf "[" + CHR$(Current.Drive - V + 64) + "]"
       NEXT
       Drive.Box.Line = 10
       GOSUB DisplayDrive
    END IF
 END IF
 RETURN

' display path.
DisplayCurrentPath:
 GOSUB DisplayCurrentPath3
 GOSUB DisplayLongName1
 RETURN

' display path.
DisplayCurrentPath2:
 GOSUB DisplayCurrentPath3
 GOSUB DisplayLongName3
 RETURN

' display path.
DisplayCurrentPath3:
 Q$ = D$
 FOR Var = LEN(Q$) TO 1 STEP -1
    IF MID$(Q$, Var, 1) = "\" THEN
       Q$ = MID$(Q$, Var + 1)
       EXIT FOR
    END IF
 NEXT
 IF Q$ = "" THEN
    Q$ = "\"
 END IF
 RETURN

' display long directory.
DisplayLongName1:
 CALL HMouse
 COLORf2 Green, 1
 IF Xcoor + 17 <= 24 THEN
    Length = 80 - Ycoor - 1
    LOCATEf Xcoor + 17, Ycoor, 0
    PRINTf SPACE$(Length)
    LOCATEf Xcoor + 17, Ycoor, 0
    P$ = "Path: " + Q$
    IF LEN(P$) > Length THEN
       P$ = LEFT$(P$, Length - 3) + "..."
    END IF
    PRINTf P$
 END IF
 COLORf2 Plain, 0
 GOSUB DisplayDirsize
 V = LEN(RTRIM$(Directories(Current.Dir)))
 IF V > 12 THEN
    V = 12
 END IF
 LOCATEf Dir.Box.Line + Xcoor + 4, Ycoor + V + 19, 1
 CALL SMouse
 RETURN

' display long filename.
DisplayLongName2:
 CALL HMouse
 COLORf2 Green, 1
 IF Xcoor + 18 <= 24 THEN
    Length = 80 - Ycoor - 1
    LOCATEf Xcoor + 18, Ycoor, 0
    PRINTf SPACE$(Length)
    LOCATEf Xcoor + 18, Ycoor, 0
    P$ = "File: " + E$
    IF LEN(P$) > Length THEN
       P$ = LEFT$(P$, Length - 3) + "..."
    END IF
    PRINTf P$
 END IF
 COLORf2 Plain, 0
 GOSUB DisplayFilesize
 V = LEN(RTRIM$(Filenames(Current.File)))
 IF V > 12 THEN
    V = 12
 END IF
 LOCATEf Box.Line + Xcoor + 4, Ycoor + V + 3, 1
 CALL SMouse
 RETURN

' display long directory.
DisplayLongName3:
 CALL HMouse
 COLORf2 Green, 1
 IF Xcoor + 17 <= 24 THEN
    Length = 80 - Ycoor - 1
    LOCATEf Xcoor + 17, Ycoor, 0
    PRINTf SPACE$(Length)
    LOCATEf Xcoor + 17, Ycoor, 0
    P$ = "Path: " + Q$
    IF LEN(P$) > Length THEN
       P$ = LEFT$(P$, Length - 3) + "..."
    END IF
    PRINTf P$
 END IF
 COLORf2 Plain, 0
 CALL SMouse
 RETURN

' display filesize.
DisplayFilesize:
 GOSUB GetFilesize
 CALL HMouse
 COLORf2 Green, 1
 IF Xcoor + 19 <= 24 THEN
    Length = 80 - Ycoor - 1
    LOCATEf Xcoor + 19, Ycoor, 0
    PRINTf SPACE$(Length)
    LOCATEf Xcoor + 19, Ycoor, 0
    x# = Filesize
    IF x# = 0# THEN
       x4$ = "zero"
    ELSE
       GOSUB FormatX
    END IF
    P$ = "Size: " + x4$
    PRINTf P$ + " "
    GOSUB DisplayFileattr
 END IF
 COLORf2 Plain, 0
 CALL SMouse
 RETURN

' display dir attribute.
DisplayDirsize:
 CALL HMouse
 COLORf2 Green, 1
 IF Xcoor + 19 <= 24 THEN
    Length = 80 - Ycoor - 1
    LOCATEf Xcoor + 19, Ycoor, 0
    PRINTf SPACE$(Length)
    LOCATEf Xcoor + 19, Ycoor, 0
    P$ = "Size: <dir>"
    IF Q$ = "." OR Q$ = ".." THEN
       PRINTf P$
    ELSE
       PRINTf P$ + " "
       GOSUB GetDirsize
       GOSUB DisplayDirattr
    END IF
 END IF
 COLORf2 Plain, 0
 CALL SMouse
 RETURN

' display drive attribute.
DisplayDrivesize:
 CALL HMouse
 COLORf2 Green, 1
 IF Xcoor + 19 <= 24 THEN
    Length = 80 - Ycoor - 1
    LOCATEf Xcoor + 19, Ycoor, 0
    PRINTf SPACE$(Length)
    LOCATEf Xcoor + 19, Ycoor, 0
    P$ = "Size: " + CHR$(Current.Drive + 64) + ":\"
    PRINTf P$
    GOSUB GetDrivesize
    PRINTf DriveAttribute$
 END IF
 COLORf2 Plain, 0
 CALL SMouse
 RETURN

' get filesize and attribute.
GetFilesize:
 ' reset filesize.
 FileSize = False
 FileAttribute = False
 ' store dta.
 GOSUB SetDTA
 ' store long filename.
 IF D$ = "" THEN
    W$ = C$ + ":\" + E$
 ELSE
    W$ = C$ + ":\" + D$ + "\" + E$
 END IF
 ' store asciiz filename.
 ASCIIZ3 = W$ + CHR$(0)
 ' check windows/get file info.
 IF Windows.Detected THEN
    InregsX.AX = &H714E
    InregsX.CX = &H27
    InregsX.SI = &H1
    InregsX.DS = VARSEG(ASCIIZ3)
    InregsX.DX = VARPTR(ASCIIZ3)
    InregsX.ES = VARSEG(WDTAfile)
    InregsX.DI = VARPTR(WDTAfile)
    CALL InterruptX(&H21, InregsX, OutregsX)
    Wfile.Handle = OutregsX.AX
 ELSE
    InregsX.AX = &H4E00
    InregsX.CX = &H27
    InregsX.DS = VARSEG(ASCIIZ3)
    InregsX.DX = VARPTR(ASCIIZ3)
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 ' check findnext error.
 IF (OutregsX.Flags AND &H1) = &H0 THEN
    ' store filesize.
    IF Windows.Detected THEN
       FileSize = ASC(MID$(WDTAfile.FileSizeHigh, 4, 1))
       FileSize = FileSize * &H100 + ASC(MID$(WDTAfile.FileSizeHigh, 3, 1))
       FileSize = FileSize * &H100 + ASC(MID$(WDTAfile.FileSizeHigh, 2, 1))
       FileSize = FileSize * &H100 + ASC(MID$(WDTAfile.FileSizeHigh, 1, 1))
       FileSize = FileSize * &H100 + ASC(MID$(WDTAfile.FileSizeLow, 4, 1))
       FileSize = FileSize * &H100 + ASC(MID$(WDTAfile.FileSizeLow, 3, 1))
       FileSize = FileSize * &H100 + ASC(MID$(WDTAfile.FileSizeLow, 2, 1))
       FileSize = FileSize * &H100 + ASC(MID$(WDTAfile.FileSizeLow, 1, 1))
    ELSE
       FileSize = ASC(MID$(DTAfile.FileSize, 4, 1))
       FileSize = FileSize * &H100 + ASC(MID$(DTAfile.FileSize, 3, 1))
       FileSize = FileSize * &H100 + ASC(MID$(DTAfile.FileSize, 2, 1))
       FileSize = FileSize * &H100 + ASC(MID$(DTAfile.FileSize, 1, 1))
    END IF
    ' store file attribute.
    IF Windows.Detected THEN
       FileAttribute = ASC(WDTAfile.FileBits)
    ELSE
       FileAttribute = ASC(DTAfile.FileBits)
    END IF
 END IF
 ' check windows dos.
 IF Windows.Detected THEN
    ' close long filename search
    InregsX.AX = &H71A1
    InregsX.BX = Wfile.Handle
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 ' restore dta.
 GOSUB ResetDTA
 RETURN

' get dir attribute.
GetDirsize:
 ' reset filesize.
 DirAttribute = False
 ' store dta.
 GOSUB SetDTA
 ' store long filename.
 IF D$ = "" THEN
    W$ = C$ + ":\" + Q$
 ELSE
    W$ = C$ + ":\" + D$ + "\" + Q$
 END IF
 ' store asciiz filename.
 ASCIIZ3 = W$ + CHR$(0)
 ' check windows/get file info.
 IF Windows.Detected THEN
    InregsX.AX = &H714E
    InregsX.CX = &H37
    InregsX.SI = &H1
    InregsX.DS = VARSEG(ASCIIZ3)
    InregsX.DX = VARPTR(ASCIIZ3)
    InregsX.ES = VARSEG(WDTAfile)
    InregsX.DI = VARPTR(WDTAfile)
    CALL InterruptX(&H21, InregsX, OutregsX)
    Wfile.Handle = OutregsX.AX
 ELSE
    InregsX.AX = &H4E00
    InregsX.CX = &H37
    InregsX.DS = VARSEG(ASCIIZ3)
    InregsX.DX = VARPTR(ASCIIZ3)
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 ' check findnext error.
 IF (OutregsX.Flags AND &H1) = &H0 THEN
    ' store file attribute.
    IF Windows.Detected THEN
       DirAttribute = ASC(WDTAfile.FileBits)
    ELSE
       DirAttribute = ASC(DTAfile.FileBits)
    END IF
 END IF
 ' check windows dos.
 IF Windows.Detected THEN
    ' close long filename search
    InregsX.AX = &H71A1
    InregsX.BX = Wfile.Handle
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 ' restore dta.
 GOSUB ResetDTA
 RETURN

' get drive attribute.
GetDrivesize:
 ' reset filesize.
 DriveAttribute$ = ""
 ' skip drive A: and B:
 IF Current.Drive < 3 THEN
    RETURN
 END IF
 ' store dta.
 GOSUB SetDTA
 ' store long filename.
 W$ = CHR$(Current.Drive + 64) + ":\*.*"
 ' store asciiz filename.
 ASCIIZ3 = W$ + CHR$(0)
 Check.Disk = True
 Disk.Ready = False
 InregsX.AX = &H4E00
 InregsX.CX = &H08
 InregsX.DS = VARSEG(ASCIIZ3)
 InregsX.DX = VARPTR(ASCIIZ3)
 CALL InterruptX(&H21, InregsX, OutregsX)
 Check.Disk = False
 IF Disk.Ready = False THEN
    ' check findnext error.
    IF (OutregsX.Flags AND &H1) = &H0 THEN
       ' store file attribute.
       DriveAttribute$ = DTAfile.ASCIIZfilename
       Var = INSTR(DriveAttribute$, CHR$(0))
       IF Var Then
          DriveAttribute$ = LEFT$(DriveAttribute$, Var - 1)
       END IF
    END IF
 END IF
 ' restore dta.
 GOSUB ResetDTA

 ' check quiet switch.
 IF QuietSwitch THEN
    RETURN
 END IF

 ' get volume info
 Check.Disk = True
 Disk.Ready = False
 InregsX.AX = &H6900
 InregsX.BX = Current.Drive
 InregsX.DS = VARSEG(BPBfile)
 InregsX.DX = VARPTR(BPBfile)
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' check flag error
 Check.Disk = False
 IF Disk.Ready THEN
    RETURN
 END IF
 IF (OutregsX.Flags AND &H1) = &H0 THEN
    DriveAttribute$ = DriveAttribute$ + "("
    ' store volume serial number
    FOR Serial.Digit = 4 TO 1 STEP -1
       IF Serial.Digit = 2 THEN
          DriveAttribute$ = DriveAttribute$ + "-"
       END IF
       Digit = ASC(MID$(BPBfile.Serial, Serial.Digit, 1))
       Digit$ = RIGHT$(HEX$(Digit + &H100), 2)
       DriveAttribute$ = DriveAttribute$ + Digit$
    NEXT
    DriveAttribute$ = DriveAttribute$ + ")"
    ' store volume fat type
    DriveAttribute$ = DriveAttribute$ +  "[" + RTRIM$(BPBfile.System) + "]"
 END IF
 RETURN

' display file attribute.
DisplayFileattr:
 P$ = Nul
 IF (FileAttribute AND ReadOnlyBit) = ReadOnlyBit THEN
    P$ = P$ + "o"
 END IF
 IF (FileAttribute AND HiddenBit) = HiddenBit THEN
    P$ = P$ + "h"
 END IF
 IF (FileAttribute AND SystemBit) = SystemBit THEN
    P$ = P$ + "s"
 END IF
 IF (FileAttribute AND ArchiveBit) = ArchiveBit THEN
    P$ = P$ + "a"
 END IF
 IF LEN(P$) THEN
    PRINTf "(" + P$ + ")"
 END IF
 RETURN

' display dir attribute.
DisplayDirattr:
 P$ = Nul
 IF (DirAttribute AND ReadOnlyBit) = ReadOnlyBit THEN
    P$ = P$ + "o"
 END IF
 IF (DirAttribute AND HiddenBit) = HiddenBit THEN
    P$ = P$ + "h"
 END IF
 IF (DirAttribute AND SystemBit) = SystemBit THEN
    P$ = P$ + "s"
 END IF
 IF (DirAttribute AND ArchiveBit) = ArchiveBit THEN
    P$ = P$ + "a"
 END IF
 IF LEN(P$) THEN
    PRINTf "(" + P$ + ")"
 END IF
 RETURN

' clear long directory area.
ClearLongName1:
 CALL HMouse
 COLORf2 Green, 1
 IF Xcoor + 17 <= 24 THEN
    Length = 80 - Ycoor - 1
    LOCATEf Xcoor + 17, Ycoor, 0
    PRINTf SPACE$(Length)
    LOCATEf Xcoor + 17, Ycoor, 0
    PRINTf "Path: "
 END IF
 COLORf2 Plain, 0
 CALL SMouse
 RETURN

' clear long filename area.
ClearLongName2:
 CALL HMouse
 COLORf2 Green, 1
 IF Xcoor + 18 <= 24 THEN
    Length = 80 - Ycoor - 1
    LOCATEf Xcoor + 18, Ycoor, 0
    PRINTf SPACE$(Length)
    LOCATEf Xcoor + 18, Ycoor, 0
    PRINTf "File: "
 END IF
 ' clear size area.
 IF Xcoor + 19 <= 24 THEN
    Length = 80 - Ycoor - 1
    LOCATEf Xcoor + 19, Ycoor, 0
    PRINTf SPACE$(Length)
    LOCATEf Xcoor + 19, Ycoor, 0
    PRINTf "Size: "
 END IF
 COLORf2 Plain, 0
 CALL SMouse
 RETURN

' construct new path.
GetNewPath:
 ' check filespec.
 IF INSTR(X$, "?") = 0 THEN
    IF INSTR(X$, "*") = 0 THEN
       X$ = "*.*"
       Xposition1 = 1
       Xposition2 = 3
    END IF
 END IF
 ' check file.
 IF X$ = "" THEN
    X$ = "*.*"
    Xposition1 = 1
    Xposition2 = 3
 END IF
 ' store new path.
 Q$ = RTRIM$(Directories(Current.Dir))
 ' store path to be parsed.
 X$ = Q$ + "\" + X$
 RETURN

' truncate filename for display.
TruncateFilename:
 A$ = RTRIM$(E$)
 IF LEN(A$) > 26 THEN
    A$ = LEFT$(A$, 23) + "..."
 END IF
 RETURN

' return current drive.
InitDrive:
 InregsX.AX = &H1900
 CALL InterruptX(&H21, InregsX, OutregsX)
 Drive.Number = OutregsX.AX AND &HFF
 C$ = CHR$(Drive.Number + 65)
 RETURN

' return current directory.
InitDir:
 ' check windows dos.
 IF Windows.Detected THEN
    ' get current directory.
    InregsX.AX = &H7147
    InregsX.DX = Drive.Number + 1
    InregsX.DS = VARSEG(ASCIIZ3)
    InregsX.SI = VARPTR(ASCIIZ3)
    CALL InterruptX(&H21, InregsX, OutregsX)
 ELSE
    ' get current directory.
    InregsX.AX = &H4700
    InregsX.DX = Drive.Number + 1
    InregsX.DS = VARSEG(ASCIIZ3)
    InregsX.SI = VARPTR(ASCIIZ3)
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 D$ = LEFT$(ASCIIZ3, INSTR(ASCIIZ3, CHR$(0)) - 1)
 RETURN

' initialize directory/filename record.
OpenDataFiles1:
 V1$ = "HEXEDIT1.DA" + MID$(STR$(Process.Number), 2)
 V2$ = "HEXEDIT2.DA" + MID$(STR$(Process.Number), 2)
 CALL OpenDataFiles(V1$, V2$)
 CLOSE #2, #3
 ' open data structure files.
 IF Windows.Detected THEN
    ' open filename random record structure for windows.
    OPEN V1$ FOR RANDOM AS #2 LEN = LEN(WinFileStruc)
    ' open directory random record structure for windows.
    OPEN V2$ FOR RANDOM AS #3 LEN = LEN(WinFileStruc)
 ELSE
    ' open filename random record structure for DOS.
    OPEN V1$ FOR RANDOM AS #2 LEN = LEN(DosFileStruc)
    ' open directory random record structure for DOS.
    OPEN V2$ FOR RANDOM AS #3 LEN = LEN(DosFileStruc)
 END IF
 RETURN

' check path.
CheckPath:
 GOSUB VerifyPath
 ' check carry flag error.
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    ' check invalid path.
    IF (OutregsX.AX) = 3 THEN
       ValidPath = False
    END IF
    RETURN
 END IF
 ' check filename is not path.
 IF (OutregsX.CX AND &H10) <> &H10 THEN
    ValidPath = False
 END IF
 RETURN

' check path.
CheckPath2:
 GOSUB VerifyPath
 ' check carry flag error.
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    ' check invalid file.
    IF (OutregsX.AX) = 2 THEN
       ValidPath = False
    END IF
 END IF
 RETURN

' get path/file attribute.
VerifyPath:
 ValidPath = True
 ' store directory.
 IF D$ = "" THEN
    ASCIIZ = C$ + ":\" + CHR$(0)
 ELSE
    IF D$ = "\" THEN
       ASCIIZ = C$ + ":\" + CHR$(0)
    ELSE
       ASCIIZ = C$ + ":\" + D$ + CHR$(0)
    END IF
 END IF
 ' conanicalize filename.
 V4 = True
 GOSUB ShortFilenameX
 ' store filename.
 ASCIIZ = RTRIM$(Short.Filename$) + CHR$(0)
 ' check windows.
 IF Windows.Detected THEN
    ' get file attribute.
    InregsX.AX = &H7143
    InregsX.BX = &H0
    InregsX.DS = VARSEG(ASCIIZ)
    InregsX.DX = VARPTR(ASCIIZ)
    CALL InterruptX(&H21, InregsX, OutregsX)
 ELSE
    ' get file attribute.
    InregsX.AX = &H4300
    InregsX.DS = VARSEG(ASCIIZ)
    InregsX.DX = VARPTR(ASCIIZ)
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 RETURN

' load current subdirectories.
LoadDirSpec:
 CALL HMouse
 COLORf White
 LOCATEf Xcoor + 1, Ycoor + 12, 1
 PRINTf SPACE$(26)
 LOCATEf Xcoor + 1, Ycoor + 12, 1
 PRINTf "Loading dirs.."
 COLORf Plain
 CALL SMouse
 ' verify valid path.
 GOSUB CheckPath
 IF ValidPath = False THEN
    GOSUB CheckPath2
    IF ValidPath = False THEN
       D$ = ""
    END IF
 END IF
 ' reset directory counter.
 Num.Dirs = 0
 ' set dta.
 GOSUB SetDTA
 ' find first directory.
 IF D$ = "" THEN
    ASCIIZ3 = C$ + ":\*.*" + CHR$(0)
 ELSE
    IF D$ = "\" THEN
       ASCIIZ3 = C$ + ":\*.*" + CHR$(0)
    ELSE
       ASCIIZ3 = C$ + ":\" + D$ + "\*.*" + CHR$(0)
    END IF
 END IF
 ' start findfirst.
 IF Windows.Detected THEN
    InregsX.AX = &H714E
    InregsX.CX = &H37
    InregsX.SI = &H1
    InregsX.DS = VARSEG(ASCIIZ3)
    InregsX.DX = VARPTR(ASCIIZ3)
    InregsX.ES = VARSEG(WDTAfile)
    InregsX.DI = VARPTR(WDTAfile)
    CALL InterruptX(&H21, InregsX, OutregsX)
    Wfile.Handle = OutregsX.AX
 ELSE
    InregsX.AX = &H4E00
    InregsX.CX = &H37
    InregsX.DS = VARSEG(ASCIIZ3)
    InregsX.DX = VARPTR(ASCIIZ3)
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 ' store directories.
 DO
    ' check findnext error.
    IF (OutregsX.Flags AND &H1) = &H1 THEN
       EXIT DO
    END IF
    ' check for directory.
    IF Windows.Detected THEN
       Attribute = ASC(WDTAfile.FileBits)
    ELSE
       Attribute = ASC(DTAfile.FileBits)
    END IF
    ' check directory attribute.
    IF (Attribute AND &H10) = &H10 THEN
       ' reset file flag.
       Flag = True
       ' check requirements.
       IF RequireDirReadOnly THEN
          IF (Attribute AND ReadOnlyBit) = 0 THEN
             Flag = False
          END IF
       END IF
       IF RequireDirHidden THEN
          IF (Attribute AND HiddenBit) = 0 THEN
             Flag = False
          END IF
       END IF
       IF RequireDirSystem THEN
          IF (Attribute AND SystemBit) = 0 THEN
             Flag = False
          END IF
       END IF
       IF RequireDirArchive THEN
          IF (Attribute AND ArchiveBit) = 0 THEN
             Flag = False
          END IF
       END IF
       ' store directory name
       GOSUB StoreName
       Flag2 = False
       IF L$ = "." OR L$ = ".." THEN
          Flag = True
          Flag2 = True
       END IF
       ' check flag.
       IF Flag THEN
          IF Num.Dirs >= 32767 THEN
             EXIT DO
          END IF
          ' check excluded list.
          IF Flag2 = False THEN
             Y2$ = DirY$
             IF LEN(Y2$) THEN
                Y2$ = UCASE$(Y2$)
                L1$ = UCASE$(L$)
                DO
                   ' parse list.
                   Y1 = INSTR(Y2$, " ")
                   IF Y1 THEN
                      Y1$ = LEFT$(Y2$, Y1 - 1)
                      Y2$ = MID$(Y2$, Y1 + 1)
                   ELSE
                      Y1$ = Y2$
                      Y2$ = ""
                   END IF
                   Y1$ = LTRIM$(Y1$)
                   Y1$ = RTRIM$(Y1$)
                   Y2$ = LTRIM$(Y2$)
                   Y2$ = RTRIM$(Y2$)
                   ' check excluded file in filename.
                   IF LEN(Y1$) THEN
                      CALL CheckExcluded(Y1$, L1$, Exclude.File%)
                      IF Exclude.File% THEN
                         Flag = False
                         EXIT DO
                      END IF
                   END IF
                   IF Y2$ = "" THEN
                      EXIT DO
                   END IF
                LOOP
             END IF
          END IF
          IF Flag THEN
             IF Num.Dirs < 32767 THEN
                Num.Dirs = Num.Dirs + 1
                IF Windows.Detected THEN
                   WinFileStruc.Name = L$
                   PUT 3, Num.Dirs, WinFileStruc
                ELSE
                   DosFileStruc.Name = L$
                   PUT 3, Num.Dirs, DosFileStruc
                END IF
             END IF
          END IF
       END IF
    END IF
    ' find next directory.
    IF Windows.Detected THEN
       ' find next long filename.
       InregsX.AX = &H714F
       InregsX.BX = Wfile.Handle
       InregsX.SI = &H1
       InregsX.ES = VARSEG(WDTAfile)
       InregsX.DI = VARPTR(WDTAfile)
       CALL InterruptX(&H21, InregsX, OutregsX)
    ELSE
       ' find next directory.
       InregsX.AX = &H4F00
       CALL InterruptX(&H21, InregsX, OutregsX)
    END IF
 LOOP
 ' check windows dos.
 IF Windows.Detected THEN
    ' close long filename search.
    InregsX.AX = &H71A1
    InregsX.BX = Wfile.Handle
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 ' restore dta.
 GOSUB ResetDTA
 ' reset number of directories.
 IF Num.Dirs = 0 THEN
    Num.Dirs = 1
    IF Windows.Detected THEN
       WinFileStruc.Name = "."
       PUT 3, 1, WinFileStruc
    ELSE
       DosFileStruc.Name = "."
       PUT 3, 1, DosFileStruc
    END IF
 END IF
 ' display number of directories.
 CALL HMouse
 LOCATEf Xcoor + 3, Ycoor + 24, 0
 PRINTf SPACE$(8)
 LOCATEf Xcoor + 3, Ycoor + 24, 0
 COLORf White
 x# = Num.Dirs
 GOSUB FormatX
 PRINTf x4$
 COLORf Plain
 CALL SMouse
 ' sort directories.
 IF HeapSortOff THEN
    RETURN
 END IF
 IF Num.Dirs < 2 THEN
    RETURN
 END IF
 CALL HMouse
 COLORf White
 LOCATEf Xcoor + 1, Ycoor + 12, 1
 PRINTf SPACE$(26)
 LOCATEf Xcoor + 1, Ycoor + 12, 1
 PRINTf "Sorting dirs.."
 COLORf Plain
 CALL SMouse
 IF Windows.Detected THEN
    CALL Win.Heap.Sort2
 ELSE
    CALL Dos.Heap.Sort2
 END IF
 RETURN

' display directory box.
DisplayDirSpec:
 CALL HMouse
 VarX = False
 DO
    VarX = VarX + 1
    IF VarX > 10 THEN
       EXIT DO
    END IF
    IF VarX > Num.Dirs THEN
       EXIT DO
    END IF
    LOCATEf VarX + Xcoor + 4, Ycoor + 19, 1
    Q$ = Directories(VarX)
    Q$ = RTRIM$(Q$)
    PRINTf LEFT$(Q$, 12)
 LOOP
 CALL SMouse
 RETURN

' clear directory box.
ClearDirBox:
 CALL HMouse
 FOR VarX = 1 TO 10
    LOCATEf VarX + Xcoor + 4, Ycoor + 19, 1
    PRINTf SPACE$(12)
 NEXT
 CALL SMouse
 RETURN

' display directory.
DisplayCurrentDir:
 IF RIGHT$(D$, 2) = "\." THEN
    D$ = LEFT$(D$, LEN(D$) - 2)
 END IF
 CALL HMouse
 ASCIIZ = C$ + ":\" + D$ + CHR$(0)
 LOCATEf Xcoor + 2, Ycoor + 2, 1
 PRINTf SPACE$(32)
 V4 = True
 GOSUB ShortFilenameX
 IF Short.Filename$ = "" THEN
    Short.Filename$ = C$ + ":\"
 END IF
 Z$ = Short.Filename$
 CALL Deconcatenate(Z$, 32)
 LOCATEf Xcoor + 2, Ycoor + 2, 1
 PRINTf UCASE$(Z$)
 CALL SMouse
 RETURN

' load specified files.
LoadFileSpec:
 CALL HMouse
 COLORf White
 LOCATEf Xcoor + 1, Ycoor + 12, 1
 PRINTf SPACE$(26)
 LOCATEf Xcoor + 1, Ycoor + 12, 1
 PRINTf "Loading files.."
 COLORf Plain
 CALL SMouse
 Num.Files = 0
 ' set dta.
 GOSUB SetDTA
 ' find first file.
 IF RIGHT$(F$, 1) = "\" THEN
    F$ = F$ + "*.*"
 END IF
 ASCIIZ3 = F$ + CHR$(0)
 ' start findfirst.
 IF Windows.Detected THEN
    InregsX.AX = &H714E
    InregsX.CX = &H27
    InregsX.SI = &H1
    InregsX.DS = VARSEG(ASCIIZ3)
    InregsX.DX = VARPTR(ASCIIZ3)
    InregsX.ES = VARSEG(WDTAfile)
    InregsX.DI = VARPTR(WDTAfile)
    CALL InterruptX(&H21, InregsX, OutregsX)
    Wfile.Handle = OutregsX.AX
 ELSE
    InregsX.AX = &H4E00
    InregsX.CX = &H27
    InregsX.DS = VARSEG(ASCIIZ3)
    InregsX.DX = VARPTR(ASCIIZ3)
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 ' store files.
 DO
    ' check findnext error.
    IF (OutregsX.Flags AND &H1) = &H1 THEN
       EXIT DO
    END IF
    ' check for file.
    IF Windows.Detected THEN
       Attribute = ASC(WDTAfile.FileBits)
    ELSE
       Attribute = ASC(DTAfile.FileBits)
    END IF
    ' check directory attribute.
    IF (Attribute AND &H10) <> &H10 THEN
       ' reset file flag.
       Flag = True
       ' check requirements.
       IF RequireReadOnly THEN
          IF (Attribute AND ReadOnlyBit) = 0 THEN
             Flag = False
          END IF
       END IF
       IF RequireHidden THEN
          IF (Attribute AND HiddenBit) = 0 THEN
             Flag = False
          END IF
       END IF
       IF RequireSystem THEN
          IF (Attribute AND SystemBit) = 0 THEN
             Flag = False
          END IF
       END IF
       IF RequireArchive THEN
          IF (Attribute AND ArchiveBit) = 0 THEN
             Flag = False
          END IF
       END IF
       ' check flag.
       IF Flag THEN
          ' store filename.
          GOSUB StoreName
          IF Num.Files >= 32767 THEN
             EXIT DO
          END IF
          ' check excluded list.
          Y2$ = FileY$
          IF LEN(Y2$) THEN
             Y2$ = UCASE$(Y2$)
             L1$ = UCASE$(L$)
             DO
                ' parse list.
                Y1 = INSTR(Y2$, " ")
                IF Y1 THEN
                   Y1$ = LEFT$(Y2$, Y1 - 1)
                   Y2$ = MID$(Y2$, Y1 + 1)
                ELSE
                   Y1$ = Y2$
                   Y2$ = ""
                END IF
                Y1$ = LTRIM$(Y1$)
                Y1$ = RTRIM$(Y1$)
                Y2$ = LTRIM$(Y2$)
                Y2$ = RTRIM$(Y2$)
                ' check excluded file in filename.
                IF LEN(Y1$) THEN
                   CALL CheckExcluded(Y1$, L1$, Exclude.File%)
                   IF Exclude.File% THEN
                      Flag = False
                      EXIT DO
                   END IF
                END IF
                IF Y2$ = "" THEN
                   EXIT DO
                END IF
             LOOP
          END IF
          ' check flag.
          IF Flag THEN
             IF Num.Files < 32767 THEN
                Num.Files = Num.Files + 1
                IF Windows.Detected THEN
                   WinFileStruc.Name = L$
                   PUT 2, Num.Files, WinFileStruc
                ELSE
                   DosFileStruc.Name = L$
                   PUT 2, Num.Files, DosFileStruc
                END IF
             END IF
          END IF
       END IF
    END IF
    ' find next file.
    IF Windows.Detected THEN
       ' find next long filename.
       InregsX.AX = &H714F
       InregsX.BX = Wfile.Handle
       InregsX.SI = &H1
       InregsX.ES = VARSEG(WDTAfile)
       InregsX.DI = VARPTR(WDTAfile)
       CALL InterruptX(&H21, InregsX, OutregsX)
    ELSE
       ' find next filename.
       InregsX.AX = &H4F00
       CALL InterruptX(&H21, InregsX, OutregsX)
    END IF
 LOOP
 ' check windows dos.
 IF Windows.Detected THEN
    ' close long filename search.
    InregsX.AX = &H71A1
    InregsX.BX = Wfile.Handle
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 ' restore dta.
 GOSUB ResetDTA
 ' display number of files.
 CALL HMouse
 LOCATEf Xcoor + 3, Ycoor + 9, 0
 PRINTf SPACE$(9)
 LOCATEf Xcoor + 3, Ycoor + 9, 0
 COLORf White
 x# = Num.Files
 GOSUB FormatX
 PRINTf x4$
 COLORf Plain
 CALL SMouse
 ' sort files.
 IF HeapSortOff THEN
    RETURN
 END IF
 IF Num.Files < 2 THEN
    RETURN
 END IF
 CALL HMouse
 COLORf White
 LOCATEf Xcoor + 1, Ycoor + 12, 1
 PRINTf SPACE$(26)
 LOCATEf Xcoor + 1, Ycoor + 12, 1
 PRINTf "Sorting files.."
 COLORf Plain
 CALL SMouse
 IF Windows.Detected THEN
    CALL Win.Heap.Sort1
 ELSE
    CALL Dos.Heap.Sort1
 END IF
 RETURN

' display filename box.
DisplayFileSpec:
 CALL HMouse
 VarX = False
 DO
    VarX = VarX + 1
    IF VarX > 10 THEN
       EXIT DO
    END IF
    IF VarX > Num.Files THEN
       EXIT DO
    END IF
    LOCATEf VarX + Xcoor + 4, Ycoor + 3, 1
    Q$ = Filenames(VarX)
    Q$ = RTRIM$(Q$)
    PRINTf LEFT$(Q$, 12)
 LOOP
 CALL SMouse
 RETURN

' clear filename box.
ClearFileBox:
 CALL HMouse
 FOR VarX = 1 TO 10
    LOCATEf VarX + Xcoor + 4, Ycoor + 3, 1
    PRINTf SPACE$(12)
 NEXT
 CALL SMouse
 RETURN

' assign program dta.
SetDTA:
 InregsX.AX = &H1A00
 InregsX.DS = VARSEG(DTAfile)
 InregsX.DX = VARPTR(DTAfile)
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN

' restore basic dta.
ResetDTA:
 InregsX.AX = &H1A00
 InregsX.DS = BASIC.DTA.SEG
 InregsX.DX = BASIC.DTA.OFF
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN

' store asciiz name.
StoreName:
 IF Windows.Detected THEN
    IF Ambiguate = False THEN
       L$ = WDTAfile.ASCIIZfull
       GOSUB StripAsciiz
       RETURN
    END IF
    L$ = WDTAfile.ASCIIZshort
    GOSUB StripAsciiz
    IF RTRIM$(L$) = "" THEN
       L$ = WDTAfile.ASCIIZfull
       GOSUB StripAsciiz
    END IF
    RETURN
 END IF
 L$ = DTAfile.ASCIIZfilename
 GOSUB StripAsciiz
 RETURN

' strip ascii 0 from asciiz.
StripAsciiz:
 IF INSTR(L$, CHR$(0)) THEN
    L$ = LEFT$(L$, INSTR(L$, CHR$(0)) - 1)
 END IF
 RETURN

' format filename for display and search purposes.
ShortFilenameX:
 ' read ambiguated 8.3 filename.
 IF Windows.Detected THEN
    InregsX.AX = &H7160
    InregsX.CX = &H8001
    InregsX.DS = VARSEG(ASCIIZ)
    InregsX.SI = VARPTR(ASCIIZ)
    InregsX.ES = VARSEG(ASCIIZ2)
    InregsX.DI = VARPTR(ASCIIZ2)
    CALL InterruptX(&H21, InregsX, OutregsX)
 ELSE
    InregsX.AX = &H6000
    InregsX.DS = VARSEG(ASCIIZ)
    InregsX.SI = VARPTR(ASCIIZ)
    InregsX.ES = VARSEG(ASCIIZ2)
    InregsX.DI = VARPTR(ASCIIZ2)
    CALL InterruptX(&H21, InregsX, OutregsX)
 END IF
 ' check carry flag error.
 IF (OutregsX.Flags AND &H1) = &H1 THEN
    Short.Filename$ = ""
    RETURN
 END IF
 IF (OutregsX.Flags AND &H1) = &H0 THEN
    ' store conanicalized 8.3 filename.
    Short.Filename$ = ASCIIZ2
    Imbedded = INSTR(Short.Filename$, CHR$(0))
    IF Imbedded THEN
       Short.Filename$ = LEFT$(Short.Filename$, Imbedded - 1)
    END IF
    Short.Filename$ = UCASE$(RTRIM$(Short.Filename$))
    ' store 8.3 filename.
    IF V4 = False THEN ' variable to strip filename from path.
       FOR V = LEN(Short.Filename$) TO 1 STEP -1
          IF MID$(Short.Filename$, V, 1) = "\" THEN
             Short.Filename$ = MID$(Short.Filename$, V + 1)
             EXIT FOR
          END IF
       NEXT
    END IF
 END IF
 RETURN

' get default drives.
GetDrives:
 ' get current drive.
 InregsX.AX = &H1900
 CALL InterruptX(&H21, InregsX, OutregsX)
 Default.Drive = OutregsX.AX AND &HFF ' 0=a, 1=b,..

 ' get maximum drives.
 InregsX.AX = &H0E00
 InregsX.DX = Default.Drive
 CALL InterruptX(&H21, InregsX, OutregsX)
 Last.Drive = OutregsX.AX AND &HFF ' number of drives

 ' some old DOS functions return 0 - 63.
 IF Last.Drive > 26 THEN
    Last.Drive = 26
 END IF
 RETURN

' clear current drive.
ClearDrive:
 CALL HMouse
 COLORf2 Plain, 0
 LOCATEf Xcoor + Drive.Box.Line + 4, Ycoor + 35, 0
 PRINTf "[" + CHR$(Current.Drive + 64) + "]"
 CALL SMouse
 RETURN

' clear drive box.
ClearDriveBox:
 CALL HMouse
 FOR Var = 1 TO 10
    LOCATEf Xcoor + 4 + Var, Ycoor + 35, 1
    PRINTf "   "
 NEXT
 CALL SMouse
 RETURN

' display current drive.
DisplayDrive:
 GOSUB DisplayDrivesize
 CALL HMouse
 COLORf2 Black, Plain
 LOCATEf Xcoor + Drive.Box.Line + 4, Ycoor + 35, 1
 PRINTf "[" + CHR$(Current.Drive + 64) + "]"
 LOCATEf Xcoor + Drive.Box.Line + 4, Ycoor + 38, 1
 COLORf2 Plain, 0
 CALL SMouse
 RETURN

' display available drives.
DisplayDrives:
 CALL HMouse
 FOR Var = 1 TO Last.Drive
    IF Var > 10 THEN
       CALL SMouse
       RETURN
    END IF
    LOCATEf Xcoor + 4 + Var, Ycoor + 35, 1
    PRINTf "[" + CHR$(Var + 64) + "]"
 NEXT
 CALL SMouse
 RETURN

' display drive box.
InitDrives:
' init drive letter.
IF Current.Drive = 0 THEN
   Current.Drive = Drive.Number + 1
END IF
' display drives.
V3 = Current.Drive
IF V3 > Last.Drive THEN
   V3 = Last.Drive
END IF
GOSUB ClearDriveBox
Drive.Box.Line = 1
Current.Drive = 1
GOSUB DisplayDrives
GOSUB DisplayDrive
' scroll to drive.
DO UNTIL Current.Drive >= V3
   GOSUB MoveDriveDown
LOOP
RETURN

' process left mouse button single-click.
MouseButton1Z:
 ' store mouse variables.
 IsMenu = False
 Mouse.Row = Mouse.RowX
 Mouse.Column = Mouse.ColumnX
 ' file box pageup
 IF Mouse.Row = Xcoor + 4 THEN
    IF Mouse.Column = Ycoor + 16 THEN
       I$ = CHR$(0) + CHR$(73)
       IsMenu = 1
       RETURN
    END IF
 END IF
 ' file box up
 IF Mouse.Row = Xcoor + 5 THEN
    IF Mouse.Column = Ycoor + 16 THEN
       I$ = CHR$(0) + CHR$(72)
       IsMenu = 1
       RETURN
    END IF
 END IF
 ' file box down
 IF Mouse.Row = Xcoor + 14 THEN
    IF Mouse.Column = Ycoor + 16 THEN
       I$ = CHR$(0) + CHR$(80)
       IsMenu = 1
       RETURN
    END IF
 END IF
 ' file box pagedown
 IF Mouse.Row = Xcoor + 15 THEN
    IF Mouse.Column = Ycoor + 16 THEN
       I$ = CHR$(0) + CHR$(81)
       IsMenu = 1
       RETURN
    END IF
 END IF
 ' directory box pageup
 IF Mouse.Row = Xcoor + 4 THEN
    IF Mouse.Column = Ycoor + 32 THEN
       I$ = CHR$(0) + CHR$(73)
       IsMenu = 2
       RETURN
    END IF
 END IF
 ' directory box up
 IF Mouse.Row = Xcoor + 5 THEN
    IF Mouse.Column = Ycoor + 32 THEN
       I$ = CHR$(0) + CHR$(72)
       IsMenu = 2
       RETURN
    END IF
 END IF
 ' directory box down
 IF Mouse.Row = Xcoor + 14 THEN
    IF Mouse.Column = Ycoor + 32 THEN
       I$ = CHR$(0) + CHR$(80)
       IsMenu = 2
       RETURN
    END IF
 END IF
 ' directory box pagedown
 IF Mouse.Row = Xcoor + 15 THEN
    IF Mouse.Column = Ycoor + 32 THEN
       I$ = CHR$(0) + CHR$(81)
       IsMenu = 2
       RETURN
    END IF
 END IF
 ' drive box up
 IF Mouse.Row = Xcoor + 5 THEN
    IF Mouse.Column = Ycoor + 39 THEN
       I$ = CHR$(0) + CHR$(72)
       IsMenu = 3
       RETURN
    END IF
 END IF
 ' drive box down
 IF Mouse.Row = Xcoor + 14 THEN
    IF Mouse.Column = Ycoor + 39 THEN
       I$ = CHR$(0) + CHR$(80)
       IsMenu = 3
       RETURN
    END IF
 END IF
 ' check mouse selection boundaries for file box.
 IF Mouse.Row >= Xcoor + 5 AND Mouse.Row <= Xcoor + 14 THEN
    IF Mouse.Column >= Ycoor + 3 AND Mouse.Column <= Ycoor + 14 THEN
       IF Num.Files > 0 THEN
          I$ = ""
          Valid = False
          V = Mouse.Row - (Xcoor + 4)
          IF V = Box.Line THEN
             Valid = True
          END IF
          IF V > Box.Line THEN
             IF Current.File + (V - Box.Line) <= Num.Files THEN
                Current.File = Current.File + (V - Box.Line)
                Valid = True
             END IF
          END IF
          IF V < Box.Line THEN
             IF Current.File - (Box.Line - V) > 0 THEN
                Current.File = Current.File - (Box.Line - V)
                Valid = True
             END IF
          END IF
          IF Valid THEN
             I$ = CHR$(13)
             IsMenu = 1
          END IF
       END IF
       RETURN
    END IF
 END IF
 ' check mouse selection boundaries for dir box.
 IF Mouse.Row >= Xcoor + 5 AND Mouse.Row <= Xcoor + 14 THEN
    IF Mouse.Column >= Ycoor + 19 AND Mouse.Column <= Ycoor + 31 THEN
       I$ = ""
       Valid = False
       V = Mouse.Row - (Xcoor + 4)
       IF V = Dir.Box.Line THEN
          Valid = True
       END IF
       IF V > Dir.Box.Line THEN
          IF Current.Dir + (V - Dir.Box.Line) <= Num.Dirs THEN
             Current.Dir = Current.Dir + (V - Dir.Box.Line)
             Valid = True
          END IF
       END IF
       IF V < Dir.Box.Line THEN
          IF Current.Dir - (Dir.Box.Line - V) > 0 THEN
             Current.Dir = Current.Dir - (Dir.Box.Line - V)
             Valid = True
          END IF
       END IF
       IF Valid THEN
          I$ = CHR$(13)
          IsMenu = 2
       END IF
       RETURN
    END IF
 END IF
 ' check mouse selection boundaries for drive box.
 IF Mouse.Row >= Xcoor + 5 AND Mouse.Row <= Xcoor + 14 THEN
    IF Mouse.Column >= Ycoor + 35 AND Mouse.Column <= Ycoor + 37 THEN
       I$ = ""
       Valid = False
       V = Mouse.Row - (Xcoor + 4)
       IF V = Drive.Box.Line THEN
          Valid = True
       END IF
       IF V > Drive.Box.Line THEN
          IF Current.Drive + (V - Drive.Box.Line) <= Last.Drive THEN
             GOSUB ClearDrive
             Current.Drive = Current.Drive + (V - Drive.Box.Line)
             Drive.Box.Line = Drive.Box.Line + (V - Drive.Box.Line)
             GOSUB DisplayDrive
             Valid = True
          END IF
       END IF
       IF V < Drive.Box.Line THEN
          IF Current.Drive - (Drive.Box.Line - V) > 0 THEN
             GOSUB ClearDrive
             Current.Drive = Current.Drive - (Drive.Box.Line - V)
             Drive.Box.Line = Drive.Box.Line - (Drive.Box.Line - V)
             GOSUB DisplayDrive
             Valid = True
          END IF
       END IF
       IF Valid THEN
          I$ = CHR$(13)
          IsMenu = 3
       END IF
       RETURN
    END IF
 END IF
 ' check mouse selection boundaries for file entry area.
 IF Mouse.Row = Xcoor + 1 THEN
    IF Mouse.Column >= Ycoor + 2 AND Mouse.Column <= Ycoor + 39 THEN
       I$ = ""
       IsMenu = 4
       RETURN
    END IF
 END IF
 ' check mouse selection boundaries for file box question.
 IF Mouse.Row = Xcoor THEN
    IF Mouse.Column = Ycoor + 39 THEN
       I$ = ""
       CALL HMouse
       CALL DisplayHelp
       GOSUB RedrawScreen
       CALL SMouse
       RETURN
    END IF
 END IF
 ' check mouse selection boundaries for file box exit.
 IF Mouse.Row = Xcoor THEN
    IF Mouse.Column = Ycoor + 40 THEN
       I$ = ""
       IsMenu = 5
       RETURN
    END IF
 END IF
 RETURN

' mouseover for file/dir/drive boxes.
MouseOverX1:
 ' check mouse selection boundaries for file box.
 IF Mouse.Row >= Xcoor + 5 AND Mouse.Row <= Xcoor + 14 THEN
    IF Mouse.Column >= Ycoor + 3 AND Mouse.Column <= Ycoor + 14 THEN
       IF Num.Files > 0 THEN
          B1 = Mouse.Row - (Xcoor + 4)
          IF B1 > Box.Line THEN
             B2 = B1 - Box.Line
             IF B2 <= Num.Files THEN
                FOR B3 = 1 TO B2
                   IF Current.File + 1 <= Num.Files THEN
                      IF Box.Line < 10 THEN
                         GOSUB ClearFilename
                         Box.Line = Box.Line + 1
                         Current.File = Current.File + 1
                         GOSUB DisplayFilename5
                         GOSUB DisplayLongName2
                     END IF
                   END IF
                NEXT
             END IF
          ELSE
             IF B1 < Box.Line THEN
                B2 = Box.Line - B1
                IF B2 > 0 THEN
                   FOR B3 = 1 TO B2
                      IF Current.File - 1 > 0 THEN
                         IF Box.Line > 1 THEN
                            GOSUB ClearFilename
                            Box.Line = Box.Line - 1
                            Current.File = Current.File - 1
                            GOSUB DisplayFilename5
                            GOSUB DisplayLongName2
                         END IF
                      END IF
                   NEXT
                END IF
             ELSE
                IF B1 = Box.Line THEN
                   GOSUB ClearFilename
                   GOSUB DisplayFilename5
                   GOSUB DisplayLongName2
                END IF
             END IF
          END IF
       END IF
       RETURN
    END IF
 END IF
 ' check mouse selection boundaries for dir box.
 IF Mouse.Row >= Xcoor + 5 AND Mouse.Row <= Xcoor + 14 THEN
    IF Mouse.Column >= Ycoor + 19 AND Mouse.Column <= Ycoor + 31 THEN
       IF Num.Dirs > 0 THEN
          D1 = Mouse.Row - (Xcoor + 4)
          IF D1 > Dir.Box.Line THEN
             D2 = D1 - Dir.Box.Line
             IF D2 > 0 THEN
                IF D2 <= Num.Dirs THEN
                   FOR D3 = 1 TO D2
                      IF Current.Dir + 1 <= Num.Dirs THEN
                         IF Dir.Box.Line < 10 THEN
                            GOSUB ClearDirectory
                            Dir.Box.Line = Dir.Box.Line + 1
                            Current.Dir = Current.Dir + 1
                            GOSUB DisplayDirectory
                            Q$ = RTRIM$(Directories(Current.Dir))
                            GOSUB DisplayLongName1
                         END IF
                      END IF
                   NEXT
                END IF
             END IF
          ELSE
             IF D1 < Dir.Box.Line THEN
                D2 = Dir.Box.Line - D1
                IF D2 > 0 THEN
                   IF D2 <= Num.Dirs THEN
                      FOR D3 = 1 TO D2
                         IF Current.Dir - 1 > 0 THEN
                            IF Dir.Box.Line > 1 THEN
                               GOSUB ClearDirectory
                               Dir.Box.Line = Dir.Box.Line - 1
                               Current.Dir = Current.Dir - 1
                               GOSUB DisplayDirectory
                               Q$ = RTRIM$(Directories(Current.Dir))
                               GOSUB DisplayLongName1
                            END IF
                         END IF
                      NEXT
                   END IF
                END IF
             ELSE
                IF D1 = Dir.Box.Line THEN
                   GOSUB DisplayDirectory
                   Q$ = RTRIM$(Directories(Current.Dir))
                   GOSUB DisplayLongName1
                END IF
             END IF
          END IF
       END IF
       RETURN
    END IF
 END IF
 ' check mouse selection boundaries for drive box.
 IF Mouse.Row >= Xcoor + 5 AND Mouse.Row <= Xcoor + 14 THEN
    IF Mouse.Column >= Ycoor + 35 AND Mouse.Column <= Ycoor + 37 THEN
       X0 = Mouse.Row - (Xcoor + 4)
       IF X0 > Drive.Box.Line THEN
          X1 = Current.Drive + (X0 - Drive.Box.Line)
          IF X1 <= Last.Drive THEN
             GOSUB ClearDrive
             Current.Drive = Current.Drive + (X0 - Drive.Box.Line)
             Drive.Box.Line = Drive.Box.Line + (X0 - Drive.Box.Line)
             GOSUB DisplayDrive
          END IF
       ELSE
          IF X0 < Drive.Box.Line THEN
             X1 = Current.Drive - (Drive.Box.Line - X0)
             IF X1 > 0 THEN
                GOSUB ClearDrive
                Current.Drive = Current.Drive - (Drive.Box.Line - X0)
                Drive.Box.Line = Drive.Box.Line - (Drive.Box.Line - X0)
                GOSUB DisplayDrive
             END IF
          ELSE
             IF X0 = Drive.Box.Line THEN
                GOSUB DisplayDrive
             END IF
          END IF
       END IF
    END IF
 END IF
 RETURN

' redraws editing screen.
RedrawScreen:
 COLORf2 White, 1
 CLS
 CALL FileMainMenu
 GOSUB UpdateDisplay
 GOSUB DisplayCurrentPath
 IF Num.Files > 0 THEN
    GOSUB DisplayLongName2
 END IF
 GOSUB DisplayFilenamex
 GOSUB DisplayFileLine
 RETURN

' store area.
StoreArea:
 RowX1 = 0
 ColumnY1 = 0
 FOR RowX2 = Xcoor - 1 TO Xcoor + 16
    RowX1 = RowX1 + 1
    ColumnY1 = 0
    FOR ColumnY2 = Ycoor TO Ycoor + 41
       ColumnY1 = ColumnY1 + 1
       ' store ascii character.
       Area1(RowX1, ColumnY1) = SCREEN(RowX2, ColumnY2)
       ' store color. (undocumented: also stores background color).
       Area2(RowX1, ColumnY1) = SCREEN(RowX2, ColumnY2, 1)
    NEXT
 NEXT
 RETURN

' restore area.
RestoreArea:
 RowX1 = 0
 ColumnY1 = 0
 FOR RowX2 = Xcoor - 1 TO Xcoor + 16
    RowX1 = RowX1 + 1
    ColumnY1 = 0
    FOR ColumnY2 = Ycoor TO Ycoor + 41
       ColumnY1 = ColumnY1 + 1
       LOCATEf RowX2, ColumnY2, 1
       ' restore color.
       TempZ = Area2(RowX1, ColumnY1)
       ' undocumented: also stores background color.
       VarB = INT(TempZ / 16)
       VarF = TempZ MOD 16
       COLORf2 VarF, VarB
       ' restore ascii character.
       PRINTf CHR$(Area1(RowX1, ColumnY1))
    NEXT
 NEXT
 RETURN

' simple formatting function.
FormatX:
 x4$ = ""
 s4$ = MID$(STR$(x#), 2)
 FOR l = LEN(s4$) TO 3 STEP -3
    x4$ = MID$(s4$, l - 2, 3) + "," + x4$
 NEXT
 IF l > 0 THEN
    x4$ = MID$(s4$, 1, l) + "," + x4$
 END IF
 IF LEN(s4$) < 3 THEN
    x4$ = s4$
 END IF
 IF RIGHT$(x4$, 1) = "," THEN
    x4$ = LEFT$(x4$, LEN(x4$) - 1)
 END IF
 RETURN

' construct file exclusion list.
Exclude.List:
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 PRINTf SPACE$(38)
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 COLORf2 White, 0
 PRINTf "Enter file spec: "
 GOTO Get.Exclude.List
Exclude.List2:
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 PRINTf SPACE$(38)
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 COLORf2 White, 0
 PRINTf "Enter dir spec: "
Get.Exclude.List:
 LINE INPUT Y$
 IF LEN(Y$) THEN
    IF LEFT$(Y$, 1) = "@" THEN
       Filename2$ = MID$(Y$, 2)
       Y$ = ""
       IF LEN(Filename2$) THEN
          Check.Disk = True
          Disk.Ready = False
          ErrorTrap = False
          CLOSE #1
          OPEN Filename2$ FOR INPUT AS #1
          Check.Disk = False
          IF Disk.Ready OR ErrorTrap THEN
             LOCATEf Xcoor + 1, Ycoor + 2, 1
             PRINTf SPACE$(38)
             LOCATEf Xcoor + 1, Ycoor + 2, 1
             COLORf2 White, 0
             PRINTf "Filelist not found. Press <esc>:"
             WHILE INKEY$<>CHR$(27)
             WEND
             RETURN
          END IF
          DO UNTIL EOF(1)
             LINE INPUT #1, Y1$
             Y1$ = LTRIM$(Y1$)
             Y1$ = RTRIM$(Y1$)
             Y1$ = UCASE$(Y1$)
             IF LEN(Y1$) THEN
                IF LEFT$(Y1$, 1) = Quote THEN
                   Y1$ = MID$(Y1$, 2)
                   IF RIGHT$(Y1$, 1) = Quote THEN
                      Y1$ = LEFT$(Y1$, LEN(Y1$) - 1)
                   END IF
                END IF
                IF LEN(Y1$) THEN
                   IF INSTR(Y1$, " ") = 0 THEN
                      ' add excluded filename.
                      Y$ = Y$ + Y1$ + " "
                      IF LEN(Y$) > 4096 THEN
                         Y$ = ""
                         EXIT DO
                      END IF
                   END IF
                END IF
             END IF
          LOOP
          LOCATEf Xcoor + 1, Ycoor + 2, 1
          PRINTf SPACE$(38)
          LOCATEf Xcoor + 1, Ycoor + 2, 1
          COLORf2 White, 0
          IF LEN(Y$) THEN
             PRINTf "Filelist loaded. Press <esc>:"
          ELSE
             PRINTf "Filelist not loaded. Press <esc>:"
          END IF
          WHILE INKEY$<>CHR$(27)
          WEND
       END IF
    END IF
 END IF
 Y$ = LTRIM$(Y$)
 Y$ = RTRIM$(Y$)
 RETURN

' scancodes for Alt-A to Alt-Z.
DATA  30, 48, 46, 32, 18, 33, 34, 35, 23, 36 
DATA  37, 38, 50, 49, 24, 25, 16, 19, 31, 20 
DATA  22, 47, 17, 45, 21, 44 

' simple error routine
Error.Routine3:
 ErrorTrap = ERR
 ' verify disk letter.
 IF Check.Disk THEN
    ' device i/o error.
    IF ERR = 57 THEN
       Disk.Ready = True
       RESUME NEXT
    END IF
    ' bad filename
    IF ERR = 64 THEN
       Disk.Ready = True
       RESUME NEXT
    END IF
    ' device unavailable.
    IF ERR = 68 THEN
       Disk.Ready = True
       RESUME NEXT
    END IF
    ' permission denied.
    IF ERR = 70 THEN
       Disk.Ready = True
       RESUME NEXT
    END IF
    ' disk not ready.
    IF ERR = 71 THEN
       Disk.Ready = True
       RESUME NEXT
    END IF
    ' path not found.
    IF ERR = 76 THEN
       Disk.Ready = True
       RESUME NEXT
    END IF
 END IF
 ' display error.
 COLORf2 White, 0
 CLS
 LOCATEf Csrlin, 1, 0
 PRINTf "Hex Editor Menu " + Version + " " + Release + " critical error trap:"
 ' display error.
 COLORf Yellow
 LOCATEf Csrlin+1, 1, 0
 CALL DisplayCriticalError(ErrorTrap)
 ' display error and exit.
 COLORf Green
 LOCATEf Csrlin+1, 1, 0
 PRINTf "Check TEMP variables, .CFG file, or DOS file handles, then restart."
 COLORf Plain
 END
END SUB
