 Rem * Filename: dnds7.bas Version: v5.0a r1.0a
 Rem * This subprogram contains all the main editor routines.

 Rem $Include: 'dnddoor.inc'

 Rem * main routine to enter the editor and process edit selections.

Sub Editor
 On Local Error Resume Next ' local error resume
 Call Put.User.Record ' store current user settings
 Graphics.Off=False ' reset ansi color
 Outpt="Edit utility v"+Version$ ' editor intro prompt
 Call IO.O ' send output
 Do ' loop through edit selections
    Graphics.Off=True ' reset color
    Outpt="[A]ction" ' edit selection
    Call IO.O ' send output
    Outpt="[E]mail" ' edit selection
    Call IO.O ' send output
    Outpt="[H]elp" ' edit selection
    Call IO.O ' send output
    Outpt="[L]inks" ' edit selection
    Call IO.O ' send output
    Outpt="[M]onster" ' edit selection
    Call IO.O ' send output
    Outpt="[N]onplayer" ' edit selection
    Call IO.O ' send output
    Outpt="[O]bject" ' edit selection
    Call IO.O ' send output
    Outpt="[R]oom" ' edit selection
    Call IO.O ' send output
    Outpt="[S]pell" ' edit selection
    Call IO.O ' send output
    Outpt="[T]reasure" ' edit selection
    Call IO.O ' send output
    Outpt="[U]ser" ' edit selection
    Call IO.O ' send output
    Graphics.Off=False ' reset ansi color
    Outpt="Edit option(q to quit)? " ' display edit prompt
    No.Input.Out="Q" ' default entry
    Call IO.I ' get input
    Select Case Ucase$(Inpt) ' selection of input choice
    Case "A" ' action selection
       Call Edit.Action ' action editor
    Case "E" ' email selection
       Call Edit.Mail ' email editor
    Case "H" ' help selection
       Call Edit.Help ' !edit help
    Case "L" ' option to edit room links
       Call Link.Room ' room link edit
    Case "M" ' monster selection
       Call Edit.Monster(Rate.Changed) ' monster editor
       If Rate.Changed Then ' check to reread monster class
          Call Read.Monclass ' reread monster class arrays
       Endif ' end check monster class
    Case "N" ' nonplayer selection
       Call Edit.Nonplayer ' nonplayer editor
    Case "O" ' object selection
       Call Edit.Object ' object editor
    Case "R" ' rooms selection
       Call Edit.Room ' room editor
    Case "S" ' spell selection
       Call Edit.Spell ' spell editor
    Case "T" ' treasure selection
       Call Edit.Treasure ' treasure editor
    Case "U" ' user selection
       Call Edit.User ' user editor
    Case "Q" ' quit selection
       Exit Do ' exit editor
    End Select ' end choice selection
 Loop ' end edit loop
 Call Get.User.Record ' restore user stats
End Sub ' end main routine to select edit option

 Rem * routine to edit actions.

Sub Edit.Action
 On Local Error Resume Next ' local error resume
 Do ' loop through action edit menu
    Graphics.Off=False ' reset color
    Outpt="Action edit:" ' make display message
    Call IO.O ' send message
    Graphics.Off=True ' reset color
    Outpt="[A]dd" ' make display message
    Call IO.O ' send message
    Outpt="[C]hange" ' make display message
    Call IO.O ' send message
    Outpt="[L]ist" ' make display message
    Call IO.O ' send message
    Graphics.Off=False ' reset color
    Outpt="Action edit option(q to quit)? " ' option input prompt
    No.Input.Out="Q" ' default input
    Call IO.I ' get user input
    Select Case Ucase$(Inpt) ' selection of option input
    Case "A" ' add action option
       New.Record=Lof(ActionFile)/Len(ActionRecord)+1
       ActionRecord.SpellTrigger=False
       ActionRecord.MonsterTrigger=False
       ActionRecord.HealthRate=False
       ActionRecord.EncounterRate=False
       ActionRecord.HitPoints=False
       ActionRecord.Inventory=False
       ActionRecord.MonsterTalk=False
       ActionRecord.Fumble=False
       ActionRecord.Teleport=False
       ActionRecord.Level=False
       ActionRecord.Restrictions=False
       ActionRecord.RustRate=False
       ActionRecord.StealRate=False
       ActionRecord.Attribute1=False
       ActionRecord.Attribute2=False
       Call Share.Record(ActionFile,New.Record)
       Outpt="Action"+Str$(New.Record)+" added." ' make message
       Call IO.O ' send message
    Case "L" ' option to list actions
       Max.Actions=Lof(ActionFile)/Len(ActionRecord) ' store action records
       ' routine to get range values
       Call Get.Range(Max.Actions,Action.List1,Action.List2)
       ' loop through range values
       Allow.Break=True ' set allow break flag
       Break=False ' reset control-k flag
       Continue=False ' set continuous flag
       For Action.Count=Action.List1 To Action.List2
          Call Read.Record(ActionFile,Action.Count) ' read action record
          Call Display.Action(Action.Count) ' routine to display actions
          If Break Then ' check control-k flag
             Exit For ' exit display loop
          Endif ' end check control-k
          If Continue=False Then ' check continuous flag
             Call More.Prompt ' routine to pause
             If No Then ' check pause input
                Exit For ' exit action list loop
             Endif ' end check input
          Endif ' end check continuous flag
       Next ' end loop through actions
       Allow.Break=False ' reset allow break flag
       If Break Then ' check control-k flag
          Break=False ' reset control-k flag
          Outpt=Nul ' set output to null
          Call IO.O ' send empty return
       Endif ' end check control-k flag
    Case "C"
       Outpt="Enter action number" ' make range prompt
       Max.Actions=Lof(ActionFile)/Len(ActionRecord) ' store action records
       ' routine to get range of numbers
       Call Get.Range2(0,Max.Actions,Action.Number)
       If Action.Number>False Then ' check number range
          Call Read.Record(ActionFile,Action.Number) ' get action record
          Do ' loop through action edit menu
             Call Display.Action(Action.Number)
             Graphics.Off=False ' reset color
             Outpt="Action edit option(q to quit)? " ' make input prompt
             No.Input.Out="Q" ' default input
             Call IO.I ' get user input
             Select Case Ucase$(Inpt) ' selection of action edit option
             Case "A" ' option for monster encounter trigger
                ' routine to get monster number
                Call Find.Monster(Monster.Number)
                ' store monster number trigger
                ActionRecord.MonsterTrigger=Monster.Number
             Case "B" ' option for spell trigger
                ' routine to get spell number
                Call Find.Spell(Spell.Number)
                ' store spell number trigger
                ActionRecord.SpellTrigger=Spell.Number
             Case "C" ' option monster talk number
                ' routine to get monster number
                Call Find.Monster(Monster.Number)
                ' store monster talk number trigger
                ActionRecord.MonsterTalk=Monster.Number
             Case "D" ' option for player level entry trigger
                Graphics.Off=True ' reset color
                ' make message
                Outpt="[H]ighest level (at least) for entry to room"
                Call IO.O ' send level trigger display message
                ' make message
                Outpt="[L]owest level (at most) for entry to room"
                Call IO.O ' send level trigger display message
                Graphics.Off=False ' reset color
                ' make input prompt
                Outpt="Action level entry option(q to quit)? "
                No.Input.Out="Q" ' default prompt
                Call IO.I ' get user input
                Select Case Ucase$(Inpt) ' selection of level entry option
                Case "H" ' high level entry option
                   Outpt="Highest level player must be (at least) to enter room? "
                   No.Input.Out="1" ' default input
                   Call IO.I ' get user input
                   ActionRecord.Level=Int(Val(Inpt)) ' store level entry trigger
                Case "L" ' low level entry option
                   Outpt="Lowest level player must be (at most) to enter room? "
                   No.Input.Out="1" ' default input
                   Call IO.I ' get user input
                   ActionRecord.Level=-Int(Val(Inpt)) ' store level entry trigger
                End Select
                Do
                   Graphics.Off=False
                   Outpt="Direction options:"
                   Call IO.O
                   Graphics.Off=True ' reset color
                   Outpt="[N]orth" ' make direction display message
                   Call IO.O ' send direction display message
                   Outpt="[E]ast" ' make direction display message
                   Call IO.O ' send direction display message
                   Outpt="[S]outh" ' make direction display message
                   Call IO.O ' send direction display message
                   Outpt="[W]est" ' make direction display message
                   Call IO.O ' send direction display message
                   Outpt="[NE]northeast" ' make direction display message
                   Call IO.O ' send direction display message
                   Outpt="[SE]southeast" ' make direction display message
                   Call IO.O ' send direction display message
                   Outpt="[SW]southwest" ' make direction display message
                   Call IO.O ' send direction display message
                   Outpt="[NW]northwest" ' make direction display message
                   Call IO.O ' send direction display message
                   Outpt="[U]p" ' make direction display message
                   Call IO.O ' send direction display message
                   Outpt="[D]own" ' make direction display message
                   Call IO.O ' send direction display message
                   Outpt="[I]n" ' make direction display message
                   Call IO.O ' send direction display message
                   Outpt="[O]ut" ' make direction display message
                   Call IO.O ' send direction display message
                   Outpt="[G]o to portal" ' make direction display message
                   Call IO.O ' send direction display message
                   Outpt="[X]clear directions" ' make direction display message
                   Call IO.O ' send direction message
                   Graphics.Off=False ' reset color
                   ' input prompt
                   Outpt="Action entry direction option(q to quit)? "
                   No.Input.Out="Q" ' default prompt
                   Call IO.I ' get user input
                   If Ucase$(Inpt)="Q" Then ' compare input to quit option
                      Exit Do ' exit direction restriction edit loop
                   Endif ' end compare input option
                   If Ucase$(Inpt)="X" Then ' compare clear directions
                      ActionRecord.Restrictions=False ' clear directions
                   Else ' compare to direction
                      ' routine to get direction number
                      Call Find.Link(Inpt,Direction.Number,False)
                      If Direction.Number>False Then ' compare direction number
                         ' set the direction bit in the action record trigger flag
                         ActionRecord.Restrictions=ActionRecord.Restrictions Or _
                         2^Direction.Number
                      Endif ' end compare clear direction
                   Endif ' end compare direction number
                Loop ' loop through level entry trigger edit loop
             Case "E" ' option for health hits result
                Graphics.Off=True ' reset color
                Outpt="[F]atigue" ' make health message
                Call IO.O ' send health message
                Outpt="[V]itality" ' make health message
                Call IO.O ' send health message
                Graphics.Off=False ' reset color
                ' make input prompt
                Outpt="Action health rate option(q to quit)? "
                No.Input.Out="Q" ' default input
                Call IO.I ' get user input
                Select Case Ucase$(Inpt) ' selection of health option
                Case "F" ' option for action to hit for fatigue
                   ' make input prompt
                   Outpt="Number of hits of fatigue(1-32767)? "
                   No.Input.Out="10" ' default input
                   Call IO.I ' get user input
                   ' store health hit result
                   ActionRecord.HitPoints=Int(Val(Inpt))
                Case "V" ' option for action to hit for vitality
                   ' make input prompt
                   Outpt="Number of hits of vitality(1-32767)? "
                   No.Input.Out="10" ' default input
                   Call IO.I ' get user input
                   ' store health hit result
                   ActionRecord.HitPoints=-Int(Val(Inpt))
                End Select ' end selection health edit option
             Case "F" ' option to edit action rates
                Graphics.Off=True ' reset color
                Outpt="[E]ncounter" ' make rate display message
                Call IO.O ' send rate display message
                Outpt="[H]ealth" ' make rate display message
                Call IO.O ' send rate display message
                Graphics.Off=False ' reset color
                Outpt="Action rate option(q to quit)? " ' make input prompt
                No.Input.Out="Q" ' default input
                Call IO.I ' get user input
                Select Case Ucase$(Inpt) ' selection of rate option
                Case "E" ' option to change action monster encounter rate
                   Outpt="Encounter rate(1-32767)? " ' make input prompt
                   No.Input.Out="6" ' default input
                   Call IO.I ' get user input
                   ' store encounter rate
                   ActionRecord.EncounterRate=Int(Val(Inpt))
                Case "H" ' option to change action health update rate
                   Outpt="Health rate(1-32767)? " ' make input prompt
                   No.Input.Out="6" ' default input
                   Call IO.I ' get user input
                   ' store health update rate
                   ActionRecord.HealthRate=Int(Val(Inpt))
                End Select ' end selection of rate option
             Case "G" ' option to edit inventory result options
                Graphics.Off=True ' reset color
                Outpt="[W]eapons" ' make inventory display message
                Call IO.O ' send inventory display message
                Outpt="[S]hields" ' make inventory display message
                Call IO.O ' send inventory display messagec
                Outpt="[A]rmor" ' make inventory display message
                Call IO.O ' send inventory display message
                Outpt="[M]agic items" ' make inventory display message
                Call IO.O ' send inventory display message
                Graphics.Off=False ' reset color
                Outpt="Action inventory option(q to quit)? " ' make input prompt
                No.Input.Out="Q" ' default input
                Call IO.I ' get user input
                Select Case Ucase$(Inpt) ' selection of inventory option
                Case "W" ' option for inventory result
                   ActionRecord.Inventory=1 ' store inventory option number
                Case "S" ' option for inventory result
                   ActionRecord.Inventory=2 ' store inventory option number
                Case "A" ' option for inventory result
                   ActionRecord.Inventory=3 ' store inventory option number
                Case "M" ' option for inventory result
                   ActionRecord.Inventory=4 ' store inventory option number
                End Select ' end selection of inventory option
             Case "H" ' option for fumble result
                ActionRecord.Fumble=Not ActionRecord.Fumble ' set fumble flag
             Case "I" ' option for teleport result
                Outpt="Room number" ' make range prompt
                Max.Rooms!=Lof(RoomFile)/Len(RoomRecord) ' store room file record
                ' routine to get range of numbers
                Call Get.Room.Range2(0!,Max.Rooms!,Room.Number!)
                ' store room teleport result number
                ActionRecord.Teleport=Room.Number!
             Case "J" ' option to change rust rate
                ' input prompt
                Outpt="Rate for weapons to rust(# of action prompts)? "
                No.Input.Out="6" ' default input
                Call IO.I ' get user input
                RustRate=Int(Val(Inpt)) ' convert input to integer
                ActionRecord.RustRate=RustRate ' store rust rate
             Case "K" ' option to change steal rate
                Outpt="Rate for monsters to steal treasure(# of action prompts)? "
                No.Input.Out="6" ' default input
                Call IO.I ' get user input
                StealRate=Int(Val(Inpt)) ' convert input to integer
                ActionRecord.StealRate=StealRate ' store steal rate
             Case "L"
                Do ' loop through attribute editing
                   Graphics.Off=True ' reset color
                   Outpt="[A]ir" ' make option message
                   Call IO.O ' send message
                   Outpt="[L]and" ' make option message
                   Call IO.O ' send message
                   Outpt="[W]ater" ' make option message
                   Call IO.O ' send message
                   Outpt="[U]nlit" ' make option message
                   Call IO.O ' send message
                   Outpt="[X]Clear" ' make option message
                   Call IO.O ' send message
                   Graphics.Off=False ' reset color
                   ' make input prompt
                   Outpt="Action attribute option(q to quit)? "
                   No.Input.Out="Q" ' default input
                   Call IO.I ' get user input
                   Select Case Ucase$(Inpt) ' selection of attribute option
                   Case "A" ' option for room attribute
                      ActionRecord.Attribute2=Air ' set flag
                   Case "L" ' option for room attribute
                      ActionRecord.Attribute2=Land ' set flag
                   Case "W" ' option for room attribute
                      ActionRecord.Attribute2=Water ' set flag
                   Case "U" ' option for room attribute
                      ActionRecord.Attribute1=UnlitRoom ' reset flag
                   Case "X" ' option to clear room attributes
                      ActionRecord.Attribute1=False ' reset room attribute
                      ActionRecord.Attribute2=False ' reset room attribute
                   Case "Q" ' option to exit room attribute editing
                      Exit Do ' exit room attribute editing
                   End Select ' end selection of room attribute editing
                Loop ' end loop through room attribute editing menu options
             Case "X" ' option to clear triggers and results
                ActionRecord.SpellTrigger=False
                ActionRecord.MonsterTrigger=False
                ActionRecord.HealthRate=False
                ActionRecord.EncounterRate=False
                ActionRecord.HitPoints=False
                ActionRecord.Inventory=False
                ActionRecord.MonsterTalk=False
                ActionRecord.Fumble=False
                ActionRecord.Teleport=False
                ActionRecord.Level=False
                ActionRecord.Restrictions=False
                ActionRecord.RustRate=False
                ActionRecord.StealRate=False
                ActionRecord.Attribute1=False
                ActionRecord.Attribute2=False
                Outpt="Action cleared." ' make clear message
                Call IO.O ' send clear message
             Case "Q" ' option to exit room action edit menu
                Call Share.Record(ActionFile,Action.Number) ' write action file
                Outpt="Action"+Str$(Action.Number)+" changed."
                Call IO.O ' send display message
                Exit Do ' exit room action edit menu
             End Select ' end selection of action edit options
          Loop ' end loop through action edit menu
       Endif ' end check range
    Case "Q" ' selection to quit action editing
       Exit Do ' exit action editing
    End Select ' end action editing selection
 Loop ' end loop through room action menu
End Sub ' end routine to edit room actions

 Rem * routine to edit monsters file.
 Rem * output variables:
 Rem *   Rate.Changed  -  true if any monster rate edited

Sub Edit.Monster(Rate.Changed)
 On Local Error Resume Next ' local error resume
 Rate.Changed=False ' reset flag
 Do ' loop through monster editing menu
    Graphics.Off=False ' reset color
    Outpt="Monster edit:" ' make display message
    Call IO.O ' send message
    Graphics.Off=True ' reset color
    Outpt="[A]dd" ' make monster edit display message
    Call IO.O ' send monster edit display message
    Outpt="[C]hange" ' make monster edit display message
    Call IO.O ' send monster edit display message
    Outpt="[L]ist" ' make monster edit display message
    Call IO.O ' send monster edit display message
    Outpt="[M]onster class" ' make monster edit display message
    Call IO.O ' send monster edit display message
    Outpt="[T]alk responses" ' make monster edit display message
    Call IO.O ' send monster edit display message
    Graphics.Off=False ' reset color
    Outpt="Monster edit option(q to quit)? " ' make input prompt
    No.Input.Out="Q" ' default input
    Call IO.I ' get user input
    Select Case Ucase$(Inpt) ' selection of monster edit option
    Case "A" ' option to add an empty monster record
       ' store the last monster record number
       New.Monster=Lof(MonsterFile)/Len(MonsterRecord)+1
       MonsterRecord.MonsterName=Nul ' reset monster record variable
       MonsterRecord.PluralName=Nul ' reset monster record variable
       For Array.Index=1 To 5 ' loop through monster treasure inventory
          ' reset monster record variable
          MonsterRecord.Treasure(Array.Index)=False
       Next ' end loop through monster treasure inventory
       MonsterRecord.Experience=False ' reset monster record variable
       MonsterRecord.NumberAppearing=False ' reset monster record variable
       MonsterRecord.Level=False ' reset monster record variable
       MonsterRecord.Hits=False ' reset monster record variable
       MonsterRecord.Poison=False ' reset monster record variable
       MonsterRecord.LevelDrain=False ' reset monster record variable
       MonsterRecord.Spell=False ' reset monster record variable
       MonsterRecord.Block=False ' reset monster record variable
       MonsterRecord.Prevent=False ' reset monster record variable
       MonsterRecord.Follow=False ' reset monster record variable
       MonsterRecord.Magic=False ' reset monster record variable
       MonsterRecord.Jail=False ' reset monster record variable
       MonsterRecord.Teleport=False ' reset monster record variable
       MonsterRecord.FollowPercent=False ' reset monster record variable
       MonsterRecord.BlockPercent=False ' reset monster record variable
       MonsterRecord.PreventPercent=False ' reset monster record variable
       MonsterRecord.SpellPercent=False ' reset monster record variable
       MonsterRecord.PoisonPercent=False ' reset monster record variable
       MonsterRecord.DrainPercent=False ' reset monster record variable
       MonsterRecord.Rate=False ' reset monster record variable
       MonsterRecord.RatePercent=False ' reset monster record variable
       MonsterRecord.Permanent=False ' reset monster record variable
       MonsterRecord.Gold=False ' reset monster record variable
       For Array.Index=1 To 5 ' loop through monster talk responses
          ' reset monster record variable
          MonsterRecord.Talk(Array.Index)=False
       Next ' end loop through monster talk responses
       MonsterRecord.Psionic=False ' reset monster record variable
       MonsterRecord.PsionicSpell=False ' reset monster record variable
       Call Share.Record(MonsterFile,New.Monster) ' routine to write a monster record
    Case "C" ' option to change monster values
       Call Find.Monster(Mon.Number) ' get monster number to edit
       If Mon.Number>False Then ' compare monster number
          Do ' loop through monster change menu
             Call Display.Monster(Mon.Number) ' routine to display monster
             Graphics.Off=False ' reset color
             Outpt="Monster change option(q to quit)? " ' make input prompt
             No.Input.Out="Q" ' default input
             Call IO.I ' get user input
             Select Case Ucase$(Inpt) ' selection of monster change option
             Case "A" ' option to change monster name
                Outpt="Monster name(30 characters)? " ' input prompt
                Call IO.I ' get user input
                MonsterRecord.MonsterName=Lcase$(Inpt) ' store new name
             Case "B" ' option to change plural of monster name
                Outpt="Plural of name(30 characters)? " ' input prompt
                Call IO.I ' get user input
                ' store new monster plural
                MonsterRecord.PluralName=Lcase$(Inpt)
             Case "C" ' option to change monster level
                Outpt="Monster level(1-32767)? " ' input prompt
                No.Input.Out="1" ' default input
                Call IO.I ' get user input
                MonsterRecord.Level=Int(Val(Inpt)) ' store new monster level
             Case "D" ' option to change monster magical type
                Outpt="Magical monster(y/n)? " ' input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                MonsterRecord.Magic=Yes ' store monster type
             Case "E" ' option to change monster hit points
                Outpt="Hit points? " ' make input prompt
                No.Input.Out="1" ' default input
                Call IO.I ' get user input
                MonsterRecord.Hits=Cdbl(Int(Val(Inpt))) ' store monster hits
             Case "F" ' option to change monster experience
                Outpt="Experience points? " ' input prompt
                No.Input.Out="100" ' default input
                Call IO.I ' get user input
                MonsterRecord.Experience=Cdbl(Int(Val(Inpt))) ' store exp
             Case "G" ' option to change monster gold hoard
                Outpt="Gold points? " ' make input prompt
                No.Input.Out="100" ' default prompt
                Call IO.I ' get user input
                MonsterRecord.Gold=Cdbl(Int(Val(Inpt))) ' store monster gold
             Case "H" ' option to change number encountered
                Outpt="Number appearing(1-32767)? " ' input prompt
                No.Input.Out="1" ' default input
                Call IO.I ' get user input
                MonsterRecord.NumberAppearing=Int(Val(Inpt)) ' store number
             Case "I" ' option to change monster poison type
                Outpt="Poisonous monster(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default prompt
                Call IO.I ' get user input
                MonsterRecord.Poison=False ' clear monster poison
                MonsterRecord.PoisonPercent=False ' clear monster percent
                If Yes Then ' check yes repsonse
                   Outpt="Percent chance monster " ' make percent display
                   Outpt=Outpt+"will poison(1-100)? " ' input message
                   No.Input.Out="50" ' default input
                   Call IO.I ' get user input
                   Percent=Int(Val(Inpt)) ' convert input to integer
                   If Percent>=False And Percent<=100 Then ' check percent
                      MonsterRecord.Poison=True ' make monster poisonous
                      MonsterRecord.PoisonPercent=Percent ' store percent
                   Endif ' end check percent
                Endif ' end check response
             Case "J" ' option to change monster level drain type
                Outpt="Level draining monster(y/n)? " ' input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                MonsterRecord.LevelDrain=False ' clear monster level drain
                MonsterRecord.DrainPercent=False ' clear monster percent
                If Yes Then ' check yes response
                   Outpt="Percent chance monster " ' make percent display
                   Outpt=Outpt+"will level drain(1-100)? " ' input message
                   No.Input.Out="50" ' default input
                   Call IO.I ' get user input
                   Percent=Int(Val(Inpt)) ' convert input to integer
                   If Percent>=False And Percent<=100 Then ' check percent
                      ' make monster level drainer
                      MonsterRecord.LevelDrain=True
                      MonsterRecord.DrainPercent=Percent ' store percent
                   Endif ' end check percent
                Endif ' end check response
             Case "K" ' option to change monster blocks exits type
                Outpt="Monster blocks exits(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                MonsterRecord.Block=False ' clear monster block type
                MonsterRecord.BlockPercent=False ' clear monster percent
                If Yes Then ' check yes response
                   Outpt="Percent chance monster " ' make percent display
                   Outpt=Outpt+"will block exits(1-100)? " ' input prompt
                   No.Input.Out="50" ' default input
                   Call IO.I ' get user input
                   Percent=Int(Val(Inpt)) ' convert input to integer
                   If Percent>=False And Percent<=100 Then ' check percent
                      MonsterRecord.Block=True ' make monster blocker
                      MonsterRecord.BlockPercent=Percent ' store percent
                   Endif ' end check percent
                Endif ' end check response
             Case "L" ' option to change monster preventing type
                Outpt="Monster prevents player from taking treasure(y/n)? "
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                MonsterRecord.Prevent=False ' clear monster prevent type
                MonsterRecord.PreventPercent=False ' clear monster percent
                If Yes Then ' check yes response
                   Outpt="Percent chance monster " ' make input prompt
                   Outpt=Outpt+"prevents player from taking treasure(1-100)? "
                   No.Input.Out="50" ' default input
                   Call IO.I ' get user input
                   Percent=Int(Val(Inpt)) ' convert input to integer
                   If Percent>=False And Percent<=100 Then ' check percent
                      MonsterRecord.Prevent=True ' make monster preventer
                      MonsterRecord.PreventPercent=Percent ' store percent
                   Endif ' end check percent
                Endif ' end check response
             Case "M" ' option to change monster following type
                Outpt="Monster follows player(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default prompt
                Call IO.I ' get user input
                MonsterRecord.Follow=False ' clear monster follow type
                MonsterRecord.FollowPercent=False ' clear percent
                MonsterRecord.Teleport=False ' clear percent
                If Yes Then ' check yes response
                   MonsterRecord.Follow=True ' make monster follows
                   Outpt="Percent chance monster " ' make percent
                   Outpt=Outpt+"will follow player(1-100)? " ' input prompt
                   No.Input.Out="50" ' default input
                   Call IO.I ' get user input
                   Percent=Int(Val(Inpt)) ' convert input to integer
                   If Percent>=False And Percent<=100 Then ' check percent
                      MonsterRecord.FollowPercent=Percent ' store percent
                   Endif ' end check percent
                   Outpt="Percent chance monster " ' make percent
                   Outpt=Outpt+"will teleport with player(1-100)? " ' prompt
                   No.Input.Out="50" ' default prompt
                   Call IO.I ' get user input
                   Percent=Int(Val(Inpt)) ' convert input to integer
                   If Percent>=False And Percent<=100 Then ' check percent
                      MonsterRecord.Teleport=Percent ' store percent
                   Endif ' end check percent
                Endif ' end check response
             Case "N" ' option to change monster spell casting
                Outpt="Monster casts spells(y/n)? " ' input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                MonsterRecord.Spell=False ' clear monster spell flag
                MonsterRecord.SpellPercent=False ' clear monster spell number
                If Yes Then ' check yes response
                   Call Find.Spell(Spell.Number) ' routine to get spell number
                   If Spell.Number>False Then ' check spell number
                      Outpt="Percent chance monster " ' percent display
                      Outpt=Outpt+"casts spell(1-100)? " ' input prompt
                      No.Input.Out="50" ' default input
                      Call IO.I ' get user input
                      Percent=Int(Val(Inpt)) ' convert input to integer
                      If Percent>=False And Percent<=100 Then ' check percent
                         ' store monster spell number
                         MonsterRecord.Spell=Spell.Number
                         MonsterRecord.SpellPercent=Percent ' store percent
                      Endif ' end check percent
                   Endif ' end check spell number range
                Endif ' end check response
             Case "O" ' option to change monster jail type
                Outpt="Monster jails attacker(y/n)? " ' input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                MonsterRecord.Jail=Yes ' store yes response
                If Yes Then ' check response
                   MonsterRecord.Follow=False ' reset flag for teleport
                   Outpt="Jail room number?" ' prompt for room number
                   Call IO.I ' get input
                   MonsterRecord.Teleport=Int(Val(Inpt)) ' store room number
                Endif ' end check response
             Case "P" ' option to change monster rates
                Rate.Changed=True ' reset flag
                Outpt="Monster encounter rate(# of action prompts)? " ' prompt
                No.Input.Out="6" ' default input
                Call IO.I ' get user input
                MonsterRecord.Rate=Int(Val(Inpt)) ' store encounter rate
                Outpt="Monster encounter percent(1-100)? " ' input prompt
                No.Input.Out="50" ' default input
                Call IO.I ' get user input
                Percent=Int(Val(Inpt)) ' convert input to integer
                If Percent>=False And Percent<=100 Then ' check percent
                   MonsterRecord.RatePercent=Percent ' store percent
                Endif ' end check percent
             Case "R" ' option to change monster permanent type
                Outpt="Monster is a permanent monster(y/n)? " ' input prompt
                No.Input.Out="N" ' default input
                Call IO.I ' get user input
                MonsterRecord.Permanent=Yes ' store yes response
             Case "S" ' option to change monster psionic spell casting
                Outpt="Monster uses psionics(y/n)? " ' input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                MonsterRecord.Psionic=False ' clear monster psionics
                MonsterRecord.PsionicSpell=False ' clear monster psionics
                If Yes Then ' check yes response
                   Outpt="Enter psionic spell:" ' find spell prompt
                   Call Find.Spell(Spell.Number) ' routine to get spell number
                   If Spell.Number>False Then ' check spell number
                      If SpellRecord.Psionic=False Then ' check psionic type
                         Outpt="That spell is not a psionic spell!" ' message
                         Call IO.O ' send error message
                      Else ' check psionic spell type
                         MonsterRecord.Psionic=True ' make monster psionic
                         ' store psi spell
                         MonsterRecord.PsionicSpell=Spell.Number
                      Endif ' end check psionic spell
                   Endif ' end check spell number
                Endif ' end response
             Case "T" ' option changes monster treasure inventory
                Graphics.Off=True ' reset color
                For Array.Number=1 To 5 ' loop through monster treasure
                   ' get monster treasure number
                   Treasure.Number=MonsterRecord.Treasure(Array.Number)
                   ' check file bounds
                   If Treasure.Number>False And _
                   Treasure.Number<=Lof(TreasureFile)/Len(TreasureRecord) Then
                      ' get treasure record
                      Call Read.Record(TreasureFile,Treasure.Number)
                      Outpt="["+Mid$(Str$(Array.Number),2)+"]"+ _
                      TreasureRecord.TreasureName ' store treasure name
                      Call IO.O ' send output message
                   Endif ' end check file bounds
                Next ' end loop through monster treasure
                Graphics.Off=False ' reset color
                Outpt="Enter five treasure names:" ' make display message
                Call IO.O ' send display message
                Outpt="Press <enter> for none." ' make display message
                Call IO.O ' send display message
                Graphics.Off=True ' reset color
                For Array.Index=1 To 5 ' loop through monster inventory
                   ' routine to get treasure number
                   Call Find.Treasure(Treasure.Number)
                   ' store monster treasure
                   MonsterRecord.Treasure(Array.Index)=Treasure.Number
                Next ' end loop through monster inventory
             Case "Q" ' option to exit monster change menu
                Exit Do ' exit monster change menu
             End Select ' end selection of monster change option
          Loop ' end loop through monster change menu
          Call Share.Record(MonsterFile,Mon.Number) ' write monster record
          Outpt="Monster '"+Rtrim$(MonsterRecord.MonsterName)+"' changed."
          Call IO.O ' send monster changed message
       Endif ' end compare monster number
    Case "L" ' option to list range of monsters
       Max.Monsters=Lof(MonsterFile)/Len(MonsterRecord) ' store number records
       ' routine to get range of numbers
       Call Get.Range(Max.Monsters,Monster.List1,Monster.List2)
       ' loop through range of numbers
       Allow.Break=False ' set allow break flag
       Break=False ' reset control-k flag
       Continue=False ' set continuous flag
       For Monster.Count=Monster.List1 To Monster.List2
          Call Read.Record(MonsterFile,Monster.Count) ' read monster record
          Call Display.Monster(Monster.Count) ' routine to display monster
          If Break Then ' check control-k flag
             Exit For ' exit display loop
          Endif ' end check control-k
          If Continue=False Then ' check continuous flag
             Call More.Prompt ' routine to pause
             If No Then ' check pause response
                Exit For ' exit list loop
             Endif ' end check response
          Endif ' end check continuous flag
       Next ' end loop through range
       Allow.Break=False ' reset allow break flag
       If Break Then ' check control-k flag
          Break=False ' reset control-k flag
          Outpt=Nul ' set output to null
          Call IO.O ' send empty return
       Endif ' end check control-k flag
    Case "M" ' option to edit monster class
       Do ' loop through monster class edit menu
          Graphics.Off=True ' reset color
          Outpt="[A]dd class" ' make monster class display message
          Call IO.O ' send monster class display message
          Outpt="[C]hange class" ' make monster class display message
          Call IO.O ' send monster class display message
          Outpt="[L]ist class" ' make monster class display message
          Call IO.O ' send monster class display message
          Graphics.Off=False ' reset color
          Outpt="Monster class edit option(q to quit)? " ' make input prompt
          No.Input.Out="Q" ' default input
          Call IO.I ' get user input
          Select Case Ucase$(Inpt) ' selection of monster class edit option
          Case "A" ' option to add empty monster class
             New.Monster=Lof(MonClassFile)/Len(MonclassRecord)+1 ' last record
             For Array.Index=1 To 10 ' loop through monster class record
                ' clear monster class
                MonclassRecord.Monsters(Array.Index)=False
             Next ' end loop through record
             Call Share.Record(MonClassFile,New.Monster) ' write new monster class record
             Rate.Changed=True ' reset flag
          Case "C" ' option to change a monster class
             Outpt="Monster class" ' make range prompt
             ' get number of records in file
             Max.Monclasses=Lof(MonClassFile)/Len(MonclassRecord)
             ' routine to get range of numbers
             Call Get.Range2(0,Max.Monclasses,Monclass.Number)
             If Monclass.Number>False Then ' check number range
                Outpt="Enter ten monster names:" ' make display message
                Call IO.O ' send display message
                Outpt="Press <enter> for none." ' make display message
                Call IO.O ' send display message
                Graphics.Off=True ' reset color
                For Monster.Count=1 To 10 ' loop through monster class array
                   ' routine to get monster number
                   Call Find.Monster(Monster.Number)
                   ' store monster number
                   MonclassRecord.Monsters(Monster.Count)=Monster.Number
                Next ' end loop through monster class array
                Call Share.Record(MonClassFile,Monclass.Number) ' write monster class record
                ' make message
                Outpt="Monclass number"+Str$(Monclass.Number)+" changed."
                Call IO.O ' send display message
                Rate.Changed=True ' reset flag
             Endif ' end check number range
          Case "L" ' option to list range of monster classes
             Max.Monclasses=Lof(MonClassFile)/Len(MonclassRecord) ' get records
             ' routine to get range of numbers
             Call Get.Range(Max.Monclasses,Monclass.List1,Monclass.List2)
             ' loop through range of monster classes
             Allow.Break=True ' set allow break flag
             Break=False ' reset control-k flag
             Continue=False ' set continuous flag
             For Monclass.Number=Monclass.List1 To Monclass.List2
                ' get monster class record
                Call Read.Record(MonClassFile,Monclass.Number)
                ' routine to display monclass
                Call Display.Monster.Class(Monclass.Number)
                If Break Then ' check control-k flag
                   Exit For ' exit display loop
                Endif ' end check control-k
                If Continue=False Then ' check continuous flag
                   Call More.Prompt ' routine to pause
                   If No Then ' check pause response
                      Exit For ' exit monster class list loop
                   Endif ' end check response
                Endif ' end check continuous flag
             Next ' end loop through range
             Allow.Break=False ' reset allow break flag
             If Break Then ' check control-k flag
                Break=False ' reset control-k flag
                Outpt=Nul ' set output to null
                Call IO.O ' send empty return
             Endif ' end check control-k flag
          Case "Q" ' option to exit monster class edit menu
             Exit Do ' exit monster class edit menu
          End Select ' end selection of monster class option
       Loop ' end loop through monster class menu
    Case "T" ' option to edit monster talk responses
       Do ' loop through monster talk response edit menu
          Graphics.Off=True ' reset color
          Outpt="[A]dd response" ' make monster talk response display message
          Call IO.O ' send monster talk response display message
          Outpt="[C]hange response" ' make monster talk response message
          Call IO.O ' send monster talk response display message
          Outpt="[L]ist response" ' make monster talk response display message
          Call IO.O ' send monster talk response display message
          Outpt="[M]onster response" ' make monster talk response message
          Call IO.O ' send monster talk response display message
          Graphics.Off=False ' reset color
          Outpt="Monster talk edit option(q to quit)? " ' make input prompt
          No.Input.Out="Q" ' default input
          Call IO.I ' get user input
          Select Case Ucase$(Inpt) ' selection of monster talk response option
          Case "A" ' option to add talk response string
             Outpt="Enter response(80 characters):" ' make display message
             Call IO.O ' send display message
             Outpt="Press <enter> for none." ' make display message
             Call IO.O ' send display message
             Outpt="? " ' make input prompt
             Call IO.I ' get user input
             ' get last response record
             New.Talk=Lof(MonTalkFile)/Len(MonsterTalkRecord)+1
             MonsterTalkRecord.TalkMessage=Inpt ' store talk response
             Call Share.Record(MonTalkFile,New.Talk) ' write talk response record
          Case "C" ' option to change a talk response
             Outpt="Response number to change" ' make range prompt
             ' get number of records in file
             Max.Responses=Lof(MonTalkFile)/Len(MonsterTalkRecord)
             ' routine to get range of numbers
             Call Get.Range2(0,Max.Responses,Response.Number)
             If Response.Number>False Then ' check number range
                ' display message
                Outpt="Enter response number"+Str$(Response.Number)+":"
                Call IO.O ' send message
                Outpt="? " ' make input prompt
                Call IO.I ' get user input
                MonsterTalkRecord.TalkMessage=Inpt ' store talk response string
                Call Share.Record(MonTalkFile,Response.Number) ' write talk response record
                ' display message
                Outpt="Response number"+Str$(Response.Number)+" changed."
                Call IO.O ' send message
             Endif ' end check number range
          Case "L" ' option to list monster talk responses
             Allow.Break=True ' set allow break flag
             Break=False ' reset control-k flag
             Continue=False ' reset continuous flag
             Page.Length=False ' clear paginate counter
             ' loop through file
             For Montalk.Number=1 To Lof(MonTalkFile)/Len(MonsterTalkRecord)
                ' read monster talk record
                Call Read.Record(MonTalkFile,Montalk.Number)
                Graphics.Off=False ' reset color
                ' make message
                Outpt="Response number"+Str$(Montalk.Number)+":"
                Call IO.O ' send message
                Graphics.Off=True ' reset color
                Outpt=Rtrim$(MonsterTalkRecord.TalkMessage) ' store response
                If Outpt=Nul Then ' compare length of talk response
                   Outpt="<none>" ' reset to none
                Endif ' end check length
                Call IO.O ' send response string
                If Break Then ' check control-k flag
                   Exit For ' exit display loop
                Endif ' end check control-k
                Page.Length=Page.Length+2 ' increment page counter
                If Page.Length>=User.Pagelength Then ' check page counter
                   Page.Length=False ' reset counter
                   If Continue=False Then ' check continuous flag
                      Call More.Prompt ' routine to pause
                      If No Then ' check pause response
                         Exit For ' exit file loop
                      Endif ' end check yes
                   Endif ' end check continuous flag
                Endif ' end check page
             Next ' end loop through file
             Allow.Break=False ' reset allow break flag
             If Break Then ' check control-k flag
                Break=False ' reset control-k flag
                Outpt=Nul ' set output to null
                Call IO.O ' send empty return
             Endif ' end check control-k flag
             If Page.Length Then ' recheck page counter
                Call More.Prompt ' routine to pause
             Endif ' end recheck counter
          Case "M" ' option to add talk response numbers to a monster
             Call Find.Monster(Monster.Number) ' get monster number to change
             If Monster.Number>False Then ' check monster number
                Call Read.Record(MonsterFile,Monster.Number) ' get monster
                Outpt="Enter five response numbers:" ' make display message
                Call IO.O ' send display message
                Outpt="Press <enter> for none." ' make display message
                Call IO.O ' send display message
                For Talk.Count=1 To 5 ' loop through five responses
                   Outpt="Enter response number" ' make range prompt
                   Max.Talk=Lof(MonTalkFile)/Len(MonsterTalkRecord)
                   ' routine to get range of numbers
                   Call Get.Range2(0,Max.Talk,Talk.Number)
                   ' add talk response number
                   MonsterRecord.Talk(Talk.Count)=Talk.Number
                   ' message
                   Outpt="Response number"+Str$(Talk.Count)+" added."
                   Call IO.O ' send display message
                Next ' end loop through five responses
                Call Share.Record(MonsterFile,Monster.Number) ' write monster record
             Endif ' end check monster number
          Case "Q" ' option to exit monster talk response edit menu
             Exit Do ' exit monster talk response edit menu
          End Select ' end selection of monster talk response option
       Loop ' end loop through monster talk response edit menu
    Case "Q" ' option to exit monster edit menu
       Exit Do ' exit monster edit menu
    End Select ' end selection of monster edit options
 Loop ' end loop through monster edit menu
End Sub ' end routine to edit monsters

 Rem * routine to edit nonplayers file.

Sub Edit.Nonplayer
 On Local Error Resume Next ' local error resume
 Do ' loop through nonplayer edit menu
    Graphics.Off=False ' reset color
    Outpt="Nonplayer edit:" ' make display message
    Call IO.O ' send message
    Graphics.Off=True ' reset color
    Outpt="[A]dd" ' make display message
    Call IO.O ' send message
    Outpt="[C]hange" ' make display message
    Call IO.O ' send message
    Outpt="[L]ist" ' make display message
    Call IO.O ' send message
    Graphics.Off=False ' reset color
    Outpt="Nonplayer edit option(q to quit)? " ' option input prompt
    No.Input.Out="Q" ' default input
    Call IO.I ' get user input
    Select Case Ucase$(Inpt) ' selection of option input
    Case "A" ' add nonplayer option
       ' store last nonplayer record number
       New.Nonplayer=Lof(NonPlayerFile)/Len(MonsterRecord)+1
       MonsterRecord.MonsterName=Nul ' set nonplayer record items to zero
       MonsterRecord.PluralName=Nul ' reset nonplayer record item
       For Array.Number=1 To 5 ' loop through nonplayer treasure
          ' set treasure items to zero
          MonsterRecord.Treasure(Array.Number)=False
       Next ' end loop through nonplayer treasure
       MonsterRecord.Experience=False ' set nonplayer record items to zero
       MonsterRecord.NumberAppearing=1 ' reset nonplayer record items
       MonsterRecord.Level=False ' reset nonplayer record items
       MonsterRecord.Hits=False ' reset nonplayer record items
       MonsterRecord.Gold=False ' reset nonplayer record item
       MonsterRecord.Poison=False ' reset nonplayer record items
       MonsterRecord.LevelDrain=False ' reset nonplayer record items
       MonsterRecord.Spell=False ' reset nonplayer record items
       MonsterRecord.Block=False ' reset nonplayer record items
       MonsterRecord.Prevent=False ' reset nonplayer record items
       MonsterRecord.Follow=False ' reset nonplayer record items
       MonsterRecord.Magic=True ' reset nonplayer record items
       MonsterRecord.Jail=False ' reset nonplayer record items
       MonsterRecord.Teleport=False ' reset nonplayer items
       MonsterRecord.FollowPercent=False ' reset nonplayer items
       MonsterRecord.BlockPercent=False ' reset nonplayer record items
       MonsterRecord.PreventPercent=False ' reset nonplayer record items
       MonsterRecord.SpellPercent=False ' reset nonplayer record items
       MonsterRecord.PoisonPercent=False ' reset nonplayer record items
       MonsterRecord.DrainPercent=False ' reset nonplayer record items
       MonsterRecord.Rate=False ' reset nonplayer record items
       MonsterRecord.RatePercent=False ' reset nonplayer record items
       MonsterRecord.Permanent=-2 ' reset nonplayer record items
       For Array.Number=1 To 5 ' loop through monster talk responses
          MonsterRecord.Talk(Array.Number)=False ' reset nonplayer responses
       Next ' end loop through monster talk responses
       MonsterRecord.Psionic=False ' reset nonplayer record items
       MonsterRecord.PsionicSpell=False ' reset nonplayer record items
       ' routine to write next nonplayer record
       Call Share.Record(NonPlayerFile,New.Nonplayer)
    Case "C" ' option to change nonplayer file record
       ' routine to find nonplayer to edit
       Call Find.Nonplayer(Nonplayer.Number)
       If Nonplayer.Number>False Then ' check nonplayer number
          Do ' loop through nonplayer number edit option menu
             ' routine to display nonplayer
             Call Display.Nonplayer(Nonplayer.Number)
             Graphics.Off=False ' reset color
             Outpt="Nonplayer change option(q to quit)? " ' input prompt
             No.Input.Out="Q" ' default prompt
             Call IO.I ' get user input
             Select Case Ucase$(Inpt) ' selection of nonplayer change option
             Case "A" ' option to change nonplayer name
                Outpt="Nonplayer name(30 characters)? " ' make input prompt
                Call IO.I ' get user input
                MonsterRecord.MonsterName=Lcase$(Inpt) ' store name
             Case "B" ' option to change nonplayer rooms
                Outpt="Rooms(separated by commas)? " ' make input prompt
                Call IO.I ' get user input
                MonsterRecord.PluralName=Inpt ' store rooms
             Case "C" ' option to change nonplayer level
                Outpt="Nonplayer level(1-32767)? " ' make input prompt
                No.Input.Out="1" ' default input
                Call IO.I ' get user input
                MonsterRecord.Level=Int(Val(Inpt)) ' store nonplayer level
             Case "D" ' option to change nonplayer hit points
                Outpt="Hit points? " ' make input prompt
                No.Input.Out="1" ' default input
                Call IO.I ' get user input
                MonsterRecord.Hits=Cdbl(Int(Val(Inpt))) ' store nonplayer hits
             Case "E" ' option to change nonplayer experience points
                Outpt="Experience points? " ' make input prompt
                No.Input.Out="1" ' default input
                Call IO.I ' get user input
                MonsterRecord.Experience=Cdbl(Int(Val(Inpt))) ' store exp
             Case "F" ' option to change nonplayer gold points
                Outpt="Gold points? " ' make input prompt
                No.Input.Out="1" ' default input
                Call IO.I ' get user input
                MonsterRecord.Gold=Cdbl(Int(Val(Inpt))) ' store experience
             Case "G" ' option to change poisonous nonplayer
                Outpt="Poisonous nonplayer(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                MonsterRecord.Poison=False ' reset poisonous nonplayer
                MonsterRecord.PoisonPercent=False ' reset posionous percent
                If Yes Then ' check user input response
                   MonsterRecord.Poison=True ' set poisonous nonplayer
                   Outpt="Percent chance nonplayer " ' make input prompt
                   Outpt=Outpt+"will poison(1-100)? " ' input prompt
                   No.Input.Out="50" ' default input
                   Call IO.I ' get user input
                   MonsterRecord.PoisonPercent=Int(Val(Inpt)) ' store percent
                Endif ' end check user input
             Case "H" ' option to change level draining nonplayer
                Outpt="Level draining nonplayer(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                MonsterRecord.LevelDrain=False ' reset level drain nonplayer
                MonsterRecord.DrainPercent=False ' reset level drain nonplayer
                If Yes Then ' check user input response
                   ' set level draining nonplayer
                   MonsterRecord.LevelDrain=True
                   Outpt="Percent chance nonplayer " ' make input prompt
                   Outpt=Outpt+"will level drain(1-100)? " ' input prompt
                   No.Input.Out="50" ' default input
                   Call IO.I ' get user input
                   MonsterRecord.DrainPercent=Int(Val(Inpt)) ' store percent
                Endif ' end check user input
             Case "I" ' option to change exit blocking nonplayer
                Outpt="Nonplayer blocks exits(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                MonsterRecord.Block=False ' reset blocking nonplayer
                MonsterRecord.BlockPercent=False ' reset blocking nonplayer
                If Yes Then ' check user input response
                   MonsterRecord.Block=True ' set blocking nonplayer
                   Outpt="Percent chance nonplayer " ' make input prompt
                   Outpt=Outpt+"will block exits(1-100)? " ' input prompt
                   No.Input.Out="50" ' default input
                   Call IO.I ' get user input
                   MonsterRecord.BlockPercent=Int(Val(Inpt)) ' store percent
                Endif ' end check user input
             Case "J" ' option to change preventing nonplayer
                ' input prompt
                Outpt="Nonplayer prevents taking treasure(y/n)? "
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                MonsterRecord.Prevent=False ' reset preventing nonplayer
                ' reset preventing nonplayer
                MonsterRecord.PreventPercent=False
                If Yes Then ' check user input response
                   MonsterRecord.Prevent=True ' set preventing nonplayer
                   Outpt="Percent chance nonplayer " ' make input prompt
                   Outpt=Outpt+"prevents player from taking treasure(1-100)? "
                   No.Input.Out="50" ' default input
                   Call IO.I ' get user input
                   MonsterRecord.PreventPercent=Int(Val(Inpt)) ' store percent
                Endif ' end check user input
             Case "K" ' option to change following nonplayer
                Outpt="Nonplayer follows player(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                MonsterRecord.Follow=False ' reset following nonplayer
                MonsterRecord.FollowPercent=False ' reset following nonplayer
                MonsterRecord.Teleport=False ' reset following nonplayer
                If Yes Then ' check user input response
                   MonsterRecord.Follow=True ' set following nonplayer
                   Outpt="Percent chance nonplayer " ' make input prompt
                   Outpt=Outpt+"will follow player(1-100)? " ' input prompt
                   No.Input.Out="50" ' default input
                   Call IO.I ' get user input
                   MonsterRecord.FollowPercent=Int(Val(Inpt)) ' store percent
                   Outpt="Percent chance nonplayer " ' make input prompt
                   Outpt=Outpt+"will teleport with player(1-100)? " ' prompt
                   No.Input.Out="50" ' default input
                   Call IO.I ' get user input
                   MonsterRecord.Teleport=Int(Val(Inpt)) ' store percent
                Endif ' end check user input
             Case "L" ' option to change spell casting nonplayer
                Outpt="Nonplayer casts spells(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                MonsterRecord.Spell=False ' reset spell casting nonplayer
                MonsterRecord.SpellPercent=False ' reset casting nonplayer
                If Yes Then ' check user input prompt
                   ' routine to find spell number
                   Call Find.Spell(Spell.Number)
                   If Spell.Number>False Then ' check spell number range
                      MonsterRecord.Spell=Spell.Number ' store spell number
                      Outpt="Percent chance nonplayer " ' make input prompt
                      Outpt=Outpt+"casts spell(1-100)? " ' input prompt
                      No.Input.Out="50" ' default input
                      Call IO.I ' get user input
                      ' store percent
                      MonsterRecord.SpellPercent=Int(Val(Inpt))
                   Endif ' end check spell number
                Endif ' end check user input
             Case "M" ' option to change jailing nonplayer
                Outpt="Nonplayer jails attacker(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                MonsterRecord.Jail=Yes ' set jailing nonplayer
                If Yes Then ' check response
                   MonsterRecord.Follow=False ' reset flag for teleport
                   Outpt="Jail room number?" ' prompt for room number
                   Call IO.I ' get input
                   MonsterRecord.Teleport=Int(Val(Inpt)) ' store room number
                Endif ' end check response
             Case "N" ' option to change nonplayer encounter rate
                ' prompt
                Outpt="Nonplayer encounter rate(# of action prompts)? "
                No.Input.Out="6" ' default input
                Call IO.I ' get user input
                MonsterRecord.Rate=Int(Val(Inpt)) ' store encounter rate
                ' make input prompt
                Outpt="Nonplayer encounter percent(1-100)? "
                No.Input.Out="50" ' default input
                Call IO.I ' get user input
                MonsterRecord.RatePercent=Int(Val(Inpt)) ' store percent
             Case "O" ' option to change nonplayer psionics spell
                Outpt="Nonplayer uses psionics(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                MonsterRecord.Psionic=False ' reset nonplayer psionics spell
                MonsterRecord.PsionicSpell=False ' reset nonplayer psionics
                If Yes Then ' check user input
                   Outpt="Psionic spell?" ' make input prompt
                   ' routine to find spell number
                   Call Find.Spell(Spell.Number)
                   If Spell.Number>False Then ' check spell number range
                      If SpellRecord.Psionic=False Then ' check psi spell
                         Outpt="That spell is not a psionic spell!" ' message
                         Call IO.O ' send error message
                         ' reset nonplayer psionics
                         MonsterRecord.Psionic=False
                         MonsterRecord.PsionicSpell=False ' reset psionics
                      Else ' check psionic spell type
                         MonsterRecord.Psionic=True ' set nonplayer psionics
                         ' store psi number
                         MonsterRecord.PsionicSpell=Spell.Number
                      Endif ' end check psionic spell type
                   Endif ' end check spell number
                Endif ' end check user input
             Case "P" ' option to change nonplayer treasure
                Outpt="Enter five treasure names:" ' make display message
                Call IO.O ' send message
                Outpt="Press <enter> for none." ' make display message
                Call IO.O ' send message
                Graphics.Off=True ' reset color
                For Treasure.Count=1 To 5 ' loop through nonplayer treasures
                   ' routine to get treasure number
                   Call Find.Treasure(Treasure.Number)
                   ' store nonplayer treasure
                   MonsterRecord.Treasure(Treasure.Count)=Treasure.Number
                Next ' end loop through nonplayer treasures
             Case "Q" ' option to exit nonplayer change menu
                Exit Do ' exit nonplayer change menu
             End Select ' end selections of nonplayer change options
          Loop ' end loop through nonplayer change option menu
          Call Share.Record(NonPlayerFile,Nonplayer.Number) ' write nonplayer file
          Outpt="Nonplayer '"+Rtrim$(MonsterRecord.MonsterName)+"' changed."
          Call IO.O ' send display message
       Endif ' end check nonplayer edit number
    Case "L" ' option to list range of nonplayers
       ' store length of nonplayer file
       Max.Nonplayers=Lof(NonPlayerFile)/Len(MonsterRecord)
       ' routine to get range of numbers
       Call Get.Range(Max.Nonplayers,Nonplayer.List1,Nonplayer.List2)
       ' loop through range of nonplayers
       Allow.Break=True ' set allow break flag
       Break=False ' reset control-k flag
       Continue=False ' set continuous flag
       For Nonplayers.Count=Nonplayer.List1 To Nonplayer.List2
          Call Read.Record(NonPlayerFile,Nonplayers.Count) ' read nonplayer
          ' routine to display nonplayer
          Call Display.Nonplayer(Nonplayers.Count)
          If Break Then ' check control-k flag
             Exit For ' exit display loop
          Endif ' end check control-k
          Graphics.Off=False ' reset color
          If Continue=False Then ' check continuous flag
             Call More.Prompt ' routine to pause
             If No Then ' check pause response
                Exit For ' exit nonplayer list
             Endif ' end check response
          Endif ' end check continuous flag
       Next ' end loop through range of nonplayers
       Allow.Break=False ' reset allow break flag
       If Break Then ' check control-k flag
          Break=False ' reset control-k flag
          Outpt=Nul ' set output to null
          Call IO.O ' send empty return
       Endif ' end check control-k flag
    Case "Q" ' option to exit nonplayer edit options menu
       Exit Do ' exit nonplayer edit options menu
    End Select ' end selection of nonplayers edit menu
 Loop ' end loop through nonplater edit menu
End Sub ' end routine to edit nonplayers

 Rem * routine to edit objects file.

Sub Edit.Object
 On Local Error Resume Next ' local error resume
 Do ' loop through objects edit menu
    Graphics.Off=False ' reset color
    Outpt="Object edit:" ' make display message
    Call IO.O ' send message
    Graphics.Off=True ' reset color
    Outpt="[A]dd" ' make display message
    Call IO.O ' send message
    Outpt="[C]hange" ' make display message
    Call IO.O ' send message
    Outpt="[L]ist" ' make display message
    Call IO.O ' send message
    Graphics.Off=False ' reset color
    Outpt="Object edit option(q to quit)? " ' make input prompt
    No.Input.Out="Q" ' default input
    Call IO.I ' get user input
    Select Case Ucase$(Inpt) ' selection of object edit option
    Case "A" ' option to add an object record
       New.Object=Lof(ObjectFile)/Len(ObjectRecord)+1 'store last object record
       ObjectRecord.ObjectName=Nul ' reset object record item
       ObjectRecord.ShortName=Nul ' reset object record item
       ObjectRecord.LongDesc=Nul ' reset object record item
       ObjectRecord.ShortDesc=Nul ' reset object record item
       ObjectRecord.RoomLink=False ' reset object record item
       ObjectRecord.Invisible=False ' reset object record item
       ObjectRecord.JailTrap=False ' reset object record item
       ObjectRecord.DoorLock=False ' reset object record item
       ObjectRecord.Relocks=False ' reset object record item
       ObjectRecord.Hidden=False ' reset object record item
       ObjectRecord.Closed=False ' reset object record item
       ObjectRecord.Keyed=False ' reset object record item
       ObjectRecord.Trap=False ' reset object record item
       ObjectRecord.Teleport=False ' reset object record item
       ObjectRecord.LightRoom=False ' reset object record item
       ObjectRecord.LightTime=False ' reset object record item
       ObjectRecord.FromHour=False ' reset object record item
       ObjectRecord.FromMin=False ' reset object record item
       ObjectRecord.ToHour=False ' reset object record item
       ObjectRecord.ToMin=False ' reset object record item
       ObjectRecord.Permanent=True ' reset object record item
       Call Share.Record(ObjectFile,New.Object) ' routine to write object record
    Case "C" ' option to change an object
       Call Find.Objects(Object.Number) ' routine to get object number
       If Object.Number>False Then ' check object number range
          Do ' loop through object change menu
             Call Display.Object(Object.Number) ' routine to display object
             Graphics.Off=False ' reset color
             Outpt="Object change option(q to quit)? " ' make input prompt
             No.Input.Out="Q" ' default input
             Call IO.I ' get user input
             Select Case Ucase$(Inpt) ' selection of object change option
             Case "A" ' option to change object name
                Outpt="Object name(30 characters)? " ' make input prompt
                Call IO.I ' get user input
                ObjectRecord.ObjectName=Lcase$(Inpt) ' store object name
             Case "B" ' option to change object mnemonic name
                Outpt="Object identifier(30 characters)? " ' make input prompt
                Call IO.I ' get user input
                ObjectRecord.ShortName=Ucase$(Inpt) ' store object mnemonic
             Case "C" ' option to change object room number link
                Outpt="Room number link? " ' make input prompt
                Call IO.I ' get user input
                ObjectRecord.RoomLink=Int(Val(Inpt)) ' store object room link
             Case "D" ' option to change object trap
                Outpt="Trapped portal(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                ObjectRecord.Teleport=False ' reset object trap
                ObjectRecord.Trap=False ' reset object trap
                If Yes Then ' check user input response
                   Graphics.Off=True ' reset color
                   Outpt="[P]oison needles" ' make display message
                   Call IO.O ' send message
                   Outpt="[T]eleport to room number" ' make display message
                   Call IO.O ' send message
                   Outpt="[H]its for fatigue or vitality" ' make message
                   Call IO.O ' send message
                   Graphics.Off=False ' reset color
                   Outpt="Object trap option? " ' make input prompt
                   No.Input.Out="Q" ' default input
                   Call IO.I ' get user input
                   Select Case Ucase$(Inpt) ' selection of object trap type
                   Case "P" ' poison object trap type
                      ObjectRecord.Trap=1 ' set object poison trap type
                   Case "T" ' teleport object trap type
                      ObjectRecord.Trap=2 ' set object teleport trap type
                      Outpt="Room number? " ' make input prompt
                      No.Input.Out="1" ' default input
                      Call IO.I ' get user input
                      ' store telepot room
                      ObjectRecord.Teleport=Int(Val(Inpt))
                   Case "H" ' objects hits trap type
                      Hits.Sign=False ' reset hits sign multiplier
                      Graphics.Off=True ' reset color
                      Outpt="[F]atigue" ' make display message
                      Call IO.O ' send message
                      Outpt="[V]itality" ' make display message
                      Call IO.O ' send message
                      Outpt="[N]one" ' make display message
                      Call IO.O ' send message
                      Graphics.Off=False ' reset color
                      Outpt="Object trap hits option? " ' make input prompt
                      No.Input.Out="Q" ' default input
                      Call IO.I ' get user input
                      Select Case Ucase$(Inpt) ' selection of hits option
                      Case "F" ' fatigue option
                         Hits.Sign=1 ' set hits sign multiplier
                      Case "V" ' vitality option
                         Hits.Sign=True ' set hits sign multiplier
                      Case "N" ' option for none
                         Hits.Sign=False ' reset sign multiplier
                      End Select ' end hits option selection
                      Hits.Amount=False ' reset hits number
                      If Hits.Sign Then ' check hits type
                         ObjectRecord.Trap=3 ' set object trap type
                         Outpt="Number of hits(1-32767)? " ' make input prompt
                         No.Input.Out="10" ' default input
                         Call IO.I ' get user input
                         Hits.Amount=Int(Val(Inpt)) ' store number of hits
                      Endif ' end check hits type
                      ' calculate hits
                      ObjectRecord.Teleport=Hits.Sign*Hits.Amount
                   End Select ' end selection of object trap option
                Endif ' end check user input
             Case "E" ' option to change object description
                ' make display message
                Outpt="Long description(80 characters):"
                Call IO.O ' send message
                Outpt="? " ' make input prompt
                Call IO.I ' get user input
                ObjectRecord.LongDesc=Inpt ' store object description
             Case "F" ' option to change object entry description
                Outpt="Entry description(80 characters):" ' make message
                Call IO.O ' send message
                Outpt="? " ' make input prompt
                Call IO.I ' get user input
                ObjectRecord.ShortDesc=Inpt ' store object entry description
             Case "G" ' option to change hidden object
                Outpt="Hidden object(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                ObjectRecord.Hidden=Yes ' store hidden object type
             Case "H" ' option to change invisible object
                Outpt="Invisible object(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                ObjectRecord.Invisible=Yes ' store invisible object type
             Case "I" ' option to change object jail type
                Outpt="Jail attacker trap(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                ObjectRecord.JailTrap=Yes ' store object jail type
             Case "J" ' option to change object locked type
                Outpt="Locked portal(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                ObjectRecord.DoorLock=False ' reset object lock type
                ObjectRecord.Closed=False ' reset object lock type
                If Yes Then ' check user input response
                   ObjectRecord.DoorLock=2 ' set object lock
                   ObjectRecord.Closed=True ' set object lock
                Endif ' end check user input
             Case "K" ' option to change object portal type
                Outpt="Relocking portal(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                ObjectRecord.Relocks=Yes ' set object portal type
             Case "L" ' option to change object key number
                Outpt="Key number(1-32767)? " ' make input prompt
                No.Input.Out="1" ' default input
                Call IO.I ' get user input
                ObjectRecord.Keyed=Int(Val(Inpt)) ' set object key number
             Case "M" ' option to change permanent object
                Outpt="Permanent Object(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                ObjectRecord.Permanent=Yes ' set permanent object
             Case "N" ' option to change object light type
                Outpt="Object is a light(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                ObjectRecord.LightRoom=False ' reset object light type
                ObjectRecord.LightTime=False ' reset object light type
                If Yes Then ' check user input response
                   ObjectRecord.LightRoom=True ' set object light type
                   Outpt="Object lights at a time(y/n)? " ' make input prompt
                   No.Input.Out="Y" ' default input
                   Call IO.I ' get user input
                   If Yes Then ' check user input response
                      ObjectRecord.LightTime=True ' set object light time type
                      Outpt="From hour(HH)? " ' make input prompt
                      Call IO.I ' get user input
                      ' store object hour light time
                      Time.Amount=Int(Val(Inpt))
                      ' check hour time range
                      If Time.Amount>=0 And Time.Amount<=23 Then
                         ' store hour light time
                         ObjectRecord.FromHour=Time.Amount
                      Endif ' end check hour time range
                      Outpt="From minute(MM)? " ' make input prompt
                      Call IO.I ' get user input
                      ' store object minute light time
                      Time.Amount=Int(Val(Inpt))
                      ' check minute time range
                      If Time.Amount>=0 And Time.Amount<=59 Then
                         ' store minute light time
                         ObjectRecord.FromMin=Time.Amount
                      Endif ' end check minute time range
                      Outpt="To hour(HH)? " ' make input prompt
                      Call IO.I ' get user input
                      ' store object hour light time
                      Time.Amount=Int(Val(Inpt))
                      ' check hour time range
                      If Time.Amount>=0 And Time.Amount<=23 Then
                         ' store hour light time
                         ObjectRecord.ToHour=Time.Amount
                      Endif ' end check hour time range
                      Outpt="To minute(MM)? " ' make input prompt
                      Call IO.I ' get user input
                      ' store object minute light time
                      Time.Amount=Int(Val(Inpt))
                      ' check minute time range
                      If Time.Amount>=0 And Time.Amount<=59 Then
                         ' store minute light time
                         ObjectRecord.ToMin=Time.Amount
                      Endif ' end check minute time range
                   Endif ' end check user input
                Endif ' end check user input
             Case "Q" ' option to exit object change menu
                Exit Do ' exit object change menu
             End Select ' end selection of object change menu options
          Loop ' end loop through object change options
          Call Share.Record(ObjectFile,Object.Number) ' write object file
          Outpt="Object '"+Rtrim$(ObjectRecord.ObjectName)+"' changed."
          Call IO.O ' send display message
       Endif ' end check object number range
    Case "L" ' option to list range of objects
       Max.Objects=Lof(ObjectFile)/Len(ObjectRecord) ' store length of object
       ' routine to get range of objects
       Call Get.Range(Max.Objects,Objects.List1,Objects.List2)
       ' loop through range of object numbers
       Allow.Break=True ' set allow break flag
       Break=False ' reset control-k flag
       Continue=False ' set continuous flag
       For Object.Count=Objects.List1 To Objects.List2
          Call Read.Record(ObjectFile,Object.Count) ' read object file
          Call Display.Object(Object.Count) ' routine to display object
          If Break Then ' check control-k flag
             Exit For ' exit display flag
          Endif ' end check control-k
          Graphics.Off=False ' reset color
          If Continue=False Then ' check continuous flag
             Call More.Prompt ' routine to pause
             If No Then ' check user input
                Exit For ' exit list loop
             Endif ' end check input
          Endif ' end check continuous flag
       Next ' end loop through object list
       Allow.Break=False ' reset allow break flag
       If Break Then ' check control-k flag
          Break=False ' reset control-k flag
          Outpt=Nul ' set output to null
          Call IO.O ' send empty return
       Endif ' end check control-k flag
    Case "Q" ' option to exit object edit menu
       Exit Do ' exit object edit menu
    End Select ' end selection of object edit menu option
 Loop ' end loop through object edit options
End Sub ' end routine to edit objects

 Rem * routine to edit spells file.

Sub Edit.Spell
 On Local Error Resume Next ' local error resume
 Do ' loop through spell edit menu
    Graphics.Off=False ' reset color
    Outpt="Spell edit:" ' make display message
    Call IO.O ' send message
    Graphics.Off=True ' reset color
    Outpt="[A]dd" ' make display message
    Call IO.O ' send message
    Outpt="[C]hange" ' make display message
    Call IO.O ' send message
    Outpt="[L]ist" ' make display message
    Call IO.O ' make message
    Graphics.Off=False ' reset color
    Outpt="Spell edit option(q to quit)? " ' make input prompt
    No.Input.Out="Q" ' default input
    Call IO.I ' get user input
    Select Case Ucase$(Inpt) ' selection of spell edit option
    Case "A" ' option to add a spell
       New.Spell=Lof(SpellFile)/Len(SpellRecord)+1 ' store last spell record
       SpellRecord.SpellName=Nul ' reset spell record item
       SpellRecord.Chant=Nul ' reset spell record item
       SpellRecord.Desc=Nul ' reset spell record item
       SpellRecord.Level=False ' reset spell record item
       SpellRecord.SpellType=False ' reset spell record item
       SpellRecord.Teleport=False ' reset spell record item
       SpellRecord.ClassType=False ' reset spell record item
       SpellRecord.Psionic=False ' reset spell record item
       SpellRecord.PsionicMode=False ' reset spell record item
       For Array.Index=1 To 5 ' loop through spell ingredients
          SpellRecord.Ingred(Array.Index)=False ' reset spell record item
       Next ' end loop through spell ingredients
       SpellRecord.SpellFlag=False ' reset spell record item
       Call Share.Record(SpellFile,New.Spell) ' write next spell record
    Case "C" ' option to edit a spell
       Call Find.Spell(Spell.Number) ' routine to get spell number
       If Spell.Number>False Then ' check spell number
          Do ' loop through spell edit options menu
             Call Display.Spell(Spell.Number) ' routine to display spell
             Graphics.Off=False ' reset color
             Outpt="Spell change option(q to quit)? " ' make input prompt
             No.Input.Out="Q" ' default input
             Call IO.I ' get user input
             Select Case Ucase$(Inpt) ' selection of spell edit option
             Case "A" ' option to change spell name
                Outpt="Spell name(30 characters)? " ' make input prompt
                Call IO.I ' get user input
                SpellRecord.SpellName=Lcase$(Inpt) ' store spell name
             Case "B" ' option to change spell chant
                Outpt="Spell chant(80 characters):" ' make display message
                Call IO.O ' send message
                Outpt="? " ' make input prompt
                Call IO.I ' get user input
                SpellRecord.Chant=Ucase$(Inpt) ' store spell chant
             Case "C" ' option to change spell description
                Outpt="Spell cast description(80 characters):" ' make message
                Call IO.O ' send message
                Outpt="? " ' make input prompt
                Call IO.I ' get user input
                SpellRecord.Desc=Inpt ' store spell description
             Case "D" ' option to change spell level
                Outpt="Spell level(1-32767)? " ' make input prompt
                No.Input.Out="1" ' default input
                Call IO.I ' get user input
                SpellRecord.Level=Int(Val(Inpt)) ' store spell level
             Case "E" ' option to change spell type
                Call Spell.Types ' routine displays spell types
                Graphics.Off=False ' reset color
                Outpt="Spell type option(q to quit)? " ' make input prompt
                No.Input.Out="Q" ' default input
                Call IO.I ' get user input
                Inpt=Ucase$(Inpt) ' uppercase input
                ' compare input
                Spell.Type=Instr("ABCDEFGHIJKLMNOPRSTUVWXYZ123",Inpt)
                ' check input value
                If Spell.Type>False And Spell.Type<=28 Then
                   SpellRecord.SpellType=Spell.Type ' store spell type
                   If Spell.Type=10 Then ' check teleport spell
                      Outpt="Room it teleports to(1-"+ _
                      Mid$(Str$(Lof(RoomFile)/Len(RoomRecord)),2)+")? " 'prompt
                      No.Input.Out="1" ' default input
                      Call IO.I ' get user input
                      SpellRecord.Teleport=Int(Val(Inpt)) ' store spell room
                   Endif ' end check teleport spell
                Endif ' end check input value
             Case "F" ' option to change psionic spell
                Outpt="Spell is psionic spell(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                SpellRecord.Psionic=False ' reset psionic spell
                SpellRecord.PsionicMode=False ' reset psionic spell
                If Yes Then ' check user input response
                   SpellRecord.Psionic=True ' set psionic spell
                   Graphics.Off=True ' reset color
                   Outpt="[A]ttack mode" ' make display message
                   Call IO.O ' send message
                   Outpt="[D]efense mode" ' make display message
                   Call IO.O ' send message
                   Graphics.Off=False ' reset color
                   Outpt="Spell psionic option? " ' make input prompt
                   No.Input.Out="Q" ' default input
                   Call IO.I ' get user input
                   SpellRecord.PsionicMode=False ' reset spell psionic type
                   Select Case Ucase$(Inpt) ' selection of psionic type
                   Case "A" ' attack psionic type
                      SpellRecord.PsionicMode=1 ' store psionic type
                   Case "D" ' defense psionic type
                      SpellRecord.PsionicMode=2 ' store psionic type
                   End Select ' end selection of psionic type
                Endif ' end check user input
             Case "G" ' option to change spell class restrictions
                Do ' loop through spell cast options menu
                   Graphics.Off=True ' reset color
                   For Class.Number=1 To 8 ' loop through class names
                      Outpt="["+Chr$(64+Class.Number)+"]"+ _
                      Rtrim$(Class.Name(Class.Number))
                      Call IO.O ' send class name message
                   Next ' end loop through class names
                   Outpt="[N]one" ' make message
                   Call IO.O ' send message
                   Outpt="[X]All" ' make message
                   Call IO.O ' send message
                   Graphics.Off=False ' reset color
                   Outpt="Spell class option(q to quit)? " ' make input prompt
                   No.Input.Out="Q" ' default input
                   Call IO.I ' get user input
                   Select Case Ucase$(Inpt) ' selection of class name
                   Case "A" To "H" ' range of class names
                      ' store number of class
                      Class.Number=Instr("ABCDEFGH",Inpt)
                      ' set spell cast restriction flag
                      SpellRecord.ClassType=SpellRecord.ClassType Or _
                      2^Class.Number
                   Case "N" ' option for no class restrictions
                      ' reset class restriction flag
                      SpellRecord.ClassType=False
                   Case "X" ' option to set all class restrictions
                      For Class.Number=1 To 8 ' loop through class types
                         ' set spell cast restriction flag
                         SpellRecord.ClassType=SpellRecord.ClassType Or _
                         2^Class.Number
                      Next ' end loop through class types
                   Case "Q" ' option to exit spell cast restriction menu
                      Exit Do ' exit spell cast restriction menu
                   End Select ' end selection of spell cast option
                Loop ' end loop through spell cast restriction option menu
             Case "H" ' option to change spell ingredients
                Outpt="Enter five treasure items for spell ingredients:"
                Call IO.O ' send display message
                Outpt="Press <enter> for none." ' make display message
                Call IO.O ' send message
                Graphics.Off=True ' reset color
                For Array.Count=1 To 5 ' loop through spell ingredients
                   ' routine to get treasure number
                   Call Find.Treasure(Treasure.Number)
                   ' store spell ingredient
                   SpellRecord.Ingred(Array.Count)=Treasure.Number
                Next ' end loop through spell ingredients
                Graphics.Off=False ' reset color
             Case "I" ' option to change spell ingredient cast type
                Do ' loop through spell cast type option menu
                   Graphics.Off=True ' reset color
                   Outpt="[A]Use command" ' make display message
                   Call IO.O ' send message
                   Outpt="[B]Read scroll" ' make display message
                   Call IO.O ' send message
                   Outpt="[C]Cast spell" ' make display message
                   Call IO.O ' send message
                   Outpt="[N]one" ' make display message
                   Call IO.O ' send message
                   Outpt="[X]All" ' make display message
                   Call IO.O ' send message
                   Graphics.Off=False ' reset color
                   Outpt="Spell ingredient option(q to quit)? " ' make prompt
                   No.Input.Out="Q" ' default input
                   Call IO.I ' get user input
                   Select Case Ucase$(Inpt) ' selection of spell cast type
                   Case "A" ' option to change spell cast type
                      ' store spell cast type flag
                      SpellRecord.SpellFlag= _
                      SpellRecord.SpellFlag Or Use.Spell.Type
                   Case "B" ' option to change spell cast type
                      ' store spell cast type flag
                      SpellRecord.SpellFlag= _
                      SpellRecord.SpellFlag Or Scroll.Spell.Type
                   Case "C" ' option to change spell cast type
                      ' store spell cast type flag
                      SpellRecord.SpellFlag= _
                      SpellRecord.SpellFlag Or Cast.Spell.Type
                   Case "N" ' option to clear spell cast types
                      ' clear spell cast type flag
                      SpellRecord.SpellFlag=False
                   Case "X" ' option to add all spell cast type
                      ' store all spell cast type flag
                      SpellRecord.SpellFlag= _
                      SpellRecord.SpellFlag Or Use.Spell.Type
                      SpellRecord.SpellFlag= _
                      SpellRecord.SpellFlag Or Scroll.Spell.Type
                      SpellRecord.SpellFlag= _
                      SpellRecord.SpellFlag Or Cast.Spell.Type
                   Case "Q" ' option to exit spell ingredient cast types menu
                      Exit Do ' exit spell ingredient cast types menu
                   End Select ' end selection of spell cast type
                Loop ' end loop through spell cast types options menu
             Case "Q" ' option to exit spell edit menu
                Exit Do ' exit spell edit menu
             End Select ' end selection of spell edit menu
          Loop ' end loop through spell editing
          Call Share.Record(SpellFile,Spell.Number) ' write spell record
          Outpt="Spell '"+Rtrim$(SpellRecord.SpellName)+"' changed." ' message
          Call IO.O ' send display message
       Endif ' end check spell number
    Case "L" ' option to list range of spells
       Max.Spells=Lof(SpellFile)/Len(SpellRecord) ' store length of spell file
       ' routine to get range of numbers
       Call Get.Range(Max.Spells,Spell.List1,Spell.List2)
       ' loop through range of spell numbers
       Allow.Break=True ' set allow break flag
       Break=False ' reset control-k flag
       Continue=False ' set continuous flag
       For Spell.Count=Spell.List1 To Spell.List2
          Call Read.Record(SpellFile,Spell.Count) ' read spell record
          Call Display.Spell(Spell.Count) ' routine to display spell
          If Break Then ' check control-k flag
             Exit For ' exit display loop
          Endif ' end check control-k
          Graphics.Off=False ' reset color
          If Continue=False Then ' check continuous flag
             Call More.Prompt ' routine to pause
             If No Then ' check pause response
                Exit For ' exit spell list loop
             Endif ' end check input
         Endif ' end check continuous flag
       Next ' end loop through spell list
       Allow.Break=False ' reset allow break flag
       If Break Then ' check control-k flag
          Break=False ' reset control-k flag
          Outpt=Nul ' set output to null
          Call IO.O ' send empty return
       Endif ' end check control-k flag
    Case "Q" ' option to exit spell menu
       Exit Do ' exit spell options menu
    End Select ' end selection of spell options
 Loop ' end loop through spell options menu
End Sub ' end routine to edit spell

 Rem * routine to edit treasure file.

Sub Edit.Treasure
 On Local Error Resume Next ' local error resume
 Do ' loop through treasure edit menu
    Graphics.Off=False ' reset color
    Outpt="Treasure edit:" ' make display message
    Call IO.O ' send message
    Graphics.Off=True ' reset color
    Outpt="[A]dd" ' make display message
    Call IO.O ' send message
    Outpt="[C]hange" ' make display message
    Call IO.O ' send message
    Outpt="[L]ist" ' make display message
    Call IO.O ' send message
    Graphics.Off=False ' reset color
    Outpt="Treasure edit option(q to quit)? " ' make input prompt
    No.Input.Out="Q" ' default input
    Call IO.I ' get user input
    Select Case Ucase$(Inpt) ' selection of treasure edit option
    Case "A" ' option to add treasure
       New.Treasure=Lof(TreasureFile)/Len(TreasureRecord)+1 ' store treasure
       TreasureRecord.Keyed=False ' reset treasure record item
       TreasureRecord.Weight=False ' reset treasure record item
       TreasureRecord.Gold=False ' reset treasure record item
       TreasureRecord.Plus=False ' reset treasure record item
       TreasureRecord.Charges=False ' reset treasure record item
       TreasureRecord.Type=False ' reset treasure record item
       TreasureRecord.Loadable=False ' reset treasure record item
       TreasureRecord.Ammunition=False ' reset treasure record item
       TreasureRecord.AmmoLoads=False ' reset treasure record item
       TreasureRecord.Container=False ' reset treasure record item
       TreasureRecord.Potion=False ' reset treasure record item
       TreasureRecord.Locked=False ' reset treasure record item
       TreasureRecord.Closed=False ' reset treasure record item
       TreasureRecord.Invisible=False ' reset treasure record item
       TreasureRecord.Proficiency=False ' reset treasure record item
       TreasureRecord.TreasureName=Nul ' reset treasure record item
       TreasureRecord.ShortName=Nul ' reset treasure record item
       TreasureRecord.Spell=False ' reset treasure record item
       TreasureRecord.Scroll=False ' reset treasure record item
       TreasureRecord.RingType=False ' reset treasure record item
       TreasureRecord.RingSpell=False ' reset treasure record item
       TreasureRecord.Edible=False ' reset treasure record item
       TreasureRecord.Rustable=False ' reset treasure record item
       TreasureRecord.RustPercent=False ' reset treasure record item
       TreasureRecord.Stealable=False ' reset treasure record item
       TreasureRecord.StealPercent=False ' reset treasure record item
       TreasureRecord.Launchable=False ' reset treasure record item
       TreasureRecord.LaunchLoads=False ' reset treasure record item
       TreasureRecord.LaunchAmmo=False ' reset treasure record item
       TreasureRecord.Movable=False ' reset treasure record item
       TreasureRecord.Vehicle=False ' reset treasure record item
       TreasureRecord.VehicleHits=False ' reset treasure record item
       TreasureRecord.VehicleType=False ' reset treasure record item
       TreasureRecord.LightType=False ' reset treasure record item
       TreasureRecord.LightCharges=False ' reset treasure record item
       TreasureRecord.FuelType=False ' reset treasure record item
       TreasureRecord.FuelCharges=False ' reset treasure record item
       TreasureRecord.Permanent=False ' reset treasure record item
       TreasureRecord.Invisible=False ' reset treasure record item
       Call Share.Record(TreasureFile,New.Treasure) ' write next treasure record
    Case "C" ' option to change treasure
       Call Find.Treasure(Treasure.Number) ' routine to get treasure number
       If Treasure.Number>False Then ' check treasure number
          Do ' loop through treasure edit options
             ' routine to display treasure
             Call Display.Treasure(Treasure.Number)
             Graphics.Off=False ' reset color
             Outpt="Treasure change option(q to quit)? " ' make input prompt
             No.Input.Out="Q" ' default input
             Call IO.I ' get user input
             Select Case Ucase$(Inpt) ' selection of treasure option
             Case "A" ' option to change treasure name
                Outpt="Treasure name(30 characters)? " ' make input prompt
                Call IO.I ' get user input
                TreasureRecord.TreasureName=Lcase$(Inpt) ' store treasure name
             Case "B" ' option to change treasure mnemonic
                ' make input prompt
                Outpt="Treasure identifier(30 characters)? "
                Call IO.I ' get user input
                ' store treasure mnemonic
                TreasureRecord.ShortName=Ucase$(Inpt)
             Case "C" ' option to change treasure weight
                Outpt="Weight(1-32767)? " ' make input prompt
                No.Input.Out="1" ' default input
                Call IO.I ' get user input
                TreasureRecord.Weight=Int(Val(Inpt)) ' store treasure weight
             Case "D" ' option to change treasure gold value
                Outpt="Gold value? " ' make input prompt
                No.Input.Out="10" ' default input
                Call IO.I ' get user input
                TreasureRecord.Gold=Int(Val(Inpt)) ' store treasure gold value
             Case "E" ' option to change treasure type
                Graphics.Off=True ' reset color
                Outpt="[W]eapon" ' make display message
                Call IO.O ' send message
                Outpt="[S]hield" ' make display message
                Call IO.O ' send message
                Outpt="[A]rmor" ' make display message
                Call IO.O ' send message
                Outpt="[T]reasure" ' make display message
                Call IO.O ' send message
                Graphics.Off=False ' reset color
                Outpt="Treasure type option? " ' make input prompt
                No.Input.Out="Q" ' default input
                Call IO.I
                Select Case Ucase$(Inpt) ' selecction of treasure type
                Case "W" ' option for weapon type
                   TreasureRecord.Type=False ' set treasure type
                   TreasureRecord.Permanent=False ' set treasure type
                   Outpt="Hit plus(1-32767)? " ' make input prompt
                   No.Input.Out="10" ' default input
                   Call IO.I ' get user input
                   TreasureRecord.Plus=Int(Val(Inpt)) ' store treasure plus
                Case "S" ' option for shield type
                   TreasureRecord.Type=True ' set treasure type
                   TreasureRecord.Permanent=False ' set treasure type
                Case "A" ' option for armor type
                   TreasureRecord.Type=1 ' set treasure type
                   TreasureRecord.Permanent=False ' set treasure type
                Case "T" ' option for treasure type
                   TreasureRecord.Plus=False ' set treasure type
                   TreasureRecord.Charges=False ' set treasure type
                   TreasureRecord.Type=False ' set treasure type
                   TreasureRecord.Permanent=False ' set treasure type
                End Select ' end selection of treasure type
             Case "F" ' option to change treasure hits plus
                Outpt="Hit plus(1-32767)? " ' make input prompt
                No.Input.Out="1" ' default input
                Call IO.I ' get user input
                TreasureRecord.Plus=Int(Val(Inpt)) ' store treasure hits plus
             Case "G" ' option to change treasure charges
                Outpt="Charges(1-32767)? " ' make input prompt
                No.Input.Out="1" ' default input
                Call IO.I ' get user input
                TreasureRecord.Charges=Int(Val(Inpt)) ' store treasure charges
             Case "H" ' option to change treasure weapon type
                Graphics.Off=True ' reset color
                Outpt="[B]lunt" ' make display message
                Call IO.O ' send message
                Outpt="[P]ole" ' make display message
                Call IO.O ' send message
                Outpt="[S]harp" ' make display message
                Call IO.O ' send message
                Outpt="[T]hrusting" ' make display message
                Call IO.O ' send message
                Graphics.Off=False ' reset color
                Outpt="Treasure weapon class option? " ' make input prompt
                No.Input.Out="Q" ' default input
                Call IO.I ' get user input
                Select Case Ucase$(Inpt) ' selection of treasure weapon type
                Case "B" ' blunt weapon type
                   TreasureRecord.Proficiency=1 ' set weapon type
                Case "P" ' pole weapon type
                   TreasureRecord.Proficiency=2 ' set weapon type
                Case "S" ' sharp weapon type
                   TreasureRecord.Proficiency=3 ' set weapon type
                Case "T" ' thrusting weapon type
                   TreasureRecord.Proficiency=4 ' set weapon type
                End Select ' end selection of treasure weapon type
             Case "I" ' option to change permanent treasure
                Outpt="Treasure is permanent(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                TreasureRecord.Permanent=Yes ' store permanent type
             Case "J" ' option to change edible treasure
                Outpt="Treasure is edible(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                TreasureRecord.Edible=Yes ' store edible type
             Case "K" ' option to change treasure spell number
                Outpt="Treasure is magical(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                TreasureRecord.Spell=False ' reset treasure spell number
                If Yes Then ' check user input response
                   Call Find.Spell(Spell.Number) ' routine to get spell number
                   If Spell.Number>False Then ' check spell number range
                      ' store treasure spell number
                      TreasureRecord.Spell=Spell.Number
                   Endif ' end check spell range
                Endif ' end check input
             Case "L" ' option to change ring treasure
                Outpt="Treasure is ring(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                TreasureRecord.RingType=False ' reset treasure ring
                TreasureRecord.RingSpell=False ' reset treasure ring
                If Yes Then ' check user input response
                   Graphics.Off=True ' reset color
                   Outpt="[P]oison" ' make display message
                   Call IO.O ' send message
                   Outpt="[L]evel Drain" ' make display message
                   Call IO.O ' send message
                   Outpt="[S]pell" ' make display message
                   Call IO.O ' send message
                   Outpt="[G]eneric spell" ' make display message
                   Call IO.O ' send message
                   Graphics.Off=False ' reset color
                   Outpt="Treasure ring option? " ' make input prompt
                   No.Input.Out="Q" ' default input
                   Call IO.I ' get user input
                   Select Case Ucase$(Inpt) ' selection of ring type
                   Case "P" ' option for anti-poison ring
                      TreasureRecord.RingSpell=False ' store ring spell type
                      TreasureRecord.RingType=1 ' store ring type
                   Case "L" ' option for anti-leveldrain ring
                      TreasureRecord.RingSpell=False ' store ring spell type
                      TreasureRecord.RingType=2 ' store ring type
                   Case "S" ' option for number of anti-spell ring
                      ' routine to get spell number
                      Call Find.Spell(Spell.Number)
                      If Spell.Number>False Then ' check spell number
                         ' store ring spell number
                         TreasureRecord.RingSpell=Spell.Number
                         TreasureRecord.RingType=3 ' store ring type
                      Endif ' end check spell number
                   Case "G" ' option for generic anti-spell ring
                      TreasureRecord.RingSpell=True ' store ring spell type
                      TreasureRecord.RingType=3 ' store ring type
                   End Select ' end selection of ring type
                Endif ' end check user input
             Case "M" ' option to change treasure light
                Outpt="Treasure is a light(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                TreasureRecord.LightType=False ' reset treasure light type
                TreasureRecord.LightCharges=False ' reset treasure light type
                If Yes Then ' check user input response
                   Outpt="Light charges(1-32767)? " ' make input prompt
                   Call IO.I ' get user input
                   Light.Charges=Int(Val(Inpt)) ' convert input to integer
                   TreasureRecord.LightType=True ' set treasure light type
                   ' store treasure charges
                   TreasureRecord.LightCharges=Light.Charges
                Endif ' end check user input
             Case "N" ' option to change treasure vehicle
                Outpt="Treasure is a vehicle(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                TreasureRecord.Vehicle=False ' reset treasure vehicle
                TreasureRecord.VehicleHits=False ' reset treasure vehicle
                TreasureRecord.VehicleType=False ' reset treasure vehicle
                If Yes Then ' check user input response
                   Outpt="Vehicle hits(1-32767)? " ' make input prompt
                   Call IO.I ' get user input
                   Vehicle.Hits=Int(Val(Inpt)) ' convert input to integer
                   If Vehicle.Hits>False Then ' check input range
                      TreasureRecord.Vehicle=True ' set treasure vehicle
                      ' store vehicle hits
                      TreasureRecord.VehicleHits=Vehicle.Hits
                      Graphics.Off=True ' reset color
                      Outpt="[A]ir" ' make display message
                      Call IO.O ' send message
                      Outpt="[L]and" ' make display message
                      Call IO.O ' send message
                      Outpt="[W]ater" ' make display message
                      Call IO.O ' send message
                      Outpt="[X]All terrain" ' make display message
                      Call IO.O ' send message
                      Graphics.Off=False ' reset color
                      Outpt="Vehicle type edit option? " ' make input prompt
                      No.Input.Out="Q" ' default input
                      Call IO.I ' get user input
                      Select Case Ucase$(Inpt) ' selection of vehicle type
                      Case "A" ' air vehicle type
                         TreasureRecord.VehicleType=Air ' set vehicle type
                      Case "L" ' land vehicle type
                         TreasureRecord.VehicleType=Land ' set vehicle type
                      Case "W" ' underwaater vehicle type
                         TreasureRecord.VehicleType=Water ' set vehicle type
                      Case "X" ' all terrain vehicle type
                         TreasureRecord.VehicleType=AllTerrain ' vehicle type
                      End Select ' end selection of vehicle type
                   Endif ' end check input range
                Endif ' end check user input
             Case "O" ' option to change treasure ammunition type
                Outpt="Treasure loads from devices(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                TreasureRecord.Ammunition=Yes ' set treasure ammunition type
             Case "P" ' option to change treasure loadable type
                Outpt="Treasure is loadable device(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                ' reset treasure loadable type
                TreasureRecord.Loadable=False
                TreasureRecord.AmmoLoads=False ' reset treasure loadable type
                If Yes Then ' check user input response
                   ' write current treasure record
                   Call Share.Record(TreasureFile,Treasure.Number)
                   Outpt="Treasure which loads this device:" ' make message
                   Call IO.O ' send message
                   ' routine to get treasure number
                   Call Find.Treasure(Treasure.Device)
                   If Treasure.Device=False Then ' check number range
                      ' read current treasure record
                      Call Read.Record(TreasureFile,Treasure.Number)
                      TreasureRecord.Loadable=False ' reset loadable type
                      TreasureRecord.AmmoLoads=False ' reset loadable type
                   Else ' check input range
                      ' read loadable treasure record
                      Call Read.Record(TreasureFile,Treasure.Device)
                      If TreasureRecord.Ammunition=False Then ' check type
                         ' read current record
                         Call Read.Record(TreasureFile,Treasure.Number)
                         Outpt="That treasure is not ammunition." ' message
                         Call IO.O ' send message
                         TreasureRecord.Loadable=False ' reset loadable type
                         TreasureRecord.AmmoLoads=False ' reset loadable type
                      Else ' check ammunition type
                         ' read current record
                         Call Read.Record(TreasureFile,Treasure.Number)
                         ' set ammunition loadable
                         TreasureRecord.Loadable=True
                         ' store ammunition number
                         TreasureRecord.AmmoLoads=Treasure.Device
                      Endif ' end check ammunition type
                   Endif ' end check user input range
                   ' write current record number
                   Call Share.Record(TreasureFile,Treasure.Number)
                Endif ' end check user input
             Case "R" ' option to change treasure launchs
                ' make input prompt
                Outpt="Treasure launchs from devices(y/n)? "
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                TreasureRecord.LaunchAmmo=Yes ' store launchs type
             Case "S" ' option to change treasure launchable type
                Outpt="Treasure is launchable device(y/n)? " ' make input
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                TreasureRecord.Launchable=False ' reset launchable type
                TreasureRecord.LaunchLoads=False ' reset launchable type
                If Yes Then ' check user input response
                   ' write current treasure record
                   Call Share.Record(TreasurFile,Treasure.Number)
                   Outpt="Treasure which launchs from this device:" ' message
                   Call IO.O ' send message
                   ' routine to get treasure number
                   Call Find.Treasure(Treasure.Device)
                   ' check treasure number range
                   If Treasure.Device=False Then
                      ' read current treasure record
                      Call Read.Record(TreasureFile,Treasure.Number)
                      TreasureRecord.Launchable=False ' reset launchable type
                      TreasureRecord.LaunchLoads=False ' reset launchable type
                   Else ' check number range
                      ' read lannchable treasure
                      Call Read.Record(TreasureFile,Treasure.Device)
                      If TreasureRecord.LaunchAmmo=False Then ' check launch
                         ' read current record
                         Call Read.Record(TreasureFile,Treasure.Number)
                         Outpt="That treasure does not launch from devices."
                         Call IO.O ' send error message
                         ' reset launchable type
                         TreasureRecord.Launchable=False
                         TreasureRecord.LaunchLoads=False ' reset launchable
                      Else ' check launchable type
                         ' read current record
                         Call Read.Record(TreasureFile,Treasure.Number)
                         TreasureRecord.Launchable=True ' set launchable
                         ' store launch number
                         TreasureRecord.LaunchLoads=Treasure.Device
                      Endif ' end check launchable number type
                   Endif ' end check launchable treasure number
                   Call Share.Record(TreasureFile,Treasure.Number) ' write current record
                Endif ' end check user input
             Case "T" ' option to change movable type
                Outpt="Launchable device can be moved(y/n)? " ' make input
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                TreasureRecord.Movable=Yes ' store movable type
             Case "U" ' option  to change coin type
                Outpt="Treasure is coins(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                TreasureRecord.Coin=Yes ' store coin type
             Case "V" ' option to change potion type
                Outpt="Treasure is potion(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                TreasureRecord.Potion=Yes ' store potion type
             Case "W" ' option to change scroll type
                Outpt="Treasure is scroll(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                TreasureRecord.Scroll=Yes ' store scroll type
             Case "X" ' option to change invisible treasure
                Outpt="Treasure is invisible(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                TreasureRecord.Invisible=Yes ' store invisible type
             Case "Y" ' option to change container type
                Outpt="Treasure is a container(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                TreasureRecord.Container=Yes ' store container type
             Case "Z" ' option to change container lock
                Outpt="Container is locked(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                TreasureRecord.Locked=False ' reset container lock
                TreasureRecord.Closed=False ' reset container lock
                If Yes Then ' check user input response
                   TreasureRecord.Locked=1 ' set container lock
                   TreasureRecord.Closed=1 ' set container lock
                Endif ' end check user input
             Case "1" ' option to change key number
                Outpt="Treasure key number(1-32767)? " ' make input prompt
                No.Input.Out="1" ' default input
                Call IO.I ' get user input
                TreasureRecord.Keyed=Int(Val(Inpt)) ' store key number
             Case "2" ' option to change treasure fuel
                Outpt="Treasure is fuel(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                TreasureRecord.FuelType=False ' reset fuel type
                TreasureRecord.FuelCharges=False ' reset fuel type
                If Yes Then ' check user input response
                   Outpt="Fuel charges(1-32767)? " ' make input prompt
                   Call IO.I ' get user input
                   Fuel.Charges=Int(Val(Inpt)) ' convert input to integer
                   TreasureRecord.FuelType=True ' set fuel type
                   ' store fuel charges
                   TreasureRecord.FuelCharges=Fuel.Charges
                Endif ' end check user input
             Case "3" ' option to change rusting treasure
                Outpt="Treasure can rust(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                TreasureRecord.Rustable=False ' reset rusting treasure
                TreasureRecord.RustPercent=False ' reset rusting treasure
                If Yes Then ' check user input response
                   Outpt="Percent chance weapon " ' make input prompt
                   Outpt=Outpt+"will rust during room rust rate(1-100)? "
                   No.Input.Out="50" ' default input
                   Call IO.I ' get user input
                   Percent=Int(Val(Inpt)) ' convert input to integer
                   If Percent>=1 And Percent<=100 Then ' check input range
                      TreasureRecord.Rustable=True ' set rusting treasure
                      ' store rusting percent
                      TreasureRecord.RustPercent=Percent
                   Else ' check range
                      TreasureRecord.Rustable=False ' reset rusting treasure
                      ' reset rusting treasure
                      TreasureRecord.RustPercent=False
                   Endif ' end check range
                Endif ' end check user input
             Case "4" ' option to change stealable treasure
                Outpt="Treasure can be stolen(y/n)? " ' make input prompt
                No.Input.Out="Y" ' default input
                Call IO.I ' get user input
                TreasureRecord.Stealable=False ' reset steable treasure
                TreasureRecord.StealPercent=False ' reset steable treasure
                If Yes Then ' check user input response
                   Outpt="Percent chance treasure " ' make input prompt
                   Outpt=Outpt+"stolen during room steal rate(1-100)? "
                   No.Input.Out="50" ' default input
                   Call IO.I ' get user input
                   Percent=Int(Val(Inpt)) ' convert input to inetger
                   If Percent>=1 And Percent<=100 Then ' check input range
                      TreasureRecord.Stealable=True ' set steable treasure
                      ' set steable percent
                      TreasureRecord.StealPercent=Percent
                   Else ' check range
                      TreasureRecord.Stealable=False ' reset steable treasure
                      ' reset steable treasure
                      TreasureRecord.StealPercent=False
                   Endif ' end check range
                Endif ' end check user input
             Case "Q" ' option to exit treasure change menu
                Exit Do ' exit treasure change menu
             End Select ' end selection of treasure menu option
          Loop ' end loop through treasure change menu
          Call Share.Record(TreasureFile,Treasure.Number) ' write treasure record
          Outpt="Treasure '"+Rtrim$(TreasureRecord.TreasureName)+"' changed."
          Call IO.O ' send message
       Endif ' end check number range
    Case "L" ' option to list range of treasure numbers
       Max.Treasure=Lof(TreasureFile)/Len(TreasureRecord) ' store length of treasure file
       ' get range of treasure numbers
       Call Get.Range(Max.Treasure,Treasure.List1,Treasure.List2)
       ' loop through treasure numbers
       Allow.Break=True ' set allow break flag
       Break=False ' reset control-k flag
       Continue=False ' set continuous flag
       For Treasure.Count=Treasure.List1 To Treasure.List2
          Call Read.Record(TreasureFile,Treasure.Count) ' read treasure record
          Call Display.Treasure(Treasure.Count) ' routine to display treasure
          If Break Then ' check control-k flag
             Exit For ' exit display loop
          Endif ' end check control-k
          Graphics.Off=False ' reset color
          If Continue=False Then ' check continuous flag
             Call More.Prompt ' routine to pause
             If No Then ' check pause input response
                Exit For ' exit loop through treasure numbers
             Endif ' end check user input
          Endif ' end check continuous flag
       Next ' end loop through treasure numbers
       Allow.Break=False ' reset allow break flag
       If Break Then ' check control-k flag
          Break=False ' reset control-k flag
          Outpt=Nul ' set output to null
          Call IO.O ' send empty return
       Endif ' end check control-k flag
    Case "Q" ' option to exit treasure edit menu
       Exit Do ' exit treasure edit menu
    End Select ' end selection of treasure edit option
 Loop ' end loop through treasure edit menu
End Sub ' end routine to edit treasure

 Rem * routine to edit user file.

Sub Edit.User
 On Local Error Resume Next ' local error resume
 Do ' loop through user edit option menu
    Graphics.Off=False ' reset color
    Outpt="User edit:" ' make display message
    Call IO.O ' send message
    Graphics.Off=True ' reset color
    Outpt="[A]dd" ' make display message
    Call IO.O ' send message
    Outpt="[C]hange" ' make display message
    Call IO.O ' send message
    Outpt="[D]elete" ' make display message
    Call IO.O ' send message
    Outpt="[L]ist" ' make display message
    Call IO.O ' send message
    Outpt="[U]pdate" ' make display message
    Call IO.O ' send message
    Graphics.Off=False ' reset color
    Outpt="User edit option(q to quit)? " ' make input prompt
    No.Input.Out="Q" ' default input
    Call IO.I ' get user input
    Select Case Ucase$(Inpt) ' selection of user edit option
    Case "A" ' option to add user record
       If Local.Mode=False Then ' check local sysop online
          Outpt="Remote DMs cannot add users." ' make message
          Call IO.O ' send error message
       Else ' check local sysop
          New.User=Lof(UserFile)/Len(UserRecord)+1 ' store last user number
          Outpt=Dead$ ' store empty codename
          Call Valid(Outpt,30) ' validate codename
          Call Encrypt(Outpt,True) ' encrypt codename
          UserRecord2.CodeName=Outpt ' store empty codename
          Outpt=Deleted$ ' store empty password
          Call Valid(Outpt,20) ' validate password
          Call Encrypt(Outpt,False) ' encrypt password
          UserRecord2.PassWord=Outpt ' store empty password
          Outpt=Class.Name(1) ' store defualt class name
          Call Valid(Outpt,20) ' validate class name
          Call Encrypt(Outpt,True) ' encrypt class name
          UserRecord2.ClassName=Outpt ' store default class name
          UserRecord2.ClassType=Fighter ' store default class type
          For Array.Index=1 To 7 ' loop through user statistics
             UserRecord2.Stats(Array.Index)=12 ' store default statistic
          Next ' end loop through statistics
          For Array.Index=1 To 4 ' loop through user weapons
             UserRecord2.Weapons(Array.Index)=False ' store default weapon
          Next ' end loop through weapons
          UserRecord2.Weapons(3)=10 ' store default weapon
          UserRecord2.Room=1! ' reset user record item
          UserRecord2.Level=1 ' reset user record item
          UserRecord2.Experience=64 ' reset user record item
          UserRecord2.Gold=2048 ' reset user record item
          UserRecord2.Borrow=False ' reset user record item
          UserRecord2.NumCalls=False ' reset user record item
          UserRecord2.Poison=False ' reset user record item
          UserRecord2.Invisible=False ' reset user record item
          UserRecord2.Race=1 ' reset user record item
          UserRecord2.Proficiency=3 ' reset user record item
          UserRecord2.Bank=False ' reset user record item
          UserRecord2.MonstersKilled=False ' reset user record item
          UserRecord2.Brief=False ' reset user record item
          UserRecord2.Echo=False ' reset user echo mode
          UserRecord2.Linefeeds=False ' reset user linefeed mode
          UserRecord2.Linelength=80 ' reset user linelength
          UserRecord2.Pagelength=24 ' reset pagelength
          UserRecord2.Wordwrap=False ' reset user word wrap
          Outpt=Date$ ' store current date
          Call Valid(Outpt,10) ' validate date
          Call Encrypt(Outpt,True) ' encrypt date
          UserRecord2.DateOn=Outpt ' reset user record item
          UserRecord2.Align1=False ' reset user record item
          UserRecord2.Align2=False ' reset user record item
          UserRecord2.Flags=False ' reset user record item
          UserRecord2.MaxCalls=False ' reset user record item
          UserRecord2.FromHour=False ' reset user record item
          UserRecord2.FromMin=False ' reset user record item
          UserRecord2.ToHour=False ' reset user record item
          UserRecord2.ToMin=False ' reset user record item
          ContainerRec.Closed=False ' reset user record item
          ContainerRec.ContainerName=Nul ' reset user record item
          ContainerRec.Keyed=False ' reset user record item
          ContainerRec.Locked=False ' reset user record item
          ContainerRec.ShortName=Nul ' reset user record item
          ContainerRec.Permanent=False ' reset user record item
          Call Clear.Container(0,True) ' routine to clear the container structure
          For Array.Count=1 To 3 ' loop through user containers
             ' store empty container
             UserRecord2.Container(Array.Count)=ContainerRec
          Next ' end loop through containers
          UserRecord2.TrainRoom(1)=36
          UserRecord2.TrainRoom(2)=4
          UserRecord2.TrainRoom(3)=123
          UserRecord2.TrainRoom(4)=163
          UserRecord2.TrainRoom(5)=162
          UserRecord2.TrainRoom(6)=426
          UserRecord2.TrainRoom(7)=421
          UserRecord2.TrainRoom(8)=417
          UserRecord2.TrainRoom(9)=1
          UserRecord2.TrainRoom(10)=1
          Call Share.Record(UserFile2,New.User) ' write user record
          Outpt="New user record added." ' make display message
          Call IO.O ' send message
          Call Read.Record(UserFile,User.Index)
       Endif ' end check local sysop
    Case "D" ' option to delete user
       If Local.Mode=False Then ' check local sysop online
          Outpt="Remote DMs cannot delete users." ' make message
          Call IO.O ' send error message
       Else ' check local sysop
          Call Find.User(User.Found,User.Number) ' get user number
          If User.Found Then ' check user found flag
             If User.Number=User.Index Then ' check user number
                Outpt="Can't delete you. Try Suicide.." ' make output
                Call IO.O ' send output
             Else ' check user number
                Inpt=UserRecord.CodeName ' store player codename
                Call Decrypt(Inpt) ' decrypt codename
                Inpt=Rtrim$(Inpt) ' trim codename
                Inpt=Lcase$(Inpt) ' lowercase codename
                Mid$(Inpt,1,1)=Ucase$(Mid$(Inpt,1,1)) ' uppercase first word
                Outpt="Delete '"+Inpt+"'. Are you sure(y/n)? " ' make input prompt
                No.Input.Out="N" ' default input
                Call IO.I ' get user input
                If Yes Then ' check input response
                   Outpt="User deleted." ' make deleted message
                   Call IO.O ' send message
                   Call Delete.User ' routine to clear user record
                   Call Share.Record(UserFile2,User.Number) ' write user record
                Endif ' end check input response
             Endif ' end check user number
          Endif ' end check user found flag
       Endif ' end check local sysop online
       Call Read.Record(UserFile,User.Index)
    Case "C" ' option to change user
          Call Find.User(User.Found,User.Number) ' get user number
          If User.Found Then ' compare found flag
             Do ' loop through codename edit option menu
                Call Display.User(User.Number) ' routine to display player
                Graphics.Off=False ' reset color
                Outpt="User change option(q to quit)? " ' make input prompt
                No.Input.Out="Q" ' default input
                Call IO.I ' get user input
                Select Case Ucase$(Inpt) ' selection of player edit option
                Case "A" ' option to change player codename
                   If Local.Mode=False Then ' check local sysop online
                      Outpt="Remote DMs cannot edit codename." ' make message
                      Call IO.O ' send error message
                   Else ' check local sysop
                      Outpt="Codename? " ' make input prompt
                      No.Input.Out=Deleted$ ' default input
                      Call IO.I ' get user input
                      Inpt=Ucase$(Inpt) ' uppercase input
                      Call Valid(Inpt,30) ' validate input
                      If Inpt=Nul Then ' check validation
                         Outpt="Illegal characters in codename." ' message
                         Call IO.O ' send error message
                      Else ' check validation
                         Call Encrypt(Inpt,True) ' encrypt codename
                         UserRecord.CodeName=Inpt ' store codename
                      Endif ' end check validate
                   Endif ' end check response
                Case "B" ' option to change player password
                   If Local.Mode=False Then ' check local sysop online
                      Outpt="Remote DMs cannot edit password." ' make message
                      Call IO.O ' send error message
                   Else ' check local sysop
                      Inpt=UserRecord.PassWord ' store password
                      Call Decrypt(Inpt) ' decrypt password
                      If Inpt=Nul Then ' check decryption byte checksum
                         Outpt="This password has a checksum error." ' message
                         Call IO.O ' send error message
                      Endif ' end check byte checksum
                      Outpt="Password? " ' make input prompt
                      No.Input.Out=Deleted$ ' default input
                      Call IO.I ' get user input
                      Inpt=Ucase$(Inpt) ' uppercase input
                      Call Valid(Inpt,20) ' validate input
                      If Inpt=Nul Then ' check validation
                         Outpt="Illegal characters in password." ' message
                         Call IO.O ' send error message
                      Else ' check validation
                         Call Encrypt(Inpt,False) ' encrypt password
                         UserRecord.PassWord=Inpt ' store password
                      Endif ' end check validation
                   Endif ' end check local sysop online
                Case "C" ' option to change player level
                   Outpt="Level(1-32767)? " ' make input prompt
                   No.Input.Out="1" ' default input
                   Call IO.I ' get user input
                   Level#=Int(Val(Inpt)) ' convert input to double
                   If Level#>False And Level#<=MaxInt Then ' compare input range
                      New.Level=Cint(Level#) ' convert input to integer
                      UserRecord.Level=New.Level ' store player level
                   Endif ' end compare input range
                Case "D" ' option to change player class number
                   Graphics.Off=True ' reset color
                   If Local.Mode=False Then ' check local sysop online
                      Max.Class=8 ' store maximum class number
                   Else ' check local sysop
                      Max.Class=10 ' store maximum class number
                   Endif ' end check local sysop online
                   ' loop through class number range
                   For Class.Count=1 To Max.Class
                      ' make class display message
                      Outpt="["+Mid$(Str$(Class.Count),2)+"]"+ _
                      Rtrim$(Class.Name(Class.Count))
                      Call IO.O ' send message
                   Next ' end loop through class numbers
                   Outpt="Class option" ' make range prompt
                   ' return number from range
                   Call Get.Range2(0,Max.Class,Class.Number)
                   If Class.Number>False Then ' check number bounds
                      ' store player class number
                      UserRecord.ClassType=Class.Number
                   Endif ' end check number bounds
                Case "E" ' option to change player weapon type
                   Graphics.Off=True ' reset color
                   For Weapon.COunt=1 To 4 ' loop through weapon type names
                      ' make weapon type message
                      Outpt="["+Mid$(Str$(Weapon.Count),2)+"]"+ _
                      Rtrim$(Weapon.Type.Name(Weapon.Count))
                      Call IO.O ' send message
                   Next ' end loop through weapon type names
                   Graphics.Off=False ' reset color
                   Outpt="Weapon proficiency" ' make range prompt
                   Call Get.Range2(0,4,Weapon.Value) ' get number from range
                   If Weapon.Value>False Then ' check number bounds
                      ' store weapon type number
                      UserRecord.Proficiency=Weapon.Value
                   Endif ' end check number bounds
                Case "F" ' option to change weapon proficiency number
                   Outpt="Blunt weapon proficiency%(1-100)? " ' input prompt
                   No.Input.Out="10" '  default input
                   Call IO.I ' get user input
                   UserRecord.Weapons(1)=Int(Val(Inpt)) ' store weapon value
                Case "G" ' option to change weapon proficiency number
                   Outpt="Pole weapon proficiency%(1-100)? " ' input prompt
                   No.Input.Out="10" '  default input
                   Call IO.I ' get user input
                   UserRecord.Weapons(2)=Int(Val(Inpt)) ' store weapon value
                Case "H" ' option to change weapon proficiency number
                   Outpt="Sharp weapon proficiency%(1-100)? " ' input prompt
                   No.Input.Out="10" '  default input
                   Call IO.I ' get user input
                   UserRecord.Weapons(3)=Int(Val(Inpt)) ' store weapon value
                Case "I" ' option to change weapon proficiency number
                   ' input prompt
                   Outpt="Thrusting weapon proficiency%(1-100)? "
                   No.Input.Out="10" '  default input
                   Call IO.I ' get user input
                   UserRecord.Weapons(4)=Int(Val(Inpt)) ' store weapon value
                Case "J" ' option to change player class name
                   Outpt="Classname? " ' make input prompt
                   No.Input.Out=Deleted$ ' default input
                   Call IO.I ' get user input
                   Call Valid(Inpt,20) ' validate input
                   If Inpt=Nul Then ' check validation
                      Outpt="Illegal characters in classname." ' make message
                      Call IO.O ' send error message
                   Else ' end check validation
                      Call Encrypt(Inpt,True) ' encrypt clsss name
                      UserRecord.ClassName=Inpt ' store class name
                   Endif ' end check validation
                Case "K" ' option to change player statistic
                   Outpt="Strength? " ' make input prompt
                   No.Input.Out="12" ' default input
                   Call IO.I ' get user input
                   UserRecord.Stats(1)=Int(Val(Inpt)) ' store player staistic
                Case "L" ' option to change player statistic
                   Outpt="Intelligence? " ' make input prompt
                   No.Input.Out="12" ' default input
                   Call IO.I ' get user input
                   UserRecord.Stats(2)=Int(Val(Inpt)) ' store player staistic
                Case "M" ' option to change player statistic
                   Outpt="Wisdom? " ' make input prompt
                   No.Input.Out="12" ' default input
                   Call IO.I ' get user input
                   UserRecord.Stats(3)=Int(Val(Inpt)) ' store player staistic
                Case "N" ' option to change player statistic
                   Outpt="Dexterity? " ' make input prompt
                   No.Input.Out="12" ' default input
                   Call IO.I ' get user input
                   UserRecord.Stats(4)=Int(Val(Inpt)) ' store player staistic
                Case "O" ' option to change player statistic
                   Outpt="Constitution? " ' make input prompt
                   No.Input.Out="12" ' default input
                   Call IO.I ' get user input
                   UserRecord.Stats(5)=Int(Val(Inpt)) ' store player staistic
                Case "P" ' option to change player statistic
                   Outpt="Piety? " ' make input prompt
                   No.Input.Out="12" ' default input
                   Call IO.I ' get user input
                   UserRecord.Stats(6)=Int(Val(Inpt)) ' store player staistic
                Case "R" ' option to change player statistic
                   Outpt="Charisma? " ' make input prompt
                   No.Input.Out="12" ' default input
                   Call IO.I ' get user input
                   UserRecord.Stats(7)=Int(Val(Inpt)) ' store player staistic
                Case "S" ' option to change player experience
                   Outpt="Experience? " ' make input prompt
                   No.Input.Out="128" ' default input
                   Call IO.I ' get user input
                   UserRecord.Experience=Cdbl(Int(Val(Inpt)))
                Case "T" ' option to change player gold hoard
                   Outpt="Gold? " ' make input prompt
                   No.Input.Out="256" ' default input
                   Call IO.I ' get user input
                   UserRecord.Gold=Cdbl(Int(Val(Inpt))) ' store player gold
                Case "U" ' option to change player room number
                   Outpt="Room number? " ' make input prompt
                   No.Input.Out="1" ' default input
                   Call IO.I ' get user input
                   UserRecord.Room=Int(Val(Inpt)) ' store room number
                Case "V" ' option to change player calls
                   Graphics.Off=True ' reset color
                   Outpt="Calls made today? " ' make input prompt
                   No.Input.Out="0" ' default input
                   Call IO.I ' get user input
                   UserRecord.NumCalls=Int(Val(Inpt)) ' store player calls
                   Outpt="Maximum calls per day? " ' make input prompt
                   No.Input.Out="5" ' default input
                   Call IO.I ' get user input
                   UserRecord.MaxCalls=Int(Val(Inpt)) ' store plater calls
                   Outpt="Timeon restriction(from hour: form HH)? " ' prompt
                   No.Input.Out="00" ' default input
                   Call IO.I ' get user input
                   UserRecord.FromHour=Int(Val(Inpt)) ' store player time
                   Outpt="Timeon restriction(from minute: form MM)? " ' prompt
                   No.Input.Out="00" ' default input
                   Call IO.I ' get user input
                   UserRecord.FromMin=Int(Val(Inpt)) ' store player time
                   Outpt="Timeon restriction(to hour: form HH)? " ' prompt
                   No.Input.Out="00" ' default input
                   Call IO.I ' get user input
                   UserRecord.ToHour=Int(Val(Inpt)) ' store player time
                   Outpt="Timeon restriction(to minute: form MM)? " ' prompt
                   No.Input.Out="00" ' default input
                   Call IO.I ' get user input
                   UserRecord.ToMin=Int(Val(Inpt)) ' store player time
                   Graphics.Off=False ' reset color
                Case "W" ' option to edit player inventory
                   Do ' loop through inventory edit menu
                      Graphics.Off=True ' reset color
                      Outpt="[C]ontainers" ' make display message
                      Call IO.O ' send message
                      Outpt="[O]bjects" ' make display message
                      Call IO.O ' send message
                      Outpt="[T]reasure" ' make display message
                      Call IO.O ' send message
                      Graphics.Off=False ' reset color
                      Outpt="Inventory edit option(q to quit)? " ' prompt
                      No.Input.Out="Q" ' default input
                      Call IO.I ' get user input
                      Select Case Ucase$(Inpt) ' selection of inventory option
                      Case "C" ' option to edit player containers
                         Do ' loop through user container edit menu
                            Graphics.Off=False ' reset color
                            Outpt="User container edit options:" ' make display message
                            Call IO.O ' send message
                            Graphics.Off=True ' reset color
                            Outpt="[A]dd" ' make option message
                            Call IO.O ' send option message
                            Outpt="[C]hange" ' make option message
                            Call IO.O ' send option message
                            Outpt="[D]elete" ' make option message
                            Call IO.O ' send option message
                            Outpt="[L]ist" ' make option message
                            Call IO.O ' send option message
                            Graphics.Off=False ' reset color
                            Outpt="Enter user container edit option(q to quit)? " ' make option prompt
                            No.Input.Out="Q" ' store default input
                            Call IO.I ' get option input
                            Select Case Ucase$(Inpt) ' make selection of input option
                            Case "A" ' add container
                               Treasure.Added=False ' set container added flag
                               For Number.Containers=1 To 3 ' loop through user containers
                                  ContainerRec=UserRecord.Container(Number.Containers) ' store user container into record
                                  If Rtrim$(ContainerRec.ShortName)=Nul Then ' compare container name length
                                     Outpt="Add container name to slot #"+Mid$(Str$(Number.Containers),2)+"." ' make add message
                                     Call IO.O ' send message
                                     ' routine to get treasure number
                                     Call Find.Treasure(Treasure.Number)
                                     If Treasure.Number>False Then ' check treasure number
                                        If TreasureRecord.Container Then ' check treasure type
                                           ' store container variables
                                           ContainerRec.Closed=TreasureRecord.Closed
                                           ContainerRec.ContainerName=TreasureRecord.TreasureName
                                           ContainerRec.Locked=TreasureRecord.Locked
                                           ContainerRec.Keyed=TreasureRecord.Keyed
                                           ContainerRec.ShortName=TreasureRecord.ShortName
                                           ContainerRec.Permanent=TreasureRecord.Permanent
                                           For Container.Count=1 To 5 ' loop through container contents
                                              ' clear container contents
                                              Call Clear.Container(Container.Count,False)
                                           Next ' end loop through container
                                           UserRecord.Container(Number.Containers)=ContainerRec ' add container record to room
                                           Treasure.Added=True ' set container added flag
                                        Endif ' end check treasure type
                                     Endif ' end check treasure number
                                  Endif ' end check container name length
                               Next ' end loop through user containers
                               If Treasure.Added Then ' check added flag
                                  Outpt="Container(s) added to user." ' make message
                               Else ' check added flag
                                  Outpt="Container not added to user." ' make message
                               Endif ' end check added flag
                               Call IO.O ' display message
                            Case "C" ' change container
                               Outpt="Enter container number(1-3)?" ' get container number
                               Call IO.I ' get input
                               Container.Number=Int(Val(Inpt)) ' store input
                               If Container.Number>=1 And Container.Number<=3 Then ' check container number
                                  ContainerRec=UserRecord.Container(Container.Number) ' store user container into record
                                  If Rtrim$(ContainerRec.ShortName)<>Nul Then ' compare container name length
                                     Call Change.Container(0) ' routine to edit container
                                     UserRecord.Container(Container.Number)=ContainerRec ' store container
                                     Outpt="Container changed." ' make message
                                     Call IO.O ' send message
                                  Endif ' end check container name
                               Endif ' end check container number
                            Case "D" ' delete container
                               Treasure.Deleted=False ' set container deleted flag
                               Outpt="Enter container number(1-3)?" ' get container number
                               Call IO.I ' get input
                               Container.Number=Int(Val(Inpt)) ' store input
                               If Container.Number>=1 And Container.Number<=3 Then ' check container number
                                  ContainerRec=UserRecord.Container(Container.Number) ' store user container into record
                                  If Rtrim$(ContainerRec.ShortName)<>Nul Then ' compare container name length
                                     Call Clear.Container(0,True) ' clear entire container record
                                     UserRecord.Container(Container.Number)=ContainerRec ' clear user container
                                     Treasure.Deleted=True ' reset container deleted flag
                                  Endif ' end compare container in user
                               Endif ' end check container number
                               If Treasure.Deleted Then ' check deleted flag
                                  Outpt="Container deleted from user." ' make message
                               Else ' check added flag
                                  Outpt="Container not deleted from user." ' make message
                               Endif ' end check added flag
                               Call IO.O ' display message
                            Case "L" ' list containers
                               Graphics.Off=True ' reset color
                               Container.Count=False ' reset container count
                               For Number.Containers=1 To 3 ' loop through all user containers
                                  ContainerRec=UserRecord.Container(Number.Containers) ' store user container into record
                                  If Rtrim$(ContainerRec.ShortName)<>Nul Then ' compare container name length
                                     Container.Count=True ' reset count flag
                                     Outpt=Rtrim$(ContainerRec.ContainerName) ' store container name
                                     Mid$(Outpt,1,1)=Ucase$(Mid$(Outpt,1,1)) ' uppercase first letter
                                     Outpt="#"+Mid$(Str$(Number.Containers),2)+":"+Outpt ' store container number
                                     If ContainerRec.Locked>False Then ' check container is locked
                                        Outpt=Outpt+"[locked]" ' append message
                                     Else ' container is not locked
                                        If ContainerRec.Closed>False Then ' check container is closed
                                           Outpt=Outpt+"[closed]" ' append message
                                        Endif ' end check closed container
                                     Endif ' end check locked container
                                     If ContainerRec.Keyed Then ' check container has a key number
                                        Outpt=Outpt+"(#"+Right$(Str$(ContainerRec.Keyed+100000!),5)+")"
                                     Endif ' append key number to container name
                                     Number.Items=False ' reset counter
                                     For Treasure.Number=1 To 5 ' loop through items
                                        Treasure.Item=ContainerRec.Inventory(Treasure.Number) ' store item index
                                        ' compare item range
                                        If Treasure.Item>False And Treasure.Item<=Lof(TreasureFile)/Len(TreasureRecord) Then
                                           Number.Items=Number.Items+1 ' increment counter
                                        Endif ' end check range
                                     Next ' end item loop
                                     Outpt=Outpt+":"+Str$(Number.Items)
                                     If Number.Items=1 Then ' check counter
                                        Outpt=Outpt+" item." ' append message
                                     Else ' check counter
                                        Outpt=Outpt+" items." ' append message
                                     Endif ' end check counter
                                     Call IO.O ' display message
                                  Endif ' end compare container name length
                               Next ' end container count loop
                               If Container.Count=False Then
                                  Outpt="<no containers>" ' make message
                                  Call IO.O ' display message
                               Endif
                            Case "Q" ' quit container menu
                               Exit Do
                            End Select
                         Loop ' end room container loop
                      Case "O" ' option to edit player object inventory
                         Do ' loop through object inventory edit menu
                            Graphics.Off=False ' reset color
                            Outpt="Object inventory options:" ' make message
                            Call IO.O ' send message
                            Graphics.Off=True ' reset color
                            Outpt="[A]dd" ' make display message
                            Call IO.O ' send message
                            Outpt="[D]elete" ' make display message
                            Call IO.O ' send message
                            Outpt="[L]ist" ' make display message
                            Call IO.O ' send message
                            Graphics.Off=False ' reset color
                            Outpt="Object inventory edit option(q to quit)? "
                            No.Input.Out="Q" ' default input
                            Call IO.I ' get user input
                            ' selection of object edit
                            Select Case Ucase$(Inpt)
                            Case "A" ' option to add object
                               Object.Added=False ' object added flag
                               ' routine to get object
                               Call Find.Objects(Object.Number)
                               ' check object number
                               If Object.Number>False Then
                                  Call Add.Object(Object.Number,Object.Added)
                               Endif ' end check object number range
                               If Object.Added Then ' check object added flag
                                  Outpt="Object added to inventory." ' message
                               Else ' check added flag
                                  Outpt="Object not added to inventory."
                               Endif ' end check object added flag
                               Call IO.O ' send message
                            Case "D" ' option to delete object from inventory
                               Outpt="Number to delete" ' range prompt
                               Call Get.Range2(0,20,Object.Number) ' get number
                               If Object.Number>False Then ' check number bounds
                                  ' check object
                                  If UserRecord.Object(Object.Number)>False Then
                                     Call Discard.Inventory.Object(Object.Number)
                                     Outpt="Object deleted from inventory."
                                     Call IO.O ' send message
                                  Else ' check object
                                     Outpt="Object not deleted from inventory."
                                     Call IO.O ' send message
                                  Endif ' end check object number range
                               Endif ' end check number bounds
                            Case "L"
                               Objects.Count=False ' reset count flag
                               Graphics.Off=True ' reset color
                               ' loop through player objects
                               For Object.Index=1 To 20
                                  ' store object
                                  Object.Number=UserRecord.Object(Object.Index)
                                  ' check object number
                                  If Object.Number>False And _
                                  Object.Number<=Lof(ObjectFile)/Len(ObjectRecord) Then
                                     ' increment counter
                                     Objects.Count=True
                                     ' read object
                                     Call Read.Record(ObjectFile,Object.Number)
                                     ' store
                                     Object.Name$=ObjectRecord.ObjectName
                                     ' lowercase name
                                     Object.Name$=Lcase$(Object.Name$)
                                     Outpt="["+Mid$(Str$(Object.Index),2)+"]"+ _
                                     Object.Name$
                                     Call IO.O ' send object  name message
                                  Endif ' end check object number range
                               Next ' end loop through player object inventory
                               If Objects.Count Then ' check objects counted
                                  Call More.Prompt ' display more prmpt
                               Else ' check objects counted
                                  Outpt="<no objects>" ' make display message
                                  Call IO.O ' display message
                               Endif ' end objects counted
                            Case "Q" ' option to exit inventory object menu
                               Exit Do ' exit inventory object edit menu
                            End Select ' end selection of object edit option
                         Loop ' end loop through player object inventory menu
                      Case "T" ' option to edit player treasure inventory
                         Do ' loop through treasure inventory edit menu
                            Graphics.Off=False ' reset color
                            Outpt="Treasure inventory options:" ' message
                            Call IO.O ' send message
                            Graphics.Off=True ' reset color
                            Outpt="[A]dd" ' make message
                            Call IO.O ' send message
                            Outpt="[D]elete" ' make message
                            Call IO.O ' send message
                            Outpt="[L]ist" ' make message
                            Call IO.O ' send message
                            Graphics.Off=False ' reset color
                            Outpt="Treasure inventory edit option(q to quit)? "
                            No.Input.Out="Q" ' default input
                            Call IO.I ' get user input
                            Select Case Ucase$(Inpt) ' selection of option
                            Case "A" ' option to add inventory treasure
                               Treasure.Added=False ' treasure added flag
                               ' routine to get number
                               Call Find.Treasure(Treasure.Number)
                               If Treasure.Number>False Then ' check number
                                  ' check treasure type
                                  If TreasureRecord.Container=False Then
                                     Call TreasureCharges(Treasure.Charges)
                                     Call Add.Inventory(Treasure.Number, _
                                     Treasure.Charges,Treasure.Added)
                                  Endif ' end check treasure type
                               Endif ' end check treasure number
                               ' check treasure added flag
                               If Treasure.Added Then
                                  Outpt="Treasure added to inventory."
                               Else ' check flag
                                  Outpt="Treasure not added to inventory."
                               Endif ' end check added flag
                               Call IO.O ' send message
                            Case "D" ' option to delete treasure number
                               Outpt="Number to delete" ' range prompt
                               Call Get.Range2(0,20,Treasure.Number) ' get number
                               If Treasure.Number>False Then ' check number bounds
                                  ' check treasure index
                                  If UserRecord.Inv(Treasure.Number)>False Then
                                     If User.Number=User.Index Then ' check user
                                        ' discard online user treasure
                                        Call Discard.Inventory(Treasure.Number,True)
                                     Else ' check user
                                        ' discard offline user treasure
                                        Call Discard.Inventory.Treasure(Treasure.Number)
                                     Endif ' end check user
                                     Outpt="Treasure deleted from inventory."
                                     Call IO.O ' send message
                                  Else ' end check number range
                                     Outpt="Treasure not deleted from inventory."
                                     Call IO.O ' send message
                                  Endif ' end check deleted flag
                               Endif ' end check number bounds
                            Case "L"
                               Treasure.Counted=False ' reset counter
                               Graphics.Off=True ' reset color
                               ' loop through inventory
                               For Treasure.Index=1 To 20
                                  ' store number
                                  Treasure.Number=UserRecord.Inv(Treasure.Index)
                                  ' check number
                                  If Treasure.Number>False And _
                                  Treasure.Number<=Lof(TreasureFile)/Len(TreasureRecord) Then
                                     ' increment counter
                                     Treasure.Counted=True
                                     ' get name
                                     Call Read.Record(TreasureFile,Treasure.Number)
                                     Treasure.Name$=TreasureRecord.TreasureName
                                     ' lowercase name
                                     Treasure.Name$=Lcase$(Treasure.Name$)
                                     Outpt="["+Mid$(Str$(Treasure.Index),2)+"]"+ _
                                     Treasure.Name$
                                     Call IO.O ' send message
                                  Endif ' end check treasure number range
                               Next ' end loop through inventory treasure
                               If Treasure.Counted Then ' check counter
                                  Call More.Prompt ' display more prompt
                               Else ' check counter
                                  Outpt="<no treasure>" ' make message
                                  Call IO.O ' display message
                               Endif ' end check treasure counted
                            Case "Q" ' option to exit inventory treasure edit
                               Exit Do ' exit inventory treasure edit menu
                            End Select ' end selection of treasure edit option
                         Loop ' end loop through treasure edit menu
                      Case "Q" ' option to exit player inventory edit menu
                         Exit Do ' exit player inventory edit menu
                      End Select ' end selection of inventory menu option
                   Loop ' end loop through player inventory edit menu
                Case "X" ' option to change player special class
                   Do ' loop through special class edit menu
                      Graphics.Off=True ' reset color
                      Outpt="[A]Town Mayor" ' make display message
                      Call IO.O ' send message
                      Outpt="[B]Governor" ' make display message
                      Call IO.O ' send message
                      Outpt="[C]Guild Master" ' make display message
                      Call IO.O ' send message
                      Outpt="[D]Sysop" ' make display message
                      Call IO.O ' send message
                      Outpt="[E]None" ' make display message
                      Call IO.O ' send message
                      Graphics.Off=False ' reset color
                      Outpt="Special class option(q to quit)? " ' input prompt
                      No.Input.Out="Q" ' default input
                      Call IO.I ' get user input
                      Select Case Ucase$(Inpt) ' selection of special class
                      Case "A" ' option for special class
                         UserRecord.Flags=UserRecord.Flags Or Special.Char1
                         Outpt="Player is now town mayor." ' make message
                         Call IO.O ' send message
                      Case "B" ' option for special class
                         UserRecord.Flags=UserRecord.Flags Or Special.Char2
                         Outpt="Player is now governor." ' make message
                         Call IO.O ' send message
                      Case "C" ' option for special class
                         UserRecord.Flags=UserRecord.Flags Or Special.Char3
                         Outpt="Player is now guild master." ' make message
                         Call IO.O ' send message
                      Case "D" ' option for special class
                         UserRecord.Flags=UserRecord.Flags Or Special.Char4
                         Outpt="Player is now sysop." ' make message
                         Call IO.O ' send message
                      Case "E" ' option to clear special class
                         UserRecord.Flags=UserRecord.Flags And Not _
                         Special.Char1
                         UserRecord.Flags=UserRecord.Flags And Not _
                         Special.Char2
                         UserRecord.Flags=UserRecord.Flags And Not _
                         Special.Char3
                         UserRecord.Flags=UserRecord.Flags And Not _
                         Special.Char4
                         Outpt="Player is cleared of special character class."
                         Call IO.O ' send message
                      Case "Q" ' option to exit special class menu
                         Exit Do ' exit special class menu
                      End Select ' end selection of special class option
                   Loop ' end loop through special class option menu
                Case "Y" ' option to customize player's training rooms
                   Do ' loop through special class edit menu
                      Graphics.Off=False ' reset color
                      Outpt="Custom training room menu:" ' output message
                      Call IO.O ' send output
                      Graphics.Off=True ' reset color
                      For Train.Count=1 To 10 ' display all classnames
                         Inpt=Chr$(Train.Count+64) ' store letter output
                         ' make class display message
                         Outpt="["+Inpt+"]"+ _
                         Rtrim$(Class.Name(Train.Count))+" room number:"
                         ' store training room value
                         Train.Temp!=UserRecord.TrainRoom(Train.Count)
                         If Train.Temp!=SFalse Then ' compare value
                            Outpt=Outpt+" <none>" ' append message
                         Else ' compare value
                            Outpt=Outpt+Str$(Train.Temp!)+"." ' append message
                         Endif ' end compare value
                         Call IO.O ' send message
                      Next ' end loop through training room array
                      Outpt="[R]eset rooms" ' make output
                      Call IO.O ' send output
                      Graphics.Off=False ' reset color
                      Outpt="Training room option(q to quit)? " ' input prompt
                      No.Input.Out="Q" ' default input
                      Call IO.I ' get user input
                      Inpt=Ucase$(Inpt) ' uppercase input
                      Select Case Inpt ' selection of special class
                      Case "R" ' option for rooms reset
                         Outpt="Reset training rooms(y/n)? " ' message
                         Call IO.I ' get response
                         If Yes Then ' check response
                            ' reset training rooms
                            UserRecord.TrainRoom(1)=36
                            UserRecord.TrainRoom(2)=4
                            UserRecord.TrainRoom(3)=123
                            UserRecord.TrainRoom(4)=163
                            UserRecord.TrainRoom(5)=162
                            UserRecord.TrainRoom(6)=426
                            UserRecord.TrainRoom(7)=421
                            UserRecord.TrainRoom(8)=417
                            UserRecord.TrainRoom(9)=1
                            UserRecord.TrainRoom(10)=1
                            Outpt="Training rooms reset." ' message
                            Call IO.O ' send message
                         Endif ' end check response
                      Case "Q" ' exit training room loop
                         Exit Do ' exit special class menu
                      Case Else ' check response
                         If Inpt>="A" And Inpt<="J" Then ' check response range
                            Train.Count=Asc(Inpt)-64 ' convert to number
                            Outpt="Enter 0 for auto-train." ' make message
                            Call IO.O ' send output
                            Graphics.Off=True ' reset color
                            ' make class range prompt
                            Outpt="["+Mid$(Str$(Train.Count),2)+"]"+ _
                            Rtrim$(Class.Name(Train.Count))+" room number"
                            ' return number from range
                            Max.Rooms!=Lof(RoomFile)/Len(RoomRecord)
                            Call Get.Room.Range2(0!,Max.Rooms!,Train.Number!)
                            UserRecord.TrainRoom(Train.Count)=Train.Number!
                         Endif ' end check input
                      End Select ' end selection of special class option
                   Loop ' end loop for training rooms
                Case "Q" ' option to exit player edit menu
                   Exit Do ' exit player edit menu
                End Select ' end selection of player edit option
             Loop ' end loop through player edit menu
             Call Share.Record(UserFile,User.Number) ' write user record
          Endif ' end check user found flag
          Call Read.Record(UserFile,User.Index)
    Case "L" ' option to list user file
       Do ' loop through user file list menu
          Graphics.Off=True ' reset color
          Outpt="[L]ist" ' make display message
          Call IO.O ' send message
          Outpt="[T]op ten" ' make display message
          Call IO.O ' send message
          Outpt="[U]sers" ' make display message
          Call IO.O ' send message
          Graphics.Off=False ' reset color
          Outpt="User list option(q to quit)? " ' make input prompt
          No.Input.Out="Q" ' default input
          Call IO.I ' get user input
          Select Case Ucase$(Inpt) ' selection of user list option
          Case "L" ' option to list range of user numbers
             Outpt="Enter range:" ' make display message
             Call IO.O ' send message
             Max.Users=Lof(UserFile)/Len(UserRecord) ' store length of file
             ' routine to get range of numbers
             Call Get.Range(Max.Users,User.List1,User.List2)
             ' loop through range of user numbers
             Allow.Break=True ' set allow break flag
             Break=False ' reset control-k flag
             Continue=False ' set continuous flag
             For User.Count=User.List1 To User.List2
                Call Read.Record(UserFile,User.Count) ' read user file
                Code.Name$=UserRecord.CodeName ' store user codename
                Call Decrypt(Code.Name$) ' decrypt codename
                If Left$(Code.Name$,9)<>Deleted$ Then ' check deleted codename
                   Call Display.User(User.Count) ' routine to display user
                   If Break Then ' check control-k flag
                      Exit For ' exit display loop
                   Endif ' end check control-k
                   If Continue=False Then ' check continuous flag
                      Call More.Prompt ' routine to pause
                      If No Then ' check input pause response
                         Exit For ' exit user list loop
                      Endif ' end check user input
                   Endif ' end check continuous flag
                Endif '  end check deleted codename
             Next ' end loop through user numbers
             Allow.Break=False ' reset allow break flag
             If Break Then ' check control-k flag
                Break=False ' reset control-k flag
                Outpt=Nul ' set output to null
                Call IO.O ' send empty return
             Endif ' end check control-k flag
          Case "T" ' option to list top ten report
             Call Top.Ten ' routine for top ten
          Case "U" ' option to list user report
             Call User.List ' routine for user report
          Case "Q" ' option to exit user list menu
             Exit Do ' exit user list menu
          End Select ' end selection of user list option
       Loop ' end loop through user list menu
       Call Read.Record(UserFile,User.Index)
    Case "U" ' option to update user file
       If Local.Mode=False Then ' check local sysop online
          Outpt="Remote DMs cannot update users." ' make message
          Call IO.O ' send error message
       Else ' check local sysop
          Outpt="Delete "+Dead$+" users(y/n)? " ' make input prompt
          No.Input.Out="Y" ' default input
          Call IO.I ' get user input
          Delete.Dead.Users=Yes ' store input response
          Outpt="Delete users before date(y/n)? " ' make input prompt
          No.Input.Out="N" ' default input
          Call IO.I ' get user input
          Delete.By.Date=Yes ' store user input response
          If Delete.By.Date Then ' check date update response
             Outpt="Enter date(form: MM-DD-YYYY)? " ' make input prompt
             No.Input.Out="01-01-1980" ' default input
             Call IO.I ' get user input
             ' convert input to serial date format
             Delete.Date#=Int(DateValue(Inpt))
          Endif ' end check date update response
          Graphics.Off=False ' reset color
          Outpt="Updating userfile.." ' make display message
          Call IO.O ' send message
          Users.Deleted=False ' reset counter
          For User.Count=1 To Lof(UserFile)/Len(UserRecord) ' loop through users
             Call Read.Record(UserFile2,User.Count) ' read next user file record
             Code.Name$=UserRecord2.CodeName ' store user codename
             Call Decrypt(Code.Name$) ' decrypt codename
             Delete.User.Flag=False ' delete user flag
             If Left$(Code.Name$,Len(Deleted$))<>Deleted$ Then ' check already deleted
                If Delete.Dead.Users Then ' check update flag
                   If UserRecord2.Level=False Then ' compare player level
                      Delete.User.Flag=True ' set delete user flag
                   Endif ' end compare player level
                   If Left$(Code.Name$,Len(Dead$))=Dead$ Then ' compare dead player
                      Delete.User.Flag=True ' set delete user flag
                   Endif ' end compare dead player
                Endif ' end check update flag
                If Delete.By.date Then ' check date update flag
                   Inpt=UserRecord2.DateOn ' store player last date online
                   Call Decrypt(Inpt) ' decrypt date
                   ' calculate date differences
                   If Int(DateValue(Inpt))<Delete.Date# Then
                      Delete.User.Flag=True ' set delete user flag
                   Endif ' end calculate dates
                Endif ' end check date update flag
             Endif ' end check deleted user
             If Delete.User.Flag Then ' check delete user flag
                If User.Count<>User.Index Then ' check to current user
                   Users.Deleted=Users.Deleted+1 ' increment counter
                   Call Delete.User ' routine to clear user record
                   Call Share.Record(UserFile2,User.Count) ' write user record
                Endif ' end check current user
             Endif ' end check delete user flag
          Next ' end loop through user file
          If Users.Deleted=False Then ' check counter
             Outpt="No users deleted." ' make message
          Else ' check counter
             If Users.Deleted=1 Then ' compare counter
                Outpt="1 user deleted." ' make message
             Else ' check counter
                Outpt=Mid$(Str$(Users.Deleted),2)+" users deleted." ' message
             Endif ' check counter
          Endif ' end check counter
          Call IO.O ' display message
          Call Read.Record(UserFile,User.Index) ' restore current user
       Endif ' end check local sysop
    Case "Q" ' option to exit user edit menu
       Exit Do ' exit user edit menu
    End Select ' end selection of user edit option
 Loop ' end loop through user edit menu options
End Sub ' end routine to edit user file

 Rem * routine to find user.
 Rem * output variables:
 Rem *   User.Found  -  true if user found
 Rem *   User.Number  -  user index

Sub Find.User(User.Found,User.Number)
 On Local Error Resume Next
 Graphics.Off=False ' reset color
 Outpt="Codename, or number" ' make input prompt
 Outpt=Outpt+"(1-"+Mid$(Str$(Lof(UserFile)/Len(UserRecord)),2)+")? "
 No.Input.Out="1" ' default input
 Call IO.I ' get user input
 Call Parse.Num(Inpt,Parse.Value) ' routine to parse pound sign
 Inpt=Ucase$(Inpt) ' uppercase input
 Parse.Number=False ' reset counter
 User.Found=False ' reset user found flag
 Input.Length=Len(Inpt) ' store length of input
 For User.Number=1 To Lof(UserFile)/Len(UserRecord) ' loop through user file
    Call Read.Record(UserFile,User.Number) ' read user file
    Code.Name$=UserRecord.CodeName ' store user codename
    Call Decrypt(Code.Name$) ' decrypt codename
    ' compare codename to input
    If Left$(Code.Name$,Input.Length)=Inpt Then
       Parse.Number=Parse.Number+1 ' increment counter
       ' compare counters
       If Parse.Value=False Or Parse.Number=Parse.Value Then
          User.Found=True ' set user found flag
          Exit For ' exit user loop
       Endif ' end compare counters
    Endif ' end compare codename
 Next ' end loop through users
 If User.Found=False Then ' check user found flag
    User.Number=Int(Val(Inpt)) ' convert input to integer
    ' check bounds
    If User.Number>False And User.Number<=Lof(UserFile)/Len(UserRecord) Then
       User.Found=True ' set user found flag
    Endif ' end check file bounds
 Endif ' end check user flag
 If User.Found=False Then ' check user found flag
    Outpt="Codename not found." ' make not found message
    Call IO.O ' send message
 Endif ' end check user found flag
 If User.Found Then ' check user found flag
    Call Read.Record(UserFile,User.Number) ' read user record
    Code.Name$=UserRecord.CodeName ' store codename
    Call Decrypt(Code.Name$) ' decrypt codename
    If Left$(Code.Name$,9)=Deleted$ Then ' compare deleted codename
       Outpt="Deleted user record." ' make deleted user message
       Call IO.O ' send message
       User.Found=False ' reset flag
    Endif ' end check delete codename
 Endif ' end check user found
End Sub
