 Rem * Filename: dnds1.bas Version: v5.0a r1.0a
 Rem * This subprogram contains most display and find routines.

 Rem $Include: 'dnddoor.inc'

 Rem * This routines displays information of the action file.
 Rem * input variables:
 Rem *   Number - the room file record.

Sub Display.Action(Number)
 On Local Error Resume Next ' local error resume
 If Number<=False Then ' check number
    Exit Sub ' exit subroutine
 Endif ' end check number
 Graphics.Off=False ' reset color
 Outpt="Action number"+Str$(Number)+":" ' action number message
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 If ActionRecord.MonsterTrigger Then ' check action trigger
    ' get monster trigger record
    Call Read.Record(MonsterFile,ActionRecord.MonsterTrigger)
    Outpt=MonsterRecord.MonsterName ' store monster name
    Outpt=Rtrim$(Outpt) ' trim name
    Inpt=Str$(ActionRecord.MonsterTrigger)+", "+Outpt+"." ' make message
 Else ' check trigger
    Inpt=" <none>" ' make default message
 Endif ' end check trigger
 Outpt="[A]Monster trigger in effect for monster:"+Inpt ' make message
 Call IO.O ' send output message
 If ActionRecord.SpellTrigger Then ' check action trigger
    Call Read.Record(SpellFile,ActionRecord.SpellTrigger) ' get spell record
    Outpt=SpellRecord.SpellName ' store spell name
    Outpt=Rtrim$(Outpt) ' trim name
    Inpt=Str$(ActionRecord.SpellTrigger)+", "+Outpt+"." ' make message
 Else ' check trigger
    Inpt=" <none>" ' make default message
 Endif ' end check trigger
 Outpt="[B]Spell trigger in effect for spell:"+Inpt
 Call IO.O ' send output message
 If ActionRecord.MonsterTalk Then ' check action trigger
    Call Read.Record(MonsterFile,ActionRecord.MonsterTalk) ' get monster record
    Outpt=MonsterRecord.MonsterName ' store monster name
    Outpt=Rtrim$(Outpt) ' trim name
    Inpt=Str$(ActionRecord.MonsterTalk)+", "+Outpt+"." ' make message
 Else ' check trigger
    Inpt=" <none>" ' make default message
 Endif ' end check trigger
 Outpt="[C]Monster talk trigger in effect for monster:"+Inpt ' make message
 Call IO.O ' send output message
 If ActionRecord.Level>False Then ' check action trigger
    Inpt=Str$(ActionRecord.Level) ' make message
 Else ' check trigger
    Inpt=" <none>" ' make default message
 Endif ' end check trigger
 Outpt="[D]High level room entry:"+Inpt ' message
 If ActionRecord.Level<False Then ' check action trigger
    Inpt=Str$(Abs(ActionRecord.Level)) ' make message
 Else ' check trigger
    Inpt=" <none>" ' make default message
 Endif ' end check trigger
 Outpt=Outpt+", Low level room entry:"+Inpt ' message
 Call IO.O ' send output message
 Outpt="Restricted room directions:" ' make message
 Call IO.O ' send output message
 If ActionRecord.Restrictions>False Then ' check action trigger
    Outpt=Nul ' reset message
    For Direction.Number=1 To 12 ' loop through directions
       ' check restriction trigger
       If ActionRecord.Restrictions And 2^Direction.Number Then
          Outpts=Direction(Direction.Number) ' make direction name
          Outpt=Outpt+Outpts+", " ' append direction
       Endif ' end check trigger
    Next ' end loop
    If ActionRecord.Restrictions And 2^13 Then ' check restriction trigger
       Outpt=Outpt+"enter portal, " ' append message
    Endif ' end check trigger
    If Len(Outpt) Then ' check string length
       Outpt=Left$(Outpt,Len(Outpt)-2) ' truncate comma
    Endif ' end check string length
 Else ' check trigger
    Outpt="<none>" ' default message
 Endif ' end check trigger
 Call IO.O ' send output message
 Outpt="[E]Action hits for:"
 Select Case ActionRecord.HitPoints ' check action trigger
 Case Is>False
    Inpt=Str$(ActionRecord.HitPoints)+" fatigue" ' make message
 Case Is<False
    Inpt=Str$(Abs(ActionRecord.HitPoints))+" vitality" ' make message
 Case Else ' check trigger
    Inpt=" <none>" ' default message
 End Select ' end check trigger
 Outpt=Outpt+Inpt
 Call IO.O ' send output message
 If ActionRecord.EncounterRate Then ' check action trigger
    Inpt=Str$(ActionRecord.EncounterRate) ' make message
 Else ' check trigger
    Inpt=" <none>" ' default message
 Endif ' end check trigger
 Outpt="[F]Encounter rate:"+Inpt
 If ActionRecord.HealthRate Then ' check action trigger
    Inpt=Str$(ActionRecord.HealthRate) ' make message
 Else ' check trigger
    Inpt=" <none>" ' default message
 Endif ' end check trigger
 Outpt=Outpt+", Health rate:"+Inpt
 Call IO.O ' send output message
 Outpt="[G]Inventory: "
 Select Case ActionRecord.Inventory ' make selection of inventory actions
 Case 1 ' weapon action
    Inpt="breaks weapons" ' make message
 Case 2 ' shield action
    Inpt="smashes shields" ' make message
 Case 3 ' armor action
    Inpt="wrecks armor" ' make message
 Case 4 ' magic item action
    Inpt="drains magic items" ' make message
 Case Else ' check trigger
    Inpt="<none>"
 End Select ' end selection of inventory actions
 Outpt=Outpt+Inpt
 Call IO.O
 If ActionRecord.Fumble Then ' check action trigger
    Outpt="[H]Action fumbles." ' make message
 Else ' check trigger
    Outpt="[H]Action does not fumble." ' make message
 Endif ' end check trigger
 Call IO.O ' send output message
 If ActionRecord.Teleport Then ' check action trigger
    Outpt="[I]Action teleports to room"+Str$(ActionRecord.Teleport)+"."
 Else ' check trigger
    Outpt="[I]Action does not teleport." ' make message
 Endif ' end check trigger
 Call IO.O ' send output message
 If ActionRecord.RustRate Then ' check action trigger
    Inpt=Str$(ActionRecord.RustRate) ' make message
 Else ' check trigger
    Inpt=" <none>" ' default message
 Endif ' end check trigger
 Outpt="[J]Action has weapon rusting rate of"+Inpt+" rounds." ' message
 Call IO.O ' send output message
 If ActionRecord.StealRate Then ' check action trigger
    Inpt=Str$(ActionRecord.StealRate) ' make message
 Else ' check trigger
    Inpt=" <none>" ' default message
 Endif ' end check trigger
 Outpt="[K]Action has monster stealing rate of"+Inpt+" rounds." ' message
 Call IO.O ' send output message
 Outpt="[L]Action attributes: " ' make edit display message
 If ActionRecord.Attribute1=LitRoom Then ' check attribute
    Outpt=Outpt+"Lit" ' append attribute message
 Else ' check attribute
    If ActionRecord.Attribute1=UnLitRoom Then ' check attribute
       Outpt=Outpt+"Unlit" ' append attribute message
    Endif ' end check attribute
 Endif ' end check attribute
 Outpt=Outpt+", " ' append comma
 Select Case ActionRecord.Attribute2 ' select attribute
 Case Land ' check attribute
    Outpt=Outpt+"Land" ' append attribute message
 Case Air ' check attribute
    Outpt=Outpt+"Air" ' append attribute message
 Case Water ' check attribute
    Outpt=Outpt+"Water" ' append attribute message
 End Select ' end select attribute
 Call IO.O ' send attribute message
 Outpt="[X]Clear action" ' make alternate display message
 Call IO.O ' send alternate display message
End Sub

 Rem * This routines displays information on the monster file.
 Rem * input variables:
 Rem *   Number - the monster file record.

Sub Display.Monster(Number)
 On Local Error Resume Next ' local error resume
 If Number<=False Then ' check number
    Exit Sub ' exit subroutine
 Endif ' end check number
 Graphics.Off=False ' reset color
 Outpt="Monster number"+Str$(Number)+":" ' monster number message
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 Outpt="[A]Monster name: "+Rtrim$(MonsterRecord.MonsterName) ' message
 Call IO.O ' send output message
 Outpt="[B]Plural of monster name: "+MonsterRecord.PluralName ' message
 Call IO.O ' send output message
 Outpt="[C]Monster level:"+Str$(MonsterRecord.Level) ' message
 Call IO.O ' send output message
 Outpt="[D]Magical monster: " ' message
 If MonsterRecord.Magic Then ' verify monster
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[E]Hit points:"+Str$(MonsterRecord.Hits) ' message
 Call IO.O ' send output message
 Outpt="[F]Experience points:"+Str$(MonsterRecord.Experience) ' message
 Call IO.O ' send output message
 Outpt="[G]Gold points:"+Str$(MonsterRecord.Gold) ' message
 Call IO.O ' send output message
 Outpt="[H]Number appearing:"+Str$(MonsterRecord.NumberAppearing) ' message
 Call IO.O ' send output message
 Outpt="[I]Poisonous monster: " ' message
 If MonsterRecord.Poison Then ' verify monster
    Outpt=Outpt+"Yes("+Mid$(Str$(MonsterRecord.PoisonPercent),2)+ _
    " percent)" ' message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[J]Level draining monster: " ' message
 If MonsterRecord.LevelDrain Then ' verify monster
    Outpt=Outpt+"Yes("+Mid$(Str$(MonsterRecord.DrainPercent),2)+ _
    " percent)" ' message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[K]Monster blocks exits: " ' message
 If MonsterRecord.Block Then ' verify monster
    Outpt=Outpt+"Yes("+Mid$(Str$(MonsterRecord.BlockPercent),2)+ _
    " percent)" ' message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[L]Monster prevents treasure take: " ' message
 If MonsterRecord.Prevent Then ' verify monster
    Outpt=Outpt+"Yes("+Mid$(Str$(MonsterRecord.PreventPercent),2)+ _
    " percent)" ' message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[M]Monster follows player: " ' message
 If MonsterRecord.Follow Then ' verify monster
    Outpt=Outpt+"Yes("+Mid$(Str$(MonsterRecord.FollowPercent),2)+ _
    " percent)("+Mid$(Str$(MonsterRecord.Teleport),2)+"% teleport)"
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[N]Monster casts spells: " ' message
 Spell.Number=MonsterRecord.Spell ' store spell number
 If Spell.Number=False Then ' verify monster
    Outpt=Outpt+"No" ' add to message
 Else ' verify
    ' file bounds
    If Spell.Number>False And _
    Spell.Number<=Lof(SpellFile)/Len(SpellRecord) Then
       Call Read.Record(SpellFile,Spell.Number) ' get spell record
       Outpt=Outpt+"Yes, "+Rtrim$(SpellRecord.SpellName)+ _
       "("+Mid$(Str$(MonsterRecord.SpellPercent),2)+" percent)" ' message
    Endif ' end check file bounds
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[O]Monster jails attacker: " ' message
 If MonsterRecord.Jail Then ' verify monster
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[P]Encounter rate:"
 If MonsterRecord.Rate=False Then ' verify rate
    Outpt=Outpt+" No"
 Else ' verify rate
    Outpt=Outpt+Str$(MonsterRecord.Rate)+ _
    " ("+Mid$(Str$(MonsterRecord.RatePercent),2)+" percent)" ' message
 Endif ' end verify rate
 Call IO.O ' send output message
 Outpt="[R]Permanent monster: " ' message
 If MonsterRecord.Permanent Then ' verify monster
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[S]Monster uses psionics: " ' message
 If MonsterRecord.Psionic=False Then ' verify monster
    Outpt=Outpt+"No" ' add to message
 Else ' verify
    Spell.Number=MonsterRecord.PsionicSpell ' store psionic spell number
    ' file bounds
    If Spell.Number>False And _
    Spell.Number<=Lof(SpellFile)/Len(SpellRecord) Then
       Call Read.Record(SpellFile,Spell.Number) ' get spell record
       Outpt=Outpt+"Yes, "+SpellRecord.SpellName ' message
    Endif ' end check file bounds
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[T]Inventory:" ' message
 Number.Items=False ' reset counter
 For Array.Number=1 To 5 ' loop through monster treasure
    ' get monster treasure number
    Treasure.Number=MonsterRecord.Treasure(Array.Number)
    ' check file bounds
    If Treasure.Number>False And _
    Treasure.Number<=Lof(TreasureFile)/Len(TreasureRecord) Then
       Number.Items=Number.Items+1 ' increment counter
    Endif ' end check file bounds
 Next ' end loop through monster treasure
 If Number.Items=1 Then ' check value
    Outpt=Outpt+Str$(Number.Items)+" item." ' make display message
 Else ' check value
    Outpt=Outpt+Str$(Number.Items)+" items." ' make display message
 Endif ' end check value
 Call IO.O ' send output message
End Sub ' end routine

 Rem * This routines displays information on the monster class file.
 Rem * input variables:
 Rem *   Number - the monster class file record.

Sub Display.Monster.Class(Number)
 On Local Error Resume Next ' local error resume
 If Number<=False Then ' check number
    Exit Sub ' exit subroutine
 Endif ' end check number
 Graphics.Off=False ' reset color
 Outpt="Monster class number"+Str$(Number)+":"
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 For Array.Number=1 To 10 ' loop through the monster classes
    ' get monster number in class
    Monster.Index=MonclassRecord.Monsters(Array.Number)
    ' file bounds
    If Monster.Index>False And _
    Monster.Index<=Lof(MonsterFile)/Len(MonsterRecord) Then
       Call Read.Record(MonsterFile,Monster.Index) ' get monster record
       Outpt="Monster number"+Str$(Array.Number)+":"+ _
       Rtrim$(MonsterRecord.MonsterName) ' make display message
       Call IO.O ' send output message
    Endif ' end check file bounds
 Next ' end loop through monster class
End Sub ' end routine to display monster class

 Rem * This routines displays information on the nonplayer file.
 Rem * input variables:
 Rem *   Number - the nonplayer file record.

Sub Display.Nonplayer(Number)
 On Local Error Resume Next ' local error resume
 If Number<=False Then ' check number
    Exit Sub ' exit subroutine
 Endif ' end check number
 Graphics.Off=False ' reset color
 Outpt="Nonplayer number"+Str$(Number)+":" ' nonplayer number message
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 Outpt="[A]Nonplayer name: "+Rtrim$(MonsterRecord.MonsterName) ' message
 Call IO.O ' send output message
 Outpt="[B]Nonplayer rooms: "+MonsterRecord.PluralName ' message
 Call IO.O ' send output message
 Outpt="[C]Nonplayer level:"+Str$(MonsterRecord.Level) ' message
 Call IO.O ' send output message
 Outpt="[D]Hit points:"+Str$(MonsterRecord.Hits) ' message
 Call IO.O ' send output message
 Outpt="[E]Experience points:"+Str$(MonsterRecord.Experience) ' message
 Call IO.O ' send output message
 Outpt="[F]Gold points:"+Str$(MonsterRecord.Gold) ' message
 Call IO.O ' send output message
 Outpt="[G]Poisonous nonplayer: " ' message
 If MonsterRecord.Poison Then ' verify nonplayer
    Outpt=Outpt+"Yes("+Mid$(Str$(MonsterRecord.PoisonPercent),2)+ _
    " percent)" ' message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[H]Level draining nonplayer: " ' message
 If MonsterRecord.LevelDrain Then ' verify nonplayer
    Outpt=Outpt+"Yes("+Mid$(Str$(MonsterRecord.DrainPercent),2)+ _
    " percent)" ' message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[I]Nonplayer blocks exits: " ' message
 If MonsterRecord.Block Then ' verify nonplayer
    Outpt=Outpt+"Yes("+Mid$(Str$(MonsterRecord.BlockPercent),2)+ _
    " percent)" ' message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[J]Nonplayer prevents treasure take: " ' message
 If MonsterRecord.Prevent Then ' verify nonplayer
    Outpt=Outpt+"Yes("+Mid$(Str$(MonsterRecord.PreventPercent),2)+ _
    " percent)" ' message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[K]Nonplayer follows player: " ' message
 If MonsterRecord.Follow Then ' verify nonplayer
    Outpt=Outpt+"Yes("+Mid$(Str$(MonsterRecord.FollowPercent),2)+ _
    " percent)("+Mid$(Str$(MonsterRecord.Teleport),2)+"% teleport)" ' message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[L]Nonplayer casts spells: " ' message
 Spell.Number=MonsterRecord.Spell ' store spell number
 If Spell.Number=False Then ' verify nonplayer
    Outpt=Outpt+"No" ' add to message
 Else ' verify
    ' file bounds
    If Spell.Number>False And _
    Spell.Number<=Lof(SpellFile)/Len(SpellRecord) Then
       Call Read.Record(SpellFile,Spell.Number) ' get spell record
       Outpt=Outpt+"Yes, "+Rtrim$(SpellRecord.SpellName)+"("+ _
       Mid$(Str$(MonsterRecord.SpellPercent),2)+" percent)" ' message
    Endif ' end check file bounds
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[M]Nonplayer jails attacker: " ' message
 If MonsterRecord.Jail Then ' verify nonplayer
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[N]Encounter rate:"
 If MonsterRecord.Rate=False Then ' verify rate
    Outpt=Outpt+" No"
 Else ' verify rate
    Outpt=Outpt+Str$(MonsterRecord.Rate)+ _
    "("+Mid$(Str$(MonsterRecord.RatePercent),2)+" percent)" ' message
 Endif ' end verify rate
 Call IO.O ' send output message
 Outpt="[O]Nonplayer uses psionics: " ' message
 If MonsterRecord.Psionic=False Then ' verify nonplayer
    Outpt=Outpt+"No" ' add to message
 Else ' verify
    Spell.Number=MonsterRecord.PsionicSpell ' store psionic spell number
    ' file bounds
    If Spell.Number>False And _
    Spell.Number<=Lof(SpellFile)/Len(SpellRecord) Then
       Call Read.Record(SpellFile,Spell.Number) ' get spell record
       Outpt=Outpt+"Yes, "+SpellRecord.SpellName ' message
    Endif ' end check file bounds
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[P]Carries treasure:" ' message
 Call IO.O ' send output message
 For Array.Number=1 To 5 ' loop through nonplayer treasure
    ' get nonplayer treasure number
    Treasure.Number=MonsterRecord.Treasure(Array.Number)
    If Treasure.Number>False And _
    Treasure.Number<=Lof(TreasureFile)/Len(TreasureRecord) Then ' file bounds
       Call Read.Record(TreasureFile,Treasure.Number) ' get treasure record
       Outpt=TreasureRecord.TreasureName ' store treasure name
       Call IO.O ' send output message
    Endif ' end check file bounds
 Next ' end loop through nonplayer treasure
End Sub ' end routine

 Rem * This routines displays information on the object file.
 Rem * input variables:
 Rem *   Number - the object file record.

Sub Display.Object(Number)
 On Local Error Resume Next ' local error resume
 If Number<=False Then ' check number
    Exit Sub ' exit subroutine
 Endif ' end check number
 Graphics.Off=False ' reset color
 Outpt="Object number"+Str$(Number)+":" ' object number message
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 Outpt="[A]Object name: "+Rtrim$(ObjectRecord.ObjectName) ' message
 Call IO.O ' send output message
 Outpt="[B]Object identifier: "+Lcase$(Rtrim$(ObjectRecord.ShortName))
 Call IO.O ' send output message
 Outpt="[C]Room number link:"+Str$(ObjectRecord.RoomLink) ' message
 Call IO.O ' send output message
 Outpt="[D]Trapped portal: " ' message
 Select Case ObjectRecord.Trap ' selection of object trap type
 Case False ' verify object
    Outpt=Outpt+"No" ' add to message
 Case 1 ' verify object
    Outpt=Outpt+"poison needles" ' message
 Case 2 ' berify object
    Outpt=Outpt+"teleport to"+Str$(ObjectRecord.Teleport) ' message
 Case 3 ' verify object
    Outpt=Outpt+"hits for"+Str$(Abs(ObjectRecord.Teleport))+" " ' message
    Select Case Object.Teleport ' selection of object trap hit type
    Case Is<False ' verify object
       Outpt=Outpt+"vitality" ' message
    Case Else ' verify object
       Outpt=Outpt+"fatigue" ' message
    End Select ' end selection of object hit type
 End Select ' end selection of object type
 Call IO.O ' send output message
 Outpt="[E]Long description:" ' message
 Call IO.O ' send output message
 Outpt=Rtrim$(ObjectRecord.LongDesc) ' message
 If Outpt=Nul Then ' check message
    Outpt="<none>" ' reset
 Endif ' end check message
 Call IO.O ' send output message
 Outpt="[F]Entry description:" ' message
 Call IO.O ' send output message
 Outpt=Rtrim$(ObjectRecord.ShortDesc) ' message
 If Outpt=Nul Then ' check message
    Outpt="<none>" ' reset
 Endif ' end check message
 Call IO.O ' send output message
 Outpt="[G]Hidden object: " ' message
 If ObjectRecord.Hidden Then ' verify object
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[H]Invisible object: " ' message
 If ObjectRecord.Invisible Then ' verify object
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[I]Jail attacker trap: " ' message
 If ObjectRecord.JailTrap Then ' verify object
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[J]Locked portal: " ' message
 If ObjectRecord.DoorLock=2 Then ' verify object
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[K]Relocking portal: " ' message
 If ObjectRecord.Relocks Then ' verify object
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[L]Key number:"+Str$(ObjectRecord.Keyed) ' message
 Call IO.O ' send output message
 Outpt="[M]Permanent object: " ' message
 If ObjectRecord.Permanent Then ' verify object
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[N]Object is a light: " ' message
 If ObjectRecord.LightRoom=False Then ' verify object
    Outpt=Outpt+"No" ' add to message
 Else ' verify
    Outpt=Outpt+"Yes, Light Time: " ' message
    If ObjectRecord.LightTime=False Then ' verify object
       Outpt=Outpt+"<any>" ' message
    Else ' verify
       Outpt=Outpt+"From:"+Right$(Str$(ObjectRecord.FromHour+100),2)+":"+ _
       Right$(Str$(ObjectRecord.FromMin+100),2)+" to "+ _
       Right$(Str$(ObjectRecord.ToHour+100),2)+":"+ _
       Right$(Str$(ObjectRecord.ToMin+100),2) ' message
    Endif ' end verify
 Endif ' end verify
 Call IO.O ' send output message
End Sub ' end routine

 Rem * This routines displays information on the room file.
 Rem * input variables:
 Rem *   Number! - the room file record.

Sub Display.Room.Desc(Number!)
 On Local Error Resume Next ' local error resume
 If Number!<=0! Then ' check number
    Exit Sub ' exit subroutine
 Endif ' end check number
 Graphics.Off=False ' reset color
 Outpt="Room number"+Str$(Number!)+": Action"+Str$(RoomRecord.Action)+ _
 ": Monster class:"+Str$(RoomRecord.MonsterClass)+"." ' make room message
 Call IO.O ' send output message
 Outpt="Short description:" ' message
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 Outpt=Rtrim$(RoomRecord.ShortDesc) ' message
 If Instr(Outpt,Chr$(0)) Then ' find any null characters from old structures
    Outpt=Left$(Outpt,Instr(Outpt,Chr$(0))-1) ' truncate off nulls
 Endif ' end find old nulls
 Call IO.O ' send output message
 Graphics.Off=False ' reset color
 Outpt="Long description:" ' message
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 For Array.Number=1 To 4 ' loop through all four long room description lines
    Outpt=RoomRecord.LongDesc(Array.Number) ' get next room description line
    Outpt=Rtrim$(Outpt) ' trim room description line
    If Instr(Outpt,Chr$(0)) Then ' find any nul characters from old files
       Outpt=Left$(Outpt,Instr(Outpt,Chr$(0))-1) ' truncate off nulls
    Endif ' end find old nulls
    If Outpt=Nul Then ' check if long description ends
       Exit For ' exit long description display loop
    Endif ' end check description end
    Call IO.O ' send output message
 Next ' end long room description loop
End Sub ' end routine

 Rem * This routines displays information on the spell file.
 Rem * input variables:
 Rem *   Number - the spell file record.

Sub Display.Spell(Number)
 On Local Error Resume Next ' local error resume
 If Number<=False Then ' check number
    Exit Sub ' exit subroutine
 Endif ' end check number
 Graphics.Off=False ' reset color
 Outpt="Spell number"+Str$(Number)+":" ' spell number message
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 Outpt="[A]Spell name: "+Rtrim$(SpellRecord.SpellName) ' message
 Call IO.O ' send output message
 Outpt="[B]Spell chant:" ' message
 Call IO.O ' send output message
 Outpt=Lcase$(Rtrim$(SpellRecord.Chant)) ' message
 Call IO.O ' send output message
 Outpt="[C]Spell cast description:" ' message
 Call IO.O ' send output message
 Outpt=Rtrim$(SpellRecord.Desc)
 Call IO.O ' send output message
 Outpt="[D]Spell level:"+Str$(SpellRecord.Level) ' message
 Call IO.O ' send output message
 Outpt="[E]" ' set to option
 Select Case SpellRecord.SpellType ' selection of spell type
 Case Enchant
    Inpt="Enchant" ' message
 Case Offense
    Inpt="Offense" ' message
 Case Bless
    Inpt="Bless" ' message
 Case Wish
    Inpt="Wish" ' message
 Case Poison
    Inpt="Poison" ' message
 Case Vigor
    Inpt="Vigor" ' message
 Case Heal
    Inpt="Heal" ' message
 Case CurePoison
    Inpt="Curepoison" ' message
 Case LevelDrain
    Inpt="Level Drain" ' message
 Case Teleport
    Inpt="Teleport to Room"+Str$(SpellRecord.Teleport)
 Case Befuddled
    Inpt="Befuddle" ' message
 Case TurnUndead
    Inpt="Turn Undead" ' message
 Case PassDoor
    Inpt="Pass Door" ' message
 Case Conjure
    Inpt="Conjure" ' message
 Case Psionic
    Inpt="Psionic" ' message
 Case DetectLock
    Inpt="Detect Lock" ' message
 Case DetectEvil
    Inpt="Detect Evil" ' message
 Case DetectTrap
    Inpt="Detect Trap" ' message
 Case Intoxicate
    Inpt="Intoxicate" ' message
 Case SetTrap
    Inpt="Set Trap" ' message
 Case Hiding
    Inpt="Hide" ' message
 Case Search
    Inpt="Search" ' message
 Case Invisibility
    Inpt="Invisibility" ' message
 Case Identify
    Inpt="Identify" ' message
 Case Enlighten
    Inpt="Enlighten" ' message
 Case Illuminate
    Inpt="Illuminate" ' message
 Case Psyche
    Inpt="Psyche" ' message
 Case Telepathy
    Inpt="Telepathy" ' message
 Case Else ' other
    Inpt="<none>" ' message
 End Select ' end selection of spell type
 Outpt=Outpt+"Spell type: "+Inpt ' message
 Call IO.O ' send output message
 Outpt="[F]Spell is psionic: " ' message
 If SpellRecord.Psionic=False Then ' verify spell
    Outpt=Outpt+"No" ' add to message
 Else ' verify
    Outpt=Outpt+"Yes, " ' message
    Select Case SpellRecord.PsionicMode ' selection of spell psionic type
    Case PsiAttack
       Outpt=Outpt+"Attack" ' message
    Case PsiDefense
       Outpt=Outpt+"Defense" ' message
    Case Else ' other
       Outpt=Outpt+"<none>" ' message
    End Select ' end selection of spell type
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[G]Characters which can cast spell:" ' message
 Call IO.O ' send output message
 Spell.Cast=False ' set spell cast found flag
 For Class.Number=1 To 8 ' loop through spell cast flags
    If SpellRecord.ClassType And 2^Class.Number Then ' compare spell cast flag
       Class.Type$=Class.Name(Class.Number) ' store class name
       Class.Type$=Rtrim$(Class.Type$) ' trim name
       ' uppercase first word
       Mid$(Class.Type$,1,1)=Ucase$(Mid$(Class.Type$,1,1))
       Outpt=Outpt+Class.Type$+", " ' append to output string
       Spell.Cast=True ' set spell cast found flag
    Endif ' end compare spell cast flags
 Next ' end loop through spell cast flags
 If Spell.Cast Then ' check spell cast found flag
    Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' message
 Else ' check spell flag
    Outpt="<none>" ' message
 Endif ' end check spell cast found flag
 Call IO.O ' send output message
 Outpt="[H]Spell ingredients:" ' message
 Call IO.O ' send output message
 Spell.Ingredient=False ' set spell ingredient found flag
 For Array.Number=1 To 5 ' loop through spell ingerdients
    ' get spell ingredient number
    Treasure.Number=SpellRecord.Ingred(Array.Number)
    If Treasure.Number>False And _
    Treasure.Number<=Lof(TreasureFile)/Len(TreasureRecord) Then ' file bounds
       Call Read.Record(TreasureFile,Treasure.Number) ' get treasure record
       Ingredient.Name$=TreasureRecord.TreasureName ' store treasure name
       Ingredient.Name$=Rtrim$(Ingredient.Name$) ' trim name
       Ingredient.Name$=Lcase$(Ingredient.Name$) ' lowercase name
       ' uppercase first word
       Mid$(Ingredient.Name$,1,1)=Ucase$(Mid$(Ingredient.Name$,1,1))
       Outpt=Outpt+Ingredient.Name$+", " ' message
       Spell.Ingredient=True ' set spell ingredient found flag
    Endif ' end check file bounds
 Next ' end loop through spell ingredients
 If Spell.Ingredient Then ' check spell ingredient found flag
    Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' message
 Else ' check spell ingredient
    Outpt="<none>" ' message
 Endif ' end check spell ingredient found flag
 Call IO.O ' send output message
 Outpt="[I]Spell casting type which requires ingredients:" ' message
 Call IO.O ' send output message
 Spell.Requirement=False ' set ingredient requirement flag
 If SpellRecord.SpellFlag And Use.Spell.Type Then ' verify spell
    Outpt="use command, " ' message
    Spell.Requirement=True ' set ingredient flag
 Endif ' end verify
 If SpellRecord.SpellFlag And Scroll.Spell.Type Then ' verify spell
    Outpt=Outpt+"read scroll, " ' message
    Spell.Requirement=True ' set ingredient flag
 Endif ' end verify
 If SpellRecord.SpellFlag And Cast.Spell.Type Then ' verify spell
    Outpt=Outpt+"cast spell, " ' message
    Spell.Requirement=True ' set ingredient flag
 Endif ' end verify
 If Spell.Requirement Then ' check ingredient flag
    Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' message
 Else ' check flag
    Outpt="<none>" ' message
 Endif ' end check ingredient flag
 Call IO.O ' send output message
End Sub ' end routine

 Rem * This routines displays information on the treasure file.
 Rem * input variables:
 Rem *   Number - the treasure file record.

Sub Display.Treasure(Number)
 On Local Error Resume Next ' local error resume
 If Number<=False Then ' check number
    Exit Sub ' exit subroutine
 Endif ' end check number
 Graphics.Off=False ' reset color
 Outpt="Treasure number"+Str$(Number)+":" ' treasure number message
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 Outpt="[A]Treasure name: "+TreasureRecord.TreasureName ' message
 Outpt=Left$(Outpt,40) ' truncate string
 Outpt=Outpt+Space$(40-Len(Outpt)) ' pad with blanks
    Outpt=Outpt+"[U]Treasure is coins: " ' message
 If TreasureRecord.Coin Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[B]Treasure identifier: "+Lcase$(TreasureRecord.ShortName) ' message
 Outpt=Left$(Outpt,40) ' truncate string
 Outpt=Outpt+Space$(40-Len(Outpt)) ' pad with blanks
    Outpt=Outpt+"[V]Treasure is a potion: " ' message
 If TreasureRecord.Potion Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[C]Weight:"+Str$(TreasureRecord.Weight) ' message
 Outpt=Left$(Outpt,40) ' truncate string
 Outpt=Outpt+Space$(40-Len(Outpt)) ' pad with blanks
    Outpt=Outpt+"[W]Treasure is a scroll: " ' message
 If TreasureRecord.Scroll Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[D]Gold coin value:"+Str$(TreasureRecord.Gold) ' message
 Outpt=Left$(Outpt,40) ' truncate string
 Outpt=Outpt+Space$(40-Len(Outpt)) ' pad with blanks
    Outpt=Outpt+"[X]Treasure is invisible: " ' message
 If TreasureRecord.Invisible Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[E]Treasure type: " ' message
 If TreasureRecord.Loadable Then ' check treasure type
    Outpt=Outpt+"Loadable" ' append message
 Else ' check next type
    If TreasureRecord.Launchable Then ' check treasure type
       Outpt=Outpt+"Launchable" ' append message
    Else ' check next type
       Select Case TreasureRecord.Type ' selection of treasure type
       Case False ' verify treasure type
          If TreasureRecord.Plus=False Then ' verify weapon type
             Outpt=Outpt+"Treasure" ' message
          Else ' verify type
             Outpt=Outpt+"Weapon" ' message
          Endif ' end verify treasure type
       Case Is<False ' verify shield type
          Outpt=Outpt+"Shield" ' message
       Case Is>False ' verify armor type
          Outpt=Outpt+"Armor" ' message
       End Select ' end selection of treasure type
    Endif ' end check treasure type
 Endif ' end check treasure type
 Outpt=Left$(Outpt,40) ' truncate string
 Outpt=Outpt+Space$(40-Len(Outpt)) ' pad with blanks
 Outpt=Outpt+"[Y]Treasure is a container: " ' message
 If TreasureRecord.Container Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[F]Hit plus:"+Str$(Abs(TreasureRecord.Plus)) ' message
 Outpt=Left$(Outpt,40) ' truncate string
 Outpt=Outpt+Space$(40-Len(Outpt)) ' pad with blanks
 Outpt=Outpt+"[Z]Container is locked: " ' message
 If TreasureRecord.Locked=1 And TreasureRecord.Closed=1 Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[G]Charges:"+Str$(TreasureRecord.Charges) ' message
 Outpt=Left$(Outpt,40) ' truncate string
 Outpt=Outpt+Space$(40-Len(Outpt)) ' pad with blanks
    Outpt=Outpt+"[1]Treasure key number:"+Str$(TreasureRecord.Keyed) ' message
 Call IO.O ' send output message
 Outpt="[H]Weapon class: " ' message
 ' selection of treasure proficiency type
 Select Case TreasureRecord.Proficiency
 Case Blunt
    Outpt=Outpt+"Blunt" ' message
 Case Pole
    Outpt=Outpt+"Pole" ' message
 Case Sharp
    Outpt=Outpt+"Sharp" ' message
 Case Thrusting
    Outpt=Outpt+"Thrusting" ' message
 Case Else ' other
    Outpt=Outpt+"None" ' message
 End Select ' end selection of weapon proficiency type
 Outpt=Left$(Outpt,40) ' truncate string
 Outpt=Outpt+Space$(40-Len(Outpt)) ' pad with blanks
    Outpt=Outpt+"[2]Treasure is fuel: " ' message
 If TreasureRecord.FuelType=False Then ' verify treasure
    Outpt=Outpt+"No" ' add to message
 Else ' verify
    Outpt=Outpt+"Yes:"+Str$(TreasureRecord.FuelCharges)+" charges" ' message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[I]Treasure is permanent: " ' message
 If TreasureRecord.Permanent Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Outpt=Left$(Outpt,40) ' truncate string
 Outpt=Outpt+Space$(40-Len(Outpt)) ' pad with blanks
    Outpt=Outpt+"[3]Weapon rusts: " ' message
 If TreasureRecord.Rustable Then ' verify treasure
    Outpt=Outpt+"Yes:"+Str$(TreasureRecord.RustPercent)+"%"
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[J]Treasure is edible: " ' message
 If TreasureRecord.Edible Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Outpt=Left$(Outpt,40) ' truncate string
 Outpt=Outpt+Space$(40-Len(Outpt)) ' pad with blanks
    Outpt=Outpt+"[4]Weapon is stealable: " ' message
 If TreasureRecord.Stealable Then ' verify treasure
    Outpt=Outpt+"Yes:"+Str$(TreasureRecord.StealPercent)+"%"
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[K]Treasure is magical: " ' message
 Spell.Number=TreasureRecord.Spell ' store spell number
 If Spell.Number=False Then ' verify treasure
    Outpt=Outpt+"No" ' add to message
 Else ' verify
    ' file bounds
    If Spell.Number>False And _
    Spell.Number<=Lof(SpellFile)/Len(SpellRecord) Then
       Call Read.Record(SpellFile,Spell.Number) ' get spell record
       Outpt=Outpt+"Yes, "+Rtrim$(SpellRecord.SpellName)+" spell" ' message
    Endif ' end check file bounds
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[L]Treasure is a ring: " ' message
 Select Case TreasureRecord.RingType
 Case 1
    Outpt=Outpt+"protection from poison" ' message
 Case 2
    Outpt=Outpt+"protection from level drain" ' message
 Case 3
    Outpt=Outpt+"protection from spell: " ' message
    Spell.Number=TreasureRecord.RingSpell ' store ring spell number
    If Spell.Number=True Then ' verify treasure
       Outpt=Outpt+"generic spell" ' message
    Else ' verify
       ' file bounds
       If Spell.Number>False And _
       Spell.Number<=Lof(SpellFile)/Len(SpellRecord) Then
          Call Read.Record(SpellFile,Spell.Number) ' get spell record
          Outpt=Outpt+Rtrim$(Lcase$(SpellRecord.SpellName))+" spell" ' message
       Endif ' end check file bounds
    Endif ' end verify
 Case Else ' verify
    Outpt=Outpt+"No" ' add to message
 End Select
 Call IO.O ' send output message
 Outpt="[M]Treasure is a light: " ' message
 If TreasureRecord.LightType=False Then ' verify treasure
    Outpt=Outpt+"No" ' add to message
 Else ' verify
    Outpt=Outpt+"Yes, Charges:"+Str$(TreasureRecord.LightCharges) ' message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[N]Treasure is a vehicle: " ' message
 If TreasureRecord.Vehicle=False Then ' verify treasure
    Outpt=Outpt+"No" ' add to message
 Else ' verify
    Outpt=Outpt+"Yes, hits:"+Str$(TreasureRecord.VehicleHits) ' message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[O]Treasure loads from devices: " ' message
 If TreasureRecord.Ammunition Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[P]Treasure is loadable: " ' message
 If TreasureRecord.Loadable Then ' verify treasure
    Outpt=Outpt+"Yes: Loads(" ' add to message
    ' store ammunition treasure number
    Treasure.Number=TreasureRecord.AmmoLoads
    If Treasure.Number>False And _
    Treasure.Number<=Lof(TreasureFile)/Len(TreasureRecord) Then ' file bounds
       Call Share.Record(TreasureFile,Number) ' store current treasure record
       Call Read.Record(TreasureFile,Treasure.Number) ' get treasure record
       Outpt=Outpt+Rtrim$(TreasureRecord.TreasureName)+")" ' message
       Call Read.Record(TreasureFile,Number) ' restore treasure record
    Else ' check file bounds
       Outpt=Outpt+"<none>)" ' append message
    Endif ' end check file bounds
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[R]Treasure launchs from devices: " ' message
 If TreasureRecord.LaunchAmmo Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[S]Treasure is launchable: " ' message
 If TreasureRecord.Launchable Then ' verify treasure
    Outpt=Outpt+"Yes: Launchs(" ' add to message
    ' store ammunition treasure number
    Treasure.Number=TreasureRecord.LaunchLoads
    If Treasure.Number>False And _
    Treasure.Number<=Lof(TreasureFile)/Len(TreasureRecord) Then ' file bounds
       Call Share.Record(TreasureFile,Number) ' store current treasure record
       Call Read.Record(TreasureFile,Treasure.Number) ' get treasure record
       Outpt=Outpt+Rtrim$(TreasureRecord.TreasureName)+")" ' message
       Call Read.Record(TreasureFile,Number) ' restore treasure record
    Else ' check file bounds
       Outpt=Outpt+"<none>)" ' append message
    Endif ' end check file bounds
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[T]Launchable device can be moved: " ' message
 If TreasureRecord.Movable Then ' verify treasure
    Outpt=Outpt+"Yes" ' add to message
 Else ' verify
    Outpt=Outpt+"No" ' add to message
 Endif ' end verify
 Call IO.O ' send output message
End Sub ' end routine

 Rem * This routines displays information on the user file.
 Rem * input variables:
 Rem *   Number - the user file record.

Sub Display.User(Number)
 On Local Error Resume Next ' local error resume
 If Number<=False Then ' check number
    Exit Sub ' exit subroutine
 Endif ' end check number
 Graphics.Off=False ' reset color
 Outpt="User number"+Str$(Number)+"." ' user number message
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 Inpt=UserRecord.CodeName ' store player codename
 Call Decrypt(Inpt) ' decrypt codename
 Inpt=Rtrim$(Inpt) ' trim codename
 Inpt=Lcase$(Inpt) ' lowercase codename
 Mid$(Inpt,1,1)=Ucase$(Mid$(Inpt,1,1)) ' uppercase first word
 Outpt="[A]Codename: "+Inpt+" " ' message
 Inpt=String$(10,Mask$) ' mask passwword
 Outpt=Outpt+"[B]Password: "+Inpt ' message
 Call IO.O ' send output message
 Outpt="[C]Level:"+Str$(UserRecord.Level) ' message
 Call IO.O ' send output message
 Outpt="[D]" ' set to option
 Class.Number=UserRecord.ClassType ' store player class type
 Select Case Class.Number ' selection of class type
 Case 1 To 10 ' check class type
    Class.Type$=Class.Name(Class.Number) ' store class name
 Case Else ' check
    Class.Type$=Class.Name(1) ' default class name
 End Select ' end selection of class type
 Outpt=Outpt+"Class: "+Rtrim$(Class.Type$) ' message
 Call IO.O ' send output message
 Outpt="[E]" ' set to option
 Weapon.Number=UserRecord.Proficiency ' store player proficiency number
 Select Case Weapon.Number ' selection of proficiency
 Case 1 To 4 ' check type
    Weapon.Type$=Weapon.Type.Name(Weapon.Number) ' store proficiency name
 Case Else ' check
    Weapon.Type$=Weapon.Type.Name(1) ' default name
 End Select ' end seelction of proficiency
 Mid$(Weapon.Type$,1,1)=Ucase$(Mid$(Weapon.Type$,1,1)) ' uppercase first letter
 Outpt=Outpt+"Weapon proficiency: "+Rtrim$(Weapon.Type$) ' message
 Call IO.O ' send output message
 Outpt="[F]Blunt%:"+Str$(UserRecord.Weapons(1))+" " ' message
 Outpt=Outpt+"[G]Pole%:"+Str$(UserRecord.Weapons(2)) ' message
 Call IO.O ' send output message
 Outpt="[H]Sharp%:"+Str$(UserRecord.Weapons(3))+" " ' message
 Outpt=Outpt+"[I]Thrusting%:"+Str$(UserRecord.Weapons(4)) ' message
 Call IO.O ' send output message
 Outpt="[J]Classname: " ' message
 Inpt=UserRecord.ClassName
 Call Decrypt(Inpt)
 Inpt=Rtrim$(Inpt)
 Outpt=Outpt+Inpt
 Call IO.O ' send output message
 Outpt="[K]Strength:"+Str$(UserRecord.Stats(1)) ' message
 Call IO.O ' send output message
 Outpt="[L]Intelligence:"+Str$(UserRecord.Stats(2)) ' message
 Call IO.O ' send output message
 Outpt="[M]Wisdom:"+Str$(UserRecord.Stats(3)) ' message
 Call IO.O ' send output message
 Outpt="[N]Dexterity:"+Str$(UserRecord.Stats(4)) ' message
 Call IO.O ' send output message
 Outpt="[O]Constitution:"+Str$(UserRecord.Stats(5)) ' message
 Call IO.O ' send output message
 Outpt="[P]Piety:"+Str$(UserRecord.Stats(6)) ' message
 Call IO.O ' send output message
 Outpt="[R]Charisma:"+Str$(UserRecord.Stats(7)) ' message
 Call IO.O ' send output message
 Outpt="[S]Experience:"+Str$(UserRecord.Experience) ' message
 Call IO.O ' send output message
 Outpt="[T]Gold:"+Str$(UserRecord.Gold) ' message
 Call IO.O ' send output message
 Outpt="[U]Room number:"+Str$(UserRecord.Room) ' message
 Call IO.O ' send output message
 Outpt="[V]Call restrictions." ' message
 Call IO.O ' send output message
 Outpt="[W]Inventory:" ' message
 ' count user inventory items
 Number.Items=False ' reset counter
 ' loop through player objects
 For Object.Index=1 To 20
    ' store object
    Object.Number=UserRecord.Object(Object.Index)
    ' check object number
    If Object.Number>False And Object.Number<=Lof(ObjectFile)/Len(ObjectRecord) Then
       Number.Items=Number.Items+1 ' increment number of items
    Endif ' end check object number
 Next ' end count objects
 ' loop through inventory
 For Treasure.Index=1 To 20
    ' store number
    Treasure.Number=UserRecord.Inv(Treasure.Index)
    ' check number
    If Treasure.Number>False And Treasure.Number<=Lof(TreasureFile)/Len(TreasureRecord) Then
       Number.Items=Number.Items+1 ' increment number of items
    Endif ' end check object number
 Next ' end count inventory
 ' loop through user containers
 For Number.Containers=1 To 3 ' loop through user containers
    ContainerRec=UserRecord.Container(Number.Containers) ' store user container into record
    If Rtrim$(ContainerRec.ShortName)<>Nul Then ' compare container name length
       Number.Items=Number.Items+1 ' increment number of items
    Endif ' end check object number
 Next ' end count inventory
 If Number.Items=1 Then ' check value
    Outpt=Outpt+Str$(Number.Items)+" item." ' make display message
 Else ' check value
    Outpt=Outpt+Str$(Number.Items)+" items." ' make display message
 Endif ' end check value
 Call IO.O ' send output message
 Outpt="[X]Special characters: " ' message
 Special.Flag=False
 If UserRecord.Flags And Special.Char1 Then ' verify user
    Outpt=Outpt+"Town Mayor, " ' message
    Special.Flag=True
 Endif ' end verify
 If UserRecord.Flags And Special.Char2 Then ' verify user
    Outpt=Outpt+"Governor, " ' message
    Special.Flag=True
 Endif ' end verify
 If UserRecord.Flags And Special.Char3 Then ' verify user
    Outpt=Outpt+"Guild Master, " ' message
    Special.Flag=True
 Endif ' end verify
 If UserRecord.Flags And Special.Char4 Then ' verify user
    Outpt=Outpt+"Sysop, " ' message
    Special.Flag=True
 Endif ' end verify
 If Special.Flag Then ' verify user
    Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' message
 Else ' verify
    Outpt=Outpt+"None." ' message
 Endif ' end verify
 Call IO.O ' send output message
 Outpt="[Y]Training rooms" ' message
 Call IO.O ' send output message
 Graphics.Off=False ' reset color
End Sub ' end routine

 Rem * routine used by the editor to find monster file number
 Rem * of a monster name.
 Rem * output variables:
 Rem *   Number - record number of monster.
 Rem * processing variables:
 Rem *   Inpt - monster name or number to search for.
 Rem *   Parsed.Value - monster number increment.

Sub Find.Monster(Number)
 On Local Error Resume Next ' local error resume
 Outpt="Monster name, or number" ' input prompt
 Outpt=Outpt+"(1-"+Mid$(Str$(Lof(MonsterFile)/Len(MonsterRecord)),2)+")? "
 Call IO.I ' get input
 If Inpt=Nul Then ' compare input length
    Number=False ' reset number found
    Exit Sub ' exit routine
 Endif ' end compare length
 Call Parse.Num(Inpt,Parsed.Value) ' parse number
 Number.Count=False ' reset monster found counter
 For Number=1 To Lof(MonsterFile)/Len(MonsterRecord) ' loop through monsters
    Call Read.Record(MonsterFile,Number) ' get monster record
    ' compare monster record name to input monster name,
    ' truncated to input length
    If Left$(MonsterRecord.MonsterName,Len(Inpt))=Inpt Then ' compare
       Number.Count=Number.Count+1 ' increment monster found counter
       ' compare parsed number of monster to search for
       If Parsed.Value=False Or Number.Count=Parsed.Value Then ' compare
          Exit Sub ' exit routine
       Endif ' end compare counters
    Endif ' end compare monster names
 Next ' end loop through monster file
 Number=Int(Val(Inpt)) ' convert input to integer
 If Number<=False Or _
 Number>Lof(MonsterFile)/Len(MonsterRecord) Then ' file bounds
    Outpt=Range$ ' make error message
    Call IO.O ' send error message
    Number=False ' reset monster found
 Else ' end check file bounds
    Call Read.Record(MonsterFile,Number) ' get monster record number
 Endif ' end check file bounds
End Sub ' end routine

 Rem * routine used by the editor to find nonplayer file number
 Rem * of a nonplayer name.
 Rem * output variables:
 Rem *   Number - record number of nonplayer.
 Rem * processing variables:
 Rem *   Inpt - nonplayer name or number to search for.
 Rem *   Parsed.Value - nonplayer number increment.

Sub Find.Nonplayer(Number)
 On Local Error Resume Next ' local error resume
 Outpt="Nonplayer name, or number" ' input prompt
 Outpt=Outpt+"(1-"+Mid$(Str$(Lof(NonPlayerFile)/Len(MonsterRecord)),2)+")? "
 Call IO.I ' get input
 If Inpt=Nul Then ' compare input length
    Number=False ' reset number found
    Exit Sub ' exit routine
 Endif ' end compare length
 Call Parse.Num(Inpt,Parsed.Value) ' parse number
 Number.Count=False ' reset nonplayer counter
 For Number=1 To Lof(NonPlayerFile)/Len(MonsterRecord) ' loop through nonplayers
    Call Read.Record(NonPlayerFile,Number) ' get nonplayer record
    ' compare nonplayer record name to input nonplayer name,
    ' truncated to input length
    If Left$(MonsterRecord.MonsterName,Len(Inpt))=Inpt Then ' compare
       Number.Count=Number.Count+1 ' increment nonplayer found counter
       ' compare parsed number of object to search for
       If Parsed.Value=False Or Number.Count=Parsed.Value Then ' compare
          Exit Sub ' exit routine
       Endif ' end compare counters
    Endif ' end compare nonplayer names
 Next ' end loop through nonplayer file
 Number=Int(Val(Inpt)) ' convert input to integer
 If Number<=False Or _
 Number>Lof(NonPlayerFile)/Len(MonsterRecord) Then ' file bounds
    Outpt=Range$ ' make error message
    Call IO.O ' send error message
    Number=False ' reset nonplayer found
 Else ' end check file bounds
    Call Read.Record(NonPlayerFile,Number) ' get nonplayer record number
 Endif ' end check file bounds
End Sub ' end routine

 Rem * routine used by the editor to find the object file number
 Rem * of an object name.
 Rem * output variables:
 Rem *   Number - record number of object.
 Rem * processing variables:
 Rem *   Inpt - object name or number to search for.
 Rem *   Parsed.Value - object number increment.

Sub Find.Objects(Number)
 On Local Error Resume Next ' local error resume
 Outpt="Object name, or number" ' make input prompt
 Outpt=Outpt+"(1-"+Mid$(Str$(Lof(ObjectFile)/Len(ObjectRecord)),2)+")? "
 Call IO.I ' get input
 If Inpt=Nul Then ' compare input length
    Number=False ' reset number found
    Exit Sub ' exit routine
 Endif ' end compare length
 Call Parse.Num(Inpt,Parsed.Value) ' get parsed number
 Number.Count=False ' reset spell found counter
 For Number=1 To Lof(ObjectFile)/Len(ObjectRecord) ' loop through object file
    Call Read.Record(ObjectFile,Number) ' get object record
    ' compare object record name to input object name,
    ' truncated to input length
    If Left$(ObjectRecord.ObjectName,Len(Inpt))=Inpt Then ' compare
       Number.Count=Number.Count+1 ' increment object counter
       ' compare parsed number of object to search for
       If Parsed.Value=False Or Number.Count=Parsed.Value Then ' compare
          Exit Sub ' exit routine
       Endif ' end compare counters
    Endif ' end compare object names
 Next ' end loop through object file
 Number=Int(Val(Inpt)) ' convert input to integer
 If Number<=False Or _
 Number>Lof(ObjectFile)/Len(ObjectRecord) Then ' file bounds
    Outpt=Range$ ' make error message
    Call IO.O ' send error message
    Number=False ' reset object number to zero
 Else ' end check file bounds
    Call Read.Record(ObjectFile,Number) ' get object record number
 Endif ' end check file bounds
End Sub ' end routine

 Rem * routine used by the editor to find the spell file number
 Rem * of a spell name.
 Rem * output variables:
 Rem *   Number - record number of spell.
 Rem * processing variables:
 Rem *   Inpt - spell name or number to search for.
 Rem *   Parsed.Value - spell number increment.

Sub Find.Spell(Number)
 On Local Error Resume Next ' local error resume
 Outpt="Spell name, or number" ' input prompt
 Outpt=Outpt+"(1-"+Mid$(Str$(Lof(SpellFile)/Len(SpellRecord)),2)+")? "
 Call IO.I ' get input
 If Inpt=Nul Then ' check length of input
    Number=False ' reset number found
    Exit Sub ' exit routine
 Endif ' end check length
 Call Parse.Num(Inpt,Parsed.Value) ' parse out number
 Number.Count=False ' reset spell found counter
 For Number=1 To Lof(SpellFile)/Len(SpellRecord) ' loop through spell file
    Call Read.Record(SpellFile,Number) ' get spell record
    ' compare spell record name to input spell name, truncated to input length
    If Left$(SpellRecord.SpellName,Len(Inpt))=Inpt Then ' compare
       Number.Count=Number.Count+1 ' increment spell found
       ' compare parsed number of spell to search for
       If Parsed.Value=False Or Number.Count=Parsed.Value Then ' compare
          Exit Sub ' exit routine
       Endif ' end compare counters
    Endif ' end compare spell names
 Next ' end loop through spell file
 Number=Int(Val(Inpt)) ' convert input to integer
 If Number<=False Or _
 Number>Lof(SpellFile)/Len(SpellRecord) Then ' compare file bounds
    Outpt=Range$ ' make error message
    Call IO.O ' send error message
    Number=False ' reset return spell number to zero
 Else ' end compare spell number
    Call Read.Record(SpellFile,Number) ' get spell record number
 Endif ' end check file bounds
End Sub ' end routine

 Rem * routine used by the editor to find the treasure file number
 Rem * of a treasure name.
 Rem * output variables:
 Rem *   Number - record number of treasure.
 Rem * processing variables:
 Rem *   Inpt - treasure name or number to search for.
 Rem *   Parsed.Value - treasure number increment.

Sub Find.Treasure(Number)
 On Local Error Resume Next ' local error resume
 Outpt="Treasure name, or number" ' input prompt
 Outpt=Outpt+"(1-"+Mid$(Str$(Lof(TreasureFile)/Len(TreasureRecord)),2)+")? "
 Call IO.I ' get input
 If Inpt=Nul Then ' compare input length
    Number=False ' reset number found
    Exit Sub ' exit routine
 Endif ' end compare length
 Call Parse.Num(Inpt,Parsed.Value) ' parse number
 Number.Count=False ' reset treasure found counter
 For Number=1 To Lof(TreasureFile)/Len(TreasureRecord) ' loop through treasure
    Call Read.Record(TreasureFile,Number) ' get treasure record
    ' compare treasure record name to input treasure name,
    ' truncated to input length
    If Left$(TreasureRecord.TreasureName,Len(Inpt))=Inpt Then ' compare
       Number.Count=Number.Count+1 ' increment treasure found counter
       ' compare parsed number of treasure to search for
       If Parsed.Value=False Or Number.Count=Parsed.Value Then ' compare
          Exit Sub ' exit routine
       Endif ' end compare counters
    Endif ' end compare treasure names
 Next ' end loop through treasure file
 Number=Int(Val(Inpt)) ' convert input to integer
 If Number<=False Or _
 Number>Lof(TreasureFile)/Len(TreasureRecord) Then ' file bounds
    Outpt=Range$ ' make error message
    Call IO.O ' send error message
    Number=False ' reset treasure found
 Else ' end check file bounds
    Call Read.Record(TreasureFile,Number) ' get treasure record number
 Endif ' end check file bounds
End Sub ' end routine

 Rem * routine for player to hold an item of inventory.

Sub Hold.Object
 On Local Error Resume Next ' local error resume
 Call Check.Inventory.Treasure ' check player inventory treasure mneomnic
 If Index.Number=False Then ' found treasure file index
    Outpt="You aren't carrying that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare player inventory
 If TreasureRecord.Type>False Then ' compare treasure type
    Outpt="You can't hold that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure type
 If TreasureRecord.Loadable Then ' verify treasure type
    Outpt="You can't hold that!" ' make output message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end verify treasure type
 If TreasureRecord.Launchable Then ' verify treasure type
    Outpt="You can't hold that!" ' make output message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end verify treasure type
 ' compute treasure charges remaining
 If UserRecord.Charges(Array.Number)=False Then
    Outpt="You can't, it has zero charges!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure charges
 Item.Plus=Abs(TreasureRecord.Plus)
 Select Case TreasureRecord.Type ' select treasure type
 Case Is<False ' compare treasure type to shield
    Weapon3=Item.Plus ' set variable of holding shield plus
    ' set variable of holding shield of inventory array index
    Weapon5=Array.Number
 Case False ' compare treasure type to weapon
    If Item.Plus=False Then ' verify weapon type
       Outpt="You can't hold that!" ' make output message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end verify weapon type
    Index.Number=TreasureRecord.Proficiency ' store treasure proficiency
    If UserRecord.ClassType=Cleric Then ' compare player classtype to cleric
       Select Case Index.Number ' select treasure proficiency type
       Case 3 To 4 ' compare to sharp or thrusting
          Outpt="Clerics may only use blunt or pole type weapons!" ' message
          Call IO.O ' send message
          Exit Sub ' exit routine
       End Select ' end compare weapon proficiency type
    Endif ' end compare to cleric
    Weapon2=Item.Plus ' set variable of holding weapon plus
    ' set variable of holding weapon of inventory array index
    Weapon6=Array.Number
    Weapon10=Index.Number ' set variable of holding weapon proficiency type
 End Select ' end select treasure type
 Outpt="You hold "+Outpts+"(+"+Mid$(Str$(Item.Plus),2)+")!" ' format message
 Call IO.O ' send message
End Sub ' end routine to hold an item

 Rem * routine for player to wear an item of inventory.

Sub Wear.Object
 On Local Error Resume Next ' local error resume
 Call Check.Inventory.Treasure ' check player inventory treasure mnemonic
 If Index.Number=False Then ' found treasure index
    Outpt="You aren't carrying that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare index
 If TreasureRecord.Type<=False Then ' commpare treasure type
    If TreasureRecord.RingType=False Then ' compare ring type
       Outpt="You can't wear that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare ring
 Endif ' end compare treasure type
 If UserRecord.Charges(Array.Number)=False Then ' compare player charges array
    Outpt="You can't, it has zero charges!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare charges
 Item.Plus=Abs(TreasureRecord.Plus) ' store treasure item plus hits
 Select Case TreasureRecord.Type ' selecct treasure type
 Case Is>False ' treasure type is armor
    Weapon1=Item.Plus ' set variable of wearing item to plus
    ' set variable of wearing item to inventory array index
    Weapon4=Array.Number
 Case Else ' treasure type is ring
    Weapon7=Array.Number ' set wearing ring item to inventory array index
    Weapon8=TreasureRecord.RingType ' set wearing ring type variable
    Weapon9=TreasureRecord.RingSpell ' set wearing ring spell type variable
    Weapon11=Item.Plus ' set wearing ring plus
 End Select ' end select treasure type
 Outpt="You wear "+Outpts+"(+"+Mid$(Str$(Item.Plus),2)+")!" ' format message
 Call IO.O ' send message
End Sub ' end routine to wear an item

 Rem * routine to return an item from being held or worn.

Sub Return.Object
 On Local Error Resume Next ' local error resume
 Call Check.Inventory.Treasure ' check player inventory mnemonic
 If Index.Number=False Then ' treasure index of item
    Outpt="You aren't carrying that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure inventory
 Outpt="You return "+Outpts+"!" ' format message
 Select Case Array.Number ' select treasure inventory array variable
 Case Weapon4 ' compare treasure inventory array to armor variable
    Weapon1=False ' reset armor being worn holding variable
    Weapon4=False ' reset armor being worn variable
    Call IO.O ' send message
 Case Weapon5 ' compare treasure inventory array to shield variable
    Weapon3=False ' reset shield holding variable
    Weapon5=False ' reset shield holding variable
    Call IO.O ' send message
 Case Weapon6 ' compare treasure inventory array to weapon variable
    Weapon2=False ' reset weapon holding variable
    Weapon6=False ' reset weapon holding variable
    Weapon10=False ' reset weapon holding variable
    Call IO.O ' send message
 Case Weapon7 ' compare treasure inventory array to ring variable
    Weapon7=False ' reset ring being worn variable
    Weapon8=False ' reset ring being worn variable
    Weapon9=False ' reset ring being worn variable
    Weapon11=False ' reset ring worn variable
    Call IO.O ' send message
 Case Else ' no matching variables being held or worn
    Outpt="Your aren't wearing that!" ' make message
    Call IO.O ' send message
 End Select ' end select treasure array variable
End Sub ' end routine to return item

 Rem * routine to reset an item with original charges if broken.

Sub Fix.Object
 On Local Error Resume Next ' local error resume
 Call Examine.Treasure ' check treasure mnemonic
 If Index.Number=False Then ' treasure index
    Outpt="You can't fix that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check treasure
 If TreasureRecord.Spell Then ' treasure has spell
    Outpt="You can't fix that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare spell
 If TreasureRecord.Plus=False Then ' treasure is not weapon, armor, shield
    Outpt="You can't fix that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare spell
 If UserRecord.Charges(Array.Number) Then ' check remaining treasure charges
    Outpt="That's not broken!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare charges
 If UserRecord.Stats(3)<7 Then ' compute random chance
    Outpt="You didn't fix it!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end random chance
 If Abs(TreasureRecord.Plus)>10 Then ' compare treasure plus
    Outpt="You didn't fix it!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare plus
 If Rnd<.5 Then ' random chance
    Outpt="You didn't fix it!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end chance
 Item.Charges=TreasureRecord.Charges ' store treasure maximum charges
 If Item.Charges>250 Then ' only repair item to maximum of 250 charges
    Item.Charges=250 ' set storage variable to 250 charges
 Endif ' end compare charges
 Select Case Type.Number ' select room or inventory
 Case 1 ' treasure fixed in room
    ' reset room treasure charges
    RoomRecord.TreCharges(Array.Number)=Item.Charges
    Call Share.Room.Record(Room) ' write room record
 Case 0 ' treasure fixed in inventory
    ' reset inventory treasure charges
    UserRecord.Charges(Array.Number)=Item.Charges
 End Select ' end treasure fixed charges
 Outpt="You fix it!" ' make message
 Call IO.O ' send message
End Sub ' end fix routine

 Rem * routine to drink an item.

Sub Drink.Potion
 On Local Error Resume Next ' local error resume
 Call Check.Inventory.Treasure ' check treasure mnemonic
 If Index.Number=False Then ' inventory treasure index
    Outpt="You can't drink that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end treasure index
 If TreasureRecord.Potion=False Then ' compare treasure to potion
    Outpt="That's not a potion!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare potion
 ' check inventory charges remaining
 If UserRecord.Charges(Array.Number)=False Then
    Outpt="You can't, it's empty!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare charges
 Spell.Number=TreasureRecord.Spell ' get treasure spell number
 ' check spell file
 If Spell.Number>False And Spell.Number<=Lof(SpellFile)/Len(SpellRecord) Then
    Call Read.Record(SpellFile,Spell.Number) ' get spell record
    ' reduce charges
    UserRecord.Charges(Array.Number)=UserRecord.Charges(Array.Number)-1
    Magic.Spell=SpellRecord.SpellType ' store spell type
    Multiplier=SpellRecord.Level ' store spell level
    Monster.Number=False ' monster not being attacked
    Parser=False ' no extra parameters
    Index.Number=False ' not cast on an object
    Outpt="You drink "+Outpts+"!" ' format message
    Call IO.O ' send message
    Call Magic(True) ' cast the spell
    Exit Sub ' exit routine
 Endif ' end check spell file
 Outpt="You can't drink that!" ' make message
 Call IO.O ' send message
End Sub ' end drink potion

 Rem * routine to eat an item.

Sub Eat.Object
 On Local Error Resume Next ' local error resume
 Call Check.Inventory.Treasure ' check treasure mnemonic
 If Index.Number=False Then ' inventory treasure index
    Outpt="You can't eat that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end treasure index
 If TreasureRecord.Edible=False Then ' compare treasure to food
    Outpt="That's not edible!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare food
 ' check inventory charges remaining
 If UserRecord.Charges(Array.Number)=False Then
    Outpt="You can't, it's been eaten!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare charges
 Spell.Number=TreasureRecord.Spell ' get treasure spell number
 ' check spell file
 If Spell.Number>False And Spell.Number<=Lof(SpellFile)/Len(SpellRecord) Then
    Call Read.Record(SpellFile,Spell.Number) ' get spell record
    ' reduce charges
    UserRecord.Charges(Array.Number)=UserRecord.Charges(Array.Number)-1
    Magic.Spell=SpellRecord.SpellType ' store spell type
    Multiplier=SpellRecord.Level ' store spell level
    Monster.Number=False ' monster not being attacked
    Parser=False ' no extra parameters
    Index.Number=False ' not cast on a target
    Outpt="You eat "+Outpts+"!" ' format message
    Call IO.O ' send message
    Call Magic(True) ' cast the spell
    Exit Sub ' exit routine
 Endif ' end check spell file
 Outpt="You can't eat that!" ' make message
 Call IO.O ' send message
End Sub ' end eat routine

 Rem * routine to load device with charges from an item, loads device on
 Rem * ground or player inventory, removes item from from room or inventory.

Sub Load.Object
 On Local Error Resume Next ' local error resume
 Call Examine.Treasure ' check treasure mnemonic
 If Index.Number=False Then ' found treasure index
    Outpt="You can't load that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end treasure index
 Load.Type=False ' set load type flag
 If TreasureRecord.Loadable=True Then ' treasure can be loaded
    ' store treasure index which loads device
    Device.Type=TreasureRecord.AmmoLoads
    Load.Type=True ' set load type flag
 Endif ' end compare loaded treasure
 If TreasureRecord.Launchable=True Then ' treasure can be launched
    ' store treasure index which launchs item
    Device.Type=TreasureRecord.LaunchLoads
    Load.Type=1 ' set load type flag
 Endif ' end compare launched treasure
 If Load.Type=False Then ' compare load type flag
    Outpt="You can't load that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare load type
 ' check index bounds
 If Device.Type<False Or Device.Type>Lof(TreasureFile)/Len(TreasureRecord) Then
    Outpt="There's no ammunition!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check index bounds
 Charges.Number=False ' set treasure ammunition flag
 Call Read.Record(TreasureFile,Device.Type) ' get treasure index of ammunition
 If Load.Type=True Then ' check load type
    If TreasureRecord.Ammunition Then ' treasure index ammunition found
       Charges.Number=True ' set treasure ammunition flag
    Endif ' end compare ammunition index
 Endif ' end load type
 If Load.Type=1 Then ' check load type
    If TreasureRecord.LaunchAmmo Then ' treasure index ammunition found
       Charges.Number=True ' set treasure ammunition flag
    Endif ' end compare ammunition index
 Endif ' end load type
 If Charges.Number=False Then ' check ammunition flag
    Outpt="There's no ammunition!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check ammunition
 Ammo.Used=False ' set ammunition used flag
 For Inventory.Number=1 To 20 ' loop through all player inventory
    ' compare inventory index to ammo index
    If Device.Type=UserRecord.Inv(Inventory.Number) Then
       ' remove ammo from inventory
       Call Discard.Inventory(Inventory.Number,True)
       Ammo.Used=True ' set ammunition used flag
       Exit For ' exit loop to find ammo index
    Endif ' end compare inventory index
 Next ' end loop to find ammo index
 If Ammo.Used=False Then ' check ammunition used flag
    For Inventory.Number=1 To 20 ' loop through all room inventory
       ' compare room inventory to
       If Device.Type=RoomRecord.Treasure(Inventory.Number) Then
          ' ammo index, remove room ammo
          Call Discard.Room.Treasure(Inventory.Number)
          Ammo.Used=True ' set ammunition used flag
          Exit For ' exit loop to find ammo index
       Endif ' end compare inventory index
    Next ' end loop to find ammo index
 Endif ' end ammunition used flag
 If Ammo.Used=False Then ' check ammunition used flag
    Outpt="There's no ammunition!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check ammunition used flag
 Device.Loaded=False ' set ammunition loaded flag
 Select Case Type.Number ' select room or inventory
 Case 0 ' treasure loaded in player inventory
    ' store increment charges
    Device.Charges=UserRecord.Charges(Array.Number)+1
    If Device.Charges>10 Then ' compare to maximum charges
       Device.Loaded=True ' set ammunition loaded flag
    Else ' compare less than maximum
       UserRecord.Charges(Array.Number)=Device.Charges ' increment charges
    Endif ' end compare maximum charges
 Case 1 ' treasure loaded in room inventory
    ' store increment charges
    Device.Charges=RoomRecord.TreCharges(Array.Number)+1
    If Device.Charges>10 Then ' compare to maximum charges
       Device.Loaded=True ' set ammunition loaded flag
    Else ' compare less than maximum
       RoomRecord.TreCharges(Array.Number)=Device.Charges ' increment charges
    Endif ' end compare maximum charges
    Call Share.Room.Record(Room) ' write room record
 End Select ' end compare inventory to load
 If Device.Loaded Then ' compare ammunition loaded flag
    Outpt="The device can't load that much!" ' make message
 Else ' ammunition loaded
    Outpt="You load the device!" ' make message
 Endif ' end compare ammunition loaded flag
 Call IO.O ' send message
End Sub ' end routine to load ammunition to an item

 Rem * routine to fire a device at a monster in room, device explodes in
 Rem * player by chance, device discharges harmlessly.

Sub Fire.Object
 On Local Error Resume Next ' local error resume
 Call Find.Inventory ' check player inventory for mnemonic of device to fire
 If Index.Number=False Then ' found treasure index to player inventory
    Outpt="You can't fire that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check treasure index
 If TreasureRecord.Loadable=False Then ' check device can be loaded
    Outpt="You can't fire that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare device
 If TreasureRecord.AmmoLoads=False Then ' check item which loads device
    Outpt="It's not loaded with ammunition!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare device
 Call Read.Record(TreasureFile,TreasureRecord.AmmoLoads) ' get record ammo used
 If TreasureRecord.Ammunition=False Then ' item which loads device is nto ammo
    Outpt="It's not loaded with ammunition!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare device
 ' read treasure record index of device to fire
 Call Read.Record(TreasureFile,Index.Number)
 If Parser=False Then ' check second parameter of monster to fire at
    Outpt="Fire at what?" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare monster
 ' compare remaining charges in device
 If UserRecord.Charges(Array.Number)=False Then
    Outpt="It's not loaded!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare device
 ' decrement charges
 UserRecord.Charges(Array.Number)=UserRecord.Charges(Array.Number)-1
 Parsed.Command1=Parsed.Command2 ' get second parameter of monster
 Call Numeric ' parse out temp variable
 If Rnd<.2 Then ' compute random chance
    Outpt="Bang! The ammunition explodes in your face!" ' device backfires
    Call IO.O ' send message
    Outpt="The device hits you for" ' string preceding points hit on player
    Hits#=Cdbl(Int(Rnd*Abs(TreasureRecord.Plus)+1)) ' calculate random hits
    Call Hit.Player(Hits#) ' routine to get hits on player
    Exit Sub ' exit routine
 Endif ' end random chance
 If Rnd<.2 Then ' random chance
    Outpt="The device fires harmlessly!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end random chance
 Treasure.Name$=TreasureRecord.ShortName ' store treasure name being fired
 Treasure.Name$=Rtrim$(Treasure.Name$) ' strip trailing blanks
 Treasure.Name$=Lcase$(Treasure.Name$) ' format to lower case
 Call Check.Monster ' find monster being fired at in parsed string
 If Monster.Number Then ' monster found from second parameter
    Outpts=MonsterArray(Monster.Number).MonsterName ' store monster name
    Outpts=Rtrim$(Outpts) ' strip trailing blanks
    Outpts=Lcase$(Outpts) ' format to lower case
    Outpt="You fire the "+Treasure.Name$+" at the "+Outpts+"!" ' format message
    Call IO.O ' send message
    Multiplier=Abs(TreasureRecord.Plus) ' calculate hits on monster multiplier
    Call Hit.Monster ' routine to attack monster in Monster.Number
    Exit Sub ' exit routine
 Endif ' end compare monster to fire at
 Outpt="The device fires into empty air!" ' make message
 Call IO.O ' send message
End Sub ' end routine to fire a device at a monster

 Rem * dm/sysop routine to get an item from treasure or object files and
 Rem * add to room, interactive function during remote logon also.

Sub Drop.Object
 On Local Error Resume Next ' local error resume
 Parsed.Command1=Stored.Parsed.Command2 ' get entire second half of command
 Call Numeric ' parse temp variable
 Inpt=Parsed.Command1 ' put full name of item in variable
 Inpt=Lcase$(Inpt) ' convert to lower case
 Call Drop(True) ' routine to put item name in room
End Sub ' end dm/sysop drop routine

 Rem * routine to bless an object by increasing the magical charges.

Sub Bless.Object
 On Local Error Resume Next ' local error resume
 If Normal.User Then ' check player is normal player
    If UserRecord.ClassType<>Cleric Then ' compare player class type to cleric
       Outpt="Only clerics can bless!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare class type
 Endif ' end compare player type
 Call Examine.Treasure ' check treasure mnemonic
 If Index.Number Then ' found treasure index
    Charges.Number=TreasureRecord.Spell ' store treasure spell type
    If Charges.Number=False Then ' compare treasure spell type
       Outpt="You can't bless that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare treasure type
    ' check file bounds
    If Charges.Number>False And _
    Charges.Number<Lof(SpellFile)/Len(SpellRecord) Then
       ' read spell record from treasure index
       Call Read.Record(SpellFile,Charges.Number)
       If SpellRecord.SpellType=4 Then ' compare spell to wish
          Outpt="You can't bless that!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' and compare spell
       Object.Blessed=False ' set object blessed flag
       Max.Charges=TreasureRecord.Charges ' store maximum charges
       Select Case Type.Number ' select room or inventory
       Case 0 ' bless item in player inventory
          ' get incremented charges
          Type.Charges=UserRecord.Charges(Array.Number)+1
          If Type.Charges>Max.Charges Then ' compare maximum charges
             Object.Blessed=True ' set bless flag
          Else ' compare charges
             ' set incremented charges
             UserRecord.Charges(Array.Number)=Type.Charges
          Endif ' end compare maximum charges
       Case 1 ' bless item in room inventory
          ' get incremented charges
          Type.Charges=RoomRecord.TreCharges(Array.Number)+1
          If Type.Charges>Max.Charges Then ' compare maximum charges
             Object.Blessed=True ' set bless flag
          Else ' compare charges
             ' set incremented charges
             RoomRecord.TreCharges(Array.Number)=Type.Charges
             Call Share.Room.Record(Room) ' write room record
          Endif ' end compare maximum charges
       End Select ' end inventory type
       If Object.Blessed Then ' compare bless flag
          Outpt="Nothing happens!" ' make message
       Else ' compare bless flag
          Outpt="You bless it!" ' make message
       Endif ' end compare flag
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif
 Endif
 Outpt="You can't bless that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to bless an object

 Rem * routine to curse a monster by decreasing hits.

Sub Curse.Object
 On Local Error Resume Next ' local error resume
 If Normal.User Then ' check player type
    If UserRecord.ClassType<>Cleric Then ' check player class type to cleric
       Outpt="Only clerics can curse!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare class type
 Endif ' end compare player type
 Call Check.Monster ' search for monster parameter
 If Monster.Number Then ' index found to monster array
    Outpts=MonsterArray(Monster.Number).MonsterName ' store full monster name
    Outpts=Rtrim$(Outpts) ' strip trailing blanks
    Outpts=Lcase$(Outpts) ' convert to lower case
    Outpt="You curse the "+Outpts+"!" ' format message
    Call IO.O ' send message
    Multiplier=Int(UserRecord.Stats(6)/2) ' compute hits on monster multiplier
    Call Hit.Monster ' routine to attack a monster
    Exit Sub ' exit routine
 Endif ' end get monster index
 Outpt="You can't curse that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to curse a monster

 Rem * routine to bless player (bless without parameter).

Sub Bless.Self
 On Local Error Resume Next ' local error resume
 If Normal.User Then ' check player type
    If UserRecord.ClassType<>Cleric Then ' check player class type
       Outpt="Only clerics can bless!" ' message for clerics only
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare class type
 Endif ' end compare player type
 Type.Charges=UserRecord.Stats(6)+1 ' store incremented piety
 If Type.Charges>MaxStat Then ' compare to maximum piety
    Outpt="Nothing happens!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare piety
 UserRecord.Stats(6)=Type.Charges ' update new piety
 Outpt="You feel a glow about you!" ' make message
 Call IO.O ' send message
 Outpt="Your piety is now"+Str$(Type.Charges)+"!" ' format message
 Call IO.O ' send message
End Sub ' end routine to bless self

Rem * routine to curse player (curse without parameter).

Sub Curse.Self
 On Local Error Resume Next ' local error resume
 If Normal.User Then ' check player type
    If UserRecord.ClassType<>Cleric Then ' check player class type
       Outpt="Only clerics can curse!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare class type
 Endif ' end compare player type
 Type.Charges=UserRecord.Stats(6)-1 ' store decremented piety
 If Type.Charges<=False Then ' compare to minimum piety
    Outpt="Nothing happens!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare piety
 UserRecord.Stats(6)=Type.Charges ' set new piety
 Outpt="You feel a darkening about you!" ' make message
 Call IO.O ' send message
 Outpt="Your piety is now"+Str$(Type.Charges)+"!" ' format message
 Call IO.O ' send message
End Sub ' end routine to curse self

 Rem * routine to move a lanuch type object to a nearby room and move player
 Rem * to room also, verify room traps.

Sub Move.Object
 On Local Error Resume Next ' local error resume
 Call Parse ' parse out parameters
 If Parser Then ' check for first parameter
    Call Numeric '  parse temp variable from first parameter
 Endif ' end check parameter
 Call Examine.Treasure ' check treasure mnemonic in inventory or room
 If Index.Number=False Then ' locate treasure index
    Outpt="You can't move that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 If TreasureRecord.Movable=False Then ' compare treasure can be moved
    Outpt="You can't move that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 If TreasureRecord.Launchable=False Then ' compare treasure can be launched
    Outpt="You can't move that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 If Parser=False Then ' compare parameter parsed
    Outpt="Move which direction?" ' no direction specified
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check parse
 Treasure.Name$=Outpts ' store full treasure name to be moved
 Item.Number=Array.Number ' store treasure index to array
 Item.Charges=Charges.Number ' store treasure charges
 Item.Index=Index.Number ' store treasure index to file
 User.Command=Parsed.Command2 ' get second parameter
 Call Get.Direction(Direction.Number) ' compare moving parameter to direction
 If Direction.Number Then ' direction found flag set
    Next.Room=RoomRecord.Direct(Direction.Number) ' get room number direction
    Outpts=Rtrim$(Direction(Direction.Number)) ' store direction name
    If Next.Room=False Then ' compare room number
       Outpt="You can't move it there!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare room number
 Else ' no direction flag set, check for moving through an object
    Parsed.Command1=User.Command ' get second parameter
    Call Check.Room.Objects ' check with mnemonic name of object in room
    If Index.Number=False Then ' check object index
       Outpt="You can't move it there!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare room object
    If ObjectRecord.RoomLink=False Then ' verify room object links to room
       Outpt="You can't move it there!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare object is a portal
    If ObjectRecord.JailTrap Then ' verify room is trapped
       Outpt="Trapped portal!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare room trap
    If ObjectRecord.Closed Then ' compare room closed
       If Pass.Door=False Then ' check is passdoor spell cast
          Outpt="You can't, it's closed!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end cmpare passdoor
    Endif ' end compare object closed
    If ObjectRecord.Relocks Then ' object portal closes after entry
       ObjectRecord.DoorLock=2 ' set object portal lock
       ObjectRecord.Closed=True ' set object portal closed
       Call SHare.Record(ObjectFile,Index.Number) ' write object record
    Endif ' end compare relocking object portal
    Pass.Door=False ' reset passdoor spell
    Next.Room=ObjectRecord.RoomLink ' get room number to enter portal
    Outpts="into a "+Rtrim$(Lcase$(ObjectRecord.ShortName)) ' store object name
 Endif ' end compare move to a direction or to a portal
 Swap Room,Next.Room ' interchange current room with next room to move item
 Call Read.Room.Record(Room) ' read next room to move item to room file
 ' routine to add room item
 Call Add.Room.Treasure(Item.Index,Item.Charges,False,Item.Added)
 Swap Room,Next.Room ' interchange current room with next room
 Call Read.Room.Record(Room) ' read current room record
 If Item.Added Then ' add item to room flag
    Select Case Type.Number ' select room or inventory
    Case 0 ' treasure moved from player inventory
       Call Discard.Inventory(Item.Number,True) ' remove item from inventory
    Case 1 ' treasure moved from room
       Call Discard.Room.Treasure(Item.Number) ' remove item from room
    End Select ' end compare treasure moved
    Outpt="You move "+Treasure.Name$+" "+Outpts+"!" ' format message
    Call IO.O ' send message
    Call Enter.Room ' move player to next room
    Exit Sub ' exit routine
 Endif ' end locate empty room inventory
 Outpt="You can't move it there!" ' make message
 Call IO.O ' send message
End Sub ' end routine to move an item

 Rem * routine to launch an item in a specific direction to smash through
 Rem * a random amount of object portal locks connected through successive
 Rem * rooms, or to launch a weapon at a monster. weapon ammunition lands
 Rem * in last room accessed.

Sub Launch.Object
 On Local Error Resume Next ' local error resume
 Call Parse ' get first parameter
 If Parser Then ' found parameter
    Call Numeric ' parse number after # sign
 Endif ' end compare parse
 Call Examine.Treasure ' check treasure mnemonic to room or player inventory
 If Index.Number=False Then ' treasure index not found
    Outpt="You can't launch that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare index
 If TreasureRecord.Launchable=False Then ' check if treasure can be launched
    Outpt="That's not a launchable device!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare item to launch
 If Parser=False Then ' compare second parameter
    Outpt="Launch where?" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare second parameter
 Item.Launched=False ' item was launched flag
 Item.Type=Type.Number ' store inventory type
 Item.Index=Array.Number ' store launched item index to array
 Item.Charges=Charges.Number ' store launched item charges
 Launch.Item=TreasureRecord.LaunchLoads ' store item launched
 ' check item launch treasure record
 If Launch.Item>False And Launch.Item<=Lof(TreasureFile)/Len(TreasureRecord) Then
    Call Read.Record(TreasureFile,Launch.Item) ' read item launched record
    Call TreasureCharges(Launch.Charges) ' store item launched charges
 Endif ' end check item launched number
 Call Read.Record(TreasureFile,Index.Number) ' reread launch item
 If Charges.Number=False Then ' compare remaining charges in device
    Outpt="You can't, it's not loaded!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare device
 If Item.Charges>10 Then ' compare device charges
    Item.Charges=10 ' reset maximum charges
 Endif ' end compare device
 Launch.Number=False ' variable of number of loads launched
 Treasure.Name$=TreasureRecord.ShortName ' store name of device
 Treasure.Name$=Rtrim$(Treasure.Name$) ' strip trailing blanks
 Treasure.Name$=Lcase$(Treasure.Name$) ' convert to lower case
 User.Command=Parsed.Command2 ' get second parameter
 Parsed.Command1=User.Command ' store parameter
 Call Get.Direction(Direction.Number) ' determine direction to launch at
 If Direction.Number Then ' returned variable contains direction number
    Store.Room!=RoomRecord.Direct(Direction.Number) ' get next room direction
    If Store.Room!=SFalse Then ' compare room number
       Outpt="You can't launch at that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare room number
    Item.Launched=True ' set item is launched flag
    Outpts=Direction(Direction.Number) ' store direction name
    Outpts=Rtrim$(Outpts) ' strip trailing blanks
    Outpts=Lcase$(Outpts) ' convert to lower case
    Outpt="You launch the "+Treasure.Name$+" "+Outpts+"!" ' format message
    Call IO.O ' send message
    ' loop through all charges in device to launch
    For Launchs=1 To Item.Charges
       Graphics.Off=False ' color normal
       Outpt="For launch"+Str$(Launchs)+";" ' format message of launch number
       Call IO.O ' send message
       Launch.Number=Launch.Number+1 ' increment number of launches
       Graphics.Off=True ' color white
       Outpt="The device launchs: " ' message
       Carriage.Return=True ' suppress cr/lf
       Call IO.O ' send message
       Outpt=Outpts+", " ' first direction device launches
       Carriage.Return=True ' suppress cr/lf
       Call IO.O ' send direction message
       Locks.Smashed=False ' counter of number of locks smashed
       Chained.Rooms=False ' number of rooms chained to
       Next.Room=Store.Room! ' store room number
       Call Chain.Rooms(Next.Room,Room) ' routine to send launched item
       Outpt="and stopped!" ' trailing message
       Call IO.O ' send message
       ' place launched item in last room
       Swap Last.Room,Room ' reset current room
       Call Read.Room.Record(Room) ' read room
       ' add ammunition
       Call Add.Room.Treasure(Launch.Item,Launch.Charges,False,Added)
       Swap Last.Room,Room ' restore current room
       Call Read.Room.Record(Room) ' restore room record
    Next ' end loop through all device launch charges
    If Locks.Smashed=False Then ' compare number of locks smashed
       Outpt="You didn't smash anything!" ' make message
    Else ' compare lock number
       Outpt="You smashed open" ' format message
       Outpt=Outpt+Str$(Locks.Smashed) ' with number of locks smashed
       If Locks.Smashed=1 Then ' compare number
          Outpt=Outpt+" lock.." ' append message
       Else ' compare number
          Outpt=Outpt+" locks!" ' append message
       Endif ' end compare
    Endif ' end compare number
    Call IO.O ' send message
    Graphics.Off=False ' color normal
    Call Read.Room.Record(Room) ' read current room record
 Else ' verify monster to launch at
    Call Check.Monster ' find monster mnemonic to launch device at
    If Monster.Number Then ' found monster variable indexed to array
       Multiplier=Abs(TreasureRecord.Plus) ' compute attack multiplier
       ' store full monster name
       Outpts=MonsterArray(Monster.Number).MonsterName
       Outpts=Rtrim$(Outpts) ' strip trailing blanks
       Outpts=Lcase$(Outpts) ' convert to lower case
       Outpt="You launch "+Treasure.Name$+" at the "+Outpts+"!" ' make message
       Call IO.O ' send message
       Item.Launched=True ' set item is launched flag
       Graphics.Off=True ' color white
       ' loop through all charges in device to launch
       For Launchs=1 To Item.Charges
          ' format message of launch number
          Outpt="For launch"+Str$(Launchs)+";"
          Call IO.O ' send message
          Launch.Number=Launch.Number+1 ' increment number of launches
          Call Attack.Monster ' routine to hit monster
          Call Check.Monster ' reverify monster being attacked
          ' place launched item in room
          Call Add.Room.Treasure(Launch.Item,Launch.Charges,False,Added)
          If Monster.Number=False Then ' monster is not found
             Exit For ' exit device launch loop
          Endif ' end compare monster
       Next ' end loop through all device launch charges
       Graphics.Off=False ' color normal
    Endif ' end find monster
 Endif ' end compare launch direction or monster
 If Item.Launched=False Then ' device was launched flag
    Outpt="You can't launch at that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare if launched
 If Item.Type=False Then ' device launched from player inventory
    ' compute loads launched decrement
    Total.Charges=UserRecord.Charges(Item.Index)-Launch.Number
    If Total.Charges<False Then ' compare lower limit
       Total.Charges=False ' set lower limit
    Endif ' end compare limit
    UserRecord.Charges(Item.Index)=Total.Charges ' store inventory charges
 Else ' device launched from room
    ' compute loads launched decrement
    Total.Charges=RoomRecord.TreCharges(Item.Index)-Launch.Number
    If Total.Charges<False Then ' compare lower limit
       Total.Charges=False ' set lower limit
    Endif ' end compare limit
    RoomRecord.TreCharges(Item.Index)=Total.Charges ' store room charges
    Call Share.Room.Record(Room) ' write room record
 Endif ' end compare launched from
End Sub ' end routine to launch an item from a device

 Rem * routine to recursively enter rooms by nearby room links, smashing a
 Rem * random number of portals.

Sub Chain.Rooms(Chain.Room!,Previous.Room!)
 ' Chain.Room! is a passed parameter of the next room to access.
 ' Previous.Room! stores the called room number to be restored upon exit.
 On Local Error Resume Next ' local error resume
 Last.Room=Chain.Room! ' store last room recursed into
 Call Read.Room.Record(Chain.Room!) ' get next chained to room
 For Array.Number=1 To 20 ' loop through all objects in room
    Object.Number=RoomRecord.Object(Array.Number) ' get object index to file
    ' check object file bounds
    If Object.Number>False And _
    Object.Number<=Lof(ObjectFile)/Len(ObjectRecord) Then
       Call Read.Record(ObjectFile,Object.Number) ' get the object record
       If ObjectRecord.DoorLock=2 Then ' check if object is locked
          If Rnd>.66 Then ' compute random chance
             Locks.Smashed=Locks.Smashed+1 ' increment locks smashed counter
             ObjectRecord.DoorLock=1 ' set object unlocked
             ObjectRecord.Closed=False ' set object to open
             Call Share.Record(ObjectFile,Object.Number) ' write object record
          Endif ' end random chance
       Endif ' end compare object lock
    Endif ' end end object bounds
 Next ' end loop through all objects
 For Direction.Number=1 to 12 ' loop through all directions in chained to room
    Next.Room=RoomRecord.Direct(Direction.Number) ' get the room number of the
    If Next.Room Then ' direction and compare to
       If Next.Room<>Previous.Room! Then ' the current room in routine
          If Rnd>.66 Then ' compute random chance
             If Chained.Rooms<5 Then ' compare to maximum of 5 recursive calls
                Carriage.Return=True ' suppress cr/lf
                Outpt=Direction(Direction.Number) ' get direction name
                Outpt=Rtrim$(Outpt)+", " ' format message
                Call IO.O ' send message
                ' increment number of recursively chained rooms
                Chained.Rooms=Chained.Rooms+1
                Call Chain.Rooms(Next.Room,Chain.Room!) ' routine calls self
                Call Read.Room.Record(Chain.Room!) ' next room gets previous room
                Exit Sub ' recursively exit previous calls
             Endif ' end compare maximum
          Endif ' end random chance
       Endif ' end compare to current room
    Endif ' end compare next direction
 Next ' end loop through all directions in called room (exit recursively)
End Sub ' end routine to recursively loop through all objects in neraby rooms

 Rem * routine for player to steal an item from a monster.

Sub Steal.Object
 On Local Error Resume Next ' local error resume
 If Normal.User Then ' check player type
    If UserRecord.ClassType<>Thief Then ' check player class type
       Outpt="Only thieves can steal!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare class type
 Endif ' end compare player type
 Call ParseX ' parse the second parameter
 If Parser Then ' parse the
    Call Numeric ' number after the # sign
 Endif ' end parse
 If Parser=False Then ' no second parameter
    Outpt="Steal from whom?" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare parse
 Call Check.Monster ' verify monster mnemonic
 If Monster.Number Then ' monster index
    Parsed.Command1=Lcase$(Parsed.Command2) ' get first parameter
    Call Numeric ' parse number
    For Array.Number=1 To 5 ' loop through all monster treasure
       ' get monster treasure index
       Treasure.Number=MonsterArray(Monster.Number).Treasure(Array.Number)
       ' check file bounds
       If Treasure.Number>False And _
       Treasure.Number<=Lof(TreasureFile)/Len(TreasureRecord) Then
          Call Read.Record(TreasureFile,Treasure.Number) 'read treasure record
          Inpt=TreasureRecord.ShortName ' store short treasure mnemonic
          Inpt=Rtrim$(Inpt) ' strip trailing blanks
          Inpt=Lcase$(Inpt) ' convert to lower case
          Inpt=Left$(Inpt,Len(Parsed.Command1)) ' shorten to parsed length
          If Inpt=Parsed.Command1 Then ' compare treasure to parsed treasure
             ' compare monster to magical, or permanent
             If MonsterArray(Monster.Number).Magic<=True Or _
             MonsterArray(Monster.Number).Permanent<=True Then
                Outpt="You can't steal from that monster!" ' make message
                Call IO.O ' send message
                Exit Sub ' exit routine
             Endif ' end compare monster
             ' compute random chance
             If Int(Rnd*5+5)>UserRecord.Stats(4)/2 Then
                Outpt="Didn't work!" ' make message
                Call IO.O ' send message
                Exit Sub ' exit routine
             Endif ' end random chance
             Inpt=TreasureRecord.TreasureName ' get full name of treasure
             Inpt=Rtrim$(Inpt) ' strip trailing blanks
             Inpt=Lcase$(Inpt) ' convert to lower case
             ' get monster name
             Outpts=MonsterArray(Monster.Number).MonsterName
             Outpts=Rtrim$(Outpts) ' strip trailing blanks
             Outpts=Lcase$(Outpts) ' convert to lower case
             Item.Charges=TreasureRecord.Charges ' store charges
             ' add to player inventory
             Call Add.Inventory(Treasure.Number,Item.Charges,Item.Added)
             If Item.Added Then ' flag set to add inventory
                Outpt="You steal "+Inpt+" from the "+Outpts+"!" ' make message
                Call IO.O ' send message
                ' clear element in monster inventory array
                MonsterArray(Monster.Number).Treasure(Array.Number)=False
                Exit Sub ' exit routine
             Endif ' end compare flag
          Endif ' end compare treasure
       Endif ' end compare treasure
    Next ' end loop through all monster inventory
 Endif ' end find monster number
 Outpt="You can't steal that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to steal

 Rem * routine to throw an item of player inventory at monster, weapon falls
 Rem * into the room.

Sub Throw.Object
 On Local Error Resume Next ' local error resume
 If Normal.User Then ' verify player type
    If UserRecord.ClassType<>Thief Then ' verify player class type
       Outpt="Only thieves can throw!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare class type
 Endif ' end compare player type
 Call ParseX ' get second parameter
 If Parser Then ' parse parameter
    Call Numeric ' store number
 Endif ' end compare parse
 If Parser=False Then ' missing second parameter
    Outpt="Throw at whom?" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare parameter
 Call Check.Monster ' find monster in room
 If Monster.Number Then ' found monster index
    Last.Monster=Parsed.Command1 ' reset last monster attacked
    Parsed.Command1=Ucase$(Parsed.Command2) ' get first parameter
    Call Numeric ' parse number sign
    Call Check.Inventory.Treasure ' search player inventory for treasure
    If Index.Number>False Then ' found treasure index in player inventory
       ' weapon being held must match the weapon thrown
       If Weapon6=Array.Number Then
          Multiplier=Weapon2 ' set attack multiplier
          Inpt=MonsterArray(Monster.Number).MonsterName ' get monster name
          Inpt=Rtrim$(Inpt) ' strip trailing blanks
          Inpt=Lcase$(Inpt) ' convert to lower case
          Outpt="You throw "+Outpts+" at the "+Inpt+"!" ' format message
          Call IO.O ' send message
          If Int(Rnd*5+2)>UserRecord.Stats(4)/2 Then ' compute random chance
             Outpt="You missed!" ' make message
             Call IO.O ' send message
          Else ' random chance
             Parsed.Command1=Last.Monster ' reset parameter to last monster
             Last.Command.Number=55 ' reset the command number to attack
             Call Attack.Monster ' routine to hit monster
          Endif ' end random chance
          Call Discard.Inventory(Weapon6,False) ' remove item from inventory
          Exit Sub ' exit routine
       Endif ' end compare weapon being held
       Outpt="You aren't holding the weapon!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end search for weapon to throw
 Endif ' end search for monster
 Outpt="You can't throw that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to throw an object

 Rem * routine to fuel an item from the charges of another item.

Sub Fuel.Object
 On Local Error Resume Next ' local error resume
 Call Find.Inventory ' parse first parameter, search player inventory
 Treasure.Name$=TreasureRecord.ShortName ' store treasure short mnemonic name
 Treasure.Name$=Rtrim$(Treasure.Name$) ' strip trailing blanks
 Treasure.Name$=Lcase$(Treasure.Name$) ' convert to lower case
 If Index.Number=False Then ' compare treasure index
    Outpt="You can't fuel that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare index
 If TreasureRecord.LightType=False Then ' check treasure can be fueled
    Outpt="You can't fuel that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 If TreasureRecord.LightCharges=False Then ' check treasure can be fueled
    Outpt="It has no light charges!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 If UserRecord.Charges(Array.Number) Then ' check treasure already fueled
    Outpt="It's already fueled!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 Fuel.Charges=TreasureRecord.LightCharges ' store treasure light charges
 Item.Number=Array.Number ' store treasure array index
 If Parser=False Then ' compare second parameter
    Outpt="Fuel with what?" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare parse
 Parsed.Command1=Parsed.Command2 ' get second parameter
 Call Numeric ' parse number
 Call Find.Inventory ' search player inventory
 If Index.Number=False Then ' compare treasure index
    Outpt="You can't fuel with that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare index
 If TreasureRecord.FuelType=False Then ' check treasure is a fuel
    Outpt="You can't fuel with that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 If TreasureRecord.FuelCharges<=False Then ' check treasure fuel amount
    Outpt="It has no fuel charges!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 If UserRecord.Charges(Array.Number)=False Then ' check fuel charges
    Outpt="It has no fuel charges!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 ' decrement fuel
 UserRecord.Charges(Array.Number)=UserRecord.Charges(Array.Number)-1
 UserRecord.Charges(Item.Number)=Fuel.Charges ' add fuel charges to treasure
 Outpt="You fuel the "+Treasure.Name$+"!" ' format message
 Call IO.O ' send message
End Sub ' end routine to fuel an item

 Rem * routine to light an item.

Sub Light.Object
 On Local Error Resume Next ' local error resume
 Call Check.Inventory.Treasure ' search for player inventory treasure
 If Index.Number=False Then ' compare treasure index
    Outpt="You can't light that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure index
 If TreasureRecord.LightType=False Then ' check treasure is a light
    Outpt="That's not a light!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 If UserRecord.Charges(Array.Number)=False Then ' check treasure is fueled
    Outpt="You can't, it's not fueled!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 ' check treasure is already lit
 If UserRecord.Charges(Array.Number)<False Then
    Outpt="It's already lit!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare treasure
 ' set inventory charges
 UserRecord.Charges(Array.Number)=-UserRecord.Charges(Array.Number)
 Outpts=TreasureRecord.ShortName ' to negative to indicate treasure is a light
 Outpts=Rtrim$(Outpts) ' store treasure name, strip trailing blanks
 Outpts=Lcase$(Outpts) ' convert to lower case
 Outpt="You light the "+Outpts+"!" ' format message
 Call IO.O ' send message
End Sub ' end routine to light an item

Rem * dm/sysop routine to discard an item of inventory to nowhere, can be
Rem * used interactively during remote with function key.

Sub Discard.Object
 On Local Error Resume Next ' local error resume
 Call Check.Inventory.Treasure ' find treasure in player inventory
 If Index.Number Then ' treasure index to player array
    ' routine to remove from inventory
    Call Discard.Inventory(Array.Number,True)
    Outpt="You discard "+Outpts+"!" ' format message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end search treasure inventory
 Call Num ' decrement parse counter
 Call Check.Inventory.Objects ' find object in player inventory
 If Index.Number Then ' object index to player array
    Call Discard.Inventory.Object(Array.Number)
    Outpt="You discard "+Outpts+"!" ' format message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end search object inventory
 Call Num ' decrement parse temp
 Call Check.Inventory.Container ' check player inventory for container
 If Index.Number Then ' returns index of container to treasure
    Outpts=Rtrim$(ContainerRec.ContainerName) ' message
    Call Clear.Container(0,True) ' clear player container structure
    UserRecord.Container(Array.Number)=ContainerRec ' clear container record
    Outpt="You discard "+Outpts+"!" ' format message
    Call IO.O ' send output
    Exit Sub ' return from routine
 Endif ' end check container index
 Outpt="You can't discard that!" ' make message
 Call IO.O ' send message
End Sub ' end routine to discard an item
