 Rem * Filename: dnddoor.inc  Version: v5.0a r1.0a
 Rem * Variables here are included common to all subprograms.

 DefInt A-Z   ' define all default variables as integers
 Rem $Dynamic ' allocate common variables and arrays at runtime

 '  define register type for interrupt function
 Type RegType
  AX As Integer ' A register
  BX As Integer ' B register
  CX As Integer ' C register
  DX As Integer ' D register
  BP As Integer ' base pointer
  SI As Integer ' source index
  DI As Integer ' destination index
  Flags As Integer ' cpu flags
  DS AS Integer ' data segment
  ES AS Integer ' extra segment
 End Type

 '  define structure for containers
Type ContainerType
 Closed As Integer ' closed flag 1=closed, 0=n/a, -1=open
 ContainerName As String*30 ' container name from treasure.dat file
 Locked As Integer ' locked flag 1=locked, 0=n/a, -1=unlocked
 Keyed As Integer ' container key number 1-32767
 ShortName As String*30 ' mnemonic of container name from treasure.dat file
 Charges(1 To 5) As Integer ' treasure charges of container contents
 Inventory(1 To 5) As Integer ' index to treasure.dat of container contents
 Invisible(1 To 5) As Integer ' invisible flag -1/0 of container contents
 TreasureName(1 To 5) As String*30 ' treasure name of container contents
 Permanent As Integer ' flag for permanent container (added 05/25/01)
End Type

 '  action structure
Type ActionType
 Attribute1 As Integer ' room attribute one, 0=lit/-1=unlit
 Attribute2 As Integer  ' room attribute two, 0=land/1=air/2=underwater
 EncounterRate As Integer ' rate of action prompts to encounter monster
 Fumble As Integer ' fumble weapons/shield result
 HealthRate As Integer ' rate of action prompts to increase user health
 HitPoints As Integer ' negative/positive hits for vit/fat result
 Inventory As Integer  ' weapons=1/shields=2/armor=3/magic items=4 breakage
 Level As Integer ' negative/positive value=lower/highest user level to enter
 MonsterTalk As Integer ' talk to monster number trigger
 MonsterTrigger As Integer ' number of room monster trigger
 Restrictions As Integer ' level direction is restricted to, 12 bit flags
 RustRate As Integer ' rate of action prompts weapons/shields rust
 SpellTrigger As Integer ' number of room spell trigger
 StealRate As Integer ' rate of action prompts monsters steal
 Teleport As Single ' teleport trap room number result
End Type

 '  define room structure. this main data file contains room descriptions,
 '  directions, one container, action number, object and treasure indexes.
Type RoomType
 Action As Integer ' index to action file
 Direct(1 To 12) As Single  ' direction link values to next room number
 Flags(1 To 20) As Integer ' treasure is: hidden=1/trap=2/magically hidden=3
 LongDesc(1 To 5) As String*80 ' five line long description of room
 MonsterClass As Integer ' number of room monster class in monclass.dat file
 Object(1 To 20) As Integer ' number of object from objects.dat file
 HiddenObj(1 To 20) As Integer ' object flags, -1=hidden
 ShortDesc As String*80 ' one line short description of room for brief mode
 Treasure(1 To 20) As Integer ' number of treasure from treasure.dat file
 TreCharges(1 To 20) As Integer ' treasure charges
 Container As ContainerType ' single container per room
End Type

 '  define user structure. this main data file contains user statistics,
 '  values, flags, object and treasure indexes.
Type UserType
 CodeName As String*30 ' encrypted user codename
 PassWord As String*20 ' encrypted user password
 ClassName As String*20 ' encrypted user classname
 ClassType As Integer ' classname number 1-10
 Container(1 To 3) As ContainerType ' user's maximum of 3 containers
 Inv(1 To 20) As Integer ' user's inventory index to treasure.dat file
 Charges(1 To 20) As Integer ' treasure's charges/plus
 Object(1 To 20) As Integer ' user's object index to objects.dat file
 TrainRoom(1 To 10) As Single ' training room array
 Stats(1 To 7) As Integer ' player statistics str/int/wis/dex/con/pie/cha
 Weapons(1 To 4) As Integer ' weapons proficiency percent blu/pol/sha/thr
 Room As Single ' room number
 Level As Integer ' player's level
 Experience As Double ' player's experience
 Gold As Double ' collected gold
 NumCalls As Integer ' number of calls during one day
 Fatigue As Integer ' fatigue points during fighting
 FatigueMax As Integer ' maximum possible fatigue points
 Vitality As Integer ' vitality points during fighting
 VitalityMax As Integer ' maximum possible vitality points
 Magic As Integer ' magic points during fighting/using spells
 MagicMax As Integer ' maximum possible magic points
 Poison As Integer ' user is poisoned true/false, vitality decreasing
 Borrow As Double ' gold borrowed from bank
 Invisible As Integer ' user is invisible true/false
 Race As Integer ' player's race 1-8, hum/elf/gno/dwa/hal/hal-elf/hal-orc/ogr
 Proficiency As Integer ' weapon user is proficient in 1-4
 Bank As Double ' amount gold stored in bank
 Sort As Integer ' sort inventory (-1/0/1)
 MonstersKilled As Single ' total of all monsters killed during play
 Brief As Integer ' brief mode true/false
 DateOn As String*10 ' last date user logged on, form: MM-DD-YYYY
 Beauty As Integer ' lady class beauty points
 Glamour As Integer ' lady class glamour points
 Psionic As Integer ' psionic points during fighting/casting psi spells
 PsionicMax As Integer ' maximum possible psionic points
 Align1 As Integer ' alignment type 1, good/neutral/evil
 Align2 As Integer ' alignment type 2, lawful/neutral/chaotic
 Flags As Integer ' 1=rerolled/2-128=stat wish/256=wish/512=realigned/chars
 MaxCalls As Integer ' maximum calls user is allowed per day
 FromHour As Integer ' time restriction logon from hour,
 FromMin As Integer ' time restriction logon from minute,
 ToHour As Integer ' time restriction logon to hour,
 ToMin As Integer ' time restriction logon to minute.
 Echo As Integer ' echo mode 0=on,-1=off
 LastMessage As Integer ' last message read
 Linefeeds As Integer ' linefeed mode 0=on,-1=off
 Linelength As Integer ' linelength for display
 Pagelength As Integer ' pagelength for display
 Wordwrap As Integer ' word wrap 0=on,-1=off
End Type

 '  define spell structure. this data file contains spell statistics,
 '  values, and flags. this struture is used by treasure and spells.
Type SpellType
 SpellName As String*30 ' full name of spell
 Chant As String*80 ' chant to be used for spell
 Level As Integer ' level of spell/level user must be at least to cast spell
 SpellType As Integer ' spell type 1-28
 Teleport As Single ' spell teleports when cast
 Psionic As Integer ' spell is psionic, true/false
 PsionicMode As Integer ' spell is psionic, 1=attack/2=defense
 ClassType As Integer ' user class allowed to cast spell, flags 1-8
 Desc As String*80 ' description displayed when spell is cast
 Ingred(1 To 5) As Integer ' index to treasure.dat of required ingredients
 SpellFlag As Integer ' ingredients type required flag, 1=use/2=read/4=cast
End Type

 '  define monster class structure. this data file contains lists of monsters.
Type MonclassType
 Monsters(1 To 10) As Integer ' indexed list of ten monsters from monster.dat
End Type

 '  define object structure. this data file contains object statistics,
 '  values, and flags. this struture is used by users and rooms.
Type ObjectType
 ObjectName As String*30 ' full name of object
 ShortName As String*30 ' mnemonic of object name
 RoomLink As Single ' link to room number for entering object, or for jail
 Invisible As Integer  ' is invisible (-1/0)
 JailTrap As Integer ' jails user if attacked, roomlink is jail room number
 DoorLock As Integer ' locked (0=n/a,1=unlocked/2=locked)
 Destination As Integer ' n/a (used to be room object was created)
 Permanent As Integer ' cannot be picked up. default.
 Hidden As Integer ' hidden (cannot not be seen or searched for)
 Closed As Integer  ' closed (-1=closed/0=open)
 Keyed As Integer ' key number 1-32767
 Relocks As Integer ' relocks after entering
 LongDesc As String*80 ' description displayed when object looked at
 FromHour As Integer ' lights room from hour,
 FromMin As Integer ' lights room from minute,
 ToHour As Integer ' lights room to hour,
 ToMin As Integer ' lights room to minute.
 LightRoom As Integer ' lights room (-1=true/0=false)
 LightTime As Integer ' light time (-1=from-to/0=anytime)
 ShortDesc As String*80 ' description displayed when object entered
 Trap As Integer ' trapped portal (1=poison/2=teleport/3=hits for fat/vit)
 Teleport As Single ' (room number, trap=2), (hits -fat/hits +vit, trap=3)
End Type

 '  define monster structure. this data file contains monster statistics,
 '  values, and flags.
Type MonsterType
 MonsterName As String*30 ' full name of monster
 PluralName As String*30 ' mnemonic plural of monster name
 Treasure(1 To 5) As Integer ' five indexes to treasure.dat
 Experience As Double ' experience gained by killing monster
 Gold As Double ' money gained by killing monster
 NumberAppearing As Integer ' maximum monsters encontered at one time
 Level As Integer ' monster level/level of user required to kill monster
 Hits As Integer ' hit points monster has for user to kill
 Poison As Integer ' monster can poison=-1/monster is poisoned>0
 LevelDrain As Integer ' can drain user levels (-1/0)
 Spell As Integer ' can cast spells (equal to spell record number)
 Block As Integer ' can block user from exiting room
 Prevent As Integer ' can prevent user from taking treasure
 Follow As Integer ' can follow user, otherwise contains jail room number
 Magic As Integer ' casts magic spell (equals index to spell record number)
 Jail As Integer ' can jail attacker (-1/0), room number is in follow
 Teleport As Single ' can teleport (equals room number)
 FollowPercent As Integer ' percentage to follow
 BlockPercent As Integer ' percentage to block
 PreventPercent As Integer ' percentage to prevent
 SpellPercent As Integer ' percentage to cast spell
 PoisonPercent As Integer ' percentage to poison
 DrainPercent As Integer ' percentage to drain levels
 Rate As Integer ' encounter rate (action prompts)
 RatePercent As Integer ' percentage encountered at rate
 Permanent As Integer ' monster is permanent to room
 Talk(1 To 5) As Integer ' five indexes to montalk.dat
 Psionic As Integer ' monster casts psionic spells
 PsionicSpell As Integer ' psionic spell casted
End Type

 '  define treasure structure. this data file contains treasure statistics,
 '  values, and flags. this struture is used by users and rooms.
Type TreasureType
 TreasureName As String*30 ' full treasure name
 ShortName As String*30 ' mnemonic treasure name
 Weight As Integer ' weight in gold of treasure
 Gold As Integer ' value in gold of treasure
 Spell As Integer ' treasure is magical (index of spell record)
 Plus As Integer ' treasure plus (0=normal treasure/greater>0=weapon plus)
 Coin As Integer ' coins (-1/0)
 Keyed As Integer ' key number (1-32767)
 Scroll As Integer ' scroll (-1/0)
 Charges As Integer ' charges for weapon/armor/shield/spell
 Potion As Integer ' potion (-1/0)
 Armor As Integer ' treasure is armor
 Shield As Integer ' treasure is shield
 Weapon As Integer ' treasure is weapon
 Container As Integer ' container (-1/0)
 Type As Integer ' treasure type (-1=shield/0=normal/1=armor/0,<plus>=weapon)
 Locked As Integer ' container (1=locked,0=n/a,-1=unlocked)
 Closed As Integer ' container (1=closed,0=n/a,-1=open)
 Loadable As Integer ' can be loaded with ammunition (-1/0)
 Ammunition As Integer ' is ammunition (-1/0)
 AmmoLoads As Integer ' if ammunition, then index to treasure.dat it loads
 Invisible As Integer ' invisible (-1/0)
 Permanent As Integer ' treasure remains in room (not default)
 Proficiency As Integer ' weapon proficiency related (1-4)
 RingType As Integer ' is a ring (1=antipoison/2=antileveldrain/3=antispell)
 RingSpell As Integer ' ring antispell (-1=generic/greater>0=spell number)
 Edible As Integer ' edible (-1/0)
 Rustable As Integer ' rusts (-1/0)
 RustPercent As Integer ' percentage rusts during room rust rate
 Stealable As Integer ' stealable (-1/0)
 StealPercent As Integer ' percentage monster steals during room steal rate
 Launchable As Integer ' can be launched with launch ammunition (-1/0)
 LaunchLoads As Integer ' is launch ammunition (-1/0)
 LaunchAmmo As Integer ' if launch ammo, then index to treasure.dat it loads
 Movable As Integer ' launchable device can be moved (-1/0)
 Vehicle As Integer ' vehicle (-1/0)
 VehicleHits As Integer ' vehicle hit points for combat
 VehicleType As Integer ' vehicle type (0=land,1=air,2=underwater,3=any)
 LightType As Integer ' is a light (-1/0)
 LightCharges As Integer ' light charges
 FuelType As Integer ' is light fuel (-1/0)
 FuelCharges As Integer ' fuel charges
End Type

 '  define monster talk structure. this data file contains lists of strings
 '  monsters can respond with when talked to.
Type MonsterTalkType
 TalkMessage As String*80 ' an 80 character string response
End Type

 '  help file record structure. used for help command during play,
 '  uses files help.dat, edithelp.dat, dmhelp.dat, and logon.dat.
Type HelpType
 Text As String*79 ' text to display (updated 11/16/2001).
 CName As String*15 ' command name of command to display
End Type

 '  structure for messages text file. indexed by the table record structure.
Type MessageType
 Message As String*80 ' length of a message line
End Type

 '  table for messages. stores subject, from/to, date entered, private message
 '  and if the message is deleted. fields for start and length define the
 '  position of the message in the messages text file.
Type TableType
 ClassType As Integer ' class type of the player who entered the message
 Clock As String*21 ' stores the time the message was entered from FNclock$
 Date As String*10 ' system date message was stored
 Flags As Integer ' user record flags for special characters entered message
 From As String*30 ' field storing user who entered the message
 Killed As Integer ' true if the message is deleted
 Length As Integer ' length of lines in messages text file
 Private As Integer ' true if the message is private
 Received As Integer ' flag indicating message was read
 Reply As Integer ' flag for message reply
 Start As Single ' beginning of the line of the message in the text file
 Subject As String*20 ' stores the subject of the message
 Thread As Integer ' number of message replied to
 Time As String*10 ' stores system time message was entered
 Timer As Single ' stores system time in seconds message was entered
 TimesRead As Integer ' stores number of times message was read
 To As String*30 ' stores name of the user the message is to, or empty for all
End Type

 '  define variables, fixed length/variable strings, and
 '  dynamic arrays common to all subprograms.
Common Shared _
 ActionRecord As ActionType,_ ' action structure
 Action.Prompt As String,_ ' stores action prompt Next: or Command>
 Alignment.Name1() As String*7,_ ' stores three type 1 alignment names
 Alignment.Name2() As String*7,_ ' stores three type 2 alignment names
 Allow.Break As Integer,_ ' allows control-k checking during file output
 Array() As String,_ ' string array for mail
 Array.List() As String*16,_ ' string array for command help
 Array.Number As Integer,_ ' contains number of array element searched for
 Baud.Override As Integer,_ ' command line baud override
 BBS.Name As String,_ ' name of calling bbs name from rbbs .def file
 Break As Integer,_ ' returns -1 is control-k pressed
 Buffer As String,_ ' stores modem i/o
 Carriage.Return As Integer,_ ' supresses linefeed during output
 Charges.Number As Integer,_ ' contains charges of item searched for
 Chained.Rooms As Integer,_ ' used in launch routine
 Chat As Integer,_ ' chat mode flag
 Choice As Integer,_ ' monster number selected
 Class.Name() As String*15,_ ' stores ten class names
 Color.Code As Integer,_ ' current ansi color
 Color.Graphics As Integer,_ ' ansi color activated remote
 Command.Name As String,_ ' storage of user command
 Continue As Integer,_ ' flag for continuous output
 ContainerRec As ContainerType,_ ' container structure
 Direction As Integer,_ ' direction 1-11
 Direction() As String*9,_ ' stores eleven direction names
 Door.Name As String,_ ' name of calling bbs user from rbbs .def file
 Door.Time As Single,_ ' time left from rbbs .def file
 DOS.Major As Integer,_ ' dos major version
 DOS.Minor As Integer,_ ' dos minor version
 Dungeon.Master As Integer,_ ' user is dungeon master (-1/0)
 Dungeon.Master.Assistant As Integer,_ ' user is asst. DM (-1/0)
 Entry.Command As Integer,_ ' last command number used for room entry
 FileName As String,_ ' file name storage
 Func.Buffer As String,_ ' buffer of interactive pressed function key
 Governor As Integer,_ ' user is governor (-1/0)
 Graphics.Off As Integer,_ ' set ansi graphics off (to white) (-1/0)
 Guild.Master As Integer,_ ' user is guild master (-1/0)
 HelpRecord As HelpType,_ ' help record structure
 Hidden.Player As Integer,_ ' player is hidden (-1/0)
 Hidden As Integer,_ ' mask input for security i/o with Mask$
 High.Class.Name() As String*15,_ ' ten high class names
 Inpt As String,_ ' user i/o input
 Index.Number As Integer,_ ' contains index number of an item searched for
 Intoxicated As Integer,_ ' user is intoxicated (equal to action prompts)
 Invisible As Integer,_ ' user is invisible (-1/0)
 Jail.Room.Number As Single,_ ' room to send user when jailed
 Last.Command As String,_ ' last command entered
 Last.Command.Number As Integer,_ ' number of last command entered
 Last.Monster As String,_ ' name of last monster attacked
 Last.Room As Single,_ ' stores temporary room number
 Learned.Spells As String,_ ' string of 1's and 0's of spells learned
 Line.Length As Integer,_ ' maximum length of input allowed
 Line.Limit As Integer,_ ' used with word wrap
 Local.Mode As Integer,_ ' user is logged in at console
 Locks.Smashed As Integer,_ ' used in launch routine
 Logged.In As Integer,_ ' flag indicating user is logged in
 Magic.Spell As Integer,_ ' magic spell number of spells.dat being cast
 Max.Row As Integer,_ ' maximum rows used for screen scrolling/output
 Message1 As String,_ ' stores message when user killed for death routine
 Message.Length As Integer,_ ' stores length of message in mail
 Message.Reply As Integer,_ ' flag for message reply
 Message.Thread As Integer,_ ' message number replied to
 Message.To As String,_ ' stores message to in mail
 MessageRecord As MessageType,_ ' message record structure for mail
 Modem.Baud As Integer,_ ' connect speed, 00 truncated
 Monclass As Integer,_ ' current room monster class
 Monclass.Max As Integer,_ ' maximum monster classes in monclass array
 MonclassRecord As MonclassType,_ ' monster class record structure
 Monster.Class() As Integer,_ ' array of monster classes
 Monster.Cycle As Integer,_ ' incrementing counter for monster attacks
 Monster.Number As Integer,_ ' stores currently accessed monster number
 Monster.Percent() As Integer,_ ' array of monster percents
 Monster.Rate() As Integer,_ ' array of monster encounter rates
 Monster.Rate1 As Integer,_ ' counts file monster rates
 Monster.Rate2 As Integer,_ ' counts room monster rates
 MonsterArray() As MonsterType,_ ' array of 20 monster record structures
 MonsterIndex() As Integer,_ ' array of 20 indexes to monster.dat file
 MonsterRecord As MonsterType,_ ' defines monster structure
 Monsters.Killed As Integer,_ ' total monsters killed in session
 MonsterTalkRecord As MonsterTalkType,_ ' monster class structure
 Multiplier As Integer,_ ' multiplier used in combat
 New.Room As Integer,_ ' added new room flag
 Next.Room As Single,_ ' next room storage
 No As Integer,_ ' entered N during input (-1/0)
 No.Echo As Integer,_ ' do not echo user input
 No.Input As Integer,_ ' null was entered (-1/0)
 No.Input.Out As String,_ ' string to return if null entered during input
 Node As String,_ ' node in string form
 Node1 As Integer,_ ' node number (0-9,A-Z)
 Node2 As Integer,_ ' node number (0-99)
 Normal.User As Integer,_ ' user has special attributes (-1/0)
 Number.Appearing As Integer,_ ' maximum monsters of one type encountered
 Number.Monsters As Integer,_ ' current number of active monsters in room
 ObjectRecord As ObjectType,_ ' object structure
 Outpt As String,_ ' user i/o output
 Outpts As String,_ ' temporary user i/o output variable
 Parse.Count As Integer,_ ' parsed count to decrement
 Parse.Number As Integer,_ ' stores command numbers (pound sign) quantity
 Parsed.Command1 As String,_ ' first or second command parsed from input
 Parsed.Command2 As String,_ ' first or second command parsed from input
 Parser As Integer,_ ' position of command second word parsed 
 Pass.Door As Integer,_ ' passdoor spell cast
 Player.CodeName As String,_ ' storage for user codename
 Player.PassWord As String,_ ' storage for user password
 Port As Integer,_ ' modem port being used (0-7)
 Port.Override As Integer,_ ' command line override
 Prefix1 As String,_ ' the/or/an
 Previous.Command As Integer,_ ' -1=use,0=n/a,equals last command number
 Previous.Command1 As String,_ ' storage of previous command 
 Previous.Command2 As String,_ ' storage of previous parsed command
 Previous.Command3 As String,_ ' storage of previous second parsed command
 Private.Message As Integer,_ ' flag for mail
 Psi.Attack.Mode As Integer,_ ' last offense psi spell cast
 Psi.Defense.Mode As Integer,_ ' last defense psi spell cast
 Quit As Integer,_ ' true if Q entered
 Race() As String*8,_ ' stores eight race names
 Resurrection.Room As Integer,_ ' specifies room number to be resurrected to
 Room As Single,_ ' current room number
 Room.Health.Rate As Integer,_ ' number of action prompts for health update
 Room.Monster.Rate As Integer,_ ' number of action promptsfor monster update
 Room.Rate As Integer,_ ' counter of action prompts for room rate
 Room.Rust.Rate As Integer,_ ' counter of room rust rate
 Room.Steal.Rate As Integer,_ ' counter of room steal rate
 RoomRecord As RoomType,_ ' room structure
 Rust.Rate As Integer,_ ' rust rate in action prompts
 Share.Installed As Integer,_ stores share setting
 Sorting As Integer,_ ' inventory sorting (-1/0/1)
 SpellRecord As SpellType,_ ' spell structure
 Spell.Number As Integer,_ ' spell number being used
 Spell.Cast.Type As Integer,_ ' type of spell being cast
 Stat() As String*12,_ ' storage of eight statistics names
 Steal.Rate As Integer,_ ' steal rate in action prompts
 Stored.Parsed.Command1 As String,_ ' first parsed command from user input
 Stored.Parsed.Command2 As String,_ ' second parsed command from user input
 Subject As String,_ ' store mail subject
 Sysop As Integer,_ ' contains -1 if player is sysop
 TableRecord As TableType,_ ' message table for mail
 Teleported As Integer,_ ' user entered room by teleporting (-1/0)
 TempRecord As MessageType,_ ' temporary structure
 Temp, Temp!, Temp$,_ ' global temporary variables
 Temp.Array1() As Integer,_ ' global temporary variables
 Temp.ArrayX() As Integer,_ ' global temporary variables
 Temp.ArrayZ() As Double,_ ' global temporary variables
 Temp0, Temp1, Temp2, Temp3, Temp4,_ ' global temporary variables
 Temp5, Temp6, Temp7, Temp8, Temp9,_ ' global temporary variables
 Time.Calc As Single,_ ' time storage variable
 Time.Left As Single,_ ' amount of time user is allowed on in seconds
 Time.On As String,_ ' time user logged on in Date$ format
 Timeon As Single,_ ' time user logged on in Timer format
 Timelogged.On As Double,_ ' time user logged on on double format
 Town.Mayor As Integer,_ ' user is town mayor (-1/0)
 Training.Stats() As Integer,_ ' storage for training statistics
 TreasureRecord As TreasureType,_ ' treasure structure
 Two.Minutes.Left As Integer,_ ' flag indicating two minutes warning shown
 Type.Number As Integer,_ ' flag for type of object in room or inventory
 Upper.Case As Integer,_ ' flag to force first character uppercase in io.i
 User.Echo As Integer,_ ' stores online user echo preference
 User.LineFeeds As Integer,_ ' stores online user linefeed preference
 User.LineLength As Integer,_ ' stores online user linelength preference
 User.PageLength As Integer,_ ' stores online user pagelength preference
 User.Wordwrap As Integer,_ ' stores online user wordwrap preference
 User.Command As String,_ ' stores original user input
 User.Index As Integer,_ ' index of user number to users.dat file
 User.Number As Integer,_ ' alternate user index variable
 UserRecord As UserType,_ ' user structure
 UserRecord2 As UserType,_ ' alternate user structure
 Vehicle1 As Integer,_ ' vehicle index to room treasure array
 Vehicle2 As Integer,_ ' charges in vehicle
 Vehicle3 As Integer,_ ' index to treasure.dat file
 Vehicle4 As Integer,_ ' vehicle type (0-3)
 Weapon.Type.Name() As String*9,_ ' storage of four weapon names
 Weapon1 As Integer,_ ' plus of armor worn
 Weapon2 As Integer,_ ' plus of weapon held
 Weapon3 As Integer,_ ' plus in shield held
 Weapon4 As Integer,_ ' index to user inventory array of armor worn
 Weapon5 As Integer,_ ' index to user inventory array of shield held
 Weapon6 As Integer,_ ' index to user inventory array of weapon held
 Weapon7 As Integer,_ ' index to user inventory array of ring worn
 Weapon8 As Integer,_ ' ring type (1=antipoison/2=antileveldrain/3=antispell)
 Weapon9 As Integer,_ ' ring antispell (-1=generic/greater>0=spell number)
 Weapon10 As Integer,_ ' proficiency number of weapon held
 Weapon11 As Integer,_ ' item plus of ring being worn
 Weight As Integer,_ ' total amount in gold of user's inventory
 Win.Major As Integer,_ ' windows major version
 Win.Minor As Integer,_ ' windows minor version
 Word.Wrap As Integer,_ ' used for word wrap during input
 Yes As Integer ' user entered Y during input (-1/0)

 Common Shared Inregs As RegType, Outregs As RegType ' register structures

 '  constants used in place of variables inline programs
 Const Author$="Erik Jon Oredson" ' name of author
 Const Dead$="-dead-" ' used internal to user file
 Const Deleted$="<deleted>" ' used internal to data files
 Const Email$="eoredson@yahoo.com" ' author's email address
 Const Enter$="<enter>" ' generic response substring
 Const False=0 ' false
 Const Mask$="#" ' define mask character
 Const MaxInt=32767 ' maximum integer
 Const MaxStat=250 ' maximum player statistic
 Const MinInt=-32768 ' minimum integer
 Const More$="More(y/n/c/q)?" ' generic response substring
 Const None$="<null>" ' used internally
 Const Nul="" ' empty string
 Const Program$="DNDDOOR" ' program name
 Const Range$="<range error>" ' generic response substring
 Const Release$="1.0a" ' program minor version
 Const True=Not False ' true
 Const UnTrue=False+1 ' untrue
 Const Version$="5.0a" ' program major version

 '  constant variables corresponding to last command entered
 Const Picklock.Command=26 ' compare to picklock
 Const Hide.Command=49 ' compare to hide
 Const Identify.Command=52 ' compare to identify

 '  constant variables for driving vehicles
 Const RideVehicle=48 ' ride vehicle command number
 Const DriveVehicle=73 ' drive vehicle command number

 '  constant variables of weapon proficiency types
 Const Blunt=1 ' blunt weapon number
 Const Pole=2 ' pole weapon number
 Const Sharp=3 ' sharp weapon number
 Const Thrusting=4 ' thrusting weapon number

 '  bit constants of room record flags array attributes of room inventory
 Const Hidden.Object=1 ' object was hidden with hide command
 Const Magic.Trap=2 ' object was made into a trap with spell
 Const Magically.Hidden=4 ' object was magically hidden with spell

 '  constant variable used to indicate spell method being used
 Const Use.Spell.Type=1 ' spell cast is by the use command
 Const Scroll.Spell.Type=2 ' spell cast by using a scroll
 Const Cast.Spell.Type=4 ' spell cast with the cast command

 '  bit constants of player class, character, and command flags,
 '  bits 2 through 128 correspond to the seven statistics players may wish for.
 Const Rerolled=1 ' bit flag of user record flags field for rerolled player
 Const Wished=256 ' bit flag of user record flags field of player wished
 Const Alignmented=512 ' bit flag of user record flags field of player align
 Const Locked.User=1024 ' bit for locked mailbox
 Const Special.Char1=2048 ' bit flag of user record flags field town mayor
 Const Special.Char2=4096 ' bit flag of user record flags field governor
 Const Special.Char3=8192 ' bit flag of user record flags field guild master
 Const Special.Char4=16384 ' bit flag of user record flags field sysop

 ' constants of class type numbers
 Const Fighter=1 ' fighter class
 Const MagicUser=2 ' MU class
 Const Thief=3 ' thief class
 Const Cleric=4 ' cleric class
 Const Paladin=5 ' paladin class
 Const Ranger=6 ' ranger class
 Const Druid=7 ' druid class
 Const Lady=8 ' lady class
 Const AsstDM=9 ' asst. DM class
 Const DM=10 ' DM class

 ' constants of attack command numbers
 Const Charm=31 ' attack command number constant
 Const Beguile=32 ' attack command number constant
 Const Shield=34 ' attack command number constant
 Const Guard=35 ' attack command number constant
 Const Lunge=39 ' attack command number constant
 Const Dodge=40 ' attack command number constant
 Const Killed=55 ' attack command number constant
 Const Backstab=59 ' attack command number constant
 Const Circled=60 ' attack command number constant
 Const Feint=61 ' attack command number constant
 Const Parry=62 ' attack command number constant
 Const Thrust=63 ' attack command number constant
 Const Charge=64 ' attack command number constant
 Const Turn=65 ' attack command number constant
 Const Counter=66 ' attack command number constant
 Const Bemuse=67 ' attack command number constant
 Const Befuddle=68 ' attack command number constant
 Const Pummel=69 ' attack command number constant
 Const Resist=70 ' attack command number constant
 Const PsiMode=71 ' attack command number constant
 Const Beat=82 ' attack command number constant
 Const Punch=83 ' attack command number constant
 Const Bewitch=84 ' attack command number constant
 Const Bewilder=85 ' attack command number constant

 ' constants of spell type numbers
 Const Enchant=1 ' spell number constant
 Const Offense=2 ' spell number constant
 Const Bless=3 ' spell number constant
 Const Wish=4 ' spell number constant
 Const Poison=5 ' spell number constant
 Const Vigor=6 ' spell number constant
 Const Heal=7 ' spell number constant
 Const CurePoison=8 ' spell number constant
 Const LevelDrain=9 ' spell number constant
 Const Teleport=10 ' spell number constant
 Const Befuddled=11 ' spell number constant
 Const TurnUndead=12 ' spell number constant
 Const PassDoor=13 ' spell number constant
 Const Conjure=14 ' spell number constant
 Const Psionic=15 ' spell number constant
 Const DetectLock=16 ' spell number constant
 Const DetectEvil=17 ' spell number constant
 Const DetectTrap=18 ' spell number constant
 Const Intoxicate=19 ' spell number constant
 Const SetTrap=20 ' spell number constant
 Const Hiding=21 ' spell number constant
 Const Search=22 ' spell number constant
 Const Invisibility=23 ' spell number constant
 Const Identify=24 ' spell number constant
 Const Enlighten=25 ' spell number constant
 Const Illuminate=26 ' spell number constant
 Const Psyche=27 ' spell number constant
 Const Telepathy=28 ' spell number constant (not used)

 ' constants for psionic spells
 Const PsiAttack=1 ' psionic attack mode
 Const PsiDefense=2 ' psionic attack mode

 ' constants for room attribute 1
 Const LitRoom=0 ' flag constant for dark room
 Const UnlitRoom=-1 ' bit flag constant for lit room

 ' constants for room attribute 2 and vehicle type
 Const Land=0 ' flag value for ground type room
 Const Air=1 ' flag value for above ground room
 Const Water=2 ' flag value constant for underwater room

 ' constants of room entry command
 Const Fly=74 ' entry command number
 Const Swim=79 ' entry command number
 
 ' constants for vehicle type
 Const AllTerrain=4 ' vehicle terrain type

 ' constants of file numbers
 Const UserFile=1 ' file number
 Const NonPlayerFile=2 ' file number
 Const RoomFile=3 ' file number
 Const ObjectFile=4 ' file number
 Const MonsterFile=5 ' file number
 Const TreasureFile=6 ' file number
 Const MonTalkFile=7 ' file number
 Const MonClassFile=8 ' file number
 Const SpellFile=9 ' file number
 Const TableFile=10 ' file number
 Const MessageFile=11 ' file number
 Const ActionFile=12 ' file number
 Const TempFile=13 ' file number
 Const TempFile2=14 ' file number
 Const HelpFile=15 ' file number
 Const UserFile2=16 ' file number

 ' subroutine allows bios access. linked from VBDOS.LIB.
 Declare Sub Interrupt(N As Integer,I As RegType,O As RegType)

 ' function creates a formatted string containing the date and time.
 Def FNclock$=Format$(Now,"ddd dd mmm yy\, hh:mma/p")

 ' function creates a formatted string containing a double precision variable.
 Def FNform$(X#)=Format$(X#, "#,##0;;"+Chr$(34)+"zero"+Chr$(34))

REM Notes on terminology:

'  The term 'mnemonic' refers to shortened words for common use, example,
'    'A two-handed sword' would have a mnemonic 'sword' for the game to
'    identify the long treasure name.

'  The term 'index' refers to a variable which points to an element of an
'    array. For example, Temp7 could be an index to UserRecord.Inv array,
'    if Temp7=10, then Temp7 is the index of UserRecord.Inv(Temp7).

'  The term 'structure' refers to a collection of fixed length strings,
'    integers, and precision variable described in a common variable. For
'    example, the UserType described in the include file would be used as a
'    structure by assigning the type to the record, for example,
'    Dim UserRecord As UserType. Then variables in the structure are
'    accessed with the dot symbol, for example, UserRecord.Gold.

'  The term 'record' refers to a single structure which can be read or
'    written to a random file using the get and put statements. For example,
'    the user record could be placed into the user file with the statement
'    Put UserFile,10,UserRecord, or Put 3,10,UserRecord.

'  The term 'parse' or 'parse temp' refers to the numeric specific to an
'    item following the pound sign. For example, the parse temp for
'    'an axe#2' is equal to 2. Since searching for an item during the game
'    checks the room first then the user inventory, the parse temp must be
'    decremented after the room inventory is checked. For example, 'an axe#2'
'    would count one axe on the floor, decrement by one, then find the
'    first axe in the user inventory, which is the second axe to find.

'  The term 'player', 'user', 'character', are used interchangeably. For
'    example, 'player character' may refer to the statistics or points
'    of the user and his/her record structure. Or, for example, 'user' may
'    refer to the player and his or her codename, etc.

'  Usage of the variable 'Graphics.Off' usually with the comment 'reset color
'    is used in this manner: When the player has remote ansi installed, and
'    the game sends ansi codes, color graphics are sent to the player by
'    cycling high intensity ansi codes for the 6 base colors. The variable
'    Color.Graphics is set to true to send ansi codes. Thus, setting
'    Graphics.Off to True sets remote ansi to high intensity white, and
'    setting Graphics.Off to False resets the cycling high intensity ansi.

'  Usage of the output routine with no assignment to the output string,
'    sends a blank carriage return/linefeed to the modem. For example,
'    'Outpt=Nul' followed by 'Call IO.O' sends a blank line. Calling
'    the output routine twice sends a blank line after the first message,
'    for example, 'Outpt="Output line."', 'Call IO.O', 'Call IO.O', sends
'    the first line, then a blank line.

'  Usage of the term 'string', or 'message' refer to an assignment or use of
'    text imbedded in quotes, or assigned to a variable. For example:
'    "This text line." could be called a message or string. And the line
'    Outpt="This text line." could have a comment ' make message.

'  The term 'cr/lf' refers to carriage return/line feed which are the
'    ascii characters 13 and 10, respectively. Note however that linefeeds
'    are not normally used by terminal programs and are usually ignored.

'  The variable passing conventions for calling modules have two forms.
'    A call to an example routine, 'Call Routine1(4)' where the routine
'    has a variable with the value of 4 passed to it, 'Sub Routine1(Var)'
'    allows the routine to accept a passed parameter. This is named
'    calling by value. A call to the same routine with a variable,
'    'Call Routine1(Temp)' passes the value contained in Temp. When the
'    routine accepts the value in its own variable Var, then assigns a new
'    value to Var, the return from the routine will change the value in
'    Temp. This is named calling by reference. Passed variables should
'    match in type.

REM Notes on memory usage:

'  Memory usage by arrays include three separate methods. Assigning a
'  variable length string array, such as,
'    Redim Array1(1 To 10) As String
'  uses the near segment of the basic memory pool by using string descriptors
'  which can be very costly as the array bounds increase. Secondly, assigning
'  a fixed length array, such as,
'    Redim Array2(1 To 10) As Sring*7
'  uses the far segment which is an additional 64k memory storage area
'  in basic. The last example using fixed length arrays whose length are a
'  power of 2, such as,
'    Redim Array3(1 To 1024) As String*128
'  allows the array to excede the 64k upper bounds by using the basic heap
'  segment memory pool, the remaining available memory after the program has
'  initialized. To do this the /ah compiler switch must be used.

REM Instructions for compiling Dnd Door with VB 1.0 PRO:

' VB 1.0 Basic compiler BC.EXE and linker LINK.EXE are required.

' Libraries required: VBDOS.LIB, VBDCL10E.LIB.

' Compile:
'   BC DNDDOOR/AH/O/X;
'   BC DNDS1/AH/O/X;
'   BC DNDS2/AH/O/X;
'   BC DNDS3/AH/O/X;
'   BC DNDS4/AH/O/X;
'   BC DNDS5/AH/O/X;
'   BC DNDS6/AH/O/X;
'   BC DNDS7/AH/O/X;

' Linking:
'   LINK DNDDOOR+(DNDS1)+(DNDS2)+(DNDS3)+(DNDS4)+(DNDS5)+(DNDS6)+(DNDS7),DNDDOOR.EXE,NUL,VBDOS.LIB;

REM If you change Dnddoor.Inc then all subprograms must be compiled.

REM Use Nmake.exe to recompile using the Makefile contents.

REM -end include file-
