package demo;

import com.japisoft.xmlpad.*;
import com.japisoft.xmlpad.action.*;

import java.awt.*;
import javax.swing.*;

/** Here a demo transforming JXMLPad in a minimal JSP editor */
public class Demo extends JFrame {
    public Demo() {
	// Remove the tree
	XMLPadProperties.setProperty( "tree", "false" );
	// Disable the parse and format action
	ActionModel.setEnabledAction( ActionModel.REFRESH_ACTION, false );
	ActionModel.setEnabledAction( ActionModel.FORMAT_ACTION, false );
	ActionModel.setEnabledAction( ActionModel.SEARCH_ACTION, false );

	// Replace the default New action by this one
	ActionModel.replaceActionByName( ActionModel.NEW_ACTION, new NewAction() );

	XMLContainer container = new XMLContainer();

	// Colorize jsp prefix
	container.setColorForPrefix( "jsp", Color.red );
	// Colorize special tags
	container.setColorForTag( "root", Color.red );
	container.setColorForTag( "text", Color.red );
	container.setColorForTag( "include", Color.red );
	container.setColorForTag( "forward", Color.red );
	container.setColorForTag( "getProperty", Color.red );
	container.setColorForTag( "plugin", Color.red );
	container.setColorForTag( "setProperty", Color.red );
	container.setColorForTag( "useBean", Color.red );

	container.getDocumentInfo().addFileExt( "jsp" );
	container.getDocumentInfo().setDefaultFileExt( "jsp" );
	container.getDocumentInfo().setDocumentDescription( "JSP file" );

	getContentPane().add( container );
	setSize( new Dimension( 550, 400 ) );
	setTitle( "XMLPad/JSP simple demo" );

	// Replace the default document by this one

	setVisible( true );
    }

    ////////////////////////////////////

    class NewAction extends XMLAction {
	public NewAction() {
	    // Get the same icon than the default New action
	    super( ActionModel.NEW_ACTION );
	}
	
	public boolean notifyAction() {
	    editor.setText( "<%@page language=\"java\"%>\n" + 
			    "<html>\n" + 
			    "<body>\n" +
			    "</body>\n" +
			    "</html>" );
	    return true;
	}

	public String getName() {
	    return ActionModel.NEW_ACTION;
	}
    }

    public static void main( String[] args ) {
	new Demo();
    }
}
