package demo;

import com.japisoft.xmlpad.*;
import com.japisoft.xmlpad.action.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/** Simple usage of the <code>XMLContainer</code> toolbar action model 
    @version 1.1
*/
public class Demo extends JFrame {

    public Demo() {
	XMLContainer mContainer = new XMLContainer();
	getContentPane().add( mContainer );
	setSize( new Dimension( 550, 400 ) );
	setTitle( "JXMLPad application demo" );
	resetMenu( mContainer.getToolBarModel() );
	setVisible( true );
    }

    private void resetMenu( ToolBarModel model ) {
	JMenuBar menuBar = new JMenuBar();
	JMenu file = new JMenu( "File" );
	JMenu edit = new JMenu( "Edit" );
	JMenu xml = new JMenu( "Xml" );
	menuBar.add( file );
	menuBar.add( edit );
	menuBar.add( xml );
	setJMenuBar( menuBar );

	// I retreive all Action instances from the
	// current ActionModel

	Action[] fileAction = new Action[] {
	    ActionModel.getActionByName( ActionModel.NEW_ACTION ),
	    ActionModel.getActionByName( ActionModel.LOAD_ACTION ),
	    ActionModel.getActionByName( ActionModel.SAVE_ACTION ),
	    ActionModel.getActionByName( ActionModel.SAVEAS_ACTION )
	};

	buildMenu( fileAction, file );
	file.addSeparator();
	file.add( new ExitAction() );

	Action[] editAction = new Action[] {
	    ActionModel.getActionByName( ActionModel.UNDO_ACTION ),
	    ActionModel.getActionByName( ActionModel.REDO_ACTION ),
	    ActionModel.getActionByName( ActionModel.CUT_ACTION ),
	    ActionModel.getActionByName( ActionModel.COPY_ACTION ),
	    ActionModel.getActionByName( ActionModel.PASTE_ACTION )
	};

	buildMenu( editAction, edit );

	Action[] xmlAction = new Action[] {
	    ActionModel.getActionByName( ActionModel.REFRESH_ACTION ),
	    ActionModel.getActionByName( ActionModel.COMMENT_ACTION )
	};

	buildMenu( xmlAction, xml );
    }

    private void buildMenu( Action[] actions, JMenu menu ) {
	for ( int i = 0; i < actions.length; i++ ) {
	    JMenuItem item = ( JMenuItem )menu.add( actions[ i ] );
	    item.setText( "" + actions[ i ].getValue( "ACTION.NAME" ) );
	}
    }

    ///////////////////////////////////////////////////////////////////////

    public class ExitAction extends AbstractAction {
	public ExitAction() {
	    super();
	    putValue( Action.NAME, "Exit" );

	}
	public void actionPerformed( ActionEvent e ) {
	    System.exit( 0 );
	}
    }

    public static void main( String[] args ) {
	new Demo();
    }

}



