/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.action;

import com.japisoft.xmlpad.action.ParseAction;
import com.japisoft.xmlpad.action.XMLAction;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class FormatAction
extends XMLAction {
    private static String c = "UTF8";
    protected PrintWriter out;

    public void notifyAction() {
        ParseAction parseAction = new ParseAction();
        parseAction.setXMLContainer(this.container);
        parseAction.setXMLEditor(this.editor);
        parseAction.notifyAction();
        if (!parseAction.hasError()) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
                this.out = new PrintWriter(outputStreamWriter);
                this.print(parseAction.getDocument());
                this.out.flush();
                String string = this.editor.getText();
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < string.length()) {
                    if (string.charAt(n) == '<' && n + 1 < string.length() && string.charAt(n + 1) != '!' && string.charAt(n + 1) != '?') break;
                    stringBuffer.append(string.charAt(n));
                    if (string.charAt(n) == '>' && n > 0 && string.charAt(n - 1) == '?') {
                        boolean bl = false;
                        int n2 = n + 1;
                        while (n2 < string.length()) {
                            if (string.charAt(n2) == '\n') break;
                            if (string.charAt(n2) == '<') {
                                bl = true;
                                break;
                            }
                            ++n2;
                        }
                        if (bl) {
                            stringBuffer.append("\n");
                        }
                    }
                    ++n;
                }
                this.editor.setText(String.valueOf(stringBuffer.toString()) + new String(byteArrayOutputStream.toByteArray()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static String getWriterEncoding() {
        return c;
    }

    public void print(Node node) {
        this.print(0, node);
    }

    public void print(int n, Node node) {
        if (node == null) {
            return;
        }
        boolean bl = false;
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                Object object = node.getChildNodes();
                int n2 = 0;
                while (n2 < object.getLength()) {
                    if (object.item(n2).getNodeType() != 8) {
                        this.print(object.item(n2));
                    }
                    ++n2;
                }
                this.out.flush();
                break;
            }
            case 1: {
                int n3 = 0;
                while (n3 < n) {
                    this.out.print(" ");
                    ++n3;
                }
                this.out.print('<');
                this.out.print(node.getNodeName());
                Object object = this.sortAttributes(node.getAttributes());
                int n4 = 0;
                while (n4 < ((Attr[])object).length) {
                    Attr attr = object[n4];
                    this.out.print(' ');
                    this.out.print(attr.getNodeName());
                    this.out.print("=\"");
                    this.out.print(this.normalize(attr.getNodeValue()));
                    this.out.print('\"');
                    ++n4;
                }
                if (!node.hasChildNodes()) {
                    this.out.print("/>\n");
                } else if (node.getChildNodes().getLength() != 1 || !(node.getChildNodes().item(0) instanceof Text)) {
                    this.out.print(">\n");
                } else {
                    this.out.print(">");
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n5 = nodeList.getLength();
                int n6 = 0;
                while (n6 < n5) {
                    this.print(n + 1, nodeList.item(n6));
                    ++n6;
                }
                break;
            }
            case 5: {
                Object object;
                if (bl) {
                    object = node.getChildNodes();
                    if (object == null) break;
                    int n7 = object.getLength();
                    int n8 = 0;
                    while (n8 < n7) {
                        this.print(object.item(n8));
                        ++n8;
                    }
                    break;
                }
                this.out.print('&');
                this.out.print(node.getNodeName());
                this.out.print(';');
                break;
            }
            case 4: {
                if (bl) {
                    this.out.print(this.normalize(node.getNodeValue()));
                    break;
                }
                this.out.print("<![CDATA[");
                this.out.print(node.getNodeValue());
                this.out.print("]]>");
                break;
            }
            case 3: {
                this.out.print(this.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(node.getNodeName());
                Object object = node.getNodeValue();
                if (object != null && object.length() > 0) {
                    this.out.print(' ');
                    this.out.print((String)object);
                }
                this.out.println("?>");
                break;
            }
            case 8: {
                this.out.print("<!-- ");
                this.out.print(node.getNodeValue());
                this.out.print(" -->\n");
            }
        }
        if (s == 1 && node.hasChildNodes()) {
            int n9 = 0;
            while (n9 < n) {
                this.out.print(" ");
                ++n9;
            }
            this.out.print("</");
            this.out.print(node.getNodeName());
            this.out.print(">\n");
        }
        this.out.flush();
    }

    protected String normalize(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = true;
        int n2 = string != null ? string.length() : 0;
        int n3 = 0;
        while (n3 < n2) {
            n = string.charAt(n3);
            if (n != 32 && n != 10) {
                bl2 = false;
            }
            if (n != 32 && n != 10) {
                bl3 = false;
            }
            switch (n) {
                case 60: {
                    stringBuffer.append("&lt;");
                    break;
                }
                case 62: {
                    stringBuffer.append("&gt;");
                    break;
                }
                case 38: {
                    stringBuffer.append("&amp;");
                    break;
                }
                case 34: {
                    stringBuffer.append("&quot;");
                    break;
                }
                case 39: {
                    stringBuffer.append("&apos;");
                    break;
                }
                case 10: 
                case 13: {
                    if (bl) {
                        stringBuffer.append("&#");
                        stringBuffer.append(Integer.toString(n));
                        stringBuffer.append(';');
                        break;
                    }
                }
                default: {
                    if (bl3) break;
                    stringBuffer.append((char)n);
                }
            }
            ++n3;
        }
        if (bl2) {
            return "";
        }
        String string2 = stringBuffer.toString();
        n = -1;
        int n4 = string2.length() - 1;
        while (n4 >= 0) {
            if (string2.charAt(n4) != ' ') break;
            n = n4--;
        }
        if (n != -1) {
            return string2.substring(0, n);
        }
        return string2;
    }

    protected Attr[] sortAttributes(NamedNodeMap namedNodeMap) {
        int n = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        Attr[] attrArray = new Attr[n];
        int n2 = 0;
        while (n2 < n) {
            attrArray[n2] = (Attr)namedNodeMap.item(n2);
            ++n2;
        }
        n2 = 0;
        while (n2 < n - 1) {
            String string = attrArray[n2].getNodeName();
            int n3 = n2;
            int n4 = n2 + 1;
            while (n4 < n) {
                String string2 = attrArray[n4].getNodeName();
                if (string2.compareTo(string) < 0) {
                    string = string2;
                    n3 = n4;
                }
                ++n4;
            }
            if (n3 != n2) {
                Attr attr = attrArray[n2];
                attrArray[n2] = attrArray[n3];
                attrArray[n3] = attr;
            }
            ++n2;
        }
        return attrArray;
    }
}

