/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.ContextBuffer;
import com.ximpleware.IByteBuffer;
import com.ximpleware.IIntBuffer;
import com.ximpleware.ILongBuffer;
import com.ximpleware.NavException;
import com.ximpleware.parser.UTF8Char;

public class VTDNav {
    public static final int ROOT = 0;
    public static final int PARENT = 1;
    public static final int FIRST_CHILD = 2;
    public static final int LAST_CHILD = 3;
    public static final int NEXT_SIBLING = 4;
    public static final int PREV_SIBLING = 5;
    public static final int R = 0;
    public static final int P = 1;
    public static final int FC = 2;
    public static final int LC = 3;
    public static final int NS = 4;
    public static final int PS = 5;
    public static final int TOKEN_STARTING_TAG = 0;
    public static final int TOKEN_ENDING_TAG = 1;
    public static final int TOKEN_ATTR_NAME = 2;
    public static final int TOKEN_ATTR_NS = 3;
    public static final int TOKEN_ATTR_VAL = 4;
    public static final int TOKEN_CHARACTER_DATA = 5;
    public static final int TOKEN_COMMENT = 6;
    public static final int TOKEN_PI_NAME = 7;
    public static final int TOKEN_PI_VAL = 8;
    public static final int TOKEN_DEC_ATTR_NAME = 9;
    public static final int TOKEN_DEC_ATTR_VAL = 10;
    public static final int TOKEN_CDATA_VAL = 11;
    public static final int TOKEN_DTD_VAL = 12;
    public static final int TOKEN_DOCUMENT = 13;
    public static final int FORMAT_UTF8 = 2;
    public static final int FORMAT_ASCII = 0;
    public static final int FORMAT_ISO_8859_1 = 1;
    public static final int FORMAT_UTF_16LE = 64;
    public static final int FORMAT_UTF_16BE = 63;
    private static final long MASK_TOKEN_FULL_LEN = 0xFFFFF00000000L;
    private static final long MASK_TOKEN_PRE_LEN = 0xFF80000000000L;
    private static final long MASK_TOKEN_QN_LEN = 0x7FF00000000L;
    long MASK_TOKEN_OFFSET = 0x3FFFFFFFL;
    private static final long MASK_TOKEN_TYPE = -1152921504606846976L;
    private static final long MASK_TOKEN_DEPTH = 0xFF0000000000000L;
    private static final long MASK_TOKEN_NS_MARK = 0xC0000000L;
    protected int rootIndex;
    protected int nestingLevel;
    protected int[] context;
    protected boolean atTerminal;
    protected int l2upper;
    protected int l2lower;
    protected int l3upper;
    protected int l3lower;
    protected int l2index;
    protected int l3index;
    protected int l1index;
    protected ILongBuffer vtdBuffer;
    protected ILongBuffer l1Buffer;
    protected ILongBuffer l2Buffer;
    protected IIntBuffer l3Buffer;
    protected IByteBuffer XMLDoc;
    private ContextBuffer contextStack;
    protected ContextBuffer contextStack2;
    protected int LN;
    protected int encoding;
    protected boolean ns;
    protected int[] stackTemp;
    protected int docOffset;
    protected int docLen;
    protected int vtdSize;

    protected VTDNav(int n, int n2, boolean bl, int n3, IByteBuffer iByteBuffer, ILongBuffer iLongBuffer, ILongBuffer iLongBuffer2, ILongBuffer iLongBuffer3, IIntBuffer iIntBuffer, int n4, int n5) {
        if (iLongBuffer2 == null || iLongBuffer3 == null || iIntBuffer == null || iLongBuffer == null || iByteBuffer == null || n3 < 0 || n < 0 || n4 < 0 || n5 < 0) {
            throw new IllegalArgumentException();
        }
        this.l1Buffer = iLongBuffer2;
        this.l2Buffer = iLongBuffer3;
        this.l3Buffer = iIntBuffer;
        this.vtdBuffer = iLongBuffer;
        this.XMLDoc = iByteBuffer;
        this.encoding = n2;
        this.rootIndex = n;
        this.nestingLevel = n3 + 1;
        this.ns = bl;
        this.MASK_TOKEN_OFFSET = !this.ns ? Integer.MAX_VALUE : 0x3FFFFFFFL;
        this.atTerminal = false;
        this.context = new int[this.nestingLevel];
        this.context[0] = 0;
        for (int i = 1; i < this.nestingLevel; ++i) {
            this.context[i] = -1;
        }
        this.contextStack = new ContextBuffer(10, this.nestingLevel + 9);
        this.contextStack2 = new ContextBuffer(10, this.nestingLevel + 9);
        this.stackTemp = new int[this.nestingLevel + 9];
        this.l3index = -1;
        this.l2index = -1;
        this.l1index = -1;
        this.l3lower = -1;
        this.l2lower = -1;
        this.l3upper = -1;
        this.l2upper = -1;
        this.docOffset = n4;
        this.docLen = n5;
        this.vtdSize = iLongBuffer.size();
    }

    public int getAttrCount() {
        int n;
        if (this.context[0] == -1) {
            return 0;
        }
        int n2 = 0;
        for (int i = this.getCurrentIndex() + 1; i < this.vtdSize && ((n = this.getTokenType(i)) == 2 || n == 4 || n == 3); ++i) {
            if (n != 2 && (this.ns || n != 3)) continue;
            ++n2;
        }
        return n2;
    }

    public int getAttrVal(String string) throws NavException {
        int n;
        if (this.context[0] == -1) {
            return -1;
        }
        int n2 = n = this.context[0] != 0 ? this.context[this.context[0]] + 1 : this.rootIndex + 1;
        if (n >= this.vtdSize) {
            return -1;
        }
        int n3 = this.getTokenType(n);
        if (!this.ns) {
            while (n3 == 2 || n3 == 3) {
                if (this.matchRawTokenString(n, string)) {
                    return n + 1;
                }
                if ((n += 2) < this.vtdSize) {
                    n3 = this.getTokenType(n);
                    continue;
                }
                break;
            }
        } else {
            while (n3 == 2 || n3 == 3) {
                if (n3 == 2 && this.matchRawTokenString(n, string)) {
                    return n + 1;
                }
                if ((n += 2) < this.vtdSize) {
                    n3 = this.getTokenType(n);
                    continue;
                }
                break;
            }
        }
        return -1;
    }

    public int getAttrValNS(String string, String string2) throws NavException {
        int n;
        int n2;
        if (!this.ns) {
            return -1;
        }
        if (string == null) {
            return this.getAttrVal(string2);
        }
        int n3 = this.vtdBuffer.size();
        int n4 = n2 = this.context[0] != 0 ? this.context[this.context[0]] + 1 : this.rootIndex + 1;
        if (n2 < this.vtdSize) {
            n = this.getTokenType(n2);
        } else {
            return -1;
        }
        while (n2 < n3 && (n == 2 || n == 3)) {
            int n5 = this.getTokenLength(n2);
            int n6 = this.getTokenOffset(n2);
            int n7 = n5 >> 16 & 0xFFFF;
            int n8 = n5 & 0xFFFF;
            if (n7 != 0 && this.matchRawTokenString(n6 + n7 + 1, n8 - n7 - 1, string2) && this.resolveNS(string, n6, n7)) {
                return n2 + 1;
            }
            if ((n2 += 2) >= this.vtdSize) break;
            n = this.getTokenType(n2);
        }
        return -1;
    }

    private long handle_utf8(long l, int n) throws NavException {
        int n2;
        int n3;
        int n4;
        switch (UTF8Char.byteCount((int)l & 0xFF)) {
            case 2: {
                n4 = 31;
                n3 = 6;
                n2 = 1;
                break;
            }
            case 3: {
                n4 = 15;
                n3 = 12;
                n2 = 2;
                break;
            }
            case 4: {
                n4 = 7;
                n3 = 18;
                n2 = 3;
                break;
            }
            case 5: {
                n4 = 3;
                n3 = 24;
                n2 = 4;
                break;
            }
            case 6: {
                n4 = 1;
                n3 = 30;
                n2 = 5;
                break;
            }
            default: {
                throw new NavException("UTF 8 encoding error: should never happen");
            }
        }
        long l2 = (l & (long)n4) << n3;
        for (int i = n2 - 1; i >= 0; --i) {
            l = this.XMLDoc.byteAt(n + n2 - i);
            if ((l & 0xC0L) != 128L) {
                throw new NavException("UTF 8 encoding error: should never happen");
            }
            l2 |= (l & 0x3FL) << (i << 2) + (i << 1);
        }
        return l2 | (long)(n2 + 1) << 32;
    }

    private long handle_utf16le(int n) throws NavException {
        int n2 = (this.XMLDoc.byteAt((n << 1) + 1) & 0xFF) << 8 | this.XMLDoc.byteAt(n << 1) & 0xFF;
        if (n2 < 56320 || n2 > 57343) {
            if (n2 == 13) {
                if (this.XMLDoc.byteAt((n << 1) + 2) == 10 && this.XMLDoc.byteAt((n << 1) + 3) == 0) {
                    return 0x20000000AL;
                }
                return 0x10000000AL;
            }
            return (long)n2 | 0x100000000L;
        }
        if (n2 < 55296 || n2 > 56319) {
            throw new NavException("UTF 16 LE encoding error: should never happen");
        }
        int n3 = n2;
        n2 = (this.XMLDoc.byteAt((n << 1) + 3) & 0xFF) << 8 | this.XMLDoc.byteAt((n << 1) + 2) & 0xFF;
        if (n2 < 56320 || n2 > 57343) {
            throw new NavException("UTF 16 LE encoding error: should never happen");
        }
        n3 = (n2 - 55296 << 10) + (n3 - 56320) + 65536;
        return (long)n3 | 0x200000000L;
    }

    private long handle_utf16be(int n) throws NavException {
        int n2 = (this.XMLDoc.byteAt(n << 1) & 0xFF) << 8 | this.XMLDoc.byteAt((n << 1) + 1) & 0xFF;
        if (n2 < 55296 || n2 > 57343) {
            if (n2 == 13) {
                if (this.XMLDoc.byteAt((n << 1) + 3) == 10 && this.XMLDoc.byteAt((n << 1) + 2) == 0) {
                    return 0x20000000AL;
                }
                return 0x10000000AL;
            }
            return (long)n2 | 0x100000000L;
        }
        if (n2 < 55296 || n2 > 56319) {
            throw new NavException("UTF 16 BE encoding error: should never happen");
        }
        long l = n2;
        n2 = (this.XMLDoc.byteAt((n << 1) + 2) & 0xFF) << 8 | this.XMLDoc.byteAt((n << 1) + 3) & 0xFF;
        if (n2 < 56320 || n2 > 57343) {
            throw new NavException("UTF 16 BE encoding error: should never happen");
        }
        l = (long)(n2 - 55296 << 10) + (l - 56320L) + 65536L;
        return l | 0x200000000L;
    }

    private long getChar(int n) throws NavException {
        long l = 0L;
        switch (this.encoding) {
            case 0: {
                l = this.XMLDoc.byteAt(n);
                if (l == 13L) {
                    if (this.XMLDoc.byteAt(n + 1) == 10) {
                        return 0x20000000AL;
                    }
                    return 0x10000000AL;
                }
                return l | 0x100000000L;
            }
            case 1: {
                l = this.XMLDoc.byteAt(n);
                if (l == 13L) {
                    if (this.XMLDoc.byteAt(n + 1) == 10) {
                        return 0x20000000AL;
                    }
                    return 0x10000000AL;
                }
                return l & 0xFFL | 0x100000000L;
            }
            case 2: {
                l = this.XMLDoc.byteAt(n);
                if (l >= 0L) {
                    if (l == 13L) {
                        if (this.XMLDoc.byteAt(n + 1) == 10) {
                            return 0x20000000AL;
                        }
                        return 0x10000000AL;
                    }
                    return l | 0x100000000L;
                }
                return this.handle_utf8(l, n);
            }
            case 63: {
                return this.handle_utf16be(n);
            }
            case 64: {
                return this.handle_utf16le(n);
            }
        }
        throw new NavException("Unknown Encoding");
    }

    private long getCharResolved(int n) throws NavException {
        int n2 = 0;
        int n3 = 0;
        long l = 2L;
        long l2 = this.getChar(n);
        n2 = (int)l2;
        if (n2 != 38) {
            return l2;
        }
        n2 = this.getCharUnit(++n);
        ++n;
        switch (n2) {
            case 35: {
                n2 = this.getCharUnit(n);
                if (n2 == 120) {
                    while (true) {
                        ++l;
                        if ((n2 = this.getCharUnit(++n)) >= 48 && n2 <= 57) {
                            n3 = (n3 << 4) + (n2 - 48);
                            continue;
                        }
                        if (n2 >= 97 && n2 <= 102) {
                            n3 = (n3 << 4) + (n2 - 97 + 10);
                            continue;
                        }
                        if (n2 < 65 || n2 > 70) break;
                        n3 = (n3 << 4) + (n2 - 65 + 10);
                    }
                    if (n2 == 59) {
                        ++l;
                        break;
                    }
                    throw new NavException("Illegal char in a char reference");
                }
                while (true) {
                    n2 = this.getCharUnit(n);
                    ++n;
                    ++l;
                    if (n2 < 48 || n2 > 57) break;
                    n3 = n3 * 10 + (n2 - 48);
                }
                if (n2 == 59) break;
                throw new NavException("Illegal char in char reference");
            }
            case 97: {
                n2 = this.getCharUnit(n);
                if (n2 == 109) {
                    if (this.getCharUnit(n + 1) == 112 && this.getCharUnit(n + 2) == 59) {
                        l = 5L;
                        n3 = 38;
                        break;
                    }
                    throw new NavException("illegal builtin reference");
                }
                if (n2 == 112) {
                    if (this.getCharUnit(n + 1) == 111 && this.getCharUnit(n + 2) == 115 && this.getCharUnit(n + 3) == 59) {
                        l = 6L;
                        n3 = 39;
                        break;
                    }
                    throw new NavException("illegal builtin reference");
                }
                throw new NavException("illegal builtin reference");
            }
            case 113: {
                if (this.getCharUnit(n) == 117 && this.getCharUnit(n + 1) == 111 && this.getCharUnit(n + 2) == 116 && this.getCharUnit(n + 3) == 59) {
                    l = 6L;
                    n3 = 34;
                    break;
                }
                throw new NavException("illegal builtin reference");
            }
            case 108: {
                if (this.getCharUnit(n) == 116 && this.getCharUnit(n + 1) == 59) {
                    l = 4L;
                    n3 = 60;
                    break;
                }
                throw new NavException("illegal builtin reference");
            }
            case 103: {
                if (this.getCharUnit(n) == 116 && this.getCharUnit(n + 1) == 59) {
                    l = 4L;
                    n3 = 62;
                    break;
                }
                throw new NavException("illegal builtin reference");
            }
            default: {
                throw new NavException("Invalid entity char");
            }
        }
        return (long)n3 | l << 32;
    }

    private int getCharUnit(int n) {
        return this.encoding <= 2 ? this.XMLDoc.byteAt(n) & 0xFF : (this.encoding == 63 ? this.XMLDoc.byteAt(n << 1) << 8 | this.XMLDoc.byteAt((n << 1) + 1) : this.XMLDoc.byteAt((n << 1) + 1) << 8 | this.XMLDoc.byteAt(n << 1));
    }

    public final int getCurrentDepth() {
        return this.context[0];
    }

    public final int getCurrentIndex() {
        if (this.atTerminal) {
            return this.LN;
        }
        switch (this.context[0]) {
            case -1: {
                return 0;
            }
            case 0: {
                return this.rootIndex;
            }
        }
        return this.context[this.context[0]];
    }

    protected final int getCurrentIndex2() {
        switch (this.context[0]) {
            case -1: {
                return 0;
            }
            case 0: {
                return this.rootIndex;
            }
        }
        return this.context[this.context[0]];
    }

    public long getElementFragment() throws NavException {
        int n;
        int n2 = this.getCurrentDepth();
        if (n2 == -1) {
            int n3 = this.vtdBuffer.lower32At(0);
            if (n3 == 0) {
                return (long)this.docLen << 32 | (long)this.docOffset;
            }
            return (long)(this.docLen - 32) | 0x20L;
        }
        int n4 = this.getTokenOffset(this.getCurrentIndex2()) - 1;
        int n5 = 0;
        if (this.toElement(4)) {
            int n6 = this.getCurrentIndex();
            while (this.getTokenDepth(n6) < n2) {
                --n6;
            }
            int n7 = this.getTokenOffset(n6) - 1;
            while (this.getCharUnit(n7) != 62) {
                --n7;
            }
            n5 = n7 - n4 + 1;
            this.toElement(5);
            if (this.encoding <= 2) {
                return (long)n5 << 32 | (long)n4;
            }
            return (long)n5 << 33 | (long)(n4 << 1);
        }
        if (n2 == 0) {
            int n8 = this.vtdBuffer.size() - 1;
            boolean bl = false;
            int n9 = 0;
            while (this.getTokenDepth(n8) == -1) {
                --n8;
                bl = true;
            }
            n9 = !bl ? (this.encoding <= 2 ? this.docOffset + this.docLen - 1 : (this.docOffset + this.docLen << 1) - 1) : this.getTokenOffset(n8 + 1);
            while (this.getCharUnit(n9) != 62) {
                --n9;
            }
            n5 = n9 - n4 + 1;
            if (this.encoding <= 2) {
                return (long)n5 << 32 | (long)n4;
            }
            return (long)n5 << 33 | (long)(n4 << 1);
        }
        int n10 = this.getCurrentIndex() + 1;
        if (n10 < (n = this.vtdBuffer.size()) - 1) {
            while (n10 < n && this.getTokenDepth(n10) >= n2) {
                ++n10;
            }
            if (n10 != n) {
                int n11 = n2 - this.getTokenDepth(n10) + (this.getTokenType(n10) == 0 ? 1 : 0);
                int n12 = this.getTokenOffset(n10) - 1;
                int n13 = 0;
                while (n13 < n11) {
                    if (this.getCharUnit(n12) == 62) {
                        ++n13;
                    }
                    --n12;
                }
                n5 = n12 - n4 + 2;
                if (this.encoding <= 2) {
                    return (long)n5 << 32 | (long)n4;
                }
                return (long)n5 << 33 | (long)(n4 << 1);
            }
        }
        int n14 = this.encoding <= 2 ? this.docOffset + this.docLen - 1 : (this.docOffset + this.docLen << 1) - 1;
        int n15 = n2 + 1;
        int n16 = 0;
        while (n16 < n15) {
            if (this.getCharUnit(n14) == 62) {
                ++n16;
            }
            --n14;
        }
        n5 = n14 - n4 + 2;
        if (this.encoding <= 2) {
            return (long)n5 << 32 | (long)n4;
        }
        return (long)n5 << 33 | (long)(n4 << 1);
    }

    public final int getEncoding() {
        return this.encoding;
    }

    public final int getNestingLevel() {
        return this.nestingLevel;
    }

    public final int getRootIndex() {
        return this.rootIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getText() {
        if (this.context[0] == -1) {
            return -1;
        }
        int n = this.context[0] != 0 ? this.context[this.context[0]] + 1 : this.rootIndex + 1;
        int n2 = this.getCurrentDepth();
        if (n >= this.vtdSize) {
            return -1;
        }
        int n3 = this.getTokenType(n);
        while (true) {
            if (n3 == 5 || n3 == 11) {
                if (n2 != this.getTokenDepth(n)) return -1;
                return n;
            }
            if (n3 == 3 || n3 == 2) {
                n += 2;
            } else {
                if (n3 != 7 && n3 != 8 && n3 != 6) return -1;
                if (n2 != this.getTokenDepth(n)) return -1;
                ++n;
            }
            if (n >= this.vtdSize) return -1;
            n3 = this.getTokenType(n);
        }
    }

    public final int getTokenCount() {
        return this.vtdSize;
    }

    public final int getTokenDepth(int n) {
        int n2 = (int)((this.vtdBuffer.longAt(n) & 0xFF0000000000000L) >> 52);
        if (n2 != 255) {
            return n2;
        }
        return -1;
    }

    public int getTokenLength(int n) {
        int n2 = this.getTokenType(n);
        int n3 = 0;
        switch (n2) {
            case 0: 
            case 2: 
            case 3: {
                long l = this.vtdBuffer.longAt(n);
                return !this.ns ? (int)((l & 0x7FF00000000L) >> 32) : (int)((l & 0x7FF00000000L) >> 32) | (int)((l & 0xFF80000000000L) >> 32) << 5;
            }
            case 5: 
            case 6: 
            case 11: {
                int n4 = this.getTokenDepth(n);
                do {
                    n3 += (int)((this.vtdBuffer.longAt(n) & 0xFFFFF00000000L) >> 32);
                } while (++n < this.vtdSize && n4 == this.getTokenDepth(n) && n2 == this.getTokenType(n));
                return n3;
            }
        }
        return (int)((this.vtdBuffer.longAt(n) & 0xFFFFF00000000L) >> 32);
    }

    public final int getTokenOffset(int n) {
        return (int)(this.vtdBuffer.longAt(n) & this.MASK_TOKEN_OFFSET);
    }

    public final IByteBuffer getXML() {
        return this.XMLDoc;
    }

    public final int getTokenType(int n) {
        return (int)((this.vtdBuffer.longAt(n) & 0xF000000000000000L) >> 60) & 0xF;
    }

    public final boolean hasAttr(String string) throws NavException {
        return this.getAttrVal(string) != -1;
    }

    public final boolean hasAttrNS(String string, String string2) throws NavException {
        return this.getAttrValNS(string, string2) != -1;
    }

    private final boolean isElement(int n) {
        return ((this.vtdBuffer.longAt(n) & 0xF000000000000000L) >> 60 & 0xFL) == 0L;
    }

    private final boolean isElementOrDocument(int n) {
        long l = (this.vtdBuffer.longAt(n) & 0xF000000000000000L) >> 60 & 0xFL;
        return l == 0L || l == 13L;
    }

    private final boolean isWS(int n) {
        return n == 32 || n == 10 || n == 9 || n == 13;
    }

    public final boolean matchElement(String string) throws NavException {
        if (string.equals("*") && this.context[0] != -1) {
            return true;
        }
        if (this.context[0] == -1) {
            return false;
        }
        return this.matchRawTokenString(this.context[0] == 0 ? this.rootIndex : this.context[this.context[0]], string);
    }

    public boolean matchElementNS(String string, String string2) throws NavException {
        if (this.context[0] == -1) {
            return false;
        }
        int n = this.getTokenLength(this.context[0] != 0 ? this.context[this.context[0]] : this.rootIndex);
        int n2 = this.getTokenOffset(this.context[0] != 0 ? this.context[this.context[0]] : this.rootIndex);
        int n3 = n >> 16 & 0xFFFF;
        int n4 = n & 0xFFFF;
        return (string2.equals("*") || (n3 != 0 ? this.matchRawTokenString(n2 + n3 + 1, n4 - n3 - 1, string2) : this.matchRawTokenString(n2, n4, string2))) && (string != null && string.equals("*") || this.resolveNS(string, n2, n3));
    }

    private final boolean matchRawTokenString(int n, int n2, String string) throws NavException {
        return this.compareRawTokenString(n, n2, string) == 0;
    }

    protected int compareTokenString(int n, int n2, String string) throws NavException {
        int n3;
        long l;
        int n4 = n + n2;
        int n5 = string.length();
        for (n3 = 0; n3 < n5 && n < n4; n += (int)(l >> 32), ++n3) {
            l = this.getCharResolved(n);
            char c = string.charAt(n3);
            if (c < (int)l) {
                return 1;
            }
            if (c <= (int)l) continue;
            return -1;
        }
        if (n3 == n5 && n < n4) {
            return 1;
        }
        if (n3 < n5 && n == n4) {
            return -1;
        }
        return 0;
    }

    public int compareTokens(int n, VTDNav vTDNav, int n2) throws NavException {
        long l;
        int n3;
        if (n == n2 && this == vTDNav) {
            return 0;
        }
        int n4 = this.getTokenType(n);
        int n5 = vTDNav.getTokenType(n2);
        int n6 = this.getTokenOffset(n);
        int n7 = this.getTokenLength(n) + n6;
        int n8 = vTDNav.getTokenLength(n2) + n3;
        for (n3 = vTDNav.getTokenOffset(n2); n6 < n7 && n3 < n8; n6 += (int)(l >> 32), n3 += (int)(l >> 32)) {
            l = n4 == 5 || n4 == 4 ? this.getCharResolved(n6) : this.getChar(n6);
            int n9 = (int)l;
            l = n5 == 5 || n5 == 4 ? vTDNav.getCharResolved(n3) : vTDNav.getChar(n3);
            int n10 = (int)l;
            if (n9 <= n10) continue;
            return 1;
        }
        if (n6 == n7 && n3 < n8) {
            return -1;
        }
        if (n6 < n7 && n3 == n8) {
            return 1;
        }
        return 0;
    }

    protected int compareRawTokenString(int n, int n2, String string) throws NavException {
        int n3;
        long l;
        int n4 = n + n2;
        int n5 = string.length();
        for (n3 = 0; n3 < n5 && n < n4; n += (int)(l >> 32), ++n3) {
            l = this.getChar(n);
            char c = string.charAt(n3);
            if (c < (int)l) {
                return 1;
            }
            if (c <= (int)l) continue;
            return -1;
        }
        if (n3 == n5 && n < n4) {
            return 1;
        }
        if (n3 < n5 && n == n4) {
            return -1;
        }
        return 0;
    }

    public final int compareRawTokenString(int n, String string) throws NavException {
        int n2 = this.getTokenType(n);
        int n3 = n2 == 0 || n2 == 2 || n2 == 3 ? this.getTokenLength(n) & 0xFFFF : this.getTokenLength(n);
        return this.compareRawTokenString(this.getTokenOffset(n), n3, string);
    }

    public final boolean matchRawTokenString(int n, String string) throws NavException {
        int n2 = this.getTokenType(n);
        int n3 = n2 == 0 || n2 == 2 || n2 == 3 ? this.getTokenLength(n) & 0xFFFF : this.getTokenLength(n);
        return this.compareRawTokenString(this.getTokenOffset(n), n3, string) == 0;
    }

    private final boolean matchRawTokenString(long l, String string) throws NavException {
        int n = (int)((l & 0xFFFFF00000000L) >> 32);
        return this.compareRawTokenString((int)l, n, string) == 0;
    }

    private final boolean matchTokenString(int n, int n2, String string) throws NavException {
        return this.compareTokenString(n, n2, string) == 0;
    }

    public int compareTokenString(int n, String string) throws NavException {
        int n2 = this.getTokenType(n);
        int n3 = n2 == 0 || n2 == 2 || n2 == 3 ? this.getTokenLength(n) & 0xFFFF : this.getTokenLength(n);
        return this.compareTokenString(this.getTokenOffset(n), n3, string);
    }

    public final boolean matchTokenString(int n, String string) throws NavException {
        int n2 = this.getTokenType(n);
        int n3 = n2 == 0 || n2 == 2 || n2 == 3 ? this.getTokenLength(n) & 0xFFFF : this.getTokenLength(n);
        return this.compareTokenString(this.getTokenOffset(n), n3, string) == 0;
    }

    private final boolean matchTokenString(long l, String string) throws NavException {
        int n = (int)(l >> 32) & 0xFFFF;
        return this.compareTokenString((int)l, n, string) == 0;
    }

    private final int NSval(int n) {
        return (int)(this.vtdBuffer.longAt(n) & 0xC0000000L);
    }

    public final boolean overWrite(int n, byte[] byArray) {
        return this.overWrite(n, byArray, 0, byArray.length);
    }

    public boolean overWrite(int n, byte[] byArray, int n2, int n3) {
        if (byArray == null || n >= this.vtdSize || n2 < 0 || n2 + n3 > byArray.length) {
            throw new IllegalArgumentException("Illegal argument for overwrite");
        }
        if (this.encoding >= 63 && ((n3 & 1) == 1 || (n2 & 1) == 1)) {
            return false;
        }
        int n4 = this.getTokenType(n);
        if (n4 == 5 || n4 == 4 || n4 == 11) {
            int n5 = this.getTokenLength(n);
            if (n5 < n3) {
                return false;
            }
            int n6 = this.getTokenOffset(n);
            int n7 = n5 - n3;
            System.arraycopy(byArray, n2, this.XMLDoc.getBytes(), n6, n3);
            int n8 = 0;
            while (n8 < n7) {
                if (this.encoding < 63) {
                    this.XMLDoc.getBytes()[n6 + n3 + n8] = 32;
                    ++n8;
                    continue;
                }
                if (this.encoding == 63) {
                    this.XMLDoc.getBytes()[n6 + n3 + n8] = 0;
                    this.XMLDoc.getBytes()[n6 + n3 + n8 + 1] = 32;
                } else {
                    this.XMLDoc.getBytes()[n6 + n3 + n8] = 32;
                    this.XMLDoc.getBytes()[n6 + n3 + n8 + 1] = 0;
                }
                n8 += 2;
            }
            return true;
        }
        return false;
    }

    public double parseDouble(int n) throws NavException {
        int n2;
        boolean bl;
        int n3 = this.getTokenOffset(n);
        long l = 0L;
        int n4 = n3 + this.getTokenLength(n);
        int n5 = this.getTokenType(n);
        boolean bl2 = n5 == 5 || n5 == 4;
        boolean bl3 = false;
        l = bl2 ? this.getCharResolved(n3) : this.getChar(n3);
        int n6 = (int)l;
        n3 += (int)(l >> 32);
        while (n3 < n4 && this.isWS(n6)) {
            l = bl2 ? this.getCharResolved(n3) : this.getChar(n3);
            n6 = (int)l;
            n3 += (int)(l >> 32);
        }
        if (n3 > n4) {
            return Double.NaN;
        }
        boolean bl4 = bl = n6 == 45;
        if (n6 == 45 || n6 == 43) {
            l = bl2 ? this.getCharResolved(n3) : this.getChar(n3);
            n6 = (int)l;
            n3 += (int)(l >> 32);
        }
        double d = 0.0;
        while (n3 <= n4 && (n2 = Character.digit((char)n6, 10)) >= 0) {
            d = d * 10.0 + (double)n2;
            l = bl2 ? this.getCharResolved(n3) : this.getChar(n3);
            n6 = (int)l;
            n3 += (int)(l >> 32);
        }
        double d2 = 0.0;
        double d3 = 1.0;
        if (n6 == 46) {
            int n7;
            l = bl2 ? this.getCharResolved(n3) : this.getChar(n3);
            n6 = (int)l;
            n3 += (int)(l >> 32);
            while (n3 <= n4 && (n7 = Character.digit((char)n6, 10)) >= 0) {
                d2 = d2 * 10.0 + (double)n7;
                d3 *= 10.0;
                l = bl2 ? this.getCharResolved(n3) : this.getChar(n3);
                n6 = (int)l;
                n3 += (int)(l >> 32);
            }
        }
        long l2 = 0L;
        if (n6 == 69 || n6 == 101) {
            int n8;
            l = bl2 ? this.getCharResolved(n3) : this.getChar(n3);
            n6 = (int)l;
            n3 += (int)(l >> 32);
            boolean bl5 = bl3 = n6 == 45;
            if (n6 == 43 || n6 == 45) {
                l = bl2 ? this.getCharResolved(n3) : this.getChar(n3);
                n6 = (int)l;
                n3 += (int)(l >> 32);
            }
            int n9 = n3;
            while (n3 <= n4 && (n8 = Character.digit((char)n6, 10)) >= 0) {
                l2 = l2 * 10L + (long)n8;
                l = bl2 ? this.getCharResolved(n3) : this.getChar(n3);
                n6 = (int)l;
                n3 += (int)(l >> 32);
            }
            if (n9 == n3) {
                return Double.NaN;
            }
        }
        while (n3 <= n4) {
            if (!this.isWS(n6)) {
                return Double.NaN;
            }
            l = bl2 ? this.getCharResolved(n3) : this.getChar(n3);
            n6 = (int)l;
            n3 += (int)(l >> 32);
        }
        double d4 = d;
        if (d2 != 0.0) {
            d4 += d2 / d3;
        }
        if (l2 != 0L) {
            d4 = bl3 ? d4 / Math.pow(10.0, l2) : d4 * Math.pow(10.0, l2);
        }
        return bl ? -d4 : d4;
    }

    public float parseFloat(int n) throws NavException {
        int n2;
        boolean bl;
        int n3 = this.getTokenOffset(n);
        int n4 = n3 + this.getTokenLength(n);
        int n5 = this.getTokenType(n);
        boolean bl2 = n5 == 5 || n5 == 4;
        long l = bl2 ? this.getCharResolved(n3) : this.getChar(n3);
        int n6 = (int)l;
        n3 += (int)(l >> 32);
        while (n3 <= n4 && this.isWS(n6)) {
            l = bl2 ? this.getCharResolved(n3) : this.getChar(n3);
            n6 = (int)l;
            n3 += (int)(l >> 32);
        }
        if (n3 > n4) {
            throw new NavException("Empty string");
        }
        boolean bl3 = bl = n6 == 45;
        if (n6 == 45 || n6 == 43) {
            l = bl2 ? this.getCharResolved(n3) : this.getChar(n3);
            n6 = (int)l;
            n3 += (int)(l >> 32);
        }
        long l2 = 0L;
        while (n3 <= n4 && (n2 = Character.digit((char)n6, 10)) >= 0) {
            l2 = l2 * 10L + (long)n2;
            l = bl2 ? this.getCharResolved(n3) : this.getChar(n3);
            n6 = (int)l;
            n3 += (int)(l >> 32);
        }
        long l3 = 0L;
        long l4 = 1L;
        if (n6 == 46) {
            int n7;
            l = bl2 ? this.getCharResolved(n3) : this.getChar(n3);
            n6 = (int)l;
            n3 += (int)(l >> 32);
            while (n3 <= n4 && (n7 = Character.digit((char)n6, 10)) >= 0) {
                l3 = l3 * 10L + (long)n7;
                l4 *= 10L;
                l = bl2 ? this.getCharResolved(n3) : this.getChar(n3);
                n6 = (int)l;
                n3 += (int)(l >> 32);
            }
        }
        long l5 = 0L;
        if (n6 == 69 || n6 == 101) {
            int n8;
            boolean bl4;
            l = bl2 ? this.getCharResolved(n3) : this.getChar(n3);
            n6 = (int)l;
            n3 += (int)(l >> 32);
            boolean bl5 = bl4 = n6 == 45;
            if (n6 == 43 || n6 == 45) {
                l = bl2 ? this.getCharResolved(n3) : this.getChar(n3);
                n6 = (int)l;
                n3 += (int)(l >> 32);
            }
            int n9 = n3;
            while (n3 <= n4 && (n8 = Character.digit((char)n6, 10)) >= 0) {
                l5 = l5 * 10L + (long)n8;
                l = bl2 ? this.getCharResolved(n3) : this.getChar(n3);
                n6 = (int)l;
                n3 += (int)(l >> 32);
            }
            if (n9 == n3) {
                return Float.NaN;
            }
            if (bl4) {
                l5 = -l5;
            }
        }
        while (n3 <= n4) {
            if (!this.isWS(n6)) {
                throw new NavException(this.toString(n));
            }
            l = bl2 ? this.getCharResolved(n3) : this.getChar(n3);
            n6 = (int)l;
            n3 += (int)(l >> 32);
        }
        double d = l2;
        if (l3 != 0L) {
            d += (double)l3 / (double)l4;
        }
        if (l5 != 0L) {
            d *= Math.pow(10.0, l5);
        }
        float f = (float)d;
        if (d >= 3.4028234663852886E38) {
            f = Float.MAX_VALUE;
        } else if (d <= (double)1.4E-45f) {
            f = Float.MIN_VALUE;
        }
        if (bl) {
            f = -f;
        }
        return f;
    }

    public int parseInt(int n) throws NavException {
        return this.parseInt(n, 10);
    }

    protected int parseInt(int n, int n2) throws NavException {
        int n3;
        boolean bl;
        if (n2 < 2 || n2 > 36) {
            throw new NumberFormatException("radix " + n2 + " out of valid range");
        }
        int n4 = this.getTokenType(n);
        boolean bl2 = n4 == 5 || n4 == 4;
        int n5 = this.getTokenOffset(n);
        int n6 = n5 + this.getTokenLength(n);
        long l = bl2 ? this.getCharResolved(n5) : this.getChar(n5);
        int n7 = (int)l;
        n5 += (int)(l >> 32);
        while ((n7 == 32 || n7 == 10 || n7 == 9 || n7 == 13) && n5 <= n6) {
            l = bl2 ? this.getCharResolved(n5) : this.getChar(n5);
            n7 = (int)l;
            n5 += (int)(l >> 32);
        }
        if (n5 > n6) {
            throw new NumberFormatException(" empty string");
        }
        boolean bl3 = bl = n7 == 45;
        if (bl || n7 == 43) {
            l = bl2 ? this.getCharResolved(n5) : this.getChar(n5);
            n7 = (int)l;
            n5 += (int)(l >> 32);
        }
        long l2 = 0L;
        long l3 = 1L;
        while (n5 <= n6 && (n3 = Character.digit((char)n7, n2)) >= 0) {
            l2 = l2 * (long)n2 + (long)n3;
            l = bl2 ? this.getCharResolved(n5) : this.getChar(n5);
            n7 = (int)l;
            n5 += (int)(l >> 32);
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new NumberFormatException("Overflow: " + this.toString(n));
        }
        while (n5 <= n6 && this.isWS(n7)) {
            l = bl2 ? this.getCharResolved(n5) : this.getChar(n5);
            n7 = (int)l;
            n5 += (int)(l >> 32);
        }
        if (n5 == n6 + 1) {
            return (int)(bl ? -l2 : l2);
        }
        throw new NumberFormatException(this.toString(n));
    }

    public long parseLong(int n) throws NavException {
        return this.parseLong(n, 10);
    }

    protected long parseLong(int n, int n2) throws NavException {
        int n3;
        boolean bl;
        if (n2 < 2 || n2 > 36) {
            throw new NumberFormatException("radix " + n2 + " out of valid range");
        }
        int n4 = this.getTokenType(n);
        boolean bl2 = n4 == 5 || n4 == 4;
        int n5 = this.getTokenOffset(n);
        int n6 = n5 + this.getTokenLength(n);
        long l = bl2 ? this.getCharResolved(n5) : this.getChar(n5);
        int n7 = (int)l;
        n5 += (int)(l >> 32);
        while ((n7 == 32 || n7 == 10 || n7 == 9 || n7 == 13) && n5 <= n6) {
            l = bl2 ? this.getCharResolved(n5) : this.getChar(n5);
            n7 = (int)l;
            n5 += (int)(l >> 32);
        }
        if (n5 > n6) {
            throw new NumberFormatException(" empty string");
        }
        boolean bl3 = bl = n7 == 45;
        if (bl || n7 == 43) {
            l = bl2 ? this.getCharResolved(n5) : this.getChar(n5);
            n7 = (int)l;
            n5 += (int)(l >> 32);
        }
        long l2 = 0L;
        long l3 = 1L;
        while (n5 <= n6 && (n3 = Character.digit((char)n7, n2)) >= 0) {
            l2 = l2 * (long)n2 + (long)n3;
            l = bl2 ? this.getCharResolved(n5) : this.getChar(n5);
            n7 = (int)l;
            n5 += (int)(l >> 32);
        }
        if (l2 > Long.MAX_VALUE) {
            throw new NumberFormatException("Overflow: " + this.toString(n));
        }
        while (n5 <= n6 && this.isWS(n7)) {
            l = bl2 ? this.getCharResolved(n5) : this.getChar(n5);
            n7 = (int)l;
            n5 += (int)(l >> 32);
        }
        if (n5 == n6 + 1) {
            return bl ? -l2 : l2;
        }
        throw new NumberFormatException(this.toString(n));
    }

    public final boolean pop() {
        boolean bl = this.contextStack.load(this.stackTemp);
        if (!bl) {
            return false;
        }
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.context[i] = this.stackTemp[i];
        }
        this.l1index = this.stackTemp[this.nestingLevel];
        this.l2index = this.stackTemp[this.nestingLevel + 1];
        this.l3index = this.stackTemp[this.nestingLevel + 2];
        this.l2lower = this.stackTemp[this.nestingLevel + 3];
        this.l2upper = this.stackTemp[this.nestingLevel + 4];
        this.l3lower = this.stackTemp[this.nestingLevel + 5];
        this.l3upper = this.stackTemp[this.nestingLevel + 6];
        this.atTerminal = this.stackTemp[this.nestingLevel + 7] == 1;
        this.LN = this.stackTemp[this.nestingLevel + 8];
        return true;
    }

    protected final boolean pop2() {
        boolean bl = this.contextStack2.load(this.stackTemp);
        if (!bl) {
            return false;
        }
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.context[i] = this.stackTemp[i];
        }
        this.l1index = this.stackTemp[this.nestingLevel];
        this.l2index = this.stackTemp[this.nestingLevel + 1];
        this.l3index = this.stackTemp[this.nestingLevel + 2];
        this.l2lower = this.stackTemp[this.nestingLevel + 3];
        this.l2upper = this.stackTemp[this.nestingLevel + 4];
        this.l3lower = this.stackTemp[this.nestingLevel + 5];
        this.l3upper = this.stackTemp[this.nestingLevel + 6];
        this.atTerminal = this.stackTemp[this.nestingLevel + 7] == 1;
        this.LN = this.stackTemp[this.nestingLevel + 8];
        return true;
    }

    public final void push() {
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.stackTemp[i] = this.context[i];
        }
        this.stackTemp[this.nestingLevel] = this.l1index;
        this.stackTemp[this.nestingLevel + 1] = this.l2index;
        this.stackTemp[this.nestingLevel + 2] = this.l3index;
        this.stackTemp[this.nestingLevel + 3] = this.l2lower;
        this.stackTemp[this.nestingLevel + 4] = this.l2upper;
        this.stackTemp[this.nestingLevel + 5] = this.l3lower;
        this.stackTemp[this.nestingLevel + 6] = this.l3upper;
        this.stackTemp[this.nestingLevel + 7] = this.atTerminal ? 1 : 0;
        this.stackTemp[this.nestingLevel + 8] = this.LN;
        this.contextStack.store(this.stackTemp);
    }

    protected final void push2() {
        for (int i = 0; i < this.nestingLevel; ++i) {
            this.stackTemp[i] = this.context[i];
        }
        this.stackTemp[this.nestingLevel] = this.l1index;
        this.stackTemp[this.nestingLevel + 1] = this.l2index;
        this.stackTemp[this.nestingLevel + 2] = this.l3index;
        this.stackTemp[this.nestingLevel + 3] = this.l2lower;
        this.stackTemp[this.nestingLevel + 4] = this.l2upper;
        this.stackTemp[this.nestingLevel + 5] = this.l3lower;
        this.stackTemp[this.nestingLevel + 6] = this.l3upper;
        this.stackTemp[this.nestingLevel + 7] = this.atTerminal ? 1 : 0;
        this.stackTemp[this.nestingLevel + 8] = this.LN;
        this.contextStack2.store(this.stackTemp);
    }

    protected final void clearStack2() {
        this.contextStack2.clear();
    }

    private void resolveLC() {
        block49: {
            int n;
            if (this.context[0] <= 0) {
                return;
            }
            if (this.l1index < 0 || this.l1index >= this.l1Buffer.size() || this.context[1] != this.l1Buffer.upper32At(this.l1index)) {
                if (this.l1index >= this.l1Buffer.size() || this.l1index < 0) {
                    this.l1index = 0;
                }
                if (this.l1index + 1 < this.l1Buffer.size() && this.context[1] != this.l1Buffer.upper32At(this.l1index + 1)) {
                    n = (int)((float)this.l1Buffer.size() * ((float)this.context[1] / (float)this.vtdBuffer.size()));
                    if (this.l1Buffer.upper32At(n) > this.context[1]) {
                        while (this.l1Buffer.upper32At(n) != this.context[1]) {
                            --n;
                        }
                    } else if (this.l1Buffer.upper32At(n) < this.context[1]) {
                        while (this.l1Buffer.upper32At(n) != this.context[1]) {
                            ++n;
                        }
                    }
                    this.l1index = n;
                } else if (this.context[1] >= this.l1Buffer.upper32At(this.l1index)) {
                    while (this.context[1] != this.l1Buffer.upper32At(this.l1index) && this.l1index < this.l1Buffer.size()) {
                        ++this.l1index;
                    }
                } else {
                    while (this.context[1] != this.l1Buffer.upper32At(this.l1index) && this.l1index >= 0) {
                        --this.l1index;
                    }
                }
            }
            if (this.context[0] == 1) {
                return;
            }
            int n2 = this.l1Buffer.lower32At(this.l1index);
            if (this.l2lower != n2) {
                this.l2index = this.l2lower = n2;
                this.l2upper = this.l2Buffer.size() - 1;
                for (n = this.l1index + 1; n < this.l1Buffer.size(); ++n) {
                    n2 = this.l1Buffer.lower32At(n);
                    if (n2 == -1) continue;
                    this.l2upper = n2 - 1;
                    break;
                }
            }
            if (this.l2index < 0 || this.l2index >= this.l2Buffer.size() || this.context[2] != this.l2Buffer.upper32At(this.l2index)) {
                if (this.l2index >= this.l2Buffer.size() || this.l2index < 0) {
                    this.l2index = this.l2lower;
                }
                if (this.l2index + 1 < this.l2Buffer.size() && this.context[2] == this.l2Buffer.upper32At(this.l2index + 1)) {
                    ++this.l2index;
                } else if (this.l2upper - this.l2lower >= 16) {
                    n = this.l2lower + (int)((float)(this.l2upper - this.l2lower) * ((float)this.context[2] - (float)this.l2Buffer.upper32At(this.l2lower)) / (float)(this.l2Buffer.upper32At(this.l2upper) - this.l2Buffer.upper32At(this.l2lower)));
                    if (this.l2Buffer.upper32At(n) > this.context[2]) {
                        while (this.context[2] != this.l2Buffer.upper32At(n)) {
                            --n;
                        }
                    } else if (this.l2Buffer.upper32At(n) < this.context[2]) {
                        while (this.context[2] != this.l2Buffer.upper32At(n)) {
                            ++n;
                        }
                    }
                    this.l2index = n;
                } else if (this.context[2] < this.l2Buffer.upper32At(this.l2index)) {
                    while (this.context[2] != this.l2Buffer.upper32At(this.l2index)) {
                        --this.l2index;
                    }
                } else {
                    while (this.context[2] != this.l2Buffer.upper32At(this.l2index)) {
                        ++this.l2index;
                    }
                }
            }
            if (this.context[0] == 2) {
                return;
            }
            n2 = this.l2Buffer.lower32At(this.l2index);
            if (this.l3lower != n2) {
                this.l3index = this.l3lower = n2;
                this.l3upper = this.l3Buffer.size() - 1;
                for (n = this.l2index + 1; n < this.l2Buffer.size(); ++n) {
                    n2 = this.l2Buffer.lower32At(n);
                    if (n2 == -1) continue;
                    this.l3upper = n2 - 1;
                    break;
                }
            }
            if (this.l3index >= 0 && this.l3index < this.l3Buffer.size() && this.context[3] == this.l3Buffer.intAt(this.l3index)) break block49;
            if (this.l3index >= this.l3Buffer.size() || this.l3index < 0) {
                this.l3index = this.l3lower;
            }
            if (this.l3index + 1 < this.l3Buffer.size() && this.context[3] == this.l3Buffer.intAt(this.l3index + 1)) {
                ++this.l3index;
            } else if (this.l3upper - this.l3lower >= 16) {
                n = this.l3lower + (int)((float)(this.l3upper - this.l3lower) * ((float)(this.context[3] - this.l3Buffer.intAt(this.l3lower)) / (float)(this.l3Buffer.intAt(this.l3upper) - this.l3Buffer.intAt(this.l3lower))));
                if (this.l3Buffer.intAt(n) > this.context[3]) {
                    while (this.context[3] != this.l3Buffer.intAt(n)) {
                        --n;
                    }
                } else if (this.l3Buffer.intAt(n) < this.context[3]) {
                    while (this.context[3] != this.l3Buffer.intAt(n)) {
                        ++n;
                    }
                }
                this.l3index = n;
            } else if (this.context[3] < this.l3Buffer.intAt(this.l3index)) {
                while (this.context[3] != this.l3Buffer.intAt(this.l3index)) {
                    --this.l3index;
                }
            } else {
                while (this.context[3] != this.l3Buffer.intAt(this.l3index)) {
                    ++this.l3index;
                }
            }
        }
    }

    protected final int lookupNS() throws NavException {
        if (this.context[0] == -1) {
            throw new NavException("Can't lookup NS for document node");
        }
        int n = this.getTokenLength(this.context[0] != 0 ? this.context[this.context[0]] : this.rootIndex);
        int n2 = this.getTokenOffset(this.context[0] != 0 ? this.context[this.context[0]] : this.rootIndex);
        int n3 = n >> 16 & 0xFFFF;
        return this.lookupNS(n2, n3);
    }

    protected int lookupNS(int n, int n2) {
        boolean bl = false;
        int n3 = this.vtdBuffer.size();
        block4: for (int i = this.context[0]; i >= 0; --i) {
            int n4 = i != 0 ? this.context[i] : this.rootIndex;
            switch (this.NSval(n4)) {
                case -1073741824: {
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    if (++n4 >= n3) continue block4;
                    int n11 = this.getTokenType(n4);
                    while (n11 == 2 || n11 == 3) {
                        if (n11 == 3) {
                            n10 = this.getTokenLength(n4);
                            n9 = n10 >> 16 & 0xFFFF;
                            n8 = n10 & 0xFFFF;
                            n7 = this.getTokenOffset(n4);
                            if (n10 == 5 && n2 == 0) {
                                return n4 + 1;
                            }
                            if (n8 - n9 - 1 == n2) {
                                n6 = 1;
                                for (n5 = 0; n5 < n2; ++n5) {
                                    if (this.getCharUnit(n7 + n9 + 1 + n5) == this.getCharUnit(n + n5)) continue;
                                    n6 = 0;
                                    break;
                                }
                                if (n6 == 1) {
                                    return n4 + 1;
                                }
                            }
                        }
                        if ((n4 += 2) >= n3) continue block4;
                        n11 = this.getTokenType(n4);
                    }
                    continue block4;
                }
                case -2147483648: {
                    continue block4;
                }
                default: {
                    long l;
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10 = n4 + 1;
                    if (n10 >= n3) continue block4;
                    int n11 = this.getTokenType(n10);
                    while (n11 == 2 || n11 == 3) {
                        if (n11 == 3) {
                            bl = true;
                            n9 = this.getTokenLength(n10);
                            n8 = n9 >> 16 & 0xFFFF;
                            n7 = n9 & 0xFFFF;
                            n6 = this.getTokenOffset(n10);
                            if (n9 == 5 && n2 == 0) {
                                l = this.vtdBuffer.longAt(n4);
                                bl = false;
                                this.vtdBuffer.modifyEntry(n4, l | 0xC0000000L);
                                return n10 + 1;
                            }
                            if (n7 - n8 - 1 == n2) {
                                n5 = 1;
                                for (int j = 0; j < n2; ++j) {
                                    if (this.getCharUnit(n6 + n8 + 1 + j) == this.getCharUnit(n + j)) continue;
                                    n5 = 0;
                                    break;
                                }
                                if (n5 == 1) {
                                    l = this.vtdBuffer.longAt(n4);
                                    this.vtdBuffer.modifyEntry(n4, l | 0xC0000000L);
                                    return n10 + 1;
                                }
                            }
                        }
                        if ((n10 += 2) >= n3) break;
                        n11 = this.getTokenType(n10);
                    }
                    l = this.vtdBuffer.longAt(n4);
                    if (bl) {
                        bl = false;
                        this.vtdBuffer.modifyEntry(n4, l | 0xC0000000L);
                        continue block4;
                    }
                    this.vtdBuffer.modifyEntry(n4, l | 0x80000000L);
                }
            }
        }
        return 0;
    }

    private boolean resolveNS(String string, int n, int n2) throws NavException {
        int n3 = this.lookupNS(n, n2);
        switch (n3) {
            case 0: {
                return string == null;
            }
        }
        if (string == null) {
            return false;
        }
        return this.matchTokenString(n3, string);
    }

    public boolean toElement(int n) throws NavException {
        switch (n) {
            case 0: {
                if (this.context[0] != 0) {
                    this.context[0] = 0;
                }
                this.atTerminal = false;
                this.l3index = -1;
                this.l2index = -1;
                this.l1index = -1;
                return true;
            }
            case 1: {
                if (this.atTerminal) {
                    this.atTerminal = false;
                    return true;
                }
                if (this.context[0] > 0) {
                    this.context[this.context[0]] = -1;
                    this.context[0] = this.context[0] - 1;
                    return true;
                }
                if (this.context[0] == 0) {
                    this.context[0] = -1;
                    return true;
                }
                return false;
            }
            case 2: 
            case 3: {
                if (this.atTerminal) {
                    return false;
                }
                switch (this.context[0]) {
                    case -1: {
                        this.context[0] = 0;
                        return true;
                    }
                    case 0: {
                        if (this.l1Buffer.size() > 0) {
                            this.context[0] = 1;
                            this.l1index = n == 2 ? 0 : this.l1Buffer.size() - 1;
                            this.context[1] = this.l1Buffer.upper32At(this.l1index);
                            return true;
                        }
                        return false;
                    }
                    case 1: {
                        this.l2lower = this.l1Buffer.lower32At(this.l1index);
                        if (this.l2lower == -1) {
                            return false;
                        }
                        this.context[0] = 2;
                        this.l2upper = this.l2Buffer.size() - 1;
                        int n2 = this.l1Buffer.size();
                        for (int i = this.l1index + 1; i < n2; ++i) {
                            int n3 = this.l1Buffer.lower32At(i);
                            if (n3 == -1) continue;
                            this.l2upper = n3 - 1;
                            break;
                        }
                        this.l2index = n == 2 ? this.l2lower : this.l2upper;
                        this.context[2] = this.l2Buffer.upper32At(this.l2index);
                        return true;
                    }
                    case 2: {
                        this.l3lower = this.l2Buffer.lower32At(this.l2index);
                        if (this.l3lower == -1) {
                            return false;
                        }
                        this.context[0] = 3;
                        this.l3upper = this.l3Buffer.size() - 1;
                        int n4 = this.l2Buffer.size();
                        for (int i = this.l2index + 1; i < n4; ++i) {
                            int n5 = this.l2Buffer.lower32At(i);
                            if (n5 == -1) continue;
                            this.l3upper = n5 - 1;
                            break;
                        }
                        this.l3index = n == 2 ? this.l3lower : this.l3upper;
                        this.context[3] = this.l3Buffer.intAt(this.l3index);
                        return true;
                    }
                }
                if (n == 2) {
                    int n6 = this.vtdBuffer.size();
                    for (int i = this.context[this.context[0]] + 1; i < n6; ++i) {
                        long l = this.vtdBuffer.longAt(i);
                        int n7 = (int)((0xF000000000000000L & l) >> 60) & 0xF;
                        if (n7 != 0) continue;
                        int n8 = (int)((0xFF0000000000000L & l) >> 52);
                        if (n8 <= this.context[0]) {
                            return false;
                        }
                        if (n8 != this.context[0] + 1) continue;
                        this.context[0] = this.context[0] + 1;
                        this.context[this.context[0]] = i;
                        return true;
                    }
                    return false;
                }
                int n9 = -1;
                int n10 = this.vtdBuffer.size();
                for (int i = this.context[this.context[0]] + 1; i < n10; ++i) {
                    long l = this.vtdBuffer.longAt(i);
                    int n11 = (int)((0xFF0000000000000L & l) >> 52);
                    int n12 = (int)((0xF000000000000000L & l) >> 60) & 0xF;
                    if (n12 != 0) continue;
                    if (n11 <= this.context[0]) break;
                    if (n11 != this.context[0] + 1) continue;
                    n9 = i;
                }
                if (n9 == -1) {
                    return false;
                }
                this.context[0] = this.context[0] + 1;
                this.context[this.context[0]] = n9;
                return true;
            }
            case 4: 
            case 5: {
                if (this.atTerminal) {
                    return false;
                }
                switch (this.context[0]) {
                    case -1: 
                    case 0: {
                        return false;
                    }
                    case 1: {
                        if (n == 4) {
                            if (this.l1index + 1 >= this.l1Buffer.size()) {
                                return false;
                            }
                            ++this.l1index;
                        } else {
                            if (this.l1index - 1 < 0) {
                                return false;
                            }
                            --this.l1index;
                        }
                        this.context[1] = this.l1Buffer.upper32At(this.l1index);
                        return true;
                    }
                    case 2: {
                        if (n == 4) {
                            if (this.l2index + 1 > this.l2upper) {
                                return false;
                            }
                            ++this.l2index;
                        } else {
                            if (this.l2index - 1 < this.l2lower) {
                                return false;
                            }
                            --this.l2index;
                        }
                        this.context[2] = this.l2Buffer.upper32At(this.l2index);
                        return true;
                    }
                    case 3: {
                        if (n == 4) {
                            if (this.l3index + 1 > this.l3upper) {
                                return false;
                            }
                            ++this.l3index;
                        } else {
                            if (this.l3index - 1 < this.l3lower) {
                                return false;
                            }
                            --this.l3index;
                        }
                        this.context[3] = this.l3Buffer.intAt(this.l3index);
                        return true;
                    }
                }
                if (n == 4) {
                    int n13 = this.vtdBuffer.size();
                    for (int i = this.context[this.context[0]] + 1; i < n13; ++i) {
                        long l = this.vtdBuffer.longAt(i);
                        int n14 = (int)((0xF000000000000000L & l) >> 60) & 0xF;
                        if (n14 != 0) continue;
                        int n15 = (int)((0xFF0000000000000L & l) >> 52);
                        if (n15 < this.context[0]) {
                            return false;
                        }
                        if (n15 != this.context[0]) continue;
                        this.context[this.context[0]] = i;
                        return true;
                    }
                    return false;
                }
                for (int i = this.context[this.context[0]] - 1; i > this.context[this.context[0] - 1]; --i) {
                    int n16;
                    long l = this.vtdBuffer.longAt(i);
                    int n17 = (int)((0xF000000000000000L & l) >> 60) & 0xF;
                    if (n17 != 0 || (n16 = (int)((0xFF0000000000000L & l) >> 52)) != this.context[0]) continue;
                    this.context[this.context[0]] = i;
                    return true;
                }
                return false;
            }
        }
        throw new NavException("illegal navigation options");
    }

    public boolean toElement(int n, String string) throws NavException {
        int n2 = 0;
        if (string == null) {
            throw new IllegalArgumentException(" Element name can't be null ");
        }
        if (string.equals("*")) {
            return this.toElement(n);
        }
        switch (n) {
            case 0: {
                return this.toElement(0);
            }
            case 1: {
                return this.toElement(1);
            }
            case 2: {
                if (this.atTerminal) {
                    return false;
                }
                if (!this.toElement(2)) {
                    return false;
                }
                if (!this.matchElement(string)) {
                    if (this.toElement(4, string)) {
                        return true;
                    }
                    this.context[0] = this.context[0] - 1;
                    return false;
                }
                return true;
            }
            case 3: {
                if (this.atTerminal) {
                    return false;
                }
                if (!this.toElement(3)) {
                    return false;
                }
                if (!this.matchElement(string)) {
                    if (this.toElement(5, string)) {
                        return true;
                    }
                    this.context[0] = this.context[0] - 1;
                    return false;
                }
                return true;
            }
            case 4: {
                if (this.atTerminal) {
                    return false;
                }
                int n3 = this.context[0];
                switch (n3) {
                    case -1: 
                    case 0: {
                        return false;
                    }
                    case 1: {
                        n2 = this.l1index;
                        break;
                    }
                    case 2: {
                        n2 = this.l2index;
                        break;
                    }
                    case 3: {
                        n2 = this.l3index;
                        break;
                    }
                }
                int n4 = this.context[n3];
                while (this.toElement(4)) {
                    if (!this.matchElement(string)) continue;
                    return true;
                }
                switch (n3) {
                    case 1: {
                        this.l1index = n2;
                        break;
                    }
                    case 2: {
                        this.l2index = n2;
                        break;
                    }
                    case 3: {
                        this.l3index = n2;
                        break;
                    }
                }
                this.context[n3] = n4;
                return false;
            }
            case 5: {
                if (this.atTerminal) {
                    return false;
                }
                int n5 = this.context[0];
                switch (n5) {
                    case -1: 
                    case 0: {
                        return false;
                    }
                    case 1: {
                        n2 = this.l1index;
                        break;
                    }
                    case 2: {
                        n2 = this.l2index;
                        break;
                    }
                    case 3: {
                        n2 = this.l3index;
                        break;
                    }
                }
                int n6 = this.context[n5];
                while (this.toElement(5)) {
                    if (!this.matchElement(string)) continue;
                    return true;
                }
                switch (n5) {
                    case 1: {
                        this.l1index = n2;
                        break;
                    }
                    case 2: {
                        this.l2index = n2;
                        break;
                    }
                    case 3: {
                        this.l3index = n2;
                        break;
                    }
                }
                this.context[n5] = n6;
                return false;
            }
        }
        throw new NavException("illegal navigation options");
    }

    public boolean toElementNS(int n, String string, String string2) throws NavException {
        int n2 = 0;
        if (!this.ns) {
            return false;
        }
        switch (n) {
            case 0: {
                return this.toElement(0);
            }
            case 1: {
                return this.toElement(1);
            }
            case 2: {
                if (this.atTerminal) {
                    return false;
                }
                if (!this.toElement(2)) {
                    return false;
                }
                if (!this.matchElementNS(string, string2)) {
                    if (this.toElementNS(4, string, string2)) {
                        return true;
                    }
                    this.context[0] = this.context[0] - 1;
                    return false;
                }
                return true;
            }
            case 3: {
                if (this.atTerminal) {
                    return false;
                }
                if (!this.toElement(3)) {
                    return false;
                }
                if (!this.matchElementNS(string, string2)) {
                    if (this.toElementNS(5, string, string2)) {
                        return true;
                    }
                    this.context[0] = this.context[0] - 1;
                    return false;
                }
                return true;
            }
            case 4: {
                if (this.atTerminal) {
                    return false;
                }
                int n3 = this.context[0];
                int n4 = this.context[n3];
                switch (n3) {
                    case -1: 
                    case 0: {
                        return false;
                    }
                    case 1: {
                        n2 = this.l1index;
                        break;
                    }
                    case 2: {
                        n2 = this.l2index;
                        break;
                    }
                    case 3: {
                        n2 = this.l3index;
                        break;
                    }
                }
                while (this.toElement(4)) {
                    if (!this.matchElementNS(string, string2)) continue;
                    return true;
                }
                switch (n3) {
                    case 1: {
                        this.l1index = n2;
                        break;
                    }
                    case 2: {
                        this.l2index = n2;
                        break;
                    }
                    case 3: {
                        this.l3index = n2;
                        break;
                    }
                }
                this.context[n3] = n4;
                return false;
            }
            case 5: {
                if (this.atTerminal) {
                    return false;
                }
                int n5 = this.context[0];
                int n6 = this.context[n5];
                switch (n5) {
                    case -1: 
                    case 0: {
                        return false;
                    }
                    case 1: {
                        n2 = this.l1index;
                        break;
                    }
                    case 2: {
                        n2 = this.l2index;
                        break;
                    }
                    case 3: {
                        n2 = this.l3index;
                        break;
                    }
                }
                while (this.toElement(5)) {
                    if (!this.matchElementNS(string, string2)) continue;
                    return true;
                }
                switch (n5) {
                    case 1: {
                        this.l1index = n2;
                        break;
                    }
                    case 2: {
                        this.l2index = n2;
                        break;
                    }
                    case 3: {
                        this.l3index = n2;
                        break;
                    }
                }
                this.context[n5] = n6;
                return false;
            }
        }
        throw new NavException("illegal navigation options");
    }

    public String toNormalizedString(int n) throws NavException {
        long l;
        int n2;
        int n3;
        int n4 = this.getTokenType(n);
        if (n4 != 5 && n4 != 4) {
            return this.toRawString(n);
        }
        int n5 = n4 == 0 || n4 == 2 || n4 == 3 ? this.getTokenLength(n) & 0xFFFF : this.getTokenLength(n);
        if (n5 == 0) {
            return "";
        }
        int n6 = this.getTokenOffset(n);
        int n7 = n5 + n6 - 1;
        StringBuffer stringBuffer = new StringBuffer(n5);
        do {
            n2 = n6;
            l = this.getChar(n6);
            n3 = (int)l;
            n6 += (int)(l >> 32);
        } while (this.isWS(n3));
        n6 = n2;
        n2 = 0;
        while (n6 <= n7) {
            l = this.getCharResolved(n6);
            n3 = (int)l;
            if (this.isWS(n3) && this.getCharUnit((n6 += (int)(l >> 32)) - 1) != 59) {
                n2 = 1;
                continue;
            }
            if (n2 == 0) {
                stringBuffer.append((char)n3);
                continue;
            }
            stringBuffer.append(' ');
            stringBuffer.append((char)n3);
            n2 = 0;
        }
        return stringBuffer.toString();
    }

    public String toRawString(int n) throws NavException {
        int n2 = this.getTokenType(n);
        int n3 = n2 == 0 || n2 == 2 || n2 == 3 ? this.getTokenLength(n) & 0xFFFF : this.getTokenLength(n);
        int n4 = this.getTokenOffset(n);
        return this.toRawString(n4, n3);
    }

    protected String toRawString(int n, int n2) throws NavException {
        long l;
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = n + n2;
        for (int i = n; i < n3; i += (int)(l >> 32)) {
            l = this.getChar(i);
            stringBuffer.append((char)l);
        }
        return stringBuffer.toString();
    }

    public String toString(int n) throws NavException {
        int n2 = this.getTokenType(n);
        if (n2 != 5 && n2 != 4) {
            return this.toRawString(n);
        }
        int n3 = n2 == 0 || n2 == 2 || n2 == 3 ? this.getTokenLength(n) & 0xFFFF : this.getTokenLength(n);
        int n4 = this.getTokenOffset(n);
        return this.toString(n4, n3);
    }

    protected String toString(int n, int n2) throws NavException {
        long l;
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = n + n2;
        for (int i = n; i < n3; i += (int)(l >> 32)) {
            l = this.getCharResolved(i);
            stringBuffer.append((char)l);
        }
        return stringBuffer.toString();
    }

    public final boolean matchTokens(int n, VTDNav vTDNav, int n2) throws NavException {
        return this.compareTokens(n, vTDNav, n2) == 0;
    }

    protected boolean iterate(int n, String string, boolean bl) throws NavException {
        int n2 = this.getCurrentIndex() + 1;
        while (n2 < this.vtdSize) {
            int n3 = this.getTokenType(n2);
            if (n3 == 2 || n3 == 3) {
                n2 += 2;
                continue;
            }
            if (this.isElementOrDocument(n2)) {
                int n4 = this.getTokenDepth(n2);
                if (n4 > n) {
                    this.context[0] = n4;
                    if (n4 > 0) {
                        this.context[n4] = n2;
                    }
                    if (bl || this.matchElement(string)) {
                        if (n < 4) {
                            this.resolveLC();
                        }
                        return true;
                    }
                } else {
                    return false;
                }
            }
            ++n2;
        }
        return false;
    }

    protected final boolean iterateNS(int n, String string, String string2) throws NavException {
        if (!this.ns) {
            return false;
        }
        int n2 = this.getCurrentIndex() + 1;
        while (n2 < this.vtdSize) {
            int n3 = this.getTokenType(n2);
            if (n3 == 2 || n3 == 3) {
                n2 += 2;
                continue;
            }
            if (this.isElementOrDocument(n2)) {
                int n4 = this.getTokenDepth(n2);
                if (n4 > n) {
                    this.context[0] = n4;
                    if (n4 > 0) {
                        this.context[n4] = n2;
                    }
                    if (this.matchElementNS(string, string2)) {
                        if (n < 4) {
                            this.resolveLC();
                        }
                        return true;
                    }
                } else {
                    return false;
                }
            }
            ++n2;
        }
        return false;
    }
}

