/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.FastIntBuffer;
import com.ximpleware.FastLongBuffer;
import java.util.ArrayList;

public class ContextBuffer {
    private ArrayList bufferArrayList;
    private int capacity;
    private int pageSize;
    protected int size;
    private int incSize;
    private int n;
    private int r;

    public ContextBuffer(int n) {
        this.pageSize = 1024;
        this.n = 10;
        this.r = this.pageSize - 1;
        this.incSize = n;
        if (this.incSize < 0) {
            throw new IllegalArgumentException();
        }
        this.bufferArrayList = new ArrayList();
    }

    public ContextBuffer(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid Buffer size");
        }
        this.pageSize = 1 << n;
        this.r = this.pageSize - 1;
        this.n = n;
        this.incSize = n2;
        if (this.incSize < 0) {
            throw new IllegalArgumentException("context buffer's incremental size must be greater than zero");
        }
        this.bufferArrayList = new ArrayList();
    }

    public boolean load(int[] nArray) {
        if (this.size < this.incSize) {
            return false;
        }
        int n = this.size - this.incSize;
        int n2 = this.incSize;
        int n3 = n >> this.n;
        int n4 = n + n2 >> this.n;
        if ((n + n2 & this.r) == 0) {
            --n4;
        }
        if (n3 == n4) {
            System.arraycopy((int[])this.bufferArrayList.get(n3), n & this.r, nArray, 0, n2);
        } else {
            int n5 = 0;
            for (int i = n3; i <= n4; ++i) {
                int[] nArray2 = (int[])this.bufferArrayList.get(i);
                if (i == n3) {
                    System.arraycopy(nArray2, n & this.r, nArray, 0, this.pageSize - (n & this.r));
                    n5 += this.pageSize - (n & this.r);
                    continue;
                }
                if (i == n4) {
                    System.arraycopy(nArray2, 0, nArray, n5, n2 - n5);
                    continue;
                }
                System.arraycopy(nArray2, 0, nArray, n5, this.pageSize);
                n5 += this.pageSize;
            }
        }
        this.size -= this.incSize;
        return true;
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            int n2;
            int[] nArray = new int[18];
            ContextBuffer contextBuffer = new ContextBuffer(18);
            for (n2 = 0; n2 < 57; ++n2) {
                for (n = 0; n < 17; ++n) {
                    nArray[n] = n2;
                }
                nArray[17] = -1;
                contextBuffer.store(nArray);
            }
            for (n2 = 56; n2 >= 0; --n2) {
                contextBuffer.load(nArray);
                System.out.println("" + nArray[0]);
                if (nArray[17] != -1) {
                    System.out.println("store error " + n2 + " " + 17 + " " + nArray[17]);
                }
                for (n = 16; n >= 0; --n) {
                    if (nArray[n] == n2) continue;
                    System.out.println(" store error " + n2 + " " + n + " " + nArray[n]);
                }
            }
            System.out.println("cb.clear()");
            contextBuffer.clear();
            for (n2 = 0; n2 < 157; ++n2) {
                for (n = 0; n < 18; ++n) {
                    nArray[n] = n2;
                }
                contextBuffer.store(nArray);
            }
            for (n2 = 156; n2 >= 0; --n2) {
                contextBuffer.load(nArray);
                System.out.println("" + nArray[0]);
                for (n = 17; n >= 0; --n) {
                    if (nArray[n] == n2) continue;
                    System.out.println(" store error " + n2 + " " + n + " " + nArray[n]);
                }
            }
            contextBuffer.clear();
            for (n2 = 0; n2 < 257; ++n2) {
                for (n = 0; n < 18; ++n) {
                    nArray[n] = n2;
                }
                contextBuffer.store(nArray);
            }
            for (n2 = 256; n2 >= 0; --n2) {
                contextBuffer.load(nArray);
                System.out.println("" + nArray[0]);
                for (n = 17; n >= 0; --n) {
                    if (nArray[n] == n2) continue;
                    System.out.println(" store error " + n2 + " " + n + " " + nArray[n]);
                }
            }
            System.out.println("success");
            System.out.println("test fastIntBuffer");
            nArray = new int[1000000];
            for (n2 = 0; n2 < 1000000; ++n2) {
                nArray[n2] = n2;
            }
            FastIntBuffer fastIntBuffer = new FastIntBuffer(13);
            fastIntBuffer.append(nArray);
            fastIntBuffer.clear();
            fastIntBuffer.append(nArray);
            int[] nArray2 = fastIntBuffer.toIntArray();
            for (int i = 0; i < 1000000; ++i) {
                if (nArray2[i] == i) continue;
                System.out.println("error occurred at " + i);
            }
            System.out.println("test fastLongBuffer");
            long[] lArray = new long[1000000];
            for (int i = 0; i < 1000000; ++i) {
                lArray[i] = i;
            }
            FastLongBuffer fastLongBuffer = new FastLongBuffer(14);
            fastLongBuffer.append(lArray);
            fastLongBuffer.clear();
            fastLongBuffer.append(lArray);
            long[] lArray2 = fastLongBuffer.toLongArray();
            for (int i = 0; i < 1000000; ++i) {
                if (lArray2[i] == (long)i) continue;
                System.out.println("error occurred at " + i);
            }
            System.out.println("success");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(" exception caught ");
        }
    }

    public void clear() {
        this.size = 0;
    }

    public void store(int[] nArray) {
        int n;
        int[] nArray2;
        if (nArray == null) {
            throw new IllegalArgumentException("context buffer can't store a null pointer");
        }
        if (this.bufferArrayList.size() == 0) {
            nArray2 = new int[this.pageSize];
            this.bufferArrayList.add(nArray2);
            n = 0;
            this.capacity = this.pageSize;
        } else {
            n = Math.min(this.size >> this.n, this.bufferArrayList.size() - 1);
            nArray2 = (int[])this.bufferArrayList.get(n);
        }
        if (this.size + nArray.length < this.capacity) {
            if (this.size + nArray.length < n + 1 << this.n) {
                System.arraycopy(nArray, 0, nArray2, this.size & this.r, nArray.length);
            } else {
                int n2;
                int n3 = this.pageSize - (this.size & this.r);
                System.arraycopy(nArray, 0, nArray2, this.size & this.r, n3);
                int n4 = nArray.length - n3;
                int n5 = n4 >> this.n;
                for (n2 = 1; n2 <= n5; ++n2) {
                    System.arraycopy(nArray, n3, (int[])this.bufferArrayList.get(n + n2), 0, this.pageSize);
                    n3 += this.pageSize;
                }
                System.arraycopy(nArray, n3, (int[])this.bufferArrayList.get(n + n2), 0, n4 & this.r);
            }
            this.size += nArray.length;
            return;
        }
        int n6 = (nArray.length + this.size >> this.n) + ((nArray.length + this.size & this.r) > 0 ? 1 : 0) - (this.capacity >> this.n);
        System.arraycopy(nArray, 0, nArray2, this.size & this.r, this.capacity - this.size);
        for (int i = 0; i < n6; ++i) {
            int[] nArray3 = new int[this.pageSize];
            if (i < n6 - 1) {
                System.arraycopy(nArray, this.pageSize * i + this.capacity - this.size, nArray3, 0, this.pageSize);
            } else {
                System.arraycopy(nArray, this.pageSize * i + this.capacity - this.size, nArray3, 0, nArray.length + this.size - this.pageSize * i - this.capacity);
            }
            this.bufferArrayList.add(nArray3);
        }
        this.size += nArray.length;
        this.capacity += n6 << this.n;
    }
}

