/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.NavException;
import com.ximpleware.PilotException;
import com.ximpleware.VTDNav;

public class AutoPilot {
    private int depth;
    private int iter_type;
    private VTDNav vn;
    private int index;
    private boolean ft;
    private String name;
    private String localName;
    private String URL;
    private int size;
    boolean special;
    private int stackSize;
    public static final int UNDEFINED = 0;
    public static final int SIMPLE = 1;
    public static final int SIMPLE_NS = 2;

    public AutoPilot(VTDNav vTDNav) {
        if (vTDNav == null) {
            throw new IllegalArgumentException(" instance of VTDNav can't be null ");
        }
        this.name = null;
        this.vn = vTDNav;
        this.iter_type = 0;
        this.ft = true;
        this.size = 0;
        this.special = false;
    }

    public AutoPilot() {
        this.name = null;
        this.special = false;
        this.iter_type = 0;
        this.ft = true;
        this.size = 0;
    }

    public void bind(VTDNav vTDNav) {
        this.name = null;
        if (vTDNav == null) {
            throw new IllegalArgumentException(" instance of VTDNav can't be null ");
        }
        this.vn = vTDNav;
        this.iter_type = 0;
        this.ft = true;
        this.size = 0;
    }

    public boolean iterate() throws PilotException, NavException {
        switch (this.iter_type) {
            case 1: {
                if (this.vn.atTerminal) {
                    return false;
                }
                if (!this.ft) {
                    return this.vn.iterate(this.depth, this.name, this.special);
                }
                this.ft = false;
                if (this.special || this.vn.matchElement(this.name)) {
                    return true;
                }
                return this.vn.iterate(this.depth, this.name, this.special);
            }
            case 2: {
                if (this.vn.atTerminal) {
                    return false;
                }
                if (!this.ft) {
                    return this.vn.iterateNS(this.depth, this.URL, this.localName);
                }
                this.ft = false;
                if (this.vn.matchElementNS(this.URL, this.localName)) {
                    return true;
                }
                return this.vn.iterateNS(this.depth, this.URL, this.localName);
            }
        }
        throw new PilotException(" iteration action type undefined");
    }

    public void selectElement(String string) {
        if (string == null) {
            throw new IllegalArgumentException("element name can't be null");
        }
        this.iter_type = 1;
        this.depth = this.vn.getCurrentDepth();
        this.name = string;
        this.ft = true;
    }

    public void selectElementNS(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("local name can't be null");
        }
        this.iter_type = 2;
        this.depth = this.vn.getCurrentDepth();
        this.localName = string2;
        this.URL = string;
        this.ft = true;
    }
}

