/*
  JSmooth: a VM wrapper toolkit for Windows
  Copyright (C) 2003 Rodrigo Reyes <reyes@charabia.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/


/*
 * SkeletonEditor.java
 *
 * Created on 7 aot 2003, 22:23
 */

package net.charabia.jsmoothgen.skeleton;

import javax.swing.*;
import javax.swing.table.*;
import java.util.*;
import java.io.*;
import java.awt.*;

public class SkeletonEditor extends javax.swing.JFrame
{
	private SkeletonPropertyTableModel m_model = new SkeletonPropertyTableModel();
	
	/** Creates new form SkeletonEditor */
	public SkeletonEditor()
	{
		initComponents();
		setSkeleton(new SkeletonBean());
//		m_propTable.setModel(m_model);
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents()//GEN-BEGIN:initComponents
    {
        java.awt.GridBagConstraints gridBagConstraints;

        m_fileChooser = new javax.swing.JFileChooser();
        m_popupMenu = new javax.swing.JPopupMenu();
        m_menuAddItem = new javax.swing.JMenuItem();
        m_menuRemoveItem = new javax.swing.JMenuItem();
        jSeparator3 = new javax.swing.JSeparator();
        m_menuItemUp = new javax.swing.JMenuItem();
        jPanel1 = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        m_exeName = new javax.swing.JTextField();
        m_labelName = new javax.swing.JLabel();
        m_name = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        m_description = new javax.swing.JEditorPane();
        jLabel2 = new javax.swing.JLabel();
        m_categoryName = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        m_jarId = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        m_propsId = new javax.swing.JTextField();
        m_cbDebug = new javax.swing.JCheckBox();
        m_tablescrollpane = new javax.swing.JScrollPane();
        m_propTable = new javax.swing.JTable();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenu1 = new javax.swing.JMenu();
        m_menuNew = new javax.swing.JMenuItem();
        m_menuLoadKBML = new javax.swing.JMenuItem();
        m_menuLoad = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JSeparator();
        m_menuSaveKbml = new javax.swing.JMenuItem();
        m_menuSave = new javax.swing.JMenuItem();
        jSeparator2 = new javax.swing.JSeparator();
        m_menuExit = new javax.swing.JMenuItem();

        m_fileChooser.setCurrentDirectory(new java.io.File("c:\\"));
            m_fileChooser.setFileFilter(new javax.swing.filechooser.FileFilter()
            {
                public boolean accept(File f)
                {
                    if (f.toString().endsWith(".skel"))
                    return true;
                    if (f.isDirectory())
                    return true;
                    return false;
                }
                public String getDescription()
                {
                    return "JSmooth Skeletons (*.skel)";
                }
            });
            m_fileChooser.setFileSelectionMode(javax.swing.JFileChooser.FILES_AND_DIRECTORIES);
            m_menuAddItem.setText("Add item");
            m_menuAddItem.addActionListener(new java.awt.event.ActionListener()
            {
                public void actionPerformed(java.awt.event.ActionEvent evt)
                {
                    menuAddItemActionPerformed(evt);
                }
            });

            m_popupMenu.add(m_menuAddItem);

            m_menuRemoveItem.setText("RemoveItems");
            m_menuRemoveItem.addActionListener(new java.awt.event.ActionListener()
            {
                public void actionPerformed(java.awt.event.ActionEvent evt)
                {
                    menuRemoveItemActionPerformed(evt);
                }
            });

            m_popupMenu.add(m_menuRemoveItem);

            m_popupMenu.add(jSeparator3);

            m_menuItemUp.setText("Item Up");
            m_menuItemUp.addActionListener(new java.awt.event.ActionListener()
            {
                public void actionPerformed(java.awt.event.ActionEvent evt)
                {
                    menuItemUpActionPerformed(evt);
                }
            });

            m_popupMenu.add(m_menuItemUp);

            getContentPane().setLayout(new java.awt.GridBagLayout());

            setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
            setTitle("JSmooth Skeleton Editor");
            addWindowListener(new java.awt.event.WindowAdapter()
            {
                public void windowClosing(java.awt.event.WindowEvent evt)
                {
                    exitForm(evt);
                }
            });

            jPanel1.setLayout(new java.awt.GridBagLayout());

            jPanel1.setBorder(new javax.swing.border.EtchedBorder());
            jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
            jLabel5.setText("Executable Name");
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
            jPanel1.add(jLabel5, gridBagConstraints);

            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints.weightx = 0.5;
            jPanel1.add(m_exeName, gridBagConstraints);

            m_labelName.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
            m_labelName.setText("Short Name");
            m_labelName.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
            jPanel1.add(m_labelName, gridBagConstraints);

            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints.weightx = 0.5;
            jPanel1.add(m_name, gridBagConstraints);

            jLabel1.setText("Description");
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            jPanel1.add(jLabel1, gridBagConstraints);

            jScrollPane1.setViewportView(m_description);

            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.5;
            jPanel1.add(jScrollPane1, gridBagConstraints);

            jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
            jLabel2.setText("Category Name");
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
            jPanel1.add(jLabel2, gridBagConstraints);

            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints.weightx = 0.5;
            jPanel1.add(m_categoryName, gridBagConstraints);

            jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
            jLabel3.setText("Resource Id for JAR");
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
            jPanel1.add(jLabel3, gridBagConstraints);

            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            jPanel1.add(m_jarId, gridBagConstraints);

            jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
            jLabel4.setText("Resource Id for Properties");
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
            jPanel1.add(jLabel4, gridBagConstraints);

            m_propsId.addActionListener(new java.awt.event.ActionListener()
            {
                public void actionPerformed(java.awt.event.ActionEvent evt)
                {
                    m_propsIdActionPerformed(evt);
                }
            });

            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            jPanel1.add(m_propsId, gridBagConstraints);

            m_cbDebug.setText("Mark this wrapper for debugging only");
            m_cbDebug.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            jPanel1.add(m_cbDebug, gridBagConstraints);

            m_tablescrollpane.addMouseListener(new java.awt.event.MouseAdapter()
            {
                public void mousePressed(java.awt.event.MouseEvent evt)
                {
                    tablescrollpaneMousePressed(evt);
                }
                public void mouseReleased(java.awt.event.MouseEvent evt)
                {
                    tablescrollpaneMouseReleased(evt);
                }
            });

            m_propTable.setModel(new javax.swing.table.DefaultTableModel(
                new Object [][]
                {
                    {null, null, null, null, null},
                    {null, null, null, null, null},
                    {null, null, null, null, null},
                    {null, null, null, null, null}
                },
                new String []
                {
                    "Id", "Label", "Description", "Type", "Value"
                }
            ));
            m_propTable.addMouseListener(new java.awt.event.MouseAdapter()
            {
                public void mouseClicked(java.awt.event.MouseEvent evt)
                {
                    propTableMouseClicked(evt);
                }
                public void mousePressed(java.awt.event.MouseEvent evt)
                {
                    propTableMousePressed(evt);
                }
                public void mouseReleased(java.awt.event.MouseEvent evt)
                {
                    propTableMouseReleased(evt);
                }
            });

            m_tablescrollpane.setViewportView(m_propTable);

            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            jPanel1.add(m_tablescrollpane, gridBagConstraints);

            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
            gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints.weightx = 0.9;
            gridBagConstraints.weighty = 0.9;
            getContentPane().add(jPanel1, gridBagConstraints);

            jMenu1.setText("System");
            m_menuNew.setText("New");
            m_menuNew.addActionListener(new java.awt.event.ActionListener()
            {
                public void actionPerformed(java.awt.event.ActionEvent evt)
                {
                    menuNewActionPerformed(evt);
                }
            });

            jMenu1.add(m_menuNew);

            m_menuLoadKBML.setText("Load");
            m_menuLoadKBML.addActionListener(new java.awt.event.ActionListener()
            {
                public void actionPerformed(java.awt.event.ActionEvent evt)
                {
                    menuLoadKBMLActionPerformed(evt);
                }
            });

            jMenu1.add(m_menuLoadKBML);

            m_menuLoad.setText("Load (deprecated)");
            m_menuLoad.addActionListener(new java.awt.event.ActionListener()
            {
                public void actionPerformed(java.awt.event.ActionEvent evt)
                {
                    menuLoadActionPerformed(evt);
                }
            });

            jMenu1.add(m_menuLoad);

            jMenu1.add(jSeparator1);

            m_menuSaveKbml.setText("Save");
            m_menuSaveKbml.addActionListener(new java.awt.event.ActionListener()
            {
                public void actionPerformed(java.awt.event.ActionEvent evt)
                {
                    saveKbmlActionPerformed(evt);
                }
            });

            jMenu1.add(m_menuSaveKbml);

            m_menuSave.setText("Save (deprecated)");
            m_menuSave.addActionListener(new java.awt.event.ActionListener()
            {
                public void actionPerformed(java.awt.event.ActionEvent evt)
                {
                    menuSaveActionPerformed(evt);
                }
            });

            jMenu1.add(m_menuSave);

            jMenu1.add(jSeparator2);

            m_menuExit.setText("Exit");
            jMenu1.add(m_menuExit);

            jMenuBar1.add(jMenu1);

            setJMenuBar(jMenuBar1);

            java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
            setBounds((screenSize.width-400)/2, (screenSize.height-254)/2, 400, 254);
        }//GEN-END:initComponents

    private void menuLoadKBMLActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_menuLoadKBMLActionPerformed
    {//GEN-HEADEREND:event_menuLoadKBMLActionPerformed
        // Add your handling code here:
        if ( m_fileChooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION)
        {
                File f = m_fileChooser.getSelectedFile();
                System.out.println("loading " + m_fileChooser.getSelectedFile().toString());
                try {
                        SkeletonBean skel = SkeletonPersistency.loadWithJox(f);
                        setSkeleton(skel);
                } catch (IOException iox)
                {
                        iox.printStackTrace();
                }
        }
    }//GEN-LAST:event_menuLoadKBMLActionPerformed

    private void saveKbmlActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_saveKbmlActionPerformed
    {//GEN-HEADEREND:event_saveKbmlActionPerformed
        // Add your handling code here:
        if ( m_fileChooser.showSaveDialog(this) == JFileChooser.APPROVE_OPTION)
        {
                File f = m_fileChooser.getSelectedFile();
                if (f.toString().endsWith(".skel") == false)
                {
                        f = new File(f.getAbsolutePath() + ".skel");
                }	
                System.out.println("loading " + m_fileChooser.getSelectedFile().toString());
                try {
                        SkeletonBean skel = getSkeleton();
                        SkeletonPersistency.saveWithJox(f, skel);
                } catch (IOException iox)
                {
                        iox.printStackTrace();
                }
        }

    }//GEN-LAST:event_saveKbmlActionPerformed

	private void menuItemUpActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_menuItemUpActionPerformed
	{//GEN-HEADEREND:event_menuItemUpActionPerformed
		// Add your handling code here:
		int selr = m_propTable.getSelectedRow();
		if (selr > 0)
		{
			m_model.swapItems(selr, selr-1);
		}
	}//GEN-LAST:event_menuItemUpActionPerformed

	private void menuRemoveItemActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_menuRemoveItemActionPerformed
	{//GEN-HEADEREND:event_menuRemoveItemActionPerformed
		int selr = m_propTable.getSelectedRow();
		if (selr != -1)
		{
			m_model.removeRow(selr);
		}
	}//GEN-LAST:event_menuRemoveItemActionPerformed

	private void menuAddItemActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_menuAddItemActionPerformed
	{//GEN-HEADEREND:event_menuAddItemActionPerformed
		SkeletonProperty prop = new SkeletonProperty();
		int selr = m_propTable.getSelectedRow();
		if (selr >= 0)
			m_model.add(prop, selr);
		else
			m_model.add(prop);
	}//GEN-LAST:event_menuAddItemActionPerformed

	private void tablescrollpaneMouseReleased(java.awt.event.MouseEvent evt)//GEN-FIRST:event_tablescrollpaneMouseReleased
	{//GEN-HEADEREND:event_tablescrollpaneMouseReleased
		// Add your handling code here:
		System.out.println("MOUSE");
		if (evt.isPopupTrigger())
		{
			System.out.println("trigger !");
			showPopupMenu(evt, m_tablescrollpane);
		}		
	}//GEN-LAST:event_tablescrollpaneMouseReleased

	private void tablescrollpaneMousePressed(java.awt.event.MouseEvent evt)//GEN-FIRST:event_tablescrollpaneMousePressed
	{//GEN-HEADEREND:event_tablescrollpaneMousePressed
		// Add your handling code here:
		System.out.println("MOUSE");
		if (evt.isPopupTrigger())
		{
			System.out.println("trigger !");
			showPopupMenu(evt, m_tablescrollpane);
		}		
	}//GEN-LAST:event_tablescrollpaneMousePressed

	private void propTableMouseReleased(java.awt.event.MouseEvent evt)//GEN-FIRST:event_propTableMouseReleased
	{//GEN-HEADEREND:event_propTableMouseReleased
		// Add your handling code here:
		System.out.println("MOUSE");
		if (evt.isPopupTrigger())
		{
			System.out.println("trigger !");
			showPopupMenu(evt, m_propTable);
		}		
	}//GEN-LAST:event_propTableMouseReleased

	private void propTableMousePressed(java.awt.event.MouseEvent evt)//GEN-FIRST:event_propTableMousePressed
	{//GEN-HEADEREND:event_propTableMousePressed
		// Add your handling code here:
		System.out.println("MOUSE");
		if (evt.isPopupTrigger())
		{
			System.out.println("trigger !");
			showPopupMenu(evt, m_propTable);
		}		
	}//GEN-LAST:event_propTableMousePressed

	private void propTableMouseClicked(java.awt.event.MouseEvent evt)//GEN-FIRST:event_propTableMouseClicked
	{//GEN-HEADEREND:event_propTableMouseClicked
		// Add your handling code here:
		System.out.println("MOUSE");
		if (evt.isPopupTrigger())
		{
			System.out.println("trigger !");
			showPopupMenu(evt, m_propTable);
		}
	}//GEN-LAST:event_propTableMouseClicked

	private void m_propsIdActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_m_propsIdActionPerformed
	{//GEN-HEADEREND:event_m_propsIdActionPerformed
		// Add your handling code here:
	}//GEN-LAST:event_m_propsIdActionPerformed

	private void menuSaveActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_menuSaveActionPerformed
	{//GEN-HEADEREND:event_menuSaveActionPerformed
		// Add your handling code here:
		if ( m_fileChooser.showSaveDialog(this) == JFileChooser.APPROVE_OPTION)
		{
			File f = m_fileChooser.getSelectedFile();
			if (f.toString().endsWith(".skel") == false)
			{
				f = new File(f.getAbsolutePath() + ".skel");
			}	
			System.out.println("loading " + m_fileChooser.getSelectedFile().toString());
			try {
				SkeletonBean skel = getSkeleton();
				SkeletonPersistency.save(f, skel);
			} catch (IOException iox)
			{
				iox.printStackTrace();
			}
		}
	}//GEN-LAST:event_menuSaveActionPerformed

	private void menuLoadActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_menuLoadActionPerformed
	{//GEN-HEADEREND:event_menuLoadActionPerformed
		// Add your handling code here:
		if ( m_fileChooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION)
		{
			File f = m_fileChooser.getSelectedFile();
			System.out.println("loading " + m_fileChooser.getSelectedFile().toString());
			try {
				SkeletonBean skel = SkeletonPersistency.load(f);
				setSkeleton(skel);
			} catch (IOException iox)
			{
				iox.printStackTrace();
			}
		}
	}//GEN-LAST:event_menuLoadActionPerformed

	private void menuNewActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_menuNewActionPerformed
	{//GEN-HEADEREND:event_menuNewActionPerformed
		// Add your handling code here:
		SkeletonBean skel = new SkeletonBean();
		setSkeleton(skel);
	}//GEN-LAST:event_menuNewActionPerformed
	
	/** Exit the Application */
	private void exitForm(java.awt.event.WindowEvent evt)//GEN-FIRST:event_exitForm
	{
		System.exit(0);
	}//GEN-LAST:event_exitForm
	
	public void setSkeleton(SkeletonBean skel)
	{
		m_name.setText(skel.getShortName());
		m_description.setText(skel.getDescription());
		m_categoryName.setText(skel.getResourceCategory());
		m_jarId.setText(new Integer(skel.getResourceJarId()).toString());
		m_propsId.setText(new Integer(skel.getResourcePropsId()).toString());
		m_exeName.setText(skel.getExecutableName());
                m_cbDebug.setSelected(skel.isDebug());
		
		m_model = new SkeletonPropertyTableModel(skel.getSkeletonProperties());
		TableColumn type = m_propTable.getColumnModel().getColumn(3);
		JComboBox typeCombo = new JComboBox();
		typeCombo.addItem(SkeletonProperty.TYPE_STRING);
		typeCombo.addItem(SkeletonProperty.TYPE_TEXTAREA);
		typeCombo.addItem(SkeletonProperty.TYPE_BOOLEAN);
		type.setCellEditor(new DefaultCellEditor(typeCombo));
		
		m_propTable.setModel(m_model);
	}
	
	public SkeletonBean getSkeleton()
	{
		SkeletonBean skel = new SkeletonBean();
		skel.setExecutableName(m_exeName.getText());
		skel.setShortName(m_name.getText());
		skel.setDescription(m_description.getText());
		skel.setResourceCategory(m_categoryName.getText());
		skel.setResourceJarId(Integer.parseInt(m_jarId.getText()));
		skel.setResourcePropsId(Integer.parseInt(m_propsId.getText()));
		skel.setSkeletonProperties(m_model.getProperties());
                skel.setDebug(m_cbDebug.isSelected());
		return skel;
	}

	public void showPopupMenu(java.awt.event.MouseEvent evt, JComponent comp)
	{
		int r = m_propTable.rowAtPoint(new Point(evt.getX(), evt.getY()));
		if (r != -1)
		{
			m_propTable.setRowSelectionInterval(r,r);
		}
		m_popupMenu.show(comp, evt.getX(), evt.getY());
	}
	

	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[])
	{
		new SkeletonEditor().show();
	}
	
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JTextField m_categoryName;
    private javax.swing.JCheckBox m_cbDebug;
    private javax.swing.JEditorPane m_description;
    private javax.swing.JTextField m_exeName;
    private javax.swing.JFileChooser m_fileChooser;
    private javax.swing.JTextField m_jarId;
    private javax.swing.JLabel m_labelName;
    private javax.swing.JMenuItem m_menuAddItem;
    private javax.swing.JMenuItem m_menuExit;
    private javax.swing.JMenuItem m_menuItemUp;
    private javax.swing.JMenuItem m_menuLoad;
    private javax.swing.JMenuItem m_menuLoadKBML;
    private javax.swing.JMenuItem m_menuNew;
    private javax.swing.JMenuItem m_menuRemoveItem;
    private javax.swing.JMenuItem m_menuSave;
    private javax.swing.JMenuItem m_menuSaveKbml;
    private javax.swing.JTextField m_name;
    private javax.swing.JPopupMenu m_popupMenu;
    private javax.swing.JTable m_propTable;
    private javax.swing.JTextField m_propsId;
    private javax.swing.JScrollPane m_tablescrollpane;
    // End of variables declaration//GEN-END:variables

	
	
}
