/*
 * WarningNotRelativeFilesDialog.java
 *
 * Created on 7 septembre 2003, 20:52
 */

package net.charabia.jsmoothgen.application.gui.util;

/**
 *
 * @author  Rodrigo
 */
public class WarningNotRelativeFilesDialog extends javax.swing.JDialog {
    
    /** Creates new form WarningNotRelativeFilesDialog */
    public WarningNotRelativeFilesDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        m_errorsArea.setText("");
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jLabel1 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        m_buttonOK = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        m_errorsArea = new javax.swing.JTextArea();
        jPanel3 = new javax.swing.JPanel();
        m_cbDontDisplayAnymode = new javax.swing.JCheckBox();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jLabel1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/stock_dialog-warning-32.png")));
        jLabel1.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(10, 10, 10, 10)));
        getContentPane().add(jLabel1, java.awt.BorderLayout.WEST);

        m_buttonOK.setText("OK");
        m_buttonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonOKActionPerformed(evt);
            }
        });

        jPanel1.add(m_buttonOK);

        getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);

        jPanel2.setLayout(new java.awt.BorderLayout());

        jLabel2.setText("<html><big>Warning:</big> Not all the paths could be saved relative to the project file. This may be an issue if you transfer the project to another computer. Please see below the absolute path left.</html>");
        jPanel2.add(jLabel2, java.awt.BorderLayout.NORTH);

        m_errorsArea.setBackground((java.awt.Color) javax.swing.UIManager.getDefaults().get("Panel.background"));
        m_errorsArea.setEditable(false);
        m_errorsArea.setLineWrap(true);
        m_errorsArea.setBorder(new javax.swing.border.CompoundBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(5, 5, 5, 5)), new javax.swing.border.EtchedBorder()));
        jPanel2.add(m_errorsArea, java.awt.BorderLayout.CENTER);

        jPanel3.setLayout(new java.awt.BorderLayout());

        m_cbDontDisplayAnymode.setText("Don't display this message anymore");
        jPanel3.add(m_cbDontDisplayAnymode, java.awt.BorderLayout.CENTER);

        jPanel2.add(jPanel3, java.awt.BorderLayout.SOUTH);

        getContentPane().add(jPanel2, java.awt.BorderLayout.CENTER);

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-354)/2, (screenSize.height-271)/2, 354, 271);
    }//GEN-END:initComponents

    private void buttonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonOKActionPerformed
        // Add your handling code here:
        hide();
    }//GEN-LAST:event_buttonOKActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog

    public void setErrors(String[] errs)
    {
        StringBuffer buf = new StringBuffer();
        for (int i=0; i<errs.length; i++)
        {
            buf.append(" -");
            buf.append(errs[i]);
            buf.append("\n");
        }
        m_errorsArea.setText(buf.toString());
    }

    public boolean dontDisplayAnymore()
    {
        return m_cbDontDisplayAnymode.isSelected();
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new WarningNotRelativeFilesDialog(new javax.swing.JFrame(), true).show();
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JButton m_buttonOK;
    private javax.swing.JCheckBox m_cbDontDisplayAnymode;
    private javax.swing.JTextArea m_errorsArea;
    // End of variables declaration//GEN-END:variables
    
}
