/*
  JSmooth: a VM wrapper toolkit for Windows
  Copyright (C) 2003 Rodrigo Reyes <reyes@charabia.net>
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
 */

package net.charabia.jsmoothgen.application.gui.util;

public class VersionEditor extends javax.swing.JPanel
{
	
	/** Creates new form BeanForm */
	public VersionEditor()
	{
		initComponents();
	}
	
	public void setVersion(String version)
	{
		String[] vals = version.split("[.]");
		try
		{
			m_major.setValue(Integer.parseInt(vals[0]));
		} catch (Exception e)
		{
			m_major.clear();
		}
		
		try
		{
			m_minor.setValue(Integer.parseInt(vals[1]));
		} catch (Exception e)
		{
			m_minor.clear();
		}
		
		try
		{
			m_sub.setValue(Integer.parseInt(vals[2]));
		} catch (Exception e)
		{
			m_sub.clear();
		}
		
	}
	
	public String getVersion()
	{
		try
		{
			StringBuffer buf = new StringBuffer();
			if (m_major.getValue() != Integer.MAX_VALUE)
			{
				buf.append(Integer.toString(m_major.getValue()));
				if (m_minor.getValue() != Integer.MAX_VALUE)
				{
					buf.append(".");
					buf.append(Integer.toString(m_minor.getValue()));
					if (m_sub.getValue() != Integer.MAX_VALUE)
					{
						buf.append(".");
						buf.append(Integer.toString(m_sub.getValue()));
					}
				}
			}
			return buf.toString();
		} catch (Exception exc)
		{
			return "";
		}
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	private void initComponents()//GEN-BEGIN:initComponents
	{
		java.awt.GridBagConstraints gridBagConstraints;
		
		m_major = new net.charabia.jsmoothgen.application.gui.util.NumericTextField();
		jLabel1 = new javax.swing.JLabel();
		m_minor = new net.charabia.jsmoothgen.application.gui.util.NumericTextField();
		jLabel2 = new javax.swing.JLabel();
		m_sub = new net.charabia.jsmoothgen.application.gui.util.NumericTextField();
		
		setLayout(new java.awt.GridBagLayout());
		
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
		gridBagConstraints.weightx = 0.3;
		add(m_major, gridBagConstraints);
		
		jLabel1.setText(".");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
		add(jLabel1, gridBagConstraints);
		
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
		gridBagConstraints.weightx = 0.3;
		add(m_minor, gridBagConstraints);
		
		jLabel2.setText(".");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
		add(jLabel2, gridBagConstraints);
		
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
		gridBagConstraints.weightx = 0.3;
		add(m_sub, gridBagConstraints);
		
	}//GEN-END:initComponents
	
	
	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JLabel jLabel1;
	private javax.swing.JLabel jLabel2;
	private net.charabia.jsmoothgen.application.gui.util.NumericTextField m_major;
	private net.charabia.jsmoothgen.application.gui.util.NumericTextField m_minor;
	private net.charabia.jsmoothgen.application.gui.util.NumericTextField m_sub;
	// End of variables declaration//GEN-END:variables
	
}
