/*
  JSmooth: a VM wrapper toolkit for Windows
  Copyright (C) 2003 Rodrigo Reyes <reyes@charabia.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

package net.charabia.jsmoothgen.application.gui;

import net.charabia.jsmoothgen.application.*;
import net.charabia.jsmoothgen.skeleton.*;
import javax.swing.*;

public class StaticWizard extends javax.swing.JPanel implements ModelUpdater
{
    private ModelUpdater m_currentEditor;
    private MainController m_main;
    private JSmoothModelBean m_model;

    java.io.File m_basedir;
	
    private Executable m_panelExecutable = new Executable();
    private JVMConfigurationPanel m_panelJVMConfiguration = new JVMConfigurationPanel();
    private JVMSelectionPanel m_panelSelection = new JVMSelectionPanel();
    private JavaApp m_panelJavaApp = new JavaApp();
    private SkeletonChooser m_panelSkeletonChooser = new SkeletonChooser();
    private UserInteractionPanel m_panelUserInteraction = new UserInteractionPanel();
    private SkeletonPropertiesPanel m_panelSkeletonProps = new SkeletonPropertiesPanel();

    /** Creates new form StaticWizard */
    public StaticWizard()
    {
	m_model = new JSmoothModelBean();
	initComponents();
    }
	
    public void setMainController(MainController main)
    {
	m_main = main;
    }
	
    public void setModel(java.io.File basedir, JSmoothModelBean model)
    {
	m_basedir = basedir;
	m_model = model;
	if (m_currentEditor != null)
	    {
		m_currentEditor.setModel(basedir, model);
	    }
    }
	
    public JSmoothModelBean getModel()
    {
	return m_model;
    }
	
    public static void main(String[]args)
    {
	JFrame jf = new JFrame("test");
	StaticWizard sw = new StaticWizard();
	jf.getContentPane().add(sw);
	jf.setVisible(true);
    }
	
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents()//GEN-BEGIN:initComponents
    {
        java.awt.GridBagConstraints gridBagConstraints;

        m_leftButtonsGroup = new javax.swing.ButtonGroup();
        m_leftPane = new javax.swing.JPanel();
        m_buttonSkeleton = new javax.swing.JToggleButton();
        m_buttonExecutable = new javax.swing.JToggleButton();
        m_buttonJavaApp = new javax.swing.JToggleButton();
        m_buttonJVMSelection = new javax.swing.JToggleButton();
        m_buttonJVMConfig = new javax.swing.JToggleButton();
        m_buttonSkeletonProperties = new javax.swing.JToggleButton();
        jPanel1 = new javax.swing.JPanel();
        m_centerPane = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();

        setLayout(new java.awt.GridBagLayout());

        m_leftPane.setLayout(new java.awt.GridLayout(0, 1));

        m_leftPane.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(10, 10, 10, 10)));
        m_buttonSkeleton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/stock_new-template.png")));
        m_buttonSkeleton.setText("Skeleton Selection");
        m_leftButtonsGroup.add(m_buttonSkeleton);
        m_buttonSkeleton.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        m_buttonSkeleton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                buttonSkeletonActionPerformed(evt);
            }
        });

        m_leftPane.add(m_buttonSkeleton);

        m_buttonExecutable.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/stock_autopilot-24.png")));
        m_buttonExecutable.setText("Windows Executable");
        m_leftButtonsGroup.add(m_buttonExecutable);
        m_buttonExecutable.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        m_buttonExecutable.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        m_buttonExecutable.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                buttonExecutableActionPerformed(evt);
            }
        });

        m_leftPane.add(m_buttonExecutable);

        m_buttonJavaApp.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/stock_form-image-control.png")));
        m_buttonJavaApp.setText("Java Application");
        m_leftButtonsGroup.add(m_buttonJavaApp);
        m_buttonJavaApp.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        m_buttonJavaApp.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        m_buttonJavaApp.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                buttonJavaAppActionPerformed(evt);
            }
        });

        m_leftPane.add(m_buttonJavaApp);

        m_buttonJVMSelection.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/stock_search.png")));
        m_buttonJVMSelection.setText("JVM Selection");
        m_leftButtonsGroup.add(m_buttonJVMSelection);
        m_buttonJVMSelection.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        m_buttonJVMSelection.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                buttonJVMSelectionActionPerformed(evt);
            }
        });

        m_leftPane.add(m_buttonJVMSelection);

        m_buttonJVMConfig.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/stock_form-properties.png")));
        m_buttonJVMConfig.setText("JVM Configuration");
        m_leftButtonsGroup.add(m_buttonJVMConfig);
        m_buttonJVMConfig.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        m_buttonJVMConfig.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                buttonJVMConfigActionPerformed(evt);
            }
        });

        m_leftPane.add(m_buttonJVMConfig);

        m_buttonSkeletonProperties.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/stock_template_props.png")));
        m_buttonSkeletonProperties.setText("Skeleton Properties");
        m_leftButtonsGroup.add(m_buttonSkeletonProperties);
        m_buttonSkeletonProperties.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        m_buttonSkeletonProperties.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                buttonSkeletonPropertiesActionPerformed(evt);
            }
        });

        m_leftPane.add(m_buttonSkeletonProperties);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        add(m_leftPane, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridLayout(1, 1));

        jPanel1.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(10, 0, 10, 10)));
        m_centerPane.setLayout(new java.awt.GridLayout(1, 1, 10, 10));

        m_centerPane.setBorder(new javax.swing.border.CompoundBorder(new javax.swing.border.EtchedBorder(), new javax.swing.border.EmptyBorder(new java.awt.Insets(5, 5, 5, 5))));
        m_centerPane.add(jScrollPane1);

        jPanel1.add(m_centerPane);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.9;
        add(jPanel1, gridBagConstraints);

    }//GEN-END:initComponents

    private void buttonSkeletonPropertiesActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_buttonSkeletonPropertiesActionPerformed
    {//GEN-HEADEREND:event_buttonSkeletonPropertiesActionPerformed
	// Add your handling code here:
	try { 
	    updateModel();
		
	    //		SkeletonPropertiesPanel skelpan = new SkeletonPropertiesPanel();
	    String skelname = m_model.getSkeletonName();
	    if (skelname != null)
		{
		    System.out.println("Seting skeleton " + skelname);
		    SkeletonBean skel = m_main.getSkeletonList().getSkeleton(skelname);
		    if (skel != null)
			{
			    System.out.println("Seting skeleton bean " + skel);
			    m_panelSkeletonProps.setSkeletonProperties(skel.getSkeletonProperties());
			}
		    else
			m_panelSkeletonProps.setSkeletonProperties(new SkeletonProperty[0]);
		}
	    else
		m_panelSkeletonProps.setSkeletonProperties(new SkeletonProperty[0]);
	
	    m_panelSkeletonProps.setModel(m_basedir, m_model);
	    setNewCentralPanel(m_panelSkeletonProps, m_panelSkeletonProps);
	} catch (Exception exc)
	    {
		exc.printStackTrace();
	    }
    }//GEN-LAST:event_buttonSkeletonPropertiesActionPerformed

    private void buttonJVMConfigActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_buttonJVMConfigActionPerformed
    {//GEN-HEADEREND:event_buttonJVMConfigActionPerformed
	// Add your handling code here:
	updateModel();
	//		JVMConfigurationPanel jconf = new JVMConfigurationPanel();
	m_panelJVMConfiguration.setModel(m_basedir, m_model);
	setNewCentralPanel(m_panelJVMConfiguration, m_panelJVMConfiguration);
    }//GEN-LAST:event_buttonJVMConfigActionPerformed

    private void buttonJVMSelectionActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_buttonJVMSelectionActionPerformed
    {//GEN-HEADEREND:event_buttonJVMSelectionActionPerformed
	// Add your handling code here:
	updateModel();
	//		JVMSelectionPanel jvmsel = new JVMSelectionPanel();
	m_panelSelection.setModel(m_basedir, m_model);
	setNewCentralPanel(m_panelSelection,m_panelSelection);
    }//GEN-LAST:event_buttonJVMSelectionActionPerformed

    private void buttonJavaAppActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_buttonJavaAppActionPerformed
    {//GEN-HEADEREND:event_buttonJavaAppActionPerformed
	// Add your handling code here:
	updateModel();
	//		JavaApp japp = new JavaApp();
	m_panelJavaApp.setModel(m_basedir, m_model);
	setNewCentralPanel(m_panelJavaApp, m_panelJavaApp);
    }//GEN-LAST:event_buttonJavaAppActionPerformed

    private void buttonExecutableActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_buttonExecutableActionPerformed
    {//GEN-HEADEREND:event_buttonExecutableActionPerformed
	// Add your handling code here:
	updateModel();
	//		Executable exec = new Executable();
	m_panelExecutable.setModel(m_basedir, m_model);
	setNewCentralPanel(m_panelExecutable, m_panelExecutable);
    }//GEN-LAST:event_buttonExecutableActionPerformed

    private void buttonSkeletonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_buttonSkeletonActionPerformed
    {//GEN-HEADEREND:event_buttonSkeletonActionPerformed
	// Add your handling code here:
	updateModel();
	//		SkeletonChooser sc = new SkeletonChooser();
	m_panelSkeletonChooser.setModel(m_basedir, m_model);
	m_panelSkeletonChooser.setSkeletonList(m_main.getSkeletonList());
	setNewCentralPanel(m_panelSkeletonChooser, m_panelSkeletonChooser);
    }//GEN-LAST:event_buttonSkeletonActionPerformed

    public void setNewCentralPanel(JPanel pan, ModelUpdater upd)
    {
	m_centerPane.removeAll();
	m_centerPane.add(pan);
	m_currentEditor = upd;
		
	invalidate();
	revalidate();
	repaint();
    }
	
    public void updateModel()
    {
	if (m_currentEditor != null)
	    m_currentEditor.updateModel();
    }
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JToggleButton m_buttonExecutable;
    private javax.swing.JToggleButton m_buttonJVMConfig;
    private javax.swing.JToggleButton m_buttonJVMSelection;
    private javax.swing.JToggleButton m_buttonJavaApp;
    private javax.swing.JToggleButton m_buttonSkeleton;
    private javax.swing.JToggleButton m_buttonSkeletonProperties;
    private javax.swing.JPanel m_centerPane;
    private javax.swing.ButtonGroup m_leftButtonsGroup;
    private javax.swing.JPanel m_leftPane;
    // End of variables declaration//GEN-END:variables
	
}
