/*
  JSmooth: a VM wrapper toolkit for Windows
  Copyright (C) 2003 Rodrigo Reyes <reyes@charabia.net>
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
 */

package net.charabia.jsmoothgen.application.gui;

import net.charabia.jsmoothgen.application.*;
import net.charabia.jsmoothgen.application.gui.util.*;
import javax.swing.*;
import java.io.*;
import java.util.jar.*;

public class JavaApp extends javax.swing.JPanel implements ModelUpdater
{
    private JSmoothModelBean m_model;
    private JFileChooser m_jarLocFileChooser;
    private EditableListFileEditor m_fileeditor;
    private File m_basedir;
    private JarClassChooser m_classchooser = null;

    public class FileSelectedHandler implements FileSelectionTextField.FileSelected
    {
	public void fileSelected(String filename)
	{
	    if (m_basedir == null)
		return;
	    try {
		File f = new File(filename);
		if (f.isAbsolute() == false)
		    {
			f = new File(m_basedir, filename);
		    }

		System.out.println("Selected: " + f.toString());
		JarFile jarf = new JarFile(f);
		Manifest manifest = jarf.getManifest();
		Attributes attrs = manifest.getMainAttributes();
		String mainclass = attrs.getValue("Main-Class");
		System.out.println("mainclass: " + mainclass);
		m_mainClassName.setText(mainclass);
	    } catch (Exception exc)
		{
		    // NOTHING
		}
	}
    }
        
    /** Creates new form BeanForm */
    public JavaApp()
    {
	initComponents();
	m_jarLocFileChooser = new JFileChooser();
	m_jarLocFileChooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
	m_jarLocFileChooser.setMultiSelectionEnabled(true);
	m_jarLocFileChooser.addChoosableFileFilter(new ClassPathFileFilter());
	m_fileeditor = new EditableListFileEditor();
	m_fileeditor.setFileChooser(m_jarLocFileChooser);
	m_classPathList.setEditor(m_fileeditor);
	m_jarLocation.addListener(new FileSelectedHandler());
    }    

    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents()//GEN-BEGIN:initComponents
    {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel2 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        m_mainClassName = new javax.swing.JTextField();
        m_jarChooser = new javax.swing.JButton();
        jLabel3 = new javax.swing.JLabel();
        m_arguments = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        m_embedJar = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();
        m_jarLocation = new net.charabia.jsmoothgen.application.gui.util.FileSelectionTextField();
        classpathPanel = new javax.swing.JPanel();
        m_classPathList = new net.charabia.jsmoothgen.application.gui.util.SortedEditableList();

        setLayout(new java.awt.GridBagLayout());

        jLabel2.setText("Main Class");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        add(jLabel2, gridBagConstraints);

        jPanel1.setLayout(new java.awt.BorderLayout());

        jPanel1.add(m_mainClassName, java.awt.BorderLayout.CENTER);

        m_jarChooser.setText("...");
        m_jarChooser.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                jarChooserActionPerformed(evt);
            }
        });

        jPanel1.add(m_jarChooser, java.awt.BorderLayout.EAST);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(jPanel1, gridBagConstraints);

        jLabel3.setText("Arguments");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        add(jLabel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        add(m_arguments, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel2.setBorder(new javax.swing.border.TitledBorder("Embedded Jar"));
        m_embedJar.setText("Embed a jar file with the executable");
        m_embedJar.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                embedJarActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel2.add(m_embedJar, gridBagConstraints);

        jLabel1.setText("Jar location");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel2.add(jLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.5;
        jPanel2.add(m_jarLocation, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(jPanel2, gridBagConstraints);

        classpathPanel.setLayout(new java.awt.BorderLayout());

        classpathPanel.setBorder(new javax.swing.border.CompoundBorder(new javax.swing.border.TitledBorder("ClassPath"), new javax.swing.border.EmptyBorder(new java.awt.Insets(5, 5, 5, 5))));
        classpathPanel.add(m_classPathList, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(classpathPanel, gridBagConstraints);

    }//GEN-END:initComponents

    private void embedJarActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_embedJarActionPerformed
    {//GEN-HEADEREND:event_embedJarActionPerformed
        // Add your handling code here:
        m_jarLocation.setEnabled(m_embedJar.isSelected());
    }//GEN-LAST:event_embedJarActionPerformed

    private void jarChooserActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jarChooserActionPerformed
        // Add your handling code here:
        try {
            File jar = m_jarLocation.getFile();
            if (jar.isAbsolute() == false)
		{
		    jar = new File(m_basedir, jar.toString());
		}
            JarFile jf = new JarFile(jar);
            if (m_classchooser == null)
		{
		    m_classchooser = new JarClassChooser(JOptionPane.getFrameForComponent(this), true);
		    m_classchooser.setLocationRelativeTo(this);
		}
            m_classchooser.setJar(jf);
            System.out.println("Classname to set: " + m_mainClassName.getText());
            m_classchooser.setClassName((m_mainClassName.getText()!=null)?m_mainClassName.getText():"");
            m_classchooser.show();
            if (m_classchooser.validated())
		{
		    String classname = m_classchooser.getClassName();
		    m_mainClassName.setText(classname);
		}
        } catch (IOException iox)
	    {
		iox.printStackTrace();
	    }
    }//GEN-LAST:event_jarChooserActionPerformed
	
    public void updateModel()
    {
	//		m_model.setJarLocation(JSmoothModelPersistency.makePathRelativeIfPossible(new File(m_model.getBaseDir()),
	//				m_jarLocation.getFile()).toString());
	File jar = m_jarLocation.getFile();
	if (jar != null)
	    m_model.setJarLocation(jar.toString());
	else
	    m_model.setJarLocation(null);
	m_model.setMainClassName(m_mainClassName.getText());
	m_model.setArguments(m_arguments.getText());
	m_model.setEmbeddedJar(m_embedJar.isSelected());
	Object[] flist = m_classPathList.getData();
	String[] data = new String[flist.length];
	for (int i=0; i<data.length; i++)
	    {
		data[i] = flist[i].toString();
	    }
	m_model.setClassPath(data);
    }
	
    public void setModel(java.io.File basedir, JSmoothModelBean model)
    {
	m_model = model;
	m_basedir = basedir;
                
	if (basedir != null)
	    {
		System.out.println("basedir of jarlocation: " + basedir);
		m_jarLocation.setBaseDir(basedir);
		m_jarLocFileChooser.setCurrentDirectory(basedir);
			
		m_fileeditor.setRootDir(basedir);
	    }
	else
	    {
		m_jarLocation.setBaseDir(null);
	    }

	if (m_model.getEmbeddedJar() == true)
        {
	    m_jarLocation.setEnabled(true);
            m_embedJar.setSelected(true);
        }
	else
        {
	    m_jarLocation.setEnabled(false);
            m_embedJar.setSelected(false);
        }
	
	m_jarLocation.setFileChooser(m_jarLocFileChooser);
	if (m_model.getJarLocation() != null)
	    {
		System.out.println("basedir: " + basedir);
		System.out.println("jarloc: " + m_model.getJarLocation());
		m_jarLocation.setFile(new File(m_model.getJarLocation()));
	    }
	else
	    {
		m_jarLocation.setFile(null);
	    }
		
	if (m_model.getMainClassName() != null)
	    m_mainClassName.setText(m_model.getMainClassName());
	else
	    m_mainClassName.setText("");
		
	if (m_model.getArguments() != null)
	    m_arguments.setText(m_model.getArguments());
	else
	    m_arguments.setText("");
		
	if (m_model.getClassPath() != null)
	    {
		String[] classpathstr = m_model.getClassPath();
		File[] flist = new File[classpathstr.length];
		for (int i=0; i<classpathstr.length; i++)
		    {
			File f = new File(classpathstr[i]);
			if (basedir != null)
			    {
				f = JSmoothModelPersistency.makePathRelativeIfPossible(basedir, f);
			    }
			flist[i] = f;
		    }
		m_classPathList.setData(flist);
	    } else
		{
		    m_classPathList.setData(new String[0]);
		}
    }
	
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel classpathPanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JTextField m_arguments;
    private net.charabia.jsmoothgen.application.gui.util.SortedEditableList m_classPathList;
    private javax.swing.JCheckBox m_embedJar;
    private javax.swing.JButton m_jarChooser;
    private net.charabia.jsmoothgen.application.gui.util.FileSelectionTextField m_jarLocation;
    private javax.swing.JTextField m_mainClassName;
    // End of variables declaration//GEN-END:variables
	
}
