/*
  JSmooth: a VM wrapper toolkit for Windows
  Copyright (C) 2003 Rodrigo Reyes <reyes@charabia.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

package net.charabia.jsmoothgen.application.gui;

import net.charabia.jsmoothgen.application.*;
import net.charabia.jsmoothgen.application.gui.util.*;

public class JVMConfigurationPanel extends javax.swing.JPanel implements ModelUpdater
{
    private boolean m_editionCanceled = false;
    private JSmoothModelBean m_model;
    
    public class PropEditor implements SortedEditableList.Editor
    {
	public Object createNewItem(SortedEditableList selist)
	{
	    m_editionCanceled = false;
	    m_name.setText("");
	    m_value.setText("");
	    m_propeditor.show();
	    if ((m_editionCanceled == false) && (m_name.getText().trim().length() > 0))
		{
		    JavaPropertyPair jpp = new JavaPropertyPair(m_name.getText(), m_value.getText());
		    return jpp;
		}
	    return null;
	}
                
	public Object editItem(SortedEditableList selist, Object item)
	{
	    JavaPropertyPair jpp = (JavaPropertyPair)item;
                    
	    m_editionCanceled = false;
	    m_name.setText(jpp.getName());
	    m_value.setText(jpp.getValue());
	    m_propeditor.show();
	    if (m_editionCanceled == false)
		{
		    jpp.setName(m_name.getText());
		    jpp.setValue(m_value.getText());
		}
	    return item;
	}
                
	public boolean removeItem(SortedEditableList selist, Object item)
	{
	    return true;
	}
    }

    /** Creates new form BeanForm */
    public JVMConfigurationPanel()
    {
	initComponents();
	m_proplist.setEditor(new PropEditor());
	// m_propeditor.pack();*
	m_propeditor.setSize(400,300);
	m_propeditor.setLocationRelativeTo(m_proplist);
    }
	
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents()//GEN-BEGIN:initComponents
    {
        java.awt.GridBagConstraints gridBagConstraints;
        javax.swing.JLabel jLabel4;

        m_propeditor = new javax.swing.JDialog();
        jLabel4 = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        m_name = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        m_value = new javax.swing.JTextField();
        jPanel4 = new javax.swing.JPanel();
        jSeparator1 = new javax.swing.JSeparator();
        m_buttonDone = new javax.swing.JButton();
        m_buttonCancel = new javax.swing.JButton();
        jSeparator2 = new javax.swing.JSeparator();
        jPanel3 = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        m_numericMaxHeap = new net.charabia.jsmoothgen.application.gui.util.NumericTextField();
        m_comboMaxHeap = new javax.swing.JComboBox();
        jLabel6 = new javax.swing.JLabel();
        m_numericInitialHeap = new net.charabia.jsmoothgen.application.gui.util.NumericTextField();
        m_comboInitialHeap = new javax.swing.JComboBox();
        jPanel1 = new javax.swing.JPanel();
        m_proplist = new net.charabia.jsmoothgen.application.gui.util.SortedEditableList();
        jLabel1 = new javax.swing.JLabel();

        m_propeditor.getContentPane().setLayout(new java.awt.GridBagLayout());

        m_propeditor.setTitle("Property Editor");
        m_propeditor.setModal(true);
        m_propeditor.setName("m_propertyDialog");
        jLabel4.setText("<html><small>This property will be passed to the Java application by the exectuable. String of the form %ENVNAME% are replaced by the environment variable values at runtime. For instance, put %PATH% for the system path.</small></html>");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        m_propeditor.getContentPane().add(jLabel4, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel2.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(5, 1, 5, 1)));
        jLabel3.setText("Name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        jPanel2.add(jLabel3, gridBagConstraints);

        m_name.setText("jTextField1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.4;
        jPanel2.add(m_name, gridBagConstraints);

        jLabel2.setText("Value");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        jPanel2.add(jLabel2, gridBagConstraints);

        m_value.setText("jTextField2");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.4;
        jPanel2.add(m_value, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 1, 1, 5);
        m_propeditor.getContentPane().add(jPanel2, gridBagConstraints);

        jPanel4.setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.weightx = 0.3;
        jPanel4.add(jSeparator1, gridBagConstraints);

        m_buttonDone.setText("Done");
        m_buttonDone.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                buttonDoneDialogActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.weightx = 0.2;
        jPanel4.add(m_buttonDone, gridBagConstraints);

        m_buttonCancel.setText("Cancel");
        m_buttonCancel.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                buttonCancelDialogActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.weightx = 0.2;
        jPanel4.add(m_buttonCancel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.weightx = 0.3;
        jPanel4.add(jSeparator2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        m_propeditor.getContentPane().add(jPanel4, gridBagConstraints);

        setLayout(new java.awt.GridBagLayout());

        jPanel3.setLayout(new java.awt.GridBagLayout());

        jPanel3.setBorder(new javax.swing.border.TitledBorder("Options"));
        jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel5.setText("Maximum Memory Heap Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        jPanel3.add(jLabel5, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        jPanel3.add(m_numericMaxHeap, gridBagConstraints);

        m_comboMaxHeap.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Bytes", "KBytes", "MBytes" }));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel3.add(m_comboMaxHeap, gridBagConstraints);

        jLabel6.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel6.setText("Initial Memory Heap Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        jPanel3.add(jLabel6, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        jPanel3.add(m_numericInitialHeap, gridBagConstraints);

        m_comboInitialHeap.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Bytes", "KBytes", "MBytes" }));
        jPanel3.add(m_comboInitialHeap, new java.awt.GridBagConstraints());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 0.4;
        add(jPanel3, gridBagConstraints);

        jPanel1.setLayout(new java.awt.BorderLayout());

        jPanel1.setBorder(new javax.swing.border.CompoundBorder(new javax.swing.border.TitledBorder("Properties"), new javax.swing.border.EmptyBorder(new java.awt.Insets(1, 1, 1, 1))));
        jPanel1.add(m_proplist, java.awt.BorderLayout.CENTER);

        jLabel1.setText("<html><small>Define here the property pairs that are passed to the application.</small></html>");
        jPanel1.add(jLabel1, java.awt.BorderLayout.NORTH);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.6;
        add(jPanel1, gridBagConstraints);

    }//GEN-END:initComponents

    private void buttonCancelDialogActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonCancelDialogActionPerformed
        // Add your handling code here:
        m_editionCanceled = true;
        m_propeditor.hide();
    }//GEN-LAST:event_buttonCancelDialogActionPerformed

    private void buttonDoneDialogActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonDoneDialogActionPerformed
        // Add your handling code here:
        m_editionCanceled = false;
        m_propeditor.hide();
    }//GEN-LAST:event_buttonDoneDialogActionPerformed

    public void setModel(java.io.File basedir, JSmoothModelBean model)
    {
	m_model = model;
	JavaPropertyPair[] pairs = model.getJavaProperties();
	m_proplist.setData(pairs);
	setValueCombo(model.getMaximumMemoryHeap(), m_numericMaxHeap, m_comboMaxHeap);
	setValueCombo(model.getInitialMemoryHeap(), m_numericInitialHeap, m_comboInitialHeap);
    }	

    public void updateModel()
    {
	Object[] data = m_proplist.getData();
	JavaPropertyPair[] pairs = new JavaPropertyPair[data.length];
	for (int i=0; i<data.length; i++)
            {
                pairs[i] = (JavaPropertyPair)data[i];
            }
	m_model.setJavaProperties(pairs);
	m_model.setMaximumMemoryHeap( getValue(m_numericMaxHeap, m_comboMaxHeap) );
	m_model.setInitialMemoryHeap( getValue(m_numericInitialHeap, m_comboInitialHeap) );
    }	
	
    public int getValue(net.charabia.jsmoothgen.application.gui.util.NumericTextField num, javax.swing.JComboBox box)
    {
	if (num.isSet() == false)
	    return -1;

	int value = num.getValue();

	switch(box.getSelectedIndex())
	    {
	    case 0:
		return value;
	    case 1:
		return value * 1024;
	    case 2:
		return value * 1024 * 1024;
	    }
	return -1;
    }

    public void setValueCombo(int value, net.charabia.jsmoothgen.application.gui.util.NumericTextField num, javax.swing.JComboBox box)
    {
	if (value >= (1024 * 1024))
	    {
		num.setValue( value / (1024*1024));
		box.setSelectedIndex(2);
	    }
	else if (value >= 1024)
	    {
		num.setValue( value / 1024);
		box.setSelectedIndex(1);		
	    }
	else if (value > 0)
	    {
		num.setValue( value / 1024);
		box.setSelectedIndex(1);
	    }
	else
	    {
		num.clear();
		box.setSelectedIndex(2);
	    }
    }
    

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JButton m_buttonCancel;
    private javax.swing.JButton m_buttonDone;
    private javax.swing.JComboBox m_comboInitialHeap;
    private javax.swing.JComboBox m_comboMaxHeap;
    private javax.swing.JTextField m_name;
    private net.charabia.jsmoothgen.application.gui.util.NumericTextField m_numericInitialHeap;
    private net.charabia.jsmoothgen.application.gui.util.NumericTextField m_numericMaxHeap;
    private javax.swing.JDialog m_propeditor;
    private net.charabia.jsmoothgen.application.gui.util.SortedEditableList m_proplist;
    private javax.swing.JTextField m_value;
    // End of variables declaration//GEN-END:variables
	
}
