/*
  JSmooth: a VM wrapper toolkit for Windows
  Copyright (C) 2003 Rodrigo Reyes <reyes@charabia.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _MSJVIEWLAUNCHER_H
#define _MSJVIEWLAUNCHER_H

#include "Version.h"
#include "StringUtils.h"
#include "FileUtils.h"
#include "ResourceManager.h"

/**
 * Manages an instance of the Microsoft's JView JVM.
 *
 * @author Rodrigo Reyes <reyes@charabia.net>
 */

class MSJViewLauncher
{
 public:
  /**
   * Runs the MS JView JVM, launching the application described by the
   * ResourceManager object passed as parameter.
   *
   * @param resource the ResourceManager that describes the java application
   * @param noConsole if true, the application started is not attached to the console.
   */
  bool runProc(ResourceManager& resource, bool noConsole);

};

#endif

