package jp.gr.java_conf.a0.debug;

import java.io.FileOutputStream;
import java.io.PrintStream;

import java.io.IOException;

/***/
public class Logger
{
	/**
	 */
	public Logger(String aFileName)
	{
		if (WRITE_MODE) {
			try {
				this.stream = new PrintStream(new FileOutputStream(aFileName));
			} catch (IOException ex) {
				this.stream = System.err;
			}
		}
	}
	/***/
	protected void finalize() throws Exception
	{
		if (WRITE_MODE) {
			this.stream.close();
		}
	}

	/***/
	public synchronized void print(String aStr)
	{
		if (WRITE_MODE) {
			this.stream.print(aStr);
		}
	}
	/***/
	public synchronized void println(String aStr)
	{
		if (WRITE_MODE) {
			this.stream.println(aStr);
		}
	}
	/***/
	public synchronized void record(String aStr)
	{
		if (WRITE_MODE) {
			this.println(aStr);
		}
	}
	/***/
	public synchronized void record(Throwable anEx)
	{
		if (WRITE_MODE) {
			anEx.printStackTrace(this.stream);
		}
	}

	private PrintStream stream = null;

	/**
	 * Flag whether writs log or not. if true, writes log.
	 * In debug version, this is set true automatically.
	 * In release version, default is false. if set -Dlogger=true in
	 * start VM option, this flag set as true to output log.
	 */
	private static boolean WRITE_MODE = false;
	static {
		if (Debug.DEBUG_MODE || System.getProperty("logger") != null) {
			WRITE_MODE = true;
		}
	}
	
	/***/
	public final static Logger LOG = new Logger("debug.log");
}
