package jp.gr.java_conf.a0.jdh.parser.source;

import java.util.Vector;
import java.util.Hashtable;
import java.util.Enumeration;
import jp.gr.java_conf.a0.jdh.parser.Token;
import jp.gr.java_conf.a0.jdh.parser.comment.CommentBody;
import jp.gr.java_conf.a0.jdh.parser.comment.ParamTag;
import jp.gr.java_conf.a0.jdh.parser.comment.ExceptionTag;
import jp.gr.java_conf.a0.debug.Debug;


public class MethodDecl extends JavaDocHolder
{
/*	public void addModifier(Token t)
	{
		this.modifiers.addElement(t);
	}
*/	public void setModifiers(Vector v)
	{
		this.modifiers = v;
		Enumeration enum = v.elements();
		while (enum.hasMoreElements()) {
			super.setAccessFlag((Token)enum.nextElement());
		}
	}
	public void setResultType(ResultType rt)
	{
		this.result = rt;
	}
	public void setMethodName(Token t)
	{
		this.methodToken = t;
	}
	public void setParameters(Parameter[] ps)
	{
		this.params = ps;
	}
	public void setExceptions(Name[] ns)
	{
		this.exceptions = ns;
	}
	
	public Token getFirstToken()
	{
		if (this.modifiers.size() > 0) {
			return((Token)this.modifiers.elementAt(0));
		}
		return(this.result.getFirstToken());
	}
	
	/**
	 * ̃p[c̃VOj`i\bhANX̐錾jp[XĕԂB
	 */
	protected String parseSignature()
	{
		StringBuffer buf = new StringBuffer();
		
		Enumeration enum = this.modifiers.elements();
		while (enum.hasMoreElements()) {
			buf.append(((Token)enum.nextElement()).image);
			buf.append(" ");
		}

		this.appendResultType(buf);
		buf.append(this.methodToken.image);
		this.appendParams(buf, true);

		if (this.exceptions != null && this.exceptions.length != 0) {
			buf.append(" throws ");
			buf.append(this.exceptions[0].getSignature());
			for (int i = 1; i < this.exceptions.length; i++) {
				buf.append(", ");
				buf.append(this.exceptions[i].getSignature());
			}
		}
		return(new String(buf));
	}


	protected void appendResultType(StringBuffer aBuf)
	{
		aBuf.append(this.result.getSignature());
		aBuf.append(" ");
	}

	public String getMethodName()
	{
		if (this.methodName == null) {
			StringBuffer buf = new StringBuffer();
			buf.append(this.methodToken.image);
			this.appendParams(buf, false);
			this.methodName = new String(buf);
		}
		return(this.methodName);
	}
	/**
	 * \bḧ̐錾"()"̒̕ԂB
	 * aDetailtOŁip[^̌^ɉājp[^܂߂邩ǂw肷
	 * Ԓl͐擪"("AŌ")"̕B
	 * 
	 * @param aBuf i[obt@
	 * @param aDetail p[^i[邩ǂ̃tOBtrue̎i[B
	 */
	private void appendParams(StringBuffer aBuf, boolean aDetail)
	{
		aBuf.append("(");
		if (this.params.length != 0) {
			if (aDetail) {
				aBuf.append(this.params[0].getSignature());
			} else {
				aBuf.append(this.params[0].getParamType());
			}
			for (int i = 1; i < this.params.length; i++) {
				aBuf.append(", ");
				if (aDetail) {
					aBuf.append(this.params[i].getSignature());
				} else {
					aBuf.append(this.params[i].getParamType());
				}
			}
		}
		aBuf.append(")");
	}
	
	/**
	 * JavaDocRg param ^O`FbNB
	 * Rg̕ꍇɂ́Â܂܂ׂĂcB
	 * Ȃꍇ̂݁AȂ̂₤B
	 */
	protected void checkCommentBody(CommentBody aBody)
	{
		super.checkCommentBody(aBody);
		this.checkParamTags(aBody);
		this.checkExceptionTags(aBody);
	}
	/**
	 * p[^^Õ`FbNsB
	 * \[XR[h̃\bh錾ƁAJavaDocparam^O˂킹A
	 * ƂĂ邩ǂ𒲂ׂB
	 * Ȃꍇ̓^OǉiSTATE_FILLEDjA]ȃ^Oɂ́A
	 * STATE_EXTRA}[NB܂
	 */
	private void checkParamTags(CommentBody aBody)
	{
		Vector vec = aBody.getTagVectorFor(ParamTag.TAG_IMAGE);
		if (vec == null) {
			vec = new Vector();
		}
		//Debug.println("vec.size(): " + vec.size() + ", vec: " + vec);

		Enumeration enum = vec.elements();
		ParamTag tag = null;
		for (int i = 0; i < this.params.length; i++) {
			if (enum.hasMoreElements()) {
				tag = (ParamTag)enum.nextElement();
				//Debug.println("exists: " + tag.getParamNameInSource());
				// ݂Ă^O錾ƃ}b`Ă邩ǂ`FbN
				tag.setParamNameInSource(this.params[i].getParamName());
			} else {
				// Ȃ̂ŕ⊮
				//Debug.println("fiilUp: " +this.params[i].getParamName());
				tag = (ParamTag)ParamTag.createFillUpTag(this.params[i].getParamName());
				aBody.addTag(tag);
			}
		}
		while (enum.hasMoreElements()) {
			// ]ɂ̂Łu]}[Nv
			tag = (ParamTag)enum.nextElement();
			//tag.setExtraFlag(true);
			tag.setFlag(ParamTag.STATE_EXTRA, true);
		}
	}
	/**
	 * p[^ƈقȂȌꍇ́Ai錾̃TuNX𓊂邽߁j
	 * SɃ`FbN邱ƂłȂB̂ߐ錾Ă̂ɁA
	 * ^OȂꍇ̕⊮̂ݍsB
	 */
	private void checkExceptionTags(CommentBody aBody)
	{
		if (this.exceptions == null) {
			// ̃\bh͗O錾ĂȂ
			return;
		}
		
		Vector vec = aBody.getTagVectorFor(ExceptionTag.TAG_IMAGE);// ɋLqĂ^O
		if (vec == null) {
			vec = new Vector();
		}
		//Debug.println("vec.size(): " + vec.size() + ", vec: " + vec);

		Enumeration enum = vec.elements();// ^O
		ExceptionTag tag = null;
		// 錾ĂONXHashtableɊi[
		Hashtable hash = new Hashtable();
		for (int i = 0; i < this.exceptions.length; i++) {
			hash.put(this.exceptions[i].getLastToken().image, this.exceptions[i]);
		}
		while (enum.hasMoreElements()) {
			// 錾Ă̂^OƂċLqĂ̂폜
			tag = (ExceptionTag)enum.nextElement();
			hash.remove(tag.getClassName());
		}
		// ǉׂ錾 Hashtable ɎcĂ
		Name exName = null;
		enum = hash.elements();
		while (enum.hasMoreElements()) {
			exName = (Name)enum.nextElement();
			//Debug.println("fiil ExceptionTag: " +exName.getSignature());
			tag = (ExceptionTag)ExceptionTag.createFillUpTag(exName);
			aBody.addTag(tag);
		}
	}

/* ^O̒ǉA폜̃`FbN	
	public void notifyParamTagChanged()
	{
		Vector vec = aBody.getTagVectorFor(ParamTag.TAG_IMAGE);
		if (vec == null) {
			vec = new Vector();
		}

		Enumeration enum = vec.elements();
		ParamTag tag = null;
		for (int i = 0; i < this.params.length; i++) {
			if (enum.hasMoreElements()) {
				tag = (ParamTag)enum.nextElement();
				//Debug.println("exists: " + tag.getParamNameInSource());
				// ݂Ă^O錾ƃ}b`Ă邩ǂ`FbN
				tag.checkParamName(this.params[i].getParamName());
			} else {
				// ȂĂ⊮Ȃ
			}
		}
		while (enum.hasMoreElements()) {
			// ]ɂu]}[Nv
			tag = (ParamTag)enum.nextElement();
			tag.setFlag(ParamTag.STATE_EXTRA, true);
		}
	}
	public void notifyExceptionTagChanged()
	{
		if (this.exceptions == null) {
			// ̃\bh͗O錾ĂȂ
			return;
		}
		
		Vector vec = aBody.getTagVectorFor(ExceptionTag.TAG_IMAGE);// ɋLqĂ^O
		if (vec == null) {
			vec = new Vector();
		}

		Enumeration enum = vec.elements();// ^O
		ExceptionTag tag = null;
		// 錾ĂONXHashtableɊi[
		Hashtable hash = new Hashtable();
		for (int i = 0; i < this.exceptions.length; i++) {
			hash.put(this.exceptions[i].getLastToken().image, this.exceptions[i]);
		}
		while (enum.hasMoreElements()) {
			// 錾Ă̂^OƂċLqĂ̂폜
			tag = (ExceptionTag)enum.nextElement();
			hash.remove(tag.getClassName());
		}
		// ǉׂ錾 Hashtable ɎcĂ
		Name exName = null;
		enum = hash.elements();
		while (enum.hasMoreElements()) {
			exName = (Name)enum.nextElement();
			//Debug.println("fiil ExceptionTag: " +exName.getSignature());
			tag = (ExceptionTag)ExceptionTag.createFillUpTag(exName);
			aBody.addTag(tag);
		}
	}
*/

	private String methodName = null;

	protected Vector modifiers = null;
	private ResultType result = null;
	protected Token methodToken = null;
	private Parameter[] params = null;
	private Name[] exceptions = null;
	
}

