/*
 * $Id: JavaDocHolder.java,v 1.1.1.1 2001/03/20 01:43:52 kurokawh Exp $
 *                 Copyright(C) 2000 Hiroyuki Kurokawa
 */
package jp.gr.java_conf.a0.jdh.parser.source;

import java.io.StringReader;
import java.io.Serializable;
import jp.gr.java_conf.a0.jdh.parser.Token;
import jp.gr.java_conf.a0.jdh.parser.SourceCodeParserConstants;
import jp.gr.java_conf.a0.jdh.parser.SourceCodeParser;
import jp.gr.java_conf.a0.jdh.parser.CommentParser;
import jp.gr.java_conf.a0.jdh.parser.ParseException;
import jp.gr.java_conf.a0.jdh.parser.comment.CommentBody;
import jp.gr.java_conf.a0.debug.Debug;


public abstract class JavaDocHolder implements Serializable
{
/*	public void setJavaDocToken(Token st)
	{
		this.specialToken = st;
	}
	Token specialToken;
*/

	/**
	 * JavaDocRg܂ SpecialToken ԂB
	 */
	public final Token getJavaDocToken()
	{
		if (this.javaDocToken == null) {
			this.retrieveJavaDocToken();
		}
		return(this.javaDocToken);
	}
	
	/**
	 * ̃p[c̃VOj`i\bhANX̐錾jԂB
	 */
	abstract protected String parseSignature();

	
	/**
	 * ̃p[c̐擪 Token ԂBgetLastToken() ƕp邱Ƃ
	 * R[hĐ邱ƂłB
	 */
	abstract public Token getFirstToken();
	
	/**
	 * ̃p[c̍Ō Token ԂBgetFirstToken() ƕp邱Ƃ
	 * R[hĐ邱ƂłB
	 */
//	abstract public Token getLastToken();

	
	/**
	 * indent, javaDocToken𒲂ׂĐݒ肷B
	 * ݂Ȃꍇɂ́Ai\bhtB[h́j錾̈s
	 * 錾Ɠ悤ɃCfg`ł̃Rgg[N}B
	 */
	protected void retrieveJavaDocToken()
	{
		if (this.javaDocToken != null) {
			//łɃp[Xς
			return;
		}
		
		Token first = this.getFirstToken();
		Token st = first.specialToken;
		if (st == null) {
			Debug.println("\tretrieveJavaDocToken(): st is null: " + this.getSignature());
			this.indent = "\n";
		} else if (st.kind == SourceCodeParserConstants.ST_EOL_INDENT) {
			//Debug.println("\t: ST_EOL_INDENT:[["+st.image+"]]");
			this.indent = st.image;
		} else {
			//Debug.println("\t: st.beginColumn: "+st.beginColumn+", image:[["+st.image+"]]");
			StringBuffer buf = new StringBuffer();
			buf.append(NEW_LINE);
			while (st.kind == SourceCodeParserConstants.ST_SPACE ||
				   st.kind == SourceCodeParserConstants.ST_TAB) {
				//Debug.println("st.kind: "+st.kind+", image[["+st.image+"]]");
				buf.append(st.image);
				st = st.specialToken;
			}
			this.indent = new String(buf);
		}
		
		while (st != null) {
			if (this.isJavaDocToken(st)) {
				// JavaDocToken݂
				this.javaDocToken = st;
				return;
			}
			st = st.specialToken;
		}
		
		// firstToken ̒O JavaDocToken + EOL_INDENT }
		insertJavaDocToken(first);
	}
	private boolean isJavaDocToken(Token aTk)
	{
		if (aTk.image.length() <= 4) {
			return(false);
		}
		if (aTk.image.startsWith("/**") && aTk.image.endsWith("*/")) {
			return(true);
		}
		return(false);
		
	}
	// next̑O INDENT +	JavaDocToken + NEW_LINE }
/*	private void insertJavaDocToken(Token here)
	{
		Token tok =Token.newToken(-1);	// XXX
		tok.image = this.indent;
		here.insert(tok);
		
		this.javaDocToken = Token.newToken(-2);	// XXX
		this.javaDocToken.image = NO_COMMENT;
		here.insert(this.javaDocToken);
		
		tok = Token.newToken(-3);	// XXX
		tok.image = NEW_LINE;
		here.insert(tok);
		
		this.inserted = true;
	}
*/
	private void insertJavaDocToken(Token here)
	{
		this.javaDocToken = Token.newToken(-2);	// XXX: JavaDocToken  kind w
		this.javaDocToken.image = NO_COMMENT;
		here.insert(this.javaDocToken);
		
		Token tok =Token.newToken(SourceCodeParserConstants.ST_EOL_INDENT);
		tok.image = this.indent;
		here.insert(tok);
		
		//this.inserted = true;
	}

	/**
	 * CommentBodyACommentTagɐݒ肳ꂽ JavaDocToken ɔfB
	 * ʏ́AۑOɈxĂ΂邾B
	 */
	public void reflectToJavaDocToken()
	{
		StringBuffer buf = new StringBuffer(this.javaDocToken.image.length());
		buf.append(COMMENT_START).append(this.indent).append(" *");
		int index = 0;
		//String[] lines = this.getCommentBody().getCommentLines();
		Object[] lines = this.getCommentBody().getCommentLines();
		for (; index < lines.length; index++) {
			if (lines[index].toString().length() != 0) {
				break;
			}
		}
		String indentAsta = this.indent + " *";
		for (; index < lines.length; index++) {
			buf.append(" ").append(lines[index].toString()).append(indentAsta);
		}
		buf.append("/");
		this.getJavaDocToken().image = new String(buf);
	}

	/**
	 * commento[c̏W߂āAJavaDocToken  image ɃZbgB
	 * image  NO_COMMENT Ȃ RgubNiINDENT + JavaDoc + NEW_LINEj
	 * 폜i""ŒujB
	 */
	public void setImage()
	{
		if (!this.javaDocToken.image.equals(NO_COMMENT)) {
			return;
		}
		if (this.javaDocToken.image.equals(NULL_STRING)) {
			return;
		}
		
		this.javaDocToken.image = NULL_STRING;
/*		if (this.inserted) {
			this.javaDocToken.next.image = NULL_STRING;
			this.javaDocToken.specialToken.image = NULL_STRING;
		} else {
			// JavaDocCommentOindentƌnew_line 폜i""Ɂj
			Token st = this.javaDocToken.specialToken;
			while (true) {
				if (st == null) {
					break;
				} else if (st.kind == SourceCodeParserConstants.SP_SPACE) {
					st.image = NULL_STRING;
				} else if (st.kind == SourceCodeParserConstants.SP_TAB) {
					st.image = NULL_STRING;
				} else {
					break;
				}
				st = st.specialToken;
			}
			
			st = this.javaDocToken.next;
			while (true) {
				if (st == null) {
					break;
				} else if (st.kind == SourceCodeParserConstants.SP_SPACE) {
					st.image = NULL_STRING;
				} else if (st.kind == SourceCodeParserConstants.SP_TAB) {
					st.image = NULL_STRING;
				} else if (st.kind == SourceCodeParserConstants.SP_N) {
					st.image = NULL_STRING;
					break;
//				} else if (st.kind == SourceCodeParserConstants.SP_RN) {
				} else if (st.kind == SourceCodeParserConstants.SP_RN) {
					st.image = NULL_STRING;
					break;
				} else if (st.kind == SourceCodeParserConstants.SP_R) {
					st.image = NULL_STRING;
					break;
				} else {
					break;
				}
				st = st.next;
			}
		}
*/	}


	/**
	 * ToolTipManager Ăяo
	 */
	public final String getSignature()
	{
		if (this.signature == null) {
			this.signature = this.parseSignature();
		}
		return(this.signature);
	}
	public final CommentBody getCommentBody()
	{
		if (this.comment == null) {
			try {
				this.comment = new CommentParser(new StringReader(this.getJavaDocToken().image)).parse();
			}
			catch (ParseException ex) {
				ex.printStackTrace();
				throw(new IllegalStateException(ex.toString()));
			}
			
			if (JavaDocHolder.fixTag) {
				this.checkCommentBody(this.comment);
			}
		}
		return(this.comment);
	}
	/**
	 * CoomentBody Ɋ܂܂Ă^Oƃ\[XR[hĩVOj`j̐
	 * ƂĂ邩ǂ`FbNAKvɉă^ȌCi{Iɒǉ̂݁j
	 * sB
	 */
	protected void checkCommentBody(CommentBody aBody)
	{
		// XXX not implemented
		//Debug.println("checkCommentBody(): aBody: " + aBody +", aBody.getBody(): " + aBody.getBody());
	}
	/* ^O̒ǉA폜̃`FbN
	public void notifyParamTagChanged()
	{
		Vector vec = aBody.getTagVectorFor(ParamTag.TAG_IMAGE);
		Enumeration enum = vec.elements();
		ParamTag tag = null;
		while (enum.hasMoreElements()) {
			((ParamTag)enum.nextElement()).setFlag(ParamTag.STATE_INVALID, true);
		}
	}
	*/
	
	/**
	 * ۑAstate`FbN̂߂CommentBody擾ȂǁA
	 * svɂȂ\[XA󂫃𑝂₷B
	 */
	public void releaseCommentBody()
	{
		//Debug.println("releaseCommentBody(): comment:" + this.comment);
		this.comment = null;
	}

	/** JavaDocHolder̃IWi\[XiJavaDocRg܂ށjԂB */
	// JavaDocRg͍ŐV̂̂ԂH
	public String getSource()
	{
		if (this.source != null) {
			return(this.source);
		}
		Token currentToken = this.getFirstToken();
		Token specialToken = null;
		Token endCandidate = null;
		StringBuffer buf = new StringBuffer();
		int nest = 0;

		buf.append(this.getIndent());
		buf.append(currentToken.image);// JavaDocComment܂܂Ȃ悤ɂB
		currentToken = currentToken.next;
		//while (currentToken != null) {
		do {
			Debug.assert(currentToken == null);
			nest = 0;
			specialToken = currentToken;
			while (specialToken.specialToken != null) {
				specialToken = specialToken.specialToken;
				nest++;
			}
			endCandidate = specialToken;
			for (; nest > 0; nest--) {
				buf.append(specialToken.image);
				specialToken = specialToken.next;
			}
			buf.append(currentToken.image);
			currentToken = currentToken.next;
		} while (endCandidate.kind != SourceCodeParser.HOLDER_END_KIND);
		this.source = new String(buf);
		return(this.source);
	}
	public void releaseSource()
	{
		this.source = null;
	}
	
	
	/**
	 * ̃g[NANZXCqł΂ZbgB
	 */
	protected void setAccessFlag(Token aToken)
	{
		if (aToken.image.equals("public")) {
			this.accessFlag = ACC_PUBLIC;
		} else if (aToken.image.equals("protected")) {
			this.accessFlag = ACC_PROTECTED;
		} else if (aToken.image.equals("private")) {
			this.accessFlag = ACC_PRIVATE;
		}
	}
	
// Accessor
//	public String getAccessFlag()	{return(this.accessFlag);}
//	protected void setAccessFlag(String aStr)	{this.accessFlag = aStr;}
	public int getAccessFlag()	{return(this.accessFlag);}
	protected void setAccessFlag(int aStr)	{this.accessFlag = aStr;}
	private String getIndent()	{return(this.indent);}


	/**
	 * p[Xs javaDocToken ɒlݒ肳Bp[XOnullB
	 * "/**"Ŏn܂A"*\/"ŏIimagespecialTokenTĐݒ肷B
	 * Yspecial݂ȂȂAVɐiXgɑ}jĐݒ肷B
	 */
	private Token javaDocToken = null;
	
	/**
	 * ̐錾̃CfgB
	 * JavaDocHolder̐錾̒O hsh{hCfghi[ĂB
	 * firstTokenspecialToken𒲂ׁAA" ", "\t"CfgƂB
	 */
	private String indent;

	/**
	 * JavaDocComment̃Xe[gB0:no!, 1:OK, 2:invalid, 3:edited ...
	 */
	private int state;
	// private boolean edited;
	//private boolean inserted = false;

	/**
	 * ANZXtO public:0, protected:1, pkg:2, private:3
	 */
	//private String accessFlag = "pkg";
	private int accessFlag = ACC_PKG;

	/** JavaDocHolder̃IWi\[XR[hB */
	private String source;


	public static final String NEW_LINE = System.getProperty("line.separator");
	
	// javaDocToken.imageɂ̕񂪎w肳Ăꍇɂ́AjavaDocToken
	// ̑Oiindent, new_linej image  "" ɕςB
	//public static final String NO_COMMENT = "/** @NO! */";
	public static final String NO_COMMENT = "/***/";
	public static final String COMMENT_START = "/**";
	public static final String COMMENT_END = "*/";

	public static final String NULL_STRING = "";
	
	
/*	public static final String ACC_PKG = "pkg";
	public static final String ACC_PUBLIC = "public";
	public static final String ACC_PROTECTED = "protected";
	public static final String ACC_PRIVATE = "private";
*/	public static final int ACC_PUBLIC = 0;
	public static final int ACC_PROTECTED = 1;
	public static final int ACC_PKG = 2;
	public static final int ACC_PRIVATE = 3;

	/**
	 * 
	 */
	private String signature;
	
	private CommentBody comment;
	
	private static boolean fixTag = true;

	public static final JavaDocHolder DUMMY_HOLDER = new JavaDocHolder()
	{
		protected String parseSignature(){return("");}
		public Token getFirstToken(){return(null);}
		public String getSource(){return("");}
	};
}
