package jp.gr.java_conf.a0.jdh.parser.source;

import java.util.Vector;
import java.util.Enumeration;
import jp.gr.java_conf.a0.jdh.parser.Token;
import jp.gr.java_conf.a0.jdh.parser.comment.CommentBody;

public class FieldDecl extends JavaDocHolder
{
	//public FieldDecl(Vector aModifiers, Vector aType, VariableDecl[] aVars)
	public FieldDecl(Vector aModifiers, Type aType, VariableDecl[] aVars)
	{
		this.modifiers = aModifiers;
		this.type = aType;
		this.vars = aVars;
		
		Enumeration enum = aModifiers.elements();
		while (enum.hasMoreElements()) {
			super.setAccessFlag((Token)enum.nextElement());
		}
	}
	
	public Token getFirstToken()
	{
		if (this.modifiers.size() > 0) {
			return((Token)this.modifiers.elementAt(0));
		}
		return(this.type.getFirstToken());
	}
	//public Token getLastToken();
	
	/**
	 * ̃p[c̃VOj`i\bhANX̐錾jp[XĕԂB
	 */
	protected String parseSignature()
	{
		StringBuffer buf = new StringBuffer();
		
		Enumeration enum = this.modifiers.elements();
		while (enum.hasMoreElements()) {
			buf.append(((Token)enum.nextElement()).image);
			buf.append(" ");
		}
		buf.append(this.type.getSignature());
		buf.append(" ");

		buf.append(this.getFieldName());

		return(new String(buf));
	}
	
	public String getFieldName()
	{
		if (this.fieldName == null) {
			StringBuffer buf = new StringBuffer();
			buf.append(vars[0].getSignature());
			for (int i = 1; i < vars.length; i++) {
				buf.append(", ");
				buf.append(vars[i].getSignature());
			}
			this.fieldName = new String(buf);
		}
		return (this.fieldName);
	}
	
	private String fieldName = null;
	
	private Vector modifiers;
//	private Vector type;
	private Type type;
	private VariableDecl[] vars;
}
