/*
 * $Id: ClassDecl.java,v 1.1.1.1 2001/03/20 01:43:51 kurokawh Exp $
 *                 Copyright(C) 2000 Hiroyuki Kurokawa
 */
package jp.gr.java_conf.a0.jdh.parser.source;

import java.io.File;
import java.io.FileWriter;
import java.io.BufferedWriter;
import java.util.Vector;
import java.util.Enumeration;
import jp.gr.java_conf.a0.jdh.parser.Token;
import jp.gr.java_conf.a0.jdh.parser.comment.CommentBody;
import jp.gr.java_conf.a0.jdh.parser.comment.CommentTag;

import java.io.IOException;
import jp.gr.java_conf.a0.debug.Debug;

public class ClassDecl extends JavaDocHolder
{
	public void addModifier(Token t)
	{
		this.modifiers.addElement(t);
		super.setAccessFlag(t);
	}
	public void setType(Token t)
	{
		this.type = t;
	}
	public void setClassName(Token t)
	{
		this.className = t;
	}
	public void setSuperClass(Name n)
	{
		this.superClass = n;
	}
	//public void setImplements(Vector v)
	public void setImplements(Name[] ns)
	{
		//this.impls = v;
		this.impls = ns;
	}
	public void setClassBlock(ClassBlock b)
	{
		this.block = b;
	}
	
	public void addModifiers(Vector v)
	{
		//this.modifiers = v;
		for (int i =0; i < v.size(); i++) {
			this.modifiers.addElement(v.elementAt(i));
		}
	}
	
	
	/**
	 * ̃p[c̃VOj`i\bhANX̐錾jp[XĕԂB
	 */
	protected String parseSignature()
	{
		StringBuffer buf = new StringBuffer();
		
		Enumeration enum = this.modifiers.elements();
		while (enum.hasMoreElements()) {
			buf.append(((Token)enum.nextElement()).image);
			buf.append(" ");
		}
		buf.append(this.type.image).append(" ");
		buf.append(this.className.image);
		if (this.superClass != null) {
			buf.append(" extends ").append(this.superClass.getSignature());
		}
		if (this.impls != null) {
			buf.append(" implements ").append(this.impls[0].getSignature());
			for (int i = 1; i < impls.length; i++) {
				buf.append(", ");
				buf.append(this.impls[i].getSignature());
			}
		}
		return(new String(buf));
	}
	
	public Token getFirstToken()
	{
		if (this.modifiers.size() > 0) {
			return((Token)this.modifiers.elementAt(0));
		}
		return(this.type);
	}
//	public Token getLastToken();
	
	/**
	 * 
	 */
	protected void checkCommentBody(CommentBody aBody)
	{
		// IvVɂĕ⊮邩ǂ؂ւ悤ɂB
		super.checkCommentBody(aBody);
		Vector tagVec = null;
		for (int i = 0; i < necessaryTags.length; i++) {
			tagVec = aBody.getTagVectorFor(necessaryTags[i]);
			if (tagVec == null || tagVec.size() == 0) {
				aBody.addTag(CommentTag.createFillUpTag(necessaryTags[i]));
			}
		}
	}

	/**
	 * ̃NXw̃t@CɏoB
	 * InnerNXɑ΂Ẵ\bhĂяoĂ͂ȂB
	 */
	public void writeTo(File anOutFile) throws IOException
	{
		Debug.println("ClassDecl.writeTo(): " + anOutFile);
		Token currentToken = this.getFirstToken();
		Token specialToken = null;
		BufferedWriter writer = new BufferedWriter(new FileWriter(anOutFile), BUFFER_SIZE);
		int nest = 0;
		while (currentToken != null) {
			nest = 0;
			specialToken = currentToken;
			while (specialToken.specialToken != null) {
				specialToken = specialToken.specialToken;
				nest++;
			}
			for (; nest > 0; nest--) {
				//System.out.print("["+specialToken.image+"]");
				writer.write(specialToken.image);
				specialToken = specialToken.next;
			}
			writer.write(currentToken.image);
			currentToken = currentToken.next;
		}
		writer.flush();
		writer.close();
	}
	

//Accessor
	public ClassBlock getClassBlock()	{return(this.block);}
	public String getClassName()	{return(this.className.image);}
	public void setNecessaryTags(String[] aTags)	{necessaryTags = aTags;}



	private Token type = null;	// Class or Interface
	private Token className = null;
	private Name superClass = null;
//	private Vector impls = null;
	private Name[] impls = null;
	private ClassBlock block = null;
	private Vector modifiers = new Vector();
	
	private static String[] necessaryTags = new String[0];
	private static final int BUFFER_SIZE = 2048;
}
