package jp.gr.java_conf.a0.jdh.parser.comment;

import jp.gr.java_conf.a0.jdh.parser.Token;

import jp.gr.java_conf.a0.debug.Logger;
import jp.gr.java_conf.a0.debug.Debug;

public class ParamTag extends CommentTag
{
	public ParamTag(Token aTag)
	{
		super(aTag);
		this.paramNameInSource = aTag.image;
Logger.LOG.println("ParamTag.ParamTag(): paramNameInSource: " + paramNameInSource);
	}

/*	public void addLine(String aLine)
	{
		Debug.println("line: " + aLine);
		if (super.isFirstLine() && aLine.length() > 0) {
			// p[^擾
			int index = aLine.indexOf(' ');
			Debug.println("index: " + index);
			Debug.assert(index == 0);
			if (index < 0) {
				// ^OɃp[^݂̂LqĂ
				index = aLine.length();
			}
			if (index > 0) {
				this.paramNameInSource = aLine.substring(0, index);
				Debug.println("paramNameInSource<"+paramNameInSource+">, aLine<"+aLine+">");
			}
		}
		super.addLine(aLine);
	}
*/

	private String getParamNameInDesc()
	{
		Debug.assert(super.getDescription() == null);
		int index = super.getDescription().indexOf(' ');
		if (index > 0) {
			return(super.getDescription().substring(0, index));
		} else {
			// ^OɃp[^݂̂LqĂ or LqĂȂB
			return(super.getDescription());
		}
	}
	/**
	 * 
	 */
	public void setParamNameInSource(String aName)
	{
		this.paramNameInSource = aName;
Logger.LOG.println("ParamTag.setParamNameInSource(): aName: " + aName);
		this.checkDescription();
	}
	protected void checkDescription()
	{
		Debug.assert(this.paramNameInSource == null);
		String nameInDesc = this.getParamNameInDesc();
Logger.LOG.println("ParamTag.checkDescription(): nameInDesc: " + nameInDesc +
			  ", paramName: " +paramNameInSource);
		if (!this.paramNameInSource.equals(nameInDesc)) {
			if (ParamTag.fixInvalidTag) {
				// Âi\[XƈقȂjp[^cĂ
				int len = nameInDesc.length();
				nameInDesc = this.paramNameInSource + " ?" + nameInDesc + "?";
				super.setDescription(nameInDesc + super.getDescription().substring(len));
				super.setFlag(STATE_CONTENTS_CHANGED, true);
			} else {
				super.setFlag(STATE_INVALID, true);
			}
		} else {
			super.setFlag(STATE_INVALID | STATE_CONTENTS_CHANGED, false);
		}
	}

/* ^O̒ǉA폜̃`FbN	
	protected void checkParamName(String aMustBe)
	{
		if (aMustBe.equals(this.getParamNameInSource())) {
			// correct!
			super.setFlag(STATE_INVALID | STATE_EXTRA, false);
		} else {
			// invalid
			super.setFlag(STATE_INVALID, true);
		}
	}
*/

	/**
	 * w̃p[^p[^^O𐶐ĕԂB
	 * @param aParamName p[^̕ϐ		
	 */
	//public static FillUpParamTag createFillUpTag(String aTag)
	public static CommentTag createFillUpTag(String aParamName)
	{
		return(new FillUpParamTag(aParamName));
	}

	/**
	 * p^⊮ꍇɗp ParamTag ̃TuNX
	 */
	public static class FillUpParamTag extends ParamTag implements FillUpTag
	{
		FillUpParamTag(String aParamName)
		{
			super(createTagToken(TAG_IMAGE));
			super.setFlag(STATE_INSERTED, true);
			super.addLine(aParamName);
			this.setParamNameInSource(aParamName);
		}
	}
	/**
	 * ̃NX̃CX^XƂēKǂ𒲂ׂ
	 */
	public boolean canBe(String aTagName)
	{
		if (aTagName.equals(ParamTag.TAG_IMAGE)) {
			return(true);
		}
		return(false);
	}

// Accessor
	public String getParamNameInSource(){return(this.paramNameInSource);}

	// p[^͓ʈKvɉ Line ̐擪̒P擾
	private String paramNameInSource;
	//private int index;	// Ԗڂ @param ^O
	
	public static String TAG_IMAGE = "@param";

	private static boolean fixInvalidTag = true;
}

