package jp.gr.java_conf.a0.jdh.parser.comment;

import jp.gr.java_conf.a0.jdh.parser.Token;
import jp.gr.java_conf.a0.jdh.parser.source.Name;
import jp.gr.java_conf.a0.debug.Debug;

public class ExceptionTag extends CommentTag
{
	public ExceptionTag(Token aTag)
	{
		super(aTag);
	}
	public void addLine(String aLine)
	{
		if (super.isFirstLine() && aLine.length() > 0) {
			// ONX擾
			int index = aLine.indexOf(' ');
			Debug.assert(index == 0);
			if (index < 0) {
				// ^OɗONX݂̂LqĂ
				index = aLine.length();
			}
			if (index > 0) {
				this.exClass = aLine.substring(0, index);
				if (CUT_PACKAGE_NAME) {
					int comma = this.exClass.lastIndexOf('.');
					this.exClass = this.getClassName();
					// LqepbP[W
					aLine = aLine.substring(comma + 1);
				}
				//Debug.println("exClass"+exClass+">, aLine<"+aLine+">");
			}
		}
		super.addLine(aLine);
	}

	/** pbP[ŴONX̃NXԂ */
	public String getClassName()
	{
		int comma = this.exClass.lastIndexOf('.');
		Debug.assert(comma >= this.exClass.length());
		if (comma >= 0) {
			return(this.exClass.substring(comma + 1));
		}
		return(this.exClass);
	}
	/** pbP[W܂ނƂ΁A܂܂ȂƂB錾̂܂܁B */
	public String getExceptionName()
	{
		return(this.exClass);
	}

	public static CommentTag createFillUpTag(Name aExceptionName)
	{
		return(new FillUpExceptionTag(aExceptionName));
	}
	
	public static class FillUpExceptionTag extends ExceptionTag implements FillUpTag
	{
		FillUpExceptionTag(Name aExceptionName)
		{
			super(createTagToken(TAG_IMAGE));
			super.setFlag(STATE_INSERTED, true);
			super.addLine(aExceptionName.getSignature());
		}
	}

	/**
	 * ̃NX̃CX^XƂēKǂ𒲂ׂ
	 */
	public boolean canBe(String aTagName)
	{
		if (aTagName.equals(ExceptionTag.TAG_IMAGE)) {
			return(true);
		}
		return(false);
	}
	
	private String exClass;
	
	public static String TAG_IMAGE = "@exception";
	private static boolean CUT_PACKAGE_NAME = true;
}
//class 
