/*
 * $Id: CommentTag.java,v 1.3 2001/04/02 23:57:01 kurokawh Exp $
 *                 Copyright(C) 2000 Hiroyuki Kurokawa
 */
package jp.gr.java_conf.a0.jdh.parser.comment;

import java.util.Vector;
import java.io.Serializable;
import jp.gr.java_conf.a0.jdh.parser.Token;
import jp.gr.java_conf.a0.jdh.parser.CommentParserConstants;

import jp.gr.java_conf.a0.debug.Logger;
import jp.gr.java_conf.a0.debug.Debug;

public class CommentTag implements Serializable
{
	public CommentTag(Token aTag) 
	{
		this.tag = aTag;
	}
	
	public void addLine(String aLine)
	{
		if (this.firstLine) {
			// sڂ̂ݐ擪ɉsȂB
			this.firstLine = false;
		} else {
			if (CONVERT_TO_SPACE) {
				this.descBuffer.append(" ");// s̓Xy[Xɕϊ
			} else {
				this.descBuffer.append("\n");
			}
		}
		this.descBuffer.append(aLine);
	}
	
	/**
	 * ^Oi"@param"ȂǁjɂƂi@K擪jB
	 */
	public static CommentTag createFillUpTag(String aTagName)
	{
		return(new FillUpCommentTag(aTagName));
	}
	protected static Token createTagToken(String aName)
	{
		Token tk = Token.newToken(CommentParserConstants.COMMENT_TAG);
		tk.image = aName;
		return(tk);
	}
	/**
	 * Desciriptionǂ`FbNB
	 */
	protected void checkDescription(){}
	/**
	 * ̃NX̃CX^XƂēKǂ𒲂ׂ
	 */
	public boolean canBe(String aTagName)
	{
		if (aTagName.equals(ParamTag.TAG_IMAGE)) {
			return(false);
		} else if (aTagName.equals(ExceptionTag.TAG_IMAGE)) {
			return(false);
		}
		return(true);
	}
	
	
// Accessor
	//public boolean isValid()		{return(!this.checkFlag(STATE_INVALID));}
	//public boolean isChanged()		{return(this.checkFlag(STATE_CHANGED));}
	
	protected StringBuffer getDescBuffer()	{return(this.descBuffer);}
	/**
	 * ^Oi"@param"ȂǁjɂƂi@K擪jB
	 * e}b`Ă邩ǂ`FbNĕԂB
	 */
	//public boolean setTagName(String aName)
	public void setTagName(String aName)
	{
		this.tag.image = aName;
		this.setFlag(STATE_EDITED, true);
	}
	public String getTagName()	{return(this.tag.image);}
	//public boolean setDescription(String aDescription)
	public void setDescription(String aDescription)
	{
Logger.LOG.println("CommentTa.setDescription():description: " + aDescription);
		this.description = aDescription;
		this.setFlag(STATE_EDITED, true);
		this.checkDescription();
	}
	public String getDescription()
	{
		if (this.description == null) {
			this.description = new String(this.descBuffer);
		}
		return(this.description);
	}
	// isValid() ̑ɗpH
	public int getState()	{return(this.state);}
	public void setFlag(int aWhat, boolean aFlag)	
	{
		if (aFlag) {
			this.state |= aWhat;
		} else {
			this.state &= ~aWhat;
		}
	}
	public boolean checkFlag(int aWhat)
	{
		return((this.state & aWhat) != 0);
	}

	/**
	 * ⊮ꂽ^OB
	 */
	public static class FillUpCommentTag extends CommentTag implements FillUpTag
	{
		/**
		 * ^Oi"@param"ȂǁjɂƂi@K擪jB
		 */
		FillUpCommentTag(String aTagName)
		{
			super(CommentTag.createTagToken(aTagName));
			super.setFlag(STATE_INSERTED, true);
		}
	}

	public String toString()
	{
		return(this.getTagName() + '\t' + this.getDescription());
	}

// Accessor
	protected boolean isFirstLine(){return(this.firstLine);}

// Fields
	private final Token tag;
	private StringBuffer descBuffer = new StringBuffer();
	/** ^O̐B^O͊܂܂ȂB */
	private String description = null;
	private boolean firstLine = true;

	// paramName 錾̂̂ƈvĂ邩ǂ etc. 
	// fieldclass̐錾ɑ΂ @exception, @param, @return ^OȂ
	// javadoc ŃEH[jOłꍇɂ false ݒ肵Ă
	//private boolean valid;	// int ^ŕtOHswingŐF
	
	private int state = 0;	// 0: 
	public static final int STATE_OK = 0x00000000;		// ȁi`FbNς݁j^O
	public static final int STATE_EDITED = 0x00000001;	// eҏWꂽ^O
	public static final int STATE_INSERTED = 0x00000002;	// ⊮ꂽ^O
	public static final int STATE_CONTENTS_CHANGED = 0x00000010;// eύXꂽ^O
	public static final int STATE_EXTRA = 0x00000004;	// ]isvjȃ^O
	public static final int STATE_INVALID = 0x00000008;	// R[hƂ̐ƂĂȂ^O

	private static final boolean CONVERT_TO_SPACE = true;
}
