/*
 * $Id: CommentBody.java,v 1.1.1.1 2001/03/20 01:43:51 kurokawh Exp $
 *                 Copyright(C) 2000 Hiroyuki Kurokawa
 */
package jp.gr.java_conf.a0.jdh.parser.comment;

import java.util.StringTokenizer;
import java.util.Hashtable;
import java.util.Vector;
import java.util.Enumeration;
import java.io.Serializable;
import jp.gr.java_conf.a0.jdh.parser.Token;
import jp.gr.java_conf.a0.jdh.parser.CommentParserConstants;

import jp.gr.java_conf.a0.debug.Debug;

public class CommentBody implements Serializable
{
	public void addLine(String aLine)
	{
		/* svȋs폜
		if (aLine.length() == 0) {
			return;
		}
		*/
		if (currentTag == null) {
			this.bodyBuffer.append(aLine).append("\n");
		} else {
			this.currentTag.addLine(aLine);
		}
	}
	
	// CommentTag ̃t@Ng̖ڂʂ
	public void beginTag(Token aTag)
	{
		CommentTag tag = CommentBody.createTag(aTag.image);
		this.addTag(tag);
		this.currentTag = tag;
	}
	private static CommentTag createTag(Token aTagToken)
	{
		CommentTag tag = null;
		if (aTagToken.image.equals(ParamTag.TAG_IMAGE)) {
			tag = new ParamTag(aTagToken);
		} else if (aTagToken.image.equals(ExceptionTag.TAG_IMAGE)) {
			tag = new ExceptionTag(aTagToken);
		} else {
			tag = new CommentTag(aTagToken);
		}
		return(tag);
	}
	public static CommentTag createTag(String aTagName)
	{
		Token tok = Token.newToken(CommentParserConstants.COMMENT_TAG);
		tok.image = aTagName;
		return(createTag(tok));
	}
	
	public void addTag(CommentTag aTag)
	{
		this.tagVector.addElement(aTag);
	}
	public void insertTagAt(CommentTag aTag, int anIndex)
	{
		this.tagVector.insertElementAt(aTag, anIndex);
	}
	public void removeTag(CommentTag aTag)
	{
		this.tagVector.removeElement(aTag);
	}
	public CommentTag removeTagAt(int anIndex)
	{
		CommentTag retTag = (CommentTag)this.tagVector.elementAt(anIndex);
		this.tagVector.removeElementAt(anIndex);
		return(retTag);
	}
	//public Vector getTagVectorFor(String aTag)	{return((Vector)this.tags.get(aTag));}
	public Vector getTagVectorFor(String aTagName)
	{
		Vector vec = new Vector();
		Enumeration enum = this.getAllTags();
		CommentTag tag = null;
		while (enum.hasMoreElements()) {
			tag = (CommentTag)enum.nextElement();
			if (tag.getTagName().equals(aTagName)) {
				vec.addElement(tag);
			}
		}
		return(vec);
	}
	
	//private Vector getTagVector()	{return(this.tagVector);}
	public Enumeration getAllTags(){return(this.tagVector.elements());}
	public int getTagCount(){return(this.tagVector.size());}
	public CommentTag getTagAt(int anIndex)
	{return((CommentTag)this.tagVector.elementAt(anIndex));}
	public void setTagAt(CommentTag aTag, int anIndex)
	{this.tagVector.setElementAt(aTag, anIndex);}

	
	public String getBody()
	{
		if (this.body == null) {
			this.body = new String(this.bodyBuffer);
		}
		return(body);
	}
	public void setBody(String aBody)	{this.body = aBody;}

	/**
	 * JavaDocComment Śi^O܂ށjsiStringj̔zɂĕԂB
	 */
	//public String[] getCommentLines()
	public Object[] getCommentLines()
	{
		Vector lineVec = new Vector();
		//this.getBody().replace('\r', '\n');// XXX ???
		StringTokenizer st = new StringTokenizer(this.getBody(), "\n");
		while(st.hasMoreTokens()) {
			lineVec.addElement(st.nextToken());
		}
		lineVec.addElement("");

		String[] bodyLines = new String[lineVec.size()];
		lineVec.copyInto(bodyLines);
		Object[] tagLines = new Object[this.tagVector.size()];
		//Debug.println("tagLines: " + tagLines.length+", vec: " + this.tagVector);		
		this.tagVector.copyInto(tagLines);
		Object[] lines = new Object[bodyLines.length + tagLines.length];
		System.arraycopy(bodyLines, 0, lines, 0, bodyLines.length);
		System.arraycopy(tagLines, 0, lines, bodyLines.length, tagLines.length);
		return(lines);
	}
	
	// just for test.
/*	public String toString()
	{
		StringBuffer buf = new StringBuffer();
		
		Enumeration enum = this.lines.elements();
		while(enum.hasMoreElements()) {
			buf.append(enum.nextElement().toString()).append("\n");
		}
		enum = this.tags.elements();
		while(enum.hasMoreElements()) {
			buf.append(enum.nextElement().toString()).append("\n");
		}
		return(new String(buf));
	}
*/	
//	private final Vector lines = new Vector();
	private StringBuffer bodyBuffer = new StringBuffer();
	private String body = null;
	
	private final Vector tagVector = new Vector();
	//private final Hashtable tags = new Hashtable();	// (Tag, TagIuWFNgj
	private CommentTag currentTag;

	public static final CommentBody DUMMY_BODY = new CommentBody() {
		public void addTag(CommentTag aTag)	{}
		public void insertTagAt(CommentTag aTag, int anIndex)	{}
		public void removeTag(CommentTag aTag)	{}
		public CommentTag removeTagAt(int anIndex)	{return(null);}
		//public Vector getTagVectorFor(String aTagName)		{}
	
		//public Enumeration getAllTags(){return(this.tagVector.elements());}
		//public int getTagCount(){return(this.tagVector.size());}
		//public CommentTag getTagAt(int anIndex)
		//{return((CommentTag)this.tagVector.elementAt(anIndex));}
		public void setTagAt(CommentTag aTag, int anIndex){}
	
		public String getBody()
		{Debug.println("getBody()!!!");return("");}
		public void setBody(String aBody)	{}
		public Object[] getCommentLines()
		{
			return(new Object[0]);
		}
	};
}


