package jp.gr.java_conf.a0.jdh.gui;

import java.util.Vector;
import java.util.Enumeration;
import javax.swing.table.AbstractTableModel;
//import javax.swing.table.TableModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jp.gr.java_conf.a0.jdh.parser.comment.CommentBody;
import jp.gr.java_conf.a0.jdh.parser.comment.CommentTag;

import jp.gr.java_conf.a0.debug.Debug;
/**
 * ̃NXł͎ۂ̃f[^͕ێȂBJavaDocNodeɃANZX
 * lԂB
 */
public class TagTableModel extends AbstractTableModel
//public class TagTableModel implements TableModel
{
	/**
	 * Returns the number of records managed by the data source object. A
	 * <B>JTable</B> uses this method to determine how many rows it
	 * should create and display.  This method should be quick, as it
	 * is call by <B>JTable</B> quite frequently.
	 *
	 * @return the number or rows in the model
	 * @see #getColumnCount
	 */
	public int getRowCount()
	{
		try {
			return(this.node.getCommentBody().getTagCount());
		}
		catch (NullPointerException ex) {
			//Debug.warn(ex);
			return(0);
		}
	}

	/**
	 * Returns the number of columns managed by the data source object. A
	 * <B>JTable</B> uses this method to determine how many columns it
	 * should create and display on initialization.
	 *
	 * @return the number or columns in the model
	 * @see #getRowCount
	 */
	public int getColumnCount()
	{
		return(COLUMN_NAMES.length);
	}

	/**
	 * Returns the name of the column at <i>columnIndex</i>.  This is used
	 * to initialize the table's column header name.  Note, this name does
	 * not need to be unique.  Two columns on a table can have the same name.
	 *
	 * @param	columnIndex	the index of column
	 * @return	the name of the column
	 */
	public String getColumnName(int columnIndex)
	{
		return(COLUMN_NAMES[columnIndex]);
	}

	/**
	 * Returns the lowest common denominator Class in the column.  This is used
	 * by the table to set up a default renderer and editor for the column.
	 *
	 * @return the common ancestor class of the object values in the model.
	 */
	public Class getColumnClass(int columnIndex)
	{
		return(this.getValueAt(0, columnIndex).getClass());
	}

	/**
	 * Returns true if the cell at <I>rowIndex</I> and <I>columnIndex</I>
	 * is editable.	 Otherwise, setValueAt() on the cell will not change
	 * the value of that cell.
	 *
	 * @param	rowIndex	the row whose value is to be looked up
	 * @param	columnIndex	the column whose value is to be looked up
	 * @return	true if the cell is editable.
	 * @see #setValueAt
	 */
	public boolean isCellEditable(int rowIndex, int columnIndex)
	{
		if (rowIndex >= this.getRowCount() - 1) {
			return(false);
		}
		return(true);
	}

	/**
	 * Returns an attribute value for the cell at <I>columnIndex</I>
	 * and <I>rowIndex</I>.
	 *
	 * @param	rowIndex	the row whose value is to be looked up
	 * @param	columnIndex		the column whose value is to be looked up
	 * @return	the value Object at the specified cell
	 */
	public Object getValueAt(int rowIndex, int columnIndex)
	{
		try {
			CommentTag tag = this.node.getCommentBody().getTagAt(rowIndex);
			if (columnIndex == 0) {
				return(tag.getTagName());
			} else if (columnIndex == 1) {
				return(tag.getDescription());
			} else if (columnIndex == 2) {
				return(new Integer(tag.getState()));
			} else  {
				return("");
			}
		}
		catch (NullPointerException ex) {
			return("");
		}
	}

	/**
	 * Sets an attribute value for the record in the cell at
	 * <I>columnIndex</I> and <I>rowIndex</I>.	<I>aValue</I> is
	 * the new value.
	 *
	 * @param	aValue		 the new value
	 * @param	rowIndex	 the row whose value is to be changed
	 * @param	columnIndex		 the column whose value is to be changed
	 * @see #getValueAt
	 * @see #isCellEditable
	 */
	public void setValueAt(Object aValue, int rowIndex, int columnIndex)
	{
		// TableCellEditorĂяoB
		//Debug.println("TagTableModel.setValueAt(): " + aValue);
		try {
			CommentTag tag = this.getCommentTag(rowIndex);
			if (columnIndex == 0) {
				if (!tag.getTagName().equals(aValue)) {
					// XVĂȂACommentTagɔf
					//Debug.print("reflect!");
					if (tag.canBe((String)aValue)) {
						tag.setTagName((String)aValue);
					} else {
						this.renewTag(rowIndex, (String)aValue);
					}
					//this.node.setInvalid((tag.getState() & JavaDocNode.STATE_INVALID) != 0);
					this.node.checkStateInvalid();
					this.node.setChanged(true);
					super.fireTableRowsUpdated(rowIndex, rowIndex);
				}
			} else if (columnIndex == 1) {
				if (!tag.getDescription().equals(aValue)) {
					// XVĂȂACommentTagɔf
Debug.println("reflect!: tag: " + tag.getClass().getName());
Debug.println("TagTableModel.setValue(): aValue: " + aValue);
					tag.setDescription((String)aValue);
					//this.node.setInvalid((tag.getState() & JavaDocNode.STATE_INVALID) != 0);
Debug.println("TagTableModel.setValue(): CALL node.checkStateInvalid()");
					this.node.checkStateInvalid();
Debug.println("TagTableModel.setValue(): node: " + this.node);
					this.node.setChanged(true);
					super.fireTableRowsUpdated(rowIndex, rowIndex);
				}
			} else {
				Debug.assert(true);
			}
		}
		catch (Exception ex) {
			Debug.warn(ex);
		}
	}
	// @param, @exception ̏ꍇCommentTagւB
	private void renewTag(int aRowIndex, String aTagName)
	{
		Debug.println("renew!: " + aTagName);
		CommentTag newTag = CommentBody.createTag(aTagName);
		newTag.setDescription(this.getCommentTag(aRowIndex).getDescription());
		this.node.getCommentBody().setTagAt(newTag, aRowIndex);
	}

	//protected void addRowAt(int anIndex, String aTagName, String aDesc)
	protected void addRowAt(int anIndex, CommentTag aTag)
	{
		this.node.getCommentBody().insertTagAt(aTag, anIndex);
	}
	protected CommentTag removeRowAt(int anIndex)
	{
		return(this.node.getCommentBody().removeTagAt(anIndex));
		/* ^O̒ǉA폜̃`FbN
		   CommentTag tag = this.node.getCommentBody().removeTagAt(anIndex);
		   if (tag instanceof ParamTag) {
		   } else if (tag instanceof ExceptionTag) {
		   }
		*/
	}

// Accessor
	protected JavaDocNode getJavaDocNode()	{return(this.node);}
	public void setJavaDocNode(JavaDocNode aNode)	
	{
		try {
			this.node.getCommentBody().removeTag(DUMMY_TAG);
		}
		catch (NullPointerException ignore) {
			// ŏ̈񂾂ɂB
		}
		this.node = aNode;
		this.node.getCommentBody().addTag(DUMMY_TAG);
		super.fireTableDataChanged();
	}
	protected int getRowState(int anIndex)
	{
		return(this.getCommentTag(anIndex).getState());
	}
	protected CommentTag getCommentTag(int aRowIndex)
	{
		return((CommentTag)this.node.getCommentBody().getTagAt(aRowIndex));
	}
	
	private JavaDocNode node;
	
	public static final int TAG_COLUMN_INDEX = 0;
	public static final int DESCRIPTION_COLUMN_INDEX = 1;
	public static final String TAG_COLUMN = MainWindow.getResource().getString("tag.table.tag");
	public static final String DESCRIPTION_COLUMN = MainWindow.getResource().getString("tag.table.description");

	public static String[] COLUMN_NAMES = {
		TAG_COLUMN,
		DESCRIPTION_COLUMN
		//MainWindow.getResource().getString("tag.table.status")//fobOi\jp
	};
	//private static final JavaDocNode DEFAULT_NODE = 



	protected static final CommentTag DUMMY_TAG = new CommentTag(null)
	{
		public String getTagName()	{return("");}
		public void setTagName(String aName)
		{}
		public void setDescription(String aDescription)
		{}
		public boolean canBe(String aTagName)
		{
			return(false);
		}
	};
}
