package jp.gr.java_conf.a0.jdh.gui;

import java.awt.*;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.*;

public class TagTableButtonPanel extends JPanel
{
	public TagTableButtonPanel(TagTable aTable)
	{
		super(new FlowLayout());
		super.add(this.buttonEdit);
		super.add(this.buttonAdd);
		super.add(this.buttonDelete);
		super.add(this.buttonUp);
		super.add(this.buttonDown);
		super.add(this.buttonReflect);

		this.buttonEdit.setMnemonic('E');
		this.buttonAdd.setMnemonic('A');
		this.buttonDelete.setMnemonic('D');
		this.buttonUp.setMnemonic('P');
		this.buttonDown.setMnemonic('N');
		this.buttonReflect.setMnemonic('R');
		
		this.buttonEdit.addActionListener(aTable.actionEdit);
		this.buttonAdd.addActionListener(aTable.actionAdd);
		this.buttonDelete.addActionListener(aTable.actionDelete);
		this.buttonUp.addActionListener(aTable.actionUp);
		this.buttonDown.addActionListener(aTable.actionDown);
		this.buttonReflect.addActionListener(aTable.actionReflect);
	}

	protected JButton buttonEdit = new JButton(MainWindow.getResource().getString("button.edit"));
	protected JButton buttonAdd = new JButton(MainWindow.getResource().getString("button.add"));
	protected JButton buttonDelete = new JButton(MainWindow.getResource().getString("button.delete"));
	//JButton buttonEdit = new JButton(MainWindow.getResource().getString("button.ok"));
	protected JButton buttonUp = new JButton(MainWindow.getResource().getString("button.up"));
	protected JButton buttonDown = new JButton(MainWindow.getResource().getString("button.down"));
	protected JButton buttonReflect = new JButton(MainWindow.getResource().getString("button.reflect"));
}
