package jp.gr.java_conf.a0.jdh.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.DefaultCellEditor;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import javax.swing.table.DefaultTableCellRenderer;
import jp.gr.java_conf.a0.jdh.parser.comment.CommentBody;
import jp.gr.java_conf.a0.jdh.parser.comment.CommentTag;

import jp.gr.java_conf.a0.debug.Debug;


public class TagTable extends JTable implements PropertyChangeListener
{
	public TagTable()
	{
		super(new TagTableModel());
		super.setShowHorizontalLines(true);
		super.setShowVerticalLines(true);
		//super.setIntercellSpacing( new Dimension( 3, 2 ) );// to show E
		super.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
		
		//super.setCellEditor(new TagTableCellEditor(/*new JTextField()*/));
		//super.setDefaultEditor(String.class, new TagTableCellEditor(/*new JTextField()*/));
		JComboBox comboBox = new JComboBox();
		comboBox.setEditable(true);
		comboBox.setBackground(Color.white);
		String[] tags = CurrentProperties.getTags();
		for (int i = 0; i < tags.length; i++) {
			comboBox.addItem(tags[i]);
		}
		DefaultCellEditor cellEditor = new DefaultCellEditor(comboBox);
		cellEditor.setClickCountToStart(2);
		TableColumn column = super.getColumn(TagTableModel.TAG_COLUMN);
		column.setCellRenderer(this.cellRenderer);
		column.setCellEditor(cellEditor);
		column.setMaxWidth(110);//XXX
		column.setPreferredWidth(110);//XXX
		cellEditors[TagTableModel.TAG_COLUMN_INDEX] = cellEditor;

		cellEditor = new DefaultCellEditor(this.descriptionEditor);
		cellEditor.setClickCountToStart(2);
		column = super.getColumn(TagTableModel.DESCRIPTION_COLUMN);
		column.setCellRenderer(this.cellRenderer);
		column.setCellEditor(cellEditor);
		cellEditors[TagTableModel.DESCRIPTION_COLUMN_INDEX] = cellEditor;

		//super.dataModel.addTableModelListener(this);
		CurrentProperties.addPropertyChangeListener(this);
	}

	// for PropertyChangeListener
	public void notifyPropertyChanged()
	{
		this.repaint();
	}
	
	public void setJavaDocNode(JavaDocNode aNode)
	{
		//m[h؂ւ̕ҏWLZ
		super.removeEditor();
		this.getTagTableModel().setJavaDocNode(aNode);
	}

	protected TagTableModel getTagTableModel()
	{
		return((TagTableModel)super.dataModel);
	}

	private TagEditor getTagEditor()
	{
		if (this.tagEditor == null) {
			this.tagEditor = new TagEditor(this);
		}
		return(this.tagEditor);
	}
	
	//public void setFont(Font f)
	public void updateFont(Font f)
	{
		//this.cellRenderer.setFont(f);
		setFont(f);
		//firePropertyChange();
	}

	//private TagTableModel tagTableModel;
	private DefaultCellEditor[] cellEditors = new DefaultCellEditor[2];
	private JTextField descriptionEditor = new JTextField();
	private TagTableCellRenderer cellRenderer = new TagTableCellRenderer();
	private boolean invalid = false;
	private boolean changed = false;
	private TagEditor tagEditor = null;

	protected ActionListener actionEdit = new ActionEdit();
	protected ActionListener actionAdd = new ActionAdd();
	protected ActionListener actionDelete = new ActionDelete();
	protected ActionListener actionUp = new ActionUp();
	protected ActionListener actionDown = new ActionDown();
	protected ActionListener actionReflect = new ActionReflect();
	
	private static final int TABLE_DEFAULT = 0;
	private static final int TABLE_TAG_COLUMN = 1;
	
	protected class TagTableCellRenderer extends DefaultTableCellRenderer
	{
		public Component getTableCellRendererComponent(JTable table, Object value,
                          boolean isSelected, boolean hasFocus, int row, int column)
		{
			// ===> copied from DefaultTableCellRenderer
			if (isSelected) {
				super.setForeground(table.getSelectionForeground());
				super.setBackground(table.getSelectionBackground());
			}
			else {
				super.setForeground(CurrentProperties.getColorTableForeground());
				super.setBackground(CurrentProperties.getColorTableBackground());
			}
//table.setFont(CurrentProperties.getTableFont());
//this.setFont(table.getFont());
//this.setFont(CurrentProperties.getTableFont());
			if (hasFocus) {
				super.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
			} else {
				super.setBorder(noFocusBorder);
			}
			setValue(value); 
			// <=== copied from DefaultTableCellRenderer

			int rowState = TagTable.this.getTagTableModel().getRowState(row);
			//Debug.println("TableCellRenderer: rowState: " + rowState);
//Debug.println("TableCellRenderer: table: " + table.getFont());
//Debug.println("TableCellRenderer: font: " + this.getFont());
			super.setFont(this.getPlainFont());
			if (rowState == JavaDocNode.STATE_OK) {
				return(this);
			}
			if ((rowState & JavaDocNode.STATE_CHANGED) != 0) {
				TagTable.this.changed = true;
				if (CurrentProperties.colorsModifiedNode()) {
					super.setFont(this.getBoldFont());
				}
			}
			if ((rowState & JavaDocNode.STATE_INVALID) != 0) {
				TagTable.this.invalid = true;
				if (CurrentProperties.colorsInvalidNode()) {
					super.setForeground(CurrentProperties.getColorInvalidState());
				}
			}
			return(this);
		}
		//public Font getFont() {return(TagTable.this.getFont());}
		
		private Font getPlainFont()
		{
			if (this.plain == null) {
				this.plain = new Font(super.getFont().getName(),
									  Font.PLAIN,
									  super.getFont().getSize());
			}
			return(this.plain);
		}
		private Font getBoldFont()
		{
			if (this.bold == null) {
				this.bold = new Font(super.getFont().getName(),
									 Font.BOLD,
									 super.getFont().getSize());
			}
			return(this.bold);
		}
		// Fields
		private Font plain;
		private Font bold;
	}

	protected class ActionEdit implements ActionListener
	{
		public void actionPerformed(ActionEvent ae)
		{
			Debug.println("AcctionEdit: actionPerformed: START: ");
			int row = TagTable.this.getSelectedRow();
			if (row < 0) {
				Debug.println("AcctionEdit: not selected: " + ae);
				return;
			}
			CommentTag oldTag = getTagTableModel().getCommentTag(row);
			if (oldTag.equals(TagTableModel.DUMMY_TAG)) {
				// DUMMY_TAGIĂꍇ [Add]
				actionAdd.actionPerformed(ae);
				return;
			}
			String[] data = getTagEditor().showAndGetData(oldTag.getTagName(),
														  oldTag.getDescription());
			if (data == null) {
				//cancel
				return;
			}
			getTagTableModel().setValueAt(data[0], row, 0);
			getTagTableModel().setValueAt(data[1], row, 1);
			getTagTableModel().fireTableRowsInserted(row, row);
			row++;
			setRowSelectionInterval(row, row);
		}
	}
	protected class ActionAdd implements ActionListener
	{
		public void actionPerformed(ActionEvent ae)
		{
			Debug.println("AcctionEdit: actionPerformed: START: ");
			int row = TagTable.this.getSelectedRow();
			if (row < 0) {
				//Debug.println("AcctionAdd: not selected: " + ae);
				//return;
				// ^Oe[uIĂȂꍇ́AŌɒǉ
				row = TagTable.this.getRowCount() - 1;
			}
			String[] data = getTagEditor().showAndGetData("", "");
			if (data == null) {
				//cancel
				return;
			}
			getTagTableModel().addRowAt(row, TagTableModel.DUMMY_TAG);			
			getTagTableModel().setValueAt(data[0], row, 0);
			getTagTableModel().setValueAt(data[1], row, 1);
			getTagTableModel().fireTableRowsInserted(row, row);
			row++;
			setRowSelectionInterval(row, row);
		}
	}
	protected class ActionDelete implements ActionListener
	{
		public void actionPerformed(ActionEvent ae)
		{
			Debug.println("AcctionDelete: actionPerformed: START: ");
			int row = TagTable.this.getSelectedRow();
			if (row < 0) {
				return;
			}
			if (row >= TagTable.this.getTagTableModel().getRowCount() - 1) {
				// DummyTag
				return;
			}
			TagTable.this.getTagTableModel().removeRowAt(row);
			TagTable.this.getTagTableModel().fireTableRowsDeleted(row, row);
			setRowSelectionInterval(row, row);
		}
	}
	protected class ActionUp implements ActionListener
	{
		public void actionPerformed(ActionEvent ae)
		{
			Debug.println("AcctionUp: actionPerformed: START: ");
//Debug.assert(true);
TagTable.this.requestFocus();			
			int row = TagTable.this.getSelectedRow();
			if (row <= 0) {
				return;
			}
			if (row >= TagTable.this.getTagTableModel().getRowCount() - 1) {
				// DummyTag
				return;
			}
			int prevRow = row - 1;
			getTagTableModel().addRowAt(prevRow, getTagTableModel().removeRowAt(row));
			getTagTableModel().fireTableRowsUpdated(prevRow, row);
			setRowSelectionInterval(prevRow, prevRow);
		}
	}
	protected class ActionDown implements ActionListener
	{
		public void actionPerformed(ActionEvent ae)
		{
			Debug.println("AcctionDown: actionPerformed: START: ");
			int row = TagTable.this.getSelectedRow();
			if (row < 0) {
				return;
			}
			if (row >= (TagTable.this.getTagTableModel().getRowCount() - 2)) {
				// DummyTag
				return;
			}
			int nextRow =  row + 1;
			getTagTableModel().addRowAt(nextRow, getTagTableModel().removeRowAt(row));
			getTagTableModel().fireTableRowsUpdated(row, nextRow);
			setRowSelectionInterval(nextRow, nextRow);
		}
	}
	/**
	 * \JavaDocNodê݂𔽉fB
	 */
	//protected class ActionSave implements ActionListener
	protected class ActionReflect implements ActionListener//TreeClass
	{
		public void actionPerformed(ActionEvent ae)
		{
			Debug.println("AcctionReflect: actionPerformed: START: ");
			getTagTableModel().getJavaDocNode().reflect();
			getTagTableModel().getJavaDocNode().getSourceFileNode().save();
			repaint();
		}
	}
}
