package jp.gr.java_conf.a0.jdh.gui;

import java.awt.Frame;
import java.awt.Dimension;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JComboBox;
import javax.swing.JTextArea;
import javax.swing.JScrollPane;
//import jp.gr.java_conf.a0.jdh.parser.comment.CommentTag;
//import jp.gr.java_conf.a0.jdh.parser.comment.CommentBody;


public class TagEditor
{
	TagEditor(TagTable aTable)
	{
		this.table = aTable;
		
		this.comboBox = new JComboBox();
		comboBox.setEditable(true);
		//comboBox.setBackground(Color.white);
		String[] tags = CurrentProperties.getTags();
		for (int i = 0; i < tags.length; i++) {
			comboBox.addItem(tags[i]);
		}
		
		this.textArea = new JTextArea();
		//JScrollPane textScroller = new JScrollPane(this.textArea);
		JScrollPane textScroller = new JScrollPane(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
												   JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		textScroller.getViewport().add(this.textArea);
		textScroller.getViewport().setBackingStoreEnabled(true);
		//textScroller.setPreferredSize(new Dimension(250,50));
		//textScroller.setPreferredSize(new Dimension((int)MainWindow.getInstance().getFrame().getSize().getWidth()/2, 65));
		textScroller.setPreferredSize(new Dimension((int)MainWindow.getInstance().getFrame().getSize().width/2, 65));
	
		this. panel = new JPanel();
		//this.panel.setLayout(new BorderLayout());
		//this.panel.add(this.comboBox, BorderLayout.WEST);
		//this.panel.add(textScroller, BorderLayout.CENTER);
		this.panel.setLayout(new FlowLayout());
		this.panel.add(this.comboBox);
		this.panel.add(textScroller);
	}

	//public CommentTag showAndGetData(String aTagName, String aDescription)
	public String[] showAndGetData(String aTagName, String aDescription)
	{
		this.comboBox.insertItemAt(aTagName, 0);
		this.comboBox.setSelectedIndex(0);
		this.textArea.setText(aDescription);
		//int result = JOptionPane.showConfirmDialog(MainWindow.getInstance().getFrame(),
		int result = TagEditor.showOptionDialog(MainWindow.getInstance().getFrame(),
							this.panel,
							MainWindow.getResource().getString("window.title.tageditor"),
							JOptionPane.OK_CANCEL_OPTION,
							JOptionPane.PLAIN_MESSAGE,
							//null);
							null, null, null);
		aTagName = (String)this.comboBox.getSelectedItem();
		this.comboBox.removeItemAt(0);
		if (result == JOptionPane.OK_OPTION ) {
			//OK
			return(new String[]{aTagName, this.textArea.getText()});
		} else {
			//CANCEL_OPTION or CLOSED_OPTION
			return(null);
		}
	}

	// setResizable(false)ĂԂ߂ɂł̃\bhĒ`B
    public static int showOptionDialog(Component parentComponent, Object message,
                                       String title, int optionType,
                                       int messageType, Icon icon,
                                       Object[] options, Object initialValue) {
        JOptionPane pane = new JOptionPane(message, messageType,
										   optionType, icon,
										   options, initialValue);
        // Workaround for bug#4135218
        //pane.adjustPreferredSize();
        Dimension prefSize = pane.getPreferredSize();
        prefSize.width+=5;
        prefSize.height+=2;
        pane.setPreferredSize(prefSize);
		
        pane.setInitialValue(initialValue);
        JDialog dialog = pane.createDialog(parentComponent, title);
        pane.selectInitialValue();
		dialog.setResizable(false);// by KURO
        dialog.show();
        Object selectedValue = pane.getValue();

        if(selectedValue == null)
            return JOptionPane.CLOSED_OPTION;
		options = pane.getOptions();
        if(options == null) {
            if(selectedValue instanceof Integer)
                return ((Integer)selectedValue).intValue();
            return JOptionPane.CLOSED_OPTION;
        }
        for(int counter = 0, maxCounter = options.length;
            counter < maxCounter; counter++) {
            if(options[counter].equals(selectedValue))
                return counter;
        }
        return JOptionPane.CLOSED_OPTION;
    }
	

	private TagTable table;
	
	private JPanel panel;
	private JComboBox comboBox;
	private JTextArea textArea;

	//private final JOptionPane optionPane;
	//private final JDialog dialog;
}

