package jp.gr.java_conf.a0.jdh.gui;

import java.awt.Point;
import java.awt.Dimension;
import java.io.File;
import java.io.InputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.io.IOException;
import javax.swing.ImageIcon;

import jp.gr.java_conf.a0.debug.Debug;


class StaticProperties implements Serializable
{
	public static StaticProperties getInstance()
	{
		return INSTANCE;
	}
	public static void load() //throws IOException
	{
		try {
			String fname = getRootDir() + STATIC_PROPFILE;
			File propfile = new File(fname);
			if (!propfile.exists()) {
				Debug.println("Static file not found: " + fname);
				save();
				return;
			}
			ObjectInputStream oin = new ObjectInputStream(new BufferedInputStream(
										  new FileInputStream(propfile)));
			INSTANCE = (StaticProperties)oin.readObject();
			Debug.println("Load static file: " + fname);
			oin.close();
		}
		catch (Exception ex) {
			//Debug.warn(ex);
			MainController.messageException(ex);
		}
	}
	public static void save()
	{
		try {
			File rootdir = new File(getRootDir());
			if (!rootdir.exists()) {
				Debug.println("JDH root directory doesn't exist: " + getRootDir());
				rootdir.mkdir();
			}
			String fname = getRootDir() + STATIC_PROPFILE;
			File propfile = new File(fname);
			ObjectOutputStream oout = new ObjectOutputStream(new BufferedOutputStream(
																					  new FileOutputStream(propfile)));
			oout.writeObject(INSTANCE);
			oout.close();
			Debug.println("Wrote Static file: " + fname);
		}
		catch (Exception ex) {
			MainController.messageException(ex);
		}
	}
	public static String getRootDir()
	{
		return(System.getProperty("user.home") + File.separator + ".jdh"
			   + File.separator);
	}

	public static ImageIcon getImage(String aFile)
	{
		byte[][] buffer = new byte[1][];
		try {
			Debug.println("StaticProperties.getImage(): aFile: " + aFile);
			InputStream res = ClassLoader.getSystemResourceAsStream(aFile);
			if (res == null) {
				Debug.println("StaticProperties.getImage(): res is null.");
				return null;
			}
			BufferedInputStream in = new BufferedInputStream(res);
			ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
			buffer[0] = new byte[1024];
			int n;
			while ((n = in.read(buffer[0])) > 0) {
				out.write(buffer[0], 0, n);
			}
			in.close();
			out.flush();
			buffer[0] = out.toByteArray();
		}
		catch (IOException ex) {
			Debug.warn(ex);
			return null;
		}
		return new ImageIcon(buffer[0]);
	}
	
	Point winLocation = new Point(0, 0);
	Dimension winDimension = new Dimension(700, 400);
	int dividerTree = -1;
	int dividerTable = -1;
	
	private static StaticProperties INSTANCE = new StaticProperties();
	private static final String STATIC_PROPFILE = "static";
	//transient private static String JDH_ROOT_DIR = System.getProperty("user.home") + File.separator + ".jdh";
}
